/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory.collections;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;

public class ODirectMemoryList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess {
    private final ODirectMemory memory;
    private final OBinarySerializer<E> serializer;
    private int size;
    private long elementData;

    public ODirectMemoryList(int initialCapacity, ODirectMemory memory, OBinarySerializer<E> serializer) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.memory = memory;
        this.serializer = serializer;
        this.elementData = this.allocateSpace(initialCapacity);
    }

    public ODirectMemoryList(ODirectMemory memory, OBinarySerializer<E> serializer) {
        this(16, memory, serializer);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.getData(this.elementData, i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.getData(this.elementData, i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.getData(this.elementData, i) != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.getData(this.elementData, i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this.getData(this.elementData, index);
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        E oldValue = this.getData(this.elementData, index);
        this.setData(this.elementData, index, element);
        return oldValue;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacity(this.size + 1);
        this.setData(this.elementData, this.size++, e);
        return true;
    }

    @Override
    public E remove(int index) {
        if (this.size == 0) {
            return null;
        }
        this.rangeCheck(index);
        E oldValue = this.getData(this.elementData, index);
        this.doRemove(index);
        return oldValue;
    }

    private void doRemove(int index) {
        ++this.modCount;
        this.setData(this.elementData, index, null);
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            this.copyData(this.elementData, index + 1, index, numMoved);
        }
        --this.size;
        this.clearData(this.elementData, this.size);
    }

    @Override
    public boolean remove(Object o) {
        if (this.size == 0) {
            return false;
        }
        if (o == null) {
            for (int index = 0; index < this.size; ++index) {
                if (this.getData(this.elementData, index) != null) continue;
                this.doRemove(index);
                return true;
            }
        } else {
            for (int index = 0; index < this.size; ++index) {
                if (!o.equals(this.getData(this.elementData, index))) continue;
                this.doRemove(index);
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.setData(this.elementData, i, null);
        }
        this.size = 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        for (int i = fromIndex; i < toIndex; ++i) {
            this.setData(this.elementData, i, null);
        }
        this.copyData(this.elementData, fromIndex, toIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.clearData(this.elementData, --this.size);
        }
    }

    private void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.memory.getInt(this.elementData);
        if (minCapacity > oldCapacity) {
            long oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = this.allocateSpace(newCapacity);
            this.copyData(oldData, 0, this.elementData, 0, oldCapacity);
        }
    }

    private void copyData(long ptr, int fromIndex, int toIndex, int len) {
        long fromOffset = fromIndex * 8 + 4;
        long toOffset = toIndex * 8 + 4;
        this.memory.copyData(ptr + fromOffset, ptr + toOffset, len * 8);
    }

    private void copyData(long fromPtr, int fromIndex, long toPtr, int toIndex, int len) {
        long fromOffset = fromIndex * 8 + 4;
        long toOffset = toIndex * 8 + 4;
        this.memory.copyData(fromPtr + fromOffset, toPtr + toOffset, len * 8);
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private E getData(long ptr, int index) {
        int offset = index * 8 + 4;
        long dataPtr = this.memory.getLong(ptr + (long)offset);
        if (dataPtr == 0L) {
            return null;
        }
        return this.memory.get(dataPtr, this.serializer);
    }

    private void setData(long ptr, int index, E data) {
        long dataPtr;
        if (data != null) {
            dataPtr = this.memory.allocate(this.serializer.getObjectSize(data));
            if (dataPtr == 0L) {
                throw new IllegalStateException("There is no enough memory to allocate for item " + data);
            }
            this.memory.set(dataPtr, data, this.serializer);
        } else {
            dataPtr = 0L;
        }
        long offset = index * 8 + 4;
        long oldPtr = this.memory.getLong(ptr + offset);
        if (oldPtr != 0L) {
            this.memory.free(oldPtr);
        }
        this.memory.setLong(ptr + offset, dataPtr);
    }

    private void clearData(long ptr, int index) {
        long offset = index * 8 + 4;
        this.memory.setLong(ptr + offset, 0L);
    }

    private long allocateSpace(int capacity) {
        long size = capacity * 8 + 4;
        long ptr = this.memory.allocate(size);
        if (ptr == 0L) {
            throw new IllegalStateException("There is no enough memory to allocate for capacity = " + capacity);
        }
        long itemPtr = 4L + ptr;
        for (int i = 0; i < capacity; ++i) {
            this.memory.setLong(itemPtr, 0L);
            itemPtr += 8L;
        }
        this.memory.setInt(ptr, capacity);
        return ptr;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
        this.memory.free(this.elementData);
    }
}

