/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization;

import com.orientechnologies.common.serialization.OBinaryConverter;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

public class OUnsafeBinaryConverter
implements OBinaryConverter {
    private static final Unsafe theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object run() {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            boolean wasAccessible = f.isAccessible();
            f.setAccessible(true);
            try {
                Object object = f.get(null);
                f.setAccessible(wasAccessible);
                return object;
            }
            catch (Throwable throwable) {
                try {
                    f.setAccessible(wasAccessible);
                    throw throwable;
                }
                catch (NoSuchFieldException e) {
                    throw new Error();
                }
                catch (IllegalAccessException e) {
                    throw new Error();
                }
            }
        }
    });
    private static final long BYTE_ARRAY_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);

    @Override
    public void putShort(byte[] buffer, int index, short value, ByteOrder byteOrder) {
        if (!byteOrder.equals(ByteOrder.nativeOrder())) {
            value = Short.reverseBytes(value);
        }
        theUnsafe.putShort(buffer, (long)index + BYTE_ARRAY_OFFSET, value);
    }

    @Override
    public short getShort(byte[] buffer, int index, ByteOrder byteOrder) {
        short result = theUnsafe.getShort(buffer, (long)index + BYTE_ARRAY_OFFSET);
        if (!byteOrder.equals(ByteOrder.nativeOrder())) {
            result = Short.reverseBytes(result);
        }
        return result;
    }

    @Override
    public void putInt(byte[] buffer, int pointer, int value, ByteOrder byteOrder) {
        long position = (long)pointer + BYTE_ARRAY_OFFSET;
        if (!byteOrder.equals(ByteOrder.nativeOrder())) {
            value = Integer.reverseBytes(value);
        }
        theUnsafe.putInt(buffer, position, value);
    }

    @Override
    public int getInt(byte[] buffer, int pointer, ByteOrder byteOrder) {
        long position = (long)pointer + BYTE_ARRAY_OFFSET;
        int result = theUnsafe.getInt(buffer, position);
        if (!byteOrder.equals(ByteOrder.nativeOrder())) {
            result = Integer.reverseBytes(result);
        }
        return result;
    }

    @Override
    public void putLong(byte[] buffer, int index, long value, ByteOrder byteOrder) {
        if (!byteOrder.equals(ByteOrder.nativeOrder())) {
            value = Long.reverseBytes(value);
        }
        theUnsafe.putLong(buffer, (long)index + BYTE_ARRAY_OFFSET, value);
    }

    @Override
    public long getLong(byte[] buffer, int index, ByteOrder byteOrder) {
        long result = theUnsafe.getLong(buffer, (long)index + BYTE_ARRAY_OFFSET);
        if (!byteOrder.equals(ByteOrder.nativeOrder())) {
            result = Long.reverseBytes(result);
        }
        return result;
    }

    @Override
    public void putChar(byte[] buffer, int index, char character, ByteOrder byteOrder) {
        if (!byteOrder.equals(ByteOrder.nativeOrder())) {
            character = Character.reverseBytes(character);
        }
        theUnsafe.putChar(buffer, (long)index + BYTE_ARRAY_OFFSET, character);
    }

    @Override
    public char getChar(byte[] buffer, int index, ByteOrder byteOrder) {
        char result = theUnsafe.getChar(buffer, (long)index + BYTE_ARRAY_OFFSET);
        if (!byteOrder.equals(ByteOrder.nativeOrder())) {
            result = Character.reverseBytes(result);
        }
        return result;
    }

    @Override
    public boolean nativeAccelerationUsed() {
        return true;
    }
}

