/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import java.nio.ByteOrder;

public class OShortSerializer
implements OBinarySerializer<Short> {
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static OShortSerializer INSTANCE = new OShortSerializer();
    public static final byte ID = 12;
    public static final int SHORT_SIZE = 2;

    @Override
    public int getObjectSize(Short object) {
        return 2;
    }

    @Override
    public void serialize(Short object, byte[] stream, int startPosition) {
        short value = object;
        stream[startPosition] = (byte)(value >>> 8 & 0xFF);
        stream[startPosition + 1] = (byte)(value >>> 0 & 0xFF);
    }

    @Override
    public Short deserialize(byte[] stream, int startPosition) {
        return (short)(stream[startPosition] << 8 | stream[startPosition + 1] & 0xFF);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 2;
    }

    @Override
    public byte getId() {
        return 12;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 2;
    }

    @Override
    public void serializeNative(Short object, byte[] stream, int startPosition) {
        CONVERTER.putShort(stream, startPosition, object, ByteOrder.nativeOrder());
    }

    @Override
    public Short deserializeNative(byte[] stream, int startPosition) {
        return CONVERTER.getShort(stream, startPosition, ByteOrder.nativeOrder());
    }

    @Override
    public void serializeInDirectMemory(Short object, ODirectMemory memory, long pointer) {
        memory.setShort(pointer, object);
    }

    @Override
    public Short deserializeFromDirectMemory(ODirectMemory memory, long pointer) {
        return memory.getShort(pointer);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemory memory, long pointer) {
        return 2;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 2;
    }
}

