/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.db;

import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ODatabaseHelper {
    public static void createDatabase(ODatabase database, String iURL) throws IOException {
        ODatabaseHelper.createDatabase(database, iURL, "server");
    }

    public static void createDatabase(ODatabase database, String iURL, String iDirectory) throws IOException {
        if (iURL.startsWith("remote")) {
            new OServerAdmin(iURL).connect("root", ODatabaseHelper.getServerRootPassword(iDirectory)).createDatabase("document", "local").close();
        } else {
            database.create();
            database.close();
        }
    }

    public static void deleteDatabase(ODatabase database) throws IOException {
        ODatabaseHelper.deleteDatabase(database, "server");
    }

    @Deprecated
    public static void deleteDatabase(ODatabase database, String iDirectory) throws IOException {
        ODatabaseHelper.dropDatabase(database, iDirectory);
    }

    public static void dropDatabase(ODatabase database) throws IOException {
        ODatabaseHelper.dropDatabase(database, "server");
    }

    public static void dropDatabase(ODatabase database, String iDirectory) throws IOException {
        if (database.getURL().startsWith("remote:")) {
            new OServerAdmin(database.getURL()).connect("root", ODatabaseHelper.getServerRootPassword(iDirectory)).dropDatabase();
        } else if (ODatabaseHelper.existsDatabase(database)) {
            if (database.isClosed()) {
                database.open("admin", "admin");
            }
            database.drop();
        }
    }

    public static boolean existsDatabase(ODatabase database) throws IOException {
        if (database.getURL().startsWith("remote")) {
            return new OServerAdmin(database.getURL()).connect("root", ODatabaseHelper.getServerRootPassword()).existsDatabase();
        }
        return database.exists();
    }

    protected static String getServerRootPassword() throws IOException {
        return ODatabaseHelper.getServerRootPassword("server");
    }

    protected static String getServerRootPassword(String iDirectory) throws IOException {
        File file = new File("../releases/1.0.1/config/orientdb-server-config.xml");
        if (!file.exists()) {
            file = new File(iDirectory + "/config/orientdb-server-config.xml");
        }
        if (!file.exists()) {
            file = new File("../" + iDirectory + "/config/orientdb-server-config.xml");
        }
        if (!file.exists()) {
            file = new File(OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}/config/orientdb-server-config.xml"));
        }
        if (!file.exists()) {
            throw new OConfigurationException("Cannot load file orientdb-server-config.xml to execute remote tests");
        }
        FileReader f = new FileReader(file);
        char[] buffer = new char[(int)file.length()];
        f.read(buffer);
        f.close();
        String fileContent = new String(buffer);
        int pos = fileContent.indexOf("password=\"");
        return fileContent.substring(pos += "password=\"".length(), fileContent.indexOf(34, pos));
    }
}

