/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ONetworkConnectionPool<CH extends OChannel>
implements OResourcePoolListener<String, CH> {
    private static final int DEF_WAIT_TIMEOUT = 5000;
    private final Map<String, OResourcePool<String, CH>> pools = new HashMap<String, OResourcePool<String, CH>>();
    private int maxSize;
    private int timeout = 5000;

    public ONetworkConnectionPool(int iMinSize, int iMaxSize) {
        this(iMinSize, iMaxSize, 5000);
    }

    public ONetworkConnectionPool(int iMinSize, int iMaxSize, int iTimeout) {
        this.maxSize = iMaxSize;
        this.timeout = iTimeout;
    }

    public CH createNewResource(String iKey, Object ... iAdditionalArgs) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CH acquire(String iRemoteAddress) throws OLockException {
        OResourcePool pool = this.pools.get(iRemoteAddress);
        if (pool == null) {
            Map<String, OResourcePool<String, CH>> map = this.pools;
            synchronized (map) {
                pool = this.pools.get(iRemoteAddress);
                if (pool == null) {
                    pool = new OResourcePool(this.maxSize, (OResourcePoolListener)this);
                    this.pools.put(iRemoteAddress, pool);
                }
            }
        }
        return (CH)((OChannel)pool.getResource((Object)iRemoteAddress, (long)this.timeout, new Object[0]));
    }

    public void release(CH iChannel) {
        String address = ((OChannel)iChannel).socket.getInetAddress().toString();
        OResourcePool<String, CH> pool = this.pools.get(address);
        if (pool == null) {
            throw new OLockException("Cannot release a network channel not acquired before. Remote address: " + address);
        }
        pool.returnResource(iChannel);
    }

    public boolean reuseResource(String iKey, Object[] iAdditionalArgs, CH iValue) {
        return true;
    }

    public Map<String, OResourcePool<String, CH>> getPools() {
        return this.pools;
    }

    public void close() {
        for (Map.Entry<String, OResourcePool<String, CH>> pool : this.pools.entrySet()) {
            for (OChannel channel : pool.getValue().getResources()) {
                channel.close();
            }
        }
    }
}

