/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.db;

import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ODatabaseHelper {
    public static void createDatabase(ODatabase database, String iURL) throws IOException {
        ODatabaseHelper.createDatabase(database, iURL, "server");
    }

    public static void createDatabase(ODatabase database, String iURL, String iDirectory) throws IOException {
        if (iURL.startsWith("remote")) {
            new OServerAdmin(iURL).connect("root", ODatabaseHelper.getServerRootPassword(iDirectory)).createDatabase("document", "local").close();
        } else {
            database.create();
            database.close();
        }
    }

    public static void deleteDatabase(ODatabase database) throws IOException {
        ODatabaseHelper.deleteDatabase(database, "server");
    }

    @Deprecated
    public static void deleteDatabase(ODatabase database, String iDirectory) throws IOException {
        ODatabaseHelper.dropDatabase(database, iDirectory);
    }

    public static void dropDatabase(ODatabase database) throws IOException {
        ODatabaseHelper.dropDatabase(database, "server");
    }

    public static void dropDatabase(ODatabase database, String iDirectory) throws IOException {
        if (database.getURL().startsWith("remote:")) {
            new OServerAdmin(database.getURL()).connect("root", ODatabaseHelper.getServerRootPassword(iDirectory)).dropDatabase();
        } else if (ODatabaseHelper.existsDatabase(database)) {
            if (database.isClosed()) {
                database.open("admin", "admin");
            }
            database.drop();
        }
    }

    public static boolean existsDatabase(ODatabase database) throws IOException {
        if (database.getURL().startsWith("remote")) {
            return new OServerAdmin(database.getURL()).connect("root", ODatabaseHelper.getServerRootPassword()).existsDatabase();
        }
        return database.exists();
    }

    public static void freezeDatabase(ODatabase database) throws IOException {
        if (database.getURL().startsWith("remote")) {
            OServerAdmin serverAdmin = new OServerAdmin(database.getURL());
            serverAdmin.connect("root", ODatabaseHelper.getServerRootPassword()).freezeDatabase();
            serverAdmin.close();
        } else {
            database.freeze();
        }
    }

    public static void releaseDatabase(ODatabase database) throws IOException {
        if (database.getURL().startsWith("remote")) {
            OServerAdmin serverAdmin = new OServerAdmin(database.getURL());
            serverAdmin.connect("root", ODatabaseHelper.getServerRootPassword()).releaseDatabase();
            serverAdmin.close();
        } else {
            database.release();
        }
    }

    public static File getConfigurationFile() {
        return ODatabaseHelper.getConfigurationFile(null);
    }

    protected static String getServerRootPassword() throws IOException {
        return ODatabaseHelper.getServerRootPassword("server");
    }

    protected static String getServerRootPassword(String iDirectory) throws IOException {
        File file = ODatabaseHelper.getConfigurationFile(iDirectory);
        FileReader f = new FileReader(file);
        char[] buffer = new char[(int)file.length()];
        f.read(buffer);
        f.close();
        String fileContent = new String(buffer);
        int pos = fileContent.indexOf("password=\"");
        return fileContent.substring(pos += "password=\"".length(), fileContent.indexOf(34, pos));
    }

    protected static File getConfigurationFile(String iDirectory) {
        String sysProperty = System.getProperty("orientdb.config.file");
        File file = new File(sysProperty != null ? sysProperty : "");
        if (!file.exists()) {
            sysProperty = System.getenv("CONFIG_FILE");
            file = new File(sysProperty != null ? sysProperty : "");
        }
        if (!file.exists()) {
            file = new File("../releases/orientdb-1.2.0/config/orientdb-server-config.xml");
        }
        if (!file.exists()) {
            file = new File("../../releases/orientdb-1.2.0/config/orientdb-server-config.xml");
        }
        if (!file.exists() && iDirectory != null && !(file = new File(iDirectory + "/config/orientdb-server-config.xml")).exists()) {
            file = new File("../" + iDirectory + "/config/orientdb-server-config.xml");
        }
        if (!file.exists()) {
            file = new File(OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}/config/orientdb-server-config.xml"));
        }
        if (!file.exists()) {
            throw new OConfigurationException("Cannot load file orientdb-server-config.xml to execute remote tests. Current directory is " + new File(".").getAbsolutePath());
        }
        return file;
    }
}

