/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OClusterRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteAsynchEventListener;
import com.orientechnologies.orient.client.remote.OStorageRemoteThreadLocal;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequestAsynch;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OAsynchChannelServiceThread;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryProtocol;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class OStorageRemote
extends OStorageAbstract
implements OStorageProxy {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 2424;
    private static final String ADDRESS_SEPARATOR = ";";
    public static final String PARAM_MIN_POOL = "minpool";
    public static final String PARAM_MAX_POOL = "maxpool";
    public static final String PARAM_DB_TYPE = "dbtype";
    private static final String DRIVER_NAME = "OrientDB Java";
    private final ExecutorService asynchExecutor;
    private OAsynchChannelServiceThread serviceThread;
    private OContextConfiguration clientConfiguration;
    private int connectionRetry;
    private int connectionRetryDelay;
    private final List<OChannelBinaryClient> networkPool = new ArrayList<OChannelBinaryClient>();
    private int networkPoolCursor = 0;
    protected final List<String> serverURLs = new ArrayList<String>();
    private OCluster[] clusters = new OCluster[0];
    protected final Map<String, OCluster> clusterMap = new ConcurrentHashMap<String, OCluster>();
    private int defaultClusterId;
    private int minPool;
    private int maxPool;
    private final boolean debug = false;
    private ODocument clusterConfiguration = new ODocument();
    private ORemoteServerEventListener asynchEventListener;
    private String connectionDbType;
    private String connectionUserName;
    private String connectionUserPassword;
    private Map<String, Object> connectionOptions;
    private final String clientId;
    private final int maxReadQueue;

    public OStorageRemote(String iClientId, String iURL, String iMode) throws IOException {
        super(iURL, iURL, iMode);
        this.clientId = iClientId;
        this.configuration = null;
        this.clientConfiguration = new OContextConfiguration();
        this.connectionRetry = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY);
        this.connectionRetryDelay = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY_DELAY);
        this.asynchEventListener = new OStorageRemoteAsynchEventListener(this);
        this.parseServerURLs();
        this.asynchExecutor = Executors.newSingleThreadScheduledExecutor();
        this.maxReadQueue = Runtime.getRuntime().availableProcessors() - 1;
    }

    public int getSessionId() {
        return ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId;
    }

    public void setSessionId(int iSessionId) {
        ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = iSessionId;
    }

    public ORemoteServerEventListener getAsynchEventListener() {
        return this.asynchEventListener;
    }

    public void setAsynchEventListener(ORemoteServerEventListener iListener) {
        this.asynchEventListener = iListener;
    }

    public void removeRemoteServerEventListener() {
        this.asynchEventListener = null;
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.addUser();
        this.lock.acquireExclusiveLock();
        try {
            this.connectionUserName = iUserName;
            this.connectionUserPassword = iUserPassword;
            this.connectionOptions = iOptions != null ? new HashMap<String, Object>(iOptions) : null;
            this.openRemoteDatabase();
            this.configuration = new OStorageConfiguration((OStorage)this);
            this.configuration.load();
        }
        catch (Exception e) {
            if (!OGlobalConfiguration.STORAGE_KEEP_OPEN.getValueAsBoolean()) {
                this.close();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new OStorageException("Cannot open the remote storage: " + this.name, (Throwable)e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        this.checkConnection();
        this.lock.acquireExclusiveLock();
        try {
            while (true) {
                try {
                    OChannelBinaryClient network = null;
                    try {
                        network = this.beginRequest((byte)73);
                    }
                    finally {
                        this.endRequest(network);
                    }
                    try {
                        this.beginResponse(network);
                        this.readDatabaseInformation(network);
                    }
                    finally {
                        this.endResponse(network);
                    }
                }
                catch (Exception e) {
                    this.handleException("Error on reloading database information", e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void create(Map<String, Object> iOptions) {
        throw new UnsupportedOperationException("Cannot create a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    public boolean exists() {
        throw new UnsupportedOperationException("Cannot check the existance of a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean iForce) {
        OChannelBinaryClient network = null;
        this.lock.acquireExclusiveLock();
        try {
            List<OChannelBinaryClient> list = this.networkPool;
            synchronized (list) {
                if (this.networkPool.size() > 0) {
                    try {
                        network = this.beginRequest((byte)5);
                    }
                    finally {
                        this.endRequest(network);
                    }
                }
            }
            this.setSessionId(-1);
            if (!this.checkForClose(iForce)) {
                return;
            }
            if (this.serviceThread != null) {
                this.serviceThread.sendShutdown();
            }
            list = this.networkPool;
            synchronized (list) {
                for (OChannelBinaryClient n : this.networkPool) {
                    n.close();
                }
                this.networkPool.clear();
            }
            this.level2Cache.shutdown();
            super.close(iForce);
            this.status = OStorage.STATUS.CLOSED;
            Orient.instance().unregisterStorage((OStorage)this);
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error on closing remote connection: %s", new Object[]{network});
            this.closeChannel(network);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void delete() {
        throw new UnsupportedOperationException("Cannot delete a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getClusterNames() {
        this.lock.acquireSharedLock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.clusterMap.keySet());
            return hashSet;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OStorageOperationResult<OPhysicalPosition> createRecord(int iDataSegmentId, final ORecordId iRid, byte[] iContent, ORecordVersion iRecordVersion, byte iRecordType, int iMode, final ORecordCallback<OClusterPosition> iCallback) {
        this.checkConnection();
        if (iMode == 1 && iCallback == null) {
            iMode = 2;
        }
        OPhysicalPosition ppos = new OPhysicalPosition(iDataSegmentId, -1L, iRecordType);
        while (true) {
            try {
                final OChannelBinaryClient network = this.beginRequest((byte)31);
                try {
                    if (network.getSrvProtocolVersion() >= 10) {
                        network.writeInt(iDataSegmentId);
                    }
                    network.writeShort((short)iRid.clusterId);
                    network.writeBytes(iContent);
                    network.writeByte(iRecordType);
                    network.writeByte((byte)iMode);
                }
                finally {
                    this.endRequest(network);
                }
                switch (iMode) {
                    case 0: {
                        try {
                            this.beginResponse(network);
                            ppos.clusterPosition = iRid.clusterPosition = network.readClusterPosition();
                            ppos.recordVersion = network.getSrvProtocolVersion() >= 11 ? network.readVersion() : OVersionFactory.instance().createVersion();
                            OStorageOperationResult oStorageOperationResult = new OStorageOperationResult((Object)ppos);
                            return oStorageOperationResult;
                        }
                        finally {
                            this.endResponse(network);
                        }
                    }
                    case 1: {
                        if (iCallback == null) return new OStorageOperationResult((Object)ppos);
                        final int sessionId = this.getSessionId();
                        Callable<Object> response = new Callable<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object call() throws Exception {
                                OClusterPosition result;
                                try {
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = sessionId;
                                    System.out.println("BEGIN ASYNCH READ " + ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId);
                                    OStorageRemote.this.beginResponse(network);
                                    result = network.readClusterPosition();
                                    if (network.getSrvProtocolVersion() >= 11) {
                                        network.readVersion();
                                    }
                                }
                                finally {
                                    OStorageRemote.this.endResponse(network);
                                    System.out.println("END   ASYNCH READ " + ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId);
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = -1;
                                }
                                iCallback.call(iRid, (Object)result);
                                return null;
                            }
                        };
                        this.asynchExecutor.submit(new FutureTask<Object>(response));
                        return new OStorageOperationResult((Object)ppos);
                    }
                }
                return new OStorageOperationResult((Object)ppos);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException("Error on create record in cluster: " + iRid.clusterId, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback, boolean loadTombstones) {
        this.checkConnection();
        if (((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting) {
            return new OStorageOperationResult(null);
        }
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)30);
                    network.writeRID((ORID)iRid);
                    network.writeString(iFetchPlan != null ? iFetchPlan : "");
                    if (network.getSrvProtocolVersion() >= 9) {
                        network.writeByte((byte)(iIgnoreCache ? 1 : 0));
                    }
                    if (network.getSrvProtocolVersion() >= 13) {
                        network.writeByte(loadTombstones ? (byte)1 : 0);
                    }
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    if (network.readByte() == 0) {
                        OStorageOperationResult oStorageOperationResult = new OStorageOperationResult(null);
                        return oStorageOperationResult;
                    }
                    ORawBuffer buffer = new ORawBuffer(network.readBytes(), network.readVersion(), network.readByte());
                    ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
                    while (network.readByte() == 2) {
                        ORecordInternal record = (ORecordInternal)OChannelBinaryProtocol.readIdentifiable((OChannelBinaryClient)network);
                        if (database == null) continue;
                        database.getLevel1Cache().updateRecord(record);
                    }
                    OStorageOperationResult oStorageOperationResult = new OStorageOperationResult((Object)buffer);
                    return oStorageOperationResult;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException("Error on read record " + iRid, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OStorageOperationResult<ORecordVersion> updateRecord(final ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType, int iMode, final ORecordCallback<ORecordVersion> iCallback) {
        this.checkConnection();
        if (iMode == 1 && iCallback == null) {
            iMode = 2;
        }
        while (true) {
            try {
                final OChannelBinaryClient network = this.beginRequest((byte)32);
                try {
                    network.writeRID((ORID)iRid);
                    network.writeBytes(iContent);
                    network.writeVersion(iVersion);
                    network.writeByte(iRecordType);
                    network.writeByte((byte)iMode);
                }
                finally {
                    this.endRequest(network);
                }
                switch (iMode) {
                    case 0: {
                        try {
                            this.beginResponse(network);
                            OStorageOperationResult oStorageOperationResult = new OStorageOperationResult((Object)network.readVersion());
                            return oStorageOperationResult;
                        }
                        finally {
                            this.endResponse(network);
                        }
                    }
                    case 1: {
                        if (iCallback == null) return new OStorageOperationResult((Object)iVersion);
                        final int sessionId = this.getSessionId();
                        Callable<Object> response = new Callable<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object call() throws Exception {
                                ORecordVersion result;
                                try {
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = sessionId;
                                    OStorageRemote.this.beginResponse(network);
                                    result = network.readVersion();
                                }
                                finally {
                                    OStorageRemote.this.endResponse(network);
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = -1;
                                }
                                iCallback.call(iRid, (Object)result);
                                return null;
                            }
                        };
                        this.asynchExecutor.submit(new FutureTask<Object>(response));
                        return new OStorageOperationResult((Object)iVersion);
                    }
                }
                return new OStorageOperationResult((Object)iVersion);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException("Error on update record " + iRid, e);
                continue;
            }
            break;
        }
    }

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRid, ORecordVersion iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        this.checkConnection();
        if (iMode == 1 && iCallback == null) {
            iMode = 2;
        }
        while (true) {
            try {
                OChannelBinaryClient network = this.beginRequest((byte)33);
                return new OStorageOperationResult((Object)this.deleteRecord(iRid, iVersion, iMode, iCallback, network));
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException("Error on delete record " + iRid, e);
                continue;
            }
            break;
        }
    }

    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        this.checkConnection();
        if (iMode == 1 && callback == null) {
            iMode = 2;
        }
        while (true) {
            try {
                OChannelBinaryClient network = this.beginRequest((byte)38);
                return this.deleteRecord(recordId, recordVersion, iMode, callback, network);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException("Error on clean out record " + recordId, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteRecord(final ORecordId iRid, ORecordVersion iVersion, int iMode, final ORecordCallback<Boolean> iCallback, final OChannelBinaryClient network) throws IOException {
        try {
            network.writeRID((ORID)iRid);
            network.writeVersion(iVersion);
            network.writeByte((byte)iMode);
        }
        finally {
            this.endRequest(network);
        }
        switch (iMode) {
            case 0: {
                try {
                    this.beginResponse(network);
                    boolean bl = network.readByte() == 1;
                    return bl;
                }
                finally {
                    this.endResponse(network);
                }
            }
            case 1: {
                if (iCallback == null) break;
                final int sessionId = this.getSessionId();
                Callable<Object> response = new Callable<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object call() throws Exception {
                        Boolean result;
                        try {
                            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = sessionId;
                            OStorageRemote.this.beginResponse(network);
                            result = network.readByte() == 1;
                        }
                        finally {
                            OStorageRemote.this.endResponse(network);
                            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = -1;
                        }
                        iCallback.call(iRid, (Object)result);
                        return null;
                    }
                };
                this.asynchExecutor.submit(new FutureTask<Object>(response));
            }
        }
        return false;
    }

    public long count(int iClusterId) {
        return this.count(new int[]{iClusterId});
    }

    public long count(int iClusterId, boolean countTombstones) {
        return this.count(new int[]{iClusterId}, countTombstones);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPosition[] getClusterDataRange(int iClusterId) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)13);
                network.writeShort((short)iClusterId);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                OClusterPosition[] oClusterPositionArray = new OClusterPosition[]{network.readClusterPosition(), network.readClusterPosition()};
                this.endResponse(network);
                return oClusterPositionArray;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException("Error on getting last entry position count in cluster: " + iClusterId, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPhysicalPosition[] higherPhysicalPositions(int iClusterId, OPhysicalPosition iClusterPosition) {
        this.checkConnection();
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)36);
                    network.writeInt(iClusterId);
                    network.writeClusterPosition(iClusterPosition.clusterPosition);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException("Error on retrieving higher positions after " + iClusterPosition.clusterPosition, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        this.checkConnection();
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)42);
                    network.writeInt(clusterId);
                    network.writeClusterPosition(physicalPosition.clusterPosition);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException("Error on retrieving ceiling positions after " + physicalPosition.clusterPosition, e);
                continue;
            }
            break;
        }
    }

    private OPhysicalPosition[] readPhysicalPositions(OChannelBinaryClient network, int positionsCount) throws IOException {
        OPhysicalPosition[] physicalPositions = new OPhysicalPosition[positionsCount];
        for (int i = 0; i < physicalPositions.length; ++i) {
            OPhysicalPosition position = new OPhysicalPosition();
            position.clusterPosition = network.readClusterPosition();
            position.dataSegmentId = network.readInt();
            position.dataSegmentPos = network.readLong();
            position.recordSize = network.readInt();
            position.recordVersion = network.readVersion();
            physicalPositions[i] = position;
        }
        return physicalPositions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPhysicalPosition[] lowerPhysicalPositions(int iClusterId, OPhysicalPosition physicalPosition) {
        this.checkConnection();
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)37);
                    network.writeInt(iClusterId);
                    network.writeClusterPosition(physicalPosition.clusterPosition);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException("Error on retrieving lower positions after " + physicalPosition.clusterPosition, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        this.checkConnection();
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)39);
                    network.writeInt(clusterId);
                    network.writeClusterPosition(physicalPosition.clusterPosition);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException("Error on retrieving floor positions after " + physicalPosition.clusterPosition, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)8);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException("Error on read database size", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countRecords() {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)9);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException("Error on read database record count", e);
                    continue;
                }
            }
            break;
        }
    }

    public long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(int[] iClusterIds, boolean countTombstones) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)12);
                network.writeShort((short)iClusterIds.length);
                for (int iClusterId : iClusterIds) {
                    network.writeShort((short)iClusterId);
                }
                if (network.getSrvProtocolVersion() >= 12) {
                    network.writeByte(countTombstones ? (byte)1 : 0);
                }
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException("Error on read record count in clusters: " + Arrays.toString(iClusterIds), e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRecordIdentity(ORID originalId, ORID newId) {
        this.checkConnection();
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)35);
                    network.writeShort((short)originalId.getClusterId());
                    network.writeClusterPosition(originalId.getClusterPosition());
                    network.writeShort((short)newId.getClusterId());
                    network.writeClusterPosition(newId.getClusterPosition());
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    return;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException("Error during changing identity of  " + originalId + " record to " + newId, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLHClustersAreUsed() {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)16);
            }
            finally {
                this.endRequest(network);
            }
            try {
                boolean isLHClustersAreUsed;
                this.beginResponse(network);
                boolean bl = isLHClustersAreUsed = network.readByte() > 0;
                this.endResponse(network);
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException("Error during requesting of cluster persistence mode", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object command(OCommandRequestText iCommand) {
        this.checkConnection();
        if (!(iCommand instanceof OSerializableStream)) {
            throw new OCommandExecutionException("Cannot serialize the command to be executed to the server side.");
        }
        OCommandRequestText command = iCommand;
        Object result = null;
        ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.get();
        while (true) {
            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = true;
            try {
                OCommandRequestText aquery = iCommand;
                boolean asynch = iCommand instanceof OCommandRequestAsynch;
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)41);
                    network.writeByte((byte)(asynch ? 97 : 115));
                    network.writeBytes(OStreamSerializerAnyStreamable.INSTANCE.toStream((Object)command));
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    if (asynch) {
                        ORecordInternal record;
                        byte status;
                        block26: while ((status = network.readByte()) > 0 && (record = (ORecordInternal)OChannelBinaryProtocol.readIdentifiable((OChannelBinaryClient)network)) != null) {
                            switch (status) {
                                case 1: {
                                    try {
                                        if (!aquery.getResultListener().result((Object)record)) {
                                            while (network.in.available() > 0) {
                                                network.in.read();
                                            }
                                            continue block26;
                                        }
                                    }
                                    catch (Throwable t) {
                                        t.printStackTrace();
                                    }
                                    database.getLevel1Cache().updateRecord(record);
                                    break;
                                }
                                case 2: {
                                    database.getLevel1Cache().updateRecord(record);
                                }
                            }
                        }
                    } else {
                        byte type = network.readByte();
                        switch (type) {
                            case 110: {
                                result = null;
                                break;
                            }
                            case 114: {
                                result = OChannelBinaryProtocol.readIdentifiable((OChannelBinaryClient)network);
                                if (!(result instanceof ORecord)) break;
                                database.getLevel1Cache().updateRecord((ORecordInternal)result);
                                break;
                            }
                            case 108: {
                                int tot = network.readInt();
                                ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>();
                                for (int i = 0; i < tot; ++i) {
                                    OIdentifiable resultItem = OChannelBinaryProtocol.readIdentifiable((OChannelBinaryClient)network);
                                    if (resultItem instanceof ORecord) {
                                        database.getLevel1Cache().updateRecord((ORecordInternal)resultItem);
                                    }
                                    list.add(resultItem);
                                }
                                result = list;
                                break;
                            }
                            case 97: {
                                String value = new String(network.readBytes());
                                result = ORecordSerializerStringAbstract.fieldTypeFromStream(null, (OType)ORecordSerializerStringAbstract.getType((String)value), (Object)value);
                            }
                        }
                    }
                    this.endResponse(network);
                }
                catch (Throwable throwable) {
                    try {
                        this.endResponse(network);
                        throw throwable;
                    }
                    catch (OModificationOperationProhibitedException mope) {
                        this.handleDBFreeze();
                        ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                        continue;
                    }
                    catch (Exception e) {
                        this.handleException("Error on executing command: " + iCommand, e);
                        continue;
                    }
                }
            }
            finally {
                ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                continue;
            }
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(OTransaction iTx) {
        this.checkConnection();
        ArrayList<ORecordOperation> committedEntries = new ArrayList<ORecordOperation>();
        while (true) {
            try {
                ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = true;
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)60);
                    network.writeInt(iTx.getId());
                    network.writeByte((byte)(iTx.isUsingLog() ? 1 : 0));
                    ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
                    if (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                        while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                            for (ORecordOperation txEntry : iTx.getCurrentRecordEntries()) {
                                tmpEntries.add(txEntry);
                            }
                            iTx.clearRecordEntries();
                            if (tmpEntries.size() <= 0) continue;
                            for (ORecordOperation txEntry : tmpEntries) {
                                this.commitEntry(network, txEntry);
                                committedEntries.add(txEntry);
                            }
                            tmpEntries.clear();
                        }
                    } else if (committedEntries.size() > 0) {
                        for (ORecordOperation txEntry : committedEntries) {
                            this.commitEntry(network, txEntry);
                        }
                    }
                    network.writeByte((byte)0);
                    network.writeBytes(iTx.getIndexChanges().toStream());
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int createdRecords = network.readInt();
                    block18: for (int i = 0; i < createdRecords; ++i) {
                        ORecordId currentRid = network.readRID();
                        ORecordId createdRid = network.readRID();
                        for (ORecordOperation txEntry : iTx.getAllRecordEntries()) {
                            if (!txEntry.getRecord().getIdentity().equals(currentRid)) continue;
                            txEntry.getRecord().setIdentity(createdRid);
                            continue block18;
                        }
                    }
                    int updatedRecords = network.readInt();
                    block20: for (int i = 0; i < updatedRecords; ++i) {
                        ORecordId rid = network.readRID();
                        for (ORecordOperation txEntry : iTx.getAllRecordEntries()) {
                            if (!txEntry.getRecord().getIdentity().equals(rid)) continue;
                            txEntry.getRecord().getRecordVersion().copyFrom(network.readVersion());
                            continue block20;
                        }
                    }
                    committedEntries.clear();
                }
                finally {
                    this.endResponse(network);
                }
                for (ORecordOperation txEntry : iTx.getAllRecordEntries()) {
                    txEntry.getRecord().unload();
                }
                OTransactionAbstract.updateCacheFromEntries((OStorage)this, (OTransaction)iTx, (Iterable)iTx.getAllRecordEntries(), (boolean)false);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException("Error on commit", e);
                continue;
            }
            finally {
                ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                continue;
            }
            break;
        }
    }

    public void rollback(OTransaction iTx) {
    }

    public int getClusterIdByName(String iClusterName) {
        this.checkConnection();
        if (iClusterName == null) {
            return -1;
        }
        if (Character.isDigit(iClusterName.charAt(0))) {
            return Integer.parseInt(iClusterName);
        }
        OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
        if (cluster == null) {
            return -1;
        }
        return cluster.getId();
    }

    public String getClusterTypeByName(String iClusterName) {
        this.checkConnection();
        if (iClusterName == null) {
            return null;
        }
        OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
        if (cluster == null) {
            return null;
        }
        return cluster.getType();
    }

    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, Object ... iArguments) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)10);
                network.writeString(iClusterType.toString());
                network.writeString(iClusterName);
                if (network.getSrvProtocolVersion() >= 10 || iClusterType.equalsIgnoreCase("PHYSICAL")) {
                    network.writeString(iLocation);
                }
                if (network.getSrvProtocolVersion() >= 10) {
                    network.writeString(iDataSegmentName);
                } else {
                    network.writeInt(-1);
                }
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                short clusterId = network.readShort();
                OClusterRemote cluster = new OClusterRemote();
                cluster.setType(iClusterType);
                cluster.configure((OStorage)this, clusterId, iClusterName.toLowerCase(), null, 0, new Object[0]);
                if (this.clusters.length <= clusterId) {
                    this.clusters = Arrays.copyOf(this.clusters, clusterId + 1);
                }
                this.clusters[cluster.getId()] = cluster;
                this.clusterMap.put(cluster.getName().toLowerCase(), cluster);
                short s = clusterId;
                this.endResponse(network);
                return s;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OModificationOperationProhibitedException mphe) {
                    this.handleDBFreeze();
                    continue;
                }
                catch (Exception e) {
                    this.handleException("Error on add new cluster", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dropCluster(int iClusterId) {
        this.checkConnection();
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)11);
                    network.writeShort((short)iClusterId);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    if (network.readByte() == 1) {
                        OCluster cluster = this.clusters[iClusterId];
                        this.clusters[iClusterId] = null;
                        this.clusterMap.remove(cluster.getName());
                        if (this.configuration.clusters.size() > iClusterId) {
                            this.configuration.dropCluster(iClusterId);
                        }
                        this.getLevel2Cache().freeCluster(iClusterId);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException("Error on removing of cluster", e);
                continue;
            }
            break;
        }
    }

    public int addDataSegment(String iDataSegmentName) {
        return this.addDataSegment(iDataSegmentName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDataSegment(String iSegmentName, String iLocation) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)20);
                network.writeString(iSegmentName).writeString(iLocation);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                int n = network.readInt();
                this.endResponse(network);
                return n;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OModificationOperationProhibitedException mphe) {
                    this.handleDBFreeze();
                    continue;
                }
                catch (Exception e) {
                    this.handleException("Error on add new data segment", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropDataSegment(String iSegmentName) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)21);
                network.writeString(iSegmentName);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                boolean bl = network.readByte() == 1;
                this.endResponse(network);
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OModificationOperationProhibitedException mope) {
                    this.handleDBFreeze();
                    continue;
                }
                catch (Exception e) {
                    this.handleException("Error on remove data segment", e);
                    continue;
                }
            }
            break;
        }
    }

    public void synch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPhysicalClusterNameById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            if (iClusterId >= this.clusters.length) {
                String string = null;
                return string;
            }
            OCluster cluster = this.clusters[iClusterId];
            String string = cluster != null ? cluster.getName() : null;
            return string;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public int getClusterMap() {
        return this.clusterMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OCluster> getClusterInstances() {
        this.lock.acquireSharedLock();
        try {
            List<OCluster> list = Arrays.asList(this.clusters);
            return list;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCluster getClusterById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            OCluster oCluster = this.clusters[iClusterId];
            return oCluster;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public long getVersion() {
        throw new UnsupportedOperationException("getVersion");
    }

    public ODocument getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleException(String iMessage, Exception iException) {
        int currentRetryDelay;
        int currentMaxRetry;
        if (!(iException instanceof OTimeoutException)) {
            if (iException instanceof OException) {
                throw (OException)iException;
            }
            if (!(iException instanceof IOException)) {
                throw new OStorageException(iMessage, (Throwable)iException);
            }
        }
        if (this.status != OStorage.STATUS.OPEN) {
            return;
        }
        long lostConnectionTime = System.currentTimeMillis();
        ODocument oDocument = this.clusterConfiguration;
        synchronized (oDocument) {
            if (!this.clusterConfiguration.isEmpty()) {
                currentMaxRetry = 1;
                currentRetryDelay = 0;
            } else {
                currentMaxRetry = this.connectionRetry;
                currentRetryDelay = this.connectionRetryDelay;
            }
        }
        for (int retry = 0; retry < currentMaxRetry; ++retry) {
            if (currentRetryDelay > 0) {
                try {
                    Thread.sleep(currentRetryDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            try {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Retrying to connect to remote server #" + (retry + 1) + "/" + currentMaxRetry + "...", new Object[0]);
                }
                this.openRemoteDatabase();
                OLogManager.instance().warn((Object)this, "Connection re-acquired transparently after %dms and %d retries: no errors will be thrown at application level", new Object[]{System.currentTimeMillis() - lostConnectionTime, retry + 1});
                return;
            }
            catch (Throwable t) {
                continue;
            }
        }
        throw new OStorageException(iMessage, (Throwable)iException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openRemoteDatabase() throws IOException {
        boolean availableConnections;
        this.minPool = OGlobalConfiguration.CLIENT_CHANNEL_MIN_POOL.getValueAsInteger();
        this.maxPool = OGlobalConfiguration.CLIENT_CHANNEL_MAX_POOL.getValueAsInteger();
        this.connectionDbType = "document";
        if (this.connectionOptions != null && this.connectionOptions.size() > 0) {
            if (this.connectionOptions.containsKey(PARAM_MIN_POOL)) {
                this.minPool = Integer.parseInt(this.connectionOptions.get(PARAM_MIN_POOL).toString());
            }
            if (this.connectionOptions.containsKey(PARAM_MAX_POOL)) {
                this.maxPool = Integer.parseInt(this.connectionOptions.get(PARAM_MAX_POOL).toString());
            }
            if (this.connectionOptions.containsKey(PARAM_DB_TYPE)) {
                this.connectionDbType = this.connectionOptions.get(PARAM_DB_TYPE).toString();
            }
        }
        this.setSessionId(-1);
        this.createConnectionPool();
        List<OChannelBinaryClient> list = this.networkPool;
        synchronized (list) {
            availableConnections = !this.networkPool.isEmpty();
        }
        while (availableConnections) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)3);
                    this.sendClientInfo(network);
                    network.writeString(this.name);
                    if (network.getSrvProtocolVersion() >= 8) {
                        network.writeString(this.connectionDbType);
                    }
                    network.writeString(this.connectionUserName);
                    network.writeString(this.connectionUserPassword);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int sessionId = network.readInt();
                    this.setSessionId(sessionId);
                    OLogManager.instance().debug((Object)this, "Client connected with session id: " + sessionId, new Object[0]);
                    this.readDatabaseInformation(network);
                    this.updateClusterConfiguration(network.readBytes());
                    this.status = OStorage.STATUS.OPEN;
                    return;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (IOException e) {
                OLogManager.instance().debug((Object)this, "Error while reading response on creation of connection ", (Throwable)e, new Object[0]);
            }
            catch (OTimeoutException e) {
                OLogManager.instance().debug((Object)this, "Error while reading response on creation of connection ", (Throwable)e, new Object[0]);
            }
            catch (Exception e) {
                this.handleException("Cannot create a connection to remote server address(es): " + this.serverURLs, e);
            }
            list = this.networkPool;
            synchronized (list) {
                availableConnections = !this.networkPool.isEmpty();
            }
        }
        throw new OStorageException("Cannot create a connection to remote server address(es): " + this.serverURLs);
    }

    protected void sendClientInfo(OChannelBinaryClient network) throws IOException {
        if (network.getSrvProtocolVersion() >= 7) {
            network.writeString(DRIVER_NAME).writeString("1.3.0").writeShort((short)13).writeString(this.clientId);
        }
    }

    protected void parseServerURLs() {
        int dbPos = this.url.indexOf(47);
        if (dbPos == -1) {
            this.addHost(this.url);
            this.name = this.url;
        } else {
            this.name = this.url.substring(dbPos + 1);
            for (String host : this.url.substring(0, dbPos).split(ADDRESS_SEPARATOR)) {
                host = this.addHost(host);
            }
        }
        if (this.serverURLs.size() == 1 && OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_ENABLED.getValueAsBoolean()) {
            String primaryServer = this.serverURLs.get(0);
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                env.put("com.sun.jndi.ldap.connect.timeout", OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT.getValueAsString());
                InitialDirContext ictx = new InitialDirContext(env);
                String hostName = primaryServer.indexOf(":") == -1 ? primaryServer : primaryServer.substring(0, primaryServer.indexOf(":"));
                Attributes attrs = ictx.getAttributes(hostName, new String[]{"TXT"});
                Attribute attr = attrs.get("TXT");
                if (attr != null) {
                    String configuration = (String)attr.get();
                    if (configuration.startsWith("")) {
                        configuration = configuration.substring(1, configuration.length() - 1);
                    }
                    if (configuration != null) {
                        String[] parts;
                        for (String part : parts = configuration.split(" ")) {
                            if (!part.startsWith("s=")) continue;
                            this.addHost(part.substring("s=".length()));
                        }
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    protected String addHost(String host) {
        if (host.startsWith(DEFAULT_HOST)) {
            host = "127.0.0.1" + host.substring(DEFAULT_HOST.length());
        }
        if (host.indexOf(":") == -1) {
            host = host + ":" + this.getDefaultPort();
        }
        if (!this.serverURLs.contains(host)) {
            this.serverURLs.add(host);
        }
        return host;
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    protected int getDefaultPort() {
        return 2424;
    }

    protected OChannelBinaryClient createNetworkConnection() throws IOException, UnknownHostException {
        for (String server : this.serverURLs) {
            OLogManager.instance().debug((Object)this, "Trying to connect to the remote host %s...", new Object[]{server});
            int sepPos = server.indexOf(":");
            String remoteHost = server.substring(0, sepPos);
            int remotePort = Integer.parseInt(server.substring(sepPos + 1));
            try {
                return new OChannelBinaryClient(remoteHost, remotePort, this.clientConfiguration, 13);
            }
            catch (Exception e) {
            }
        }
        StringBuilder buffer = new StringBuilder();
        for (String server : this.serverURLs) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(server);
        }
        throw new OIOException("Cannot connect to any configured remote nodes: " + buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnection() {
        this.lock.acquireSharedLock();
        try {
            List<OChannelBinaryClient> list = this.networkPool;
            synchronized (list) {
                if (this.networkPool.size() == 0) {
                    throw new ODatabaseException("Connection is closed");
                }
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OChannelBinaryClient beginRequest(byte iCommand) throws IOException {
        OChannelBinaryClient network = null;
        List<OChannelBinaryClient> list = this.networkPool;
        synchronized (list) {
            int beginCursor = this.networkPoolCursor;
            while (network == null) {
                if (this.networkPool.size() == 0) {
                    this.openRemoteDatabase();
                }
                if (this.networkPool.size() == 0) {
                    throw new ONetworkProtocolException("Connection pool closed");
                }
                if (this.networkPoolCursor >= this.networkPool.size()) {
                    this.networkPoolCursor = 0;
                }
                network = this.networkPool.get(this.networkPoolCursor);
                ++this.networkPoolCursor;
                if (network.getLockWrite().tryLock()) break;
                network = null;
                if (this.networkPoolCursor != beginCursor) continue;
                if (this.networkPool.size() < this.maxPool) {
                    network = this.createNetworkConnection();
                    network.getLockWrite().lock();
                    this.networkPool.add(network);
                    continue;
                }
                long startToWait = System.currentTimeMillis();
                try {
                    this.networkPool.wait(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new OStorageException("Cannot acquire a connection because the thread has been interrupted");
                }
                long elapsed = Orient.instance().getProfiler().stopChrono("system.network.connectionPool.waitingTime", "Waiting for a free connection from the pool of channels", startToWait);
            }
        }
        network.writeByte(iCommand);
        network.writeInt(this.getSessionId());
        return network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRequest(OChannelBinaryClient iNetwork) throws IOException {
        if (iNetwork == null) {
            return;
        }
        try {
            iNetwork.flush();
        }
        catch (IOException e) {
            try {
                iNetwork.close();
            }
            catch (Exception exception) {
                List<OChannelBinaryClient> list = this.networkPool;
                synchronized (list) {
                    this.networkPool.remove(iNetwork);
                }
            }
            finally {
                List<OChannelBinaryClient> list = this.networkPool;
                synchronized (list) {
                    this.networkPool.remove(iNetwork);
                }
            }
            throw e;
        }
        finally {
            iNetwork.getLockWrite().unlock();
            List<OChannelBinaryClient> list = this.networkPool;
            synchronized (list) {
                this.networkPool.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeChannel(OChannelBinaryClient iNetwork) {
        iNetwork.close();
        List<OChannelBinaryClient> list = this.networkPool;
        synchronized (list) {
            this.networkPool.remove(iNetwork);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginResponse(OChannelBinaryClient iNetwork) throws IOException {
        iNetwork.beginResponse(this.getSessionId());
        if (iNetwork.getLockRead().getQueueLength() + 1 >= this.maxReadQueue) {
            List<OChannelBinaryClient> list = this.networkPool;
            synchronized (list) {
                if (this.networkPool.size() < this.maxPool) {
                    OChannelBinaryClient network = this.createNetworkConnection();
                    this.networkPool.add(network);
                }
            }
        }
    }

    public void endResponse(OChannelBinaryClient iNetwork) {
        iNetwork.endResponse();
    }

    public boolean isPermanentRequester() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getResponse(OChannelBinaryClient iNetwork) throws IOException {
        try {
            this.beginResponse(iNetwork);
        }
        finally {
            this.endResponse(iNetwork);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterConfiguration(byte[] obj) {
        if (obj == null) {
            return;
        }
        ODocument oDocument = this.clusterConfiguration;
        synchronized (oDocument) {
            this.clusterConfiguration.fromStream(obj);
            List members = (List)this.clusterConfiguration.field("members");
            if (members != null) {
                for (ODocument m : members) {
                    if (m == null || this.serverURLs.contains((String)m.field("id"))) continue;
                    for (Map listener : (Collection)m.field("listeners")) {
                        String url;
                        if (!((String)listener.get("protocol")).equals("ONetworkProtocolBinary") || this.serverURLs.contains(url = (String)listener.get("listen"))) continue;
                        this.addHost(url);
                    }
                }
            }
        }
    }

    private void commitEntry(OChannelBinaryClient iNetwork, ORecordOperation txEntry) throws IOException {
        if (txEntry.type == 0) {
            return;
        }
        byte[] stream = null;
        try {
            switch (txEntry.type) {
                case 1: 
                case 3: {
                    stream = txEntry.getRecord().toStream();
                }
            }
        }
        catch (Exception e) {
            iNetwork.writeByte((byte)-1);
            throw new OTransactionException("Error on transaction commit", (Throwable)e);
        }
        iNetwork.writeByte((byte)1);
        iNetwork.writeByte(txEntry.type);
        iNetwork.writeRID(txEntry.getRecord().getIdentity());
        iNetwork.writeByte(txEntry.getRecord().getRecordType());
        switch (txEntry.type) {
            case 3: {
                iNetwork.writeBytes(stream);
                break;
            }
            case 1: {
                iNetwork.writeVersion(txEntry.getRecord().getRecordVersion());
                iNetwork.writeBytes(stream);
                break;
            }
            case 2: {
                iNetwork.writeVersion(txEntry.getRecord().getRecordVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createConnectionPool() throws IOException, UnknownHostException {
        List<OChannelBinaryClient> list = this.networkPool;
        synchronized (list) {
            if (!this.networkPool.isEmpty()) {
                ArrayList<OChannelBinaryClient> editableList = new ArrayList<OChannelBinaryClient>(this.networkPool);
                for (OChannelBinaryClient net : editableList) {
                    if (net.isConnected()) continue;
                    this.closeChannel(net);
                }
            }
            if (this.networkPool.size() == 0) {
                OChannelBinaryClient firstChannel = this.createNetworkConnection();
                this.serviceThread = new OAsynchChannelServiceThread(this.asynchEventListener, firstChannel, "OrientDB <- Asynch Client (" + firstChannel.socket.getRemoteSocketAddress() + ")");
                this.networkPool.add(firstChannel);
            }
            for (int i = this.networkPool.size(); i < this.minPool; ++i) {
                this.networkPool.add(this.createNetworkConnection());
            }
        }
    }

    private boolean handleDBFreeze() {
        OLogManager.instance().warn((Object)this, "DB is frozen will wait for " + OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT.getValue() + " ms. and then retry.", new Object[0]);
        boolean retry = true;
        try {
            Thread.sleep(OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT.getValueAsInteger());
        }
        catch (InterruptedException ie) {
            retry = false;
            Thread.currentThread().interrupt();
        }
        return retry;
    }

    private void readDatabaseInformation(OChannelBinaryClient network) throws IOException {
        int tot = network.getSrvProtocolVersion() >= 7 ? network.readShort() : network.readInt();
        this.clusters = new OCluster[tot];
        this.clusterMap.clear();
        for (int i = 0; i < tot; ++i) {
            OClusterRemote cluster = new OClusterRemote();
            String clusterName = network.readString();
            if (clusterName != null) {
                clusterName = clusterName.toLowerCase();
            }
            short clusterId = network.readShort();
            String clusterType = network.readString();
            short dataSegmentId = network.getSrvProtocolVersion() >= 12 ? network.readShort() : (short)0;
            cluster.setType(clusterType);
            cluster.configure((OStorage)this, clusterId, clusterName, null, dataSegmentId, new Object[0]);
            if (clusterId >= this.clusters.length) {
                this.clusters = Arrays.copyOf(this.clusters, clusterId + 1);
            }
            this.clusters[clusterId] = cluster;
            this.clusterMap.put(clusterName, cluster);
        }
        this.defaultClusterId = this.clusterMap.get("default").getId();
    }

    public String getURL() {
        return "remote:" + this.url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getDataSegmentIdByName(String iName) {
        if (iName == null) {
            return 0;
        }
        throw new UnsupportedOperationException("getDataSegmentIdByName()");
    }

    public ODataSegment getDataSegmentById(int iDataSegmentId) {
        throw new UnsupportedOperationException("getDataSegmentById()");
    }

    public int getClusters() {
        return this.clusterMap.size();
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    public String getType() {
        return "remote";
    }
}

