/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class OStorageRemoteThread
implements OStorageProxy {
    private static AtomicInteger sessionSerialId = new AtomicInteger(-1);
    private final OStorageRemote delegate;
    private int sessionId;

    public OStorageRemoteThread(OStorageRemote iSharedStorage) {
        this.delegate = iSharedStorage;
        this.sessionId = sessionSerialId.decrementAndGet();
    }

    public OStorageRemoteThread(OStorageRemote iSharedStorage, int iSessionId) {
        this.delegate = iSharedStorage;
        this.sessionId = iSessionId;
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.open(iUserName, iUserPassword, iOptions);
        this.sessionId = this.delegate.getSessionId();
    }

    public void create(Map<String, Object> iOptions) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.create(iOptions);
        this.sessionId = this.delegate.getSessionId();
    }

    public void close(boolean iForce) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.close(iForce);
        Orient.instance().unregisterStorage((OStorage)this);
    }

    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.dropCluster(iClusterName, iTruncate);
    }

    public int getUsers() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getUsers();
    }

    public int addUser() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.addUser();
    }

    public OSharedResourceAdaptiveExternal getLock() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getLock();
    }

    public void setSessionId(int iSessionId) {
        this.sessionId = iSessionId;
        this.delegate.setSessionId(iSessionId);
    }

    public void reload() {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.reload();
    }

    public boolean exists() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.exists();
    }

    public int removeUser() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.removeUser();
    }

    public void close() {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.close();
    }

    public void delete() {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.delete();
        Orient.instance().unregisterStorage((OStorage)this);
    }

    public Set<String> getClusterNames() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterNames();
    }

    public OStorageOperationResult<OPhysicalPosition> createRecord(int iDataSegmentId, ORecordId iRid, byte[] iContent, ORecordVersion iRecordVersion, byte iRecordType, int iMode, ORecordCallback<OClusterPosition> iCallback) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.createRecord(iDataSegmentId, iRid, iContent, OVersionFactory.instance().createVersion(), iRecordType, iMode, iCallback);
    }

    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback, boolean loadTombstones) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.readRecord(iRid, iFetchPlan, iIgnoreCache, null, loadTombstones);
    }

    public OStorageOperationResult<ORecordVersion> updateRecord(ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType, int iMode, ORecordCallback<ORecordVersion> iCallback) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.updateRecord(iRid, iContent, iVersion, iRecordType, iMode, iCallback);
    }

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRid, ORecordVersion iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.deleteRecord(iRid, iVersion, iMode, iCallback);
    }

    public boolean updateReplica(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.updateReplica(dataSegmentId, rid, content, recordVersion, recordType);
    }

    public ORecordMetadata getRecordMetadata(ORID rid) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getRecordMetadata(rid);
    }

    public <V> V callInRecordLock(Callable<V> iCallable, ORID rid, boolean iExclusiveLock) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.callInRecordLock(iCallable, rid, iExclusiveLock);
    }

    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.cleanOutRecord(recordId, recordVersion, iMode, callback);
    }

    public long count(int iClusterId) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.count(iClusterId);
    }

    public long count(int iClusterId, boolean countTombstones) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.count(iClusterId, countTombstones);
    }

    public long count(int[] iClusterIds, boolean countTombstones) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.count(iClusterIds, countTombstones);
    }

    public String toString() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.toString();
    }

    public OClusterPosition[] getClusterDataRange(int iClusterId) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterDataRange(iClusterId);
    }

    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.higherPhysicalPositions(currentClusterId, physicalPosition);
    }

    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.lowerPhysicalPositions(currentClusterId, physicalPosition);
    }

    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.ceilingPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.floorPhysicalPositions(clusterId, physicalPosition);
    }

    public long getSize() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getSize();
    }

    public long countRecords() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.countRecords();
    }

    public long count(int[] iClusterIds) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.count(iClusterIds);
    }

    public Object command(OCommandRequestText iCommand) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.command(iCommand);
    }

    public void commit(OTransaction iTx) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.commit(iTx);
    }

    public void rollback(OTransaction iTx) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.rollback(iTx);
    }

    public int getClusterIdByName(String iClusterName) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterIdByName(iClusterName);
    }

    public String getClusterTypeByName(String iClusterName) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterTypeByName(iClusterName);
    }

    public int getDefaultClusterId() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getDefaultClusterId();
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.setDefaultClusterId(defaultClusterId);
    }

    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iArguments) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.addCluster(iClusterType, iClusterName, iLocation, iDataSegmentName, false, iArguments);
    }

    public int addCluster(String iClusterType, String iClusterName, int iRequestedId, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.addCluster(iClusterType, iClusterName, iRequestedId, iLocation, iDataSegmentName, forceListBased, iParameters);
    }

    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.dropCluster(iClusterId, iTruncate);
    }

    public ODataSegment getDataSegmentById(int iDataSegmentId) {
        return this.delegate.getDataSegmentById(iDataSegmentId);
    }

    public int getDataSegmentIdByName(String iDataSegmentName) {
        return this.delegate.getDataSegmentIdByName(iDataSegmentName);
    }

    public int addDataSegment(String iDataSegmentName) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.addDataSegment(iDataSegmentName);
    }

    public int addDataSegment(String iSegmentName, String iSegmentFileName) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.addDataSegment(iSegmentName, iSegmentFileName);
    }

    public boolean dropDataSegment(String iSegmentName) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.dropDataSegment(iSegmentName);
    }

    public void synch() {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.synch();
    }

    public String getPhysicalClusterNameById(int iClusterId) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getPhysicalClusterNameById(iClusterId);
    }

    public int getClusters() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterMap();
    }

    public Collection<OCluster> getClusterInstances() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterInstances();
    }

    public OCluster getClusterById(int iId) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterById(iId);
    }

    public long getVersion() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getVersion();
    }

    public boolean isPermanentRequester() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.isPermanentRequester();
    }

    public void updateClusterConfiguration(byte[] iContent) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.updateClusterConfiguration(iContent);
    }

    public OStorageConfiguration getConfiguration() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getConfiguration();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.checkForRecordValidity(ppos);
    }

    public String getName() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getName();
    }

    public void changeRecordIdentity(ORID originalId, ORID newId) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.changeRecordIdentity(originalId, newId);
    }

    public boolean isHashClustersAreUsed() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.isHashClustersAreUsed();
    }

    public String getURL() {
        return this.delegate.getURL();
    }

    public void beginResponse(OChannelBinaryClient iNetwork) throws IOException {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.beginResponse(iNetwork);
    }

    public OLevel2RecordCache getLevel2Cache() {
        return this.delegate.getLevel2Cache();
    }

    public boolean existsResource(String iName) {
        return this.delegate.existsResource(iName);
    }

    public synchronized <T> T getResource(String iName, Callable<T> iCallback) {
        return (T)this.delegate.getResource(iName, iCallback);
    }

    public <T> T removeResource(String iName) {
        return (T)this.delegate.removeResource(iName);
    }

    public ODocument getClusterConfiguration() {
        return this.delegate.getClusterConfiguration();
    }

    public void closeChannel(OChannelBinaryClient network) {
        this.delegate.closeChannel(network);
    }

    protected void handleException(String iMessage, Exception iException) {
        this.delegate.handleException(iMessage, iException);
    }

    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return (V)this.delegate.callInLock(iCallable, iExclusiveLock);
    }

    public ORemoteServerEventListener getRemoteServerEventListener() {
        return this.delegate.getAsynchEventListener();
    }

    public void setRemoteServerEventListener(ORemoteServerEventListener iListener) {
        this.delegate.setAsynchEventListener(iListener);
    }

    public void removeRemoteServerEventListener() {
        this.delegate.removeRemoteServerEventListener();
    }

    public static int getNextConnectionId() {
        return sessionSerialId.decrementAndGet();
    }

    public void checkForClusterPermissions(String iClusterName) {
        this.delegate.checkForClusterPermissions(iClusterName);
    }

    public OStorage.STATUS getStatus() {
        return this.delegate.getStatus();
    }

    public String getType() {
        return this.delegate.getType();
    }
}

