/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class OStorageRemoteThread
implements OStorageProxy {
    private static AtomicInteger sessionSerialId = new AtomicInteger(-1);
    private final OStorageRemote delegate;
    private String serverURL;
    private int sessionId;

    public OStorageRemoteThread(OStorageRemote iSharedStorage) {
        this.delegate = iSharedStorage;
        this.serverURL = null;
        this.sessionId = sessionSerialId.decrementAndGet();
    }

    public OStorageRemoteThread(OStorageRemote iSharedStorage, int iSessionId) {
        this.delegate = iSharedStorage;
        this.serverURL = null;
        this.sessionId = iSessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.pushSession();
        try {
            this.delegate.open(iUserName, iUserPassword, iOptions);
        }
        finally {
            this.popSession();
        }
    }

    public boolean isDistributed() {
        return this.delegate.isDistributed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Map<String, Object> iOptions) {
        this.pushSession();
        try {
            this.delegate.create(iOptions);
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean iForce) {
        this.pushSession();
        try {
            this.delegate.close(iForce);
            Orient.instance().unregisterStorage((OStorage)this);
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        this.pushSession();
        try {
            boolean bl = this.delegate.dropCluster(iClusterName, iTruncate);
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUsers() {
        this.pushSession();
        try {
            int n = this.delegate.getUsers();
            return n;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addUser() {
        this.pushSession();
        try {
            int n = this.delegate.addUser();
            return n;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSharedResourceAdaptiveExternal getLock() {
        this.pushSession();
        try {
            OSharedResourceAdaptiveExternal oSharedResourceAdaptiveExternal = this.delegate.getLock();
            return oSharedResourceAdaptiveExternal;
        }
        finally {
            this.popSession();
        }
    }

    public void setSessionId(String iServerURL, int iSessionId) {
        this.serverURL = iServerURL;
        this.sessionId = iSessionId;
        this.delegate.setSessionId(this.serverURL, iSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        this.pushSession();
        try {
            this.delegate.reload();
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        this.pushSession();
        try {
            boolean bl = this.delegate.exists();
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeUser() {
        this.pushSession();
        try {
            int n = this.delegate.removeUser();
            return n;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.pushSession();
        try {
            this.delegate.close();
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        this.pushSession();
        try {
            this.delegate.delete();
            Orient.instance().unregisterStorage((OStorage)this);
        }
        finally {
            this.popSession();
        }
    }

    public OStorage getUnderlying() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getClusterNames() {
        this.pushSession();
        try {
            Set<String> set = this.delegate.getClusterNames();
            return set;
        }
        finally {
            this.popSession();
        }
    }

    public void backup(OutputStream out, Map<String, Object> options, Callable<Object> callable) throws IOException {
        throw new UnsupportedOperationException("backup");
    }

    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable) throws IOException {
        throw new UnsupportedOperationException("restore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageOperationResult<OPhysicalPosition> createRecord(int iDataSegmentId, ORecordId iRid, byte[] iContent, ORecordVersion iRecordVersion, byte iRecordType, int iMode, ORecordCallback<OClusterPosition> iCallback) {
        this.pushSession();
        try {
            OStorageOperationResult<OPhysicalPosition> oStorageOperationResult = this.delegate.createRecord(iDataSegmentId, iRid, iContent, OVersionFactory.instance().createVersion(), iRecordType, iMode, iCallback);
            return oStorageOperationResult;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback, boolean loadTombstones) {
        this.pushSession();
        try {
            OStorageOperationResult<ORawBuffer> oStorageOperationResult = this.delegate.readRecord(iRid, iFetchPlan, iIgnoreCache, null, loadTombstones);
            return oStorageOperationResult;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageOperationResult<ORecordVersion> updateRecord(ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType, int iMode, ORecordCallback<ORecordVersion> iCallback) {
        this.pushSession();
        try {
            OStorageOperationResult<ORecordVersion> oStorageOperationResult = this.delegate.updateRecord(iRid, iContent, iVersion, iRecordType, iMode, iCallback);
            return oStorageOperationResult;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRid, ORecordVersion iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        this.pushSession();
        try {
            OStorageOperationResult<Boolean> oStorageOperationResult = this.delegate.deleteRecord(iRid, iVersion, iMode, iCallback);
            return oStorageOperationResult;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateReplica(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        this.pushSession();
        try {
            boolean bl = this.delegate.updateReplica(dataSegmentId, rid, content, recordVersion, recordType);
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORecordMetadata getRecordMetadata(ORID rid) {
        this.pushSession();
        try {
            ORecordMetadata oRecordMetadata = this.delegate.getRecordMetadata(rid);
            return oRecordMetadata;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V callInRecordLock(Callable<V> iCallable, ORID rid, boolean iExclusiveLock) {
        this.pushSession();
        try {
            V v = this.delegate.callInRecordLock(iCallable, rid, iExclusiveLock);
            return v;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        this.pushSession();
        try {
            boolean bl = this.delegate.cleanOutRecord(recordId, recordVersion, iMode, callback);
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(int iClusterId) {
        this.pushSession();
        try {
            long l = this.delegate.count(iClusterId);
            return l;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(int iClusterId, boolean countTombstones) {
        this.pushSession();
        try {
            long l = this.delegate.count(iClusterId, countTombstones);
            return l;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(int[] iClusterIds, boolean countTombstones) {
        this.pushSession();
        try {
            long l = this.delegate.count(iClusterIds, countTombstones);
            return l;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.pushSession();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPosition[] getClusterDataRange(int iClusterId) {
        this.pushSession();
        try {
            OClusterPosition[] oClusterPositionArray = this.delegate.getClusterDataRange(iClusterId);
            return oClusterPositionArray;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        this.pushSession();
        try {
            OPhysicalPosition[] oPhysicalPositionArray = this.delegate.higherPhysicalPositions(currentClusterId, physicalPosition);
            return oPhysicalPositionArray;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        this.pushSession();
        try {
            OPhysicalPosition[] oPhysicalPositionArray = this.delegate.lowerPhysicalPositions(currentClusterId, physicalPosition);
            return oPhysicalPositionArray;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        this.pushSession();
        try {
            OPhysicalPosition[] oPhysicalPositionArray = this.delegate.ceilingPhysicalPositions(clusterId, physicalPosition);
            return oPhysicalPositionArray;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        this.pushSession();
        try {
            OPhysicalPosition[] oPhysicalPositionArray = this.delegate.floorPhysicalPositions(clusterId, physicalPosition);
            return oPhysicalPositionArray;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        this.pushSession();
        try {
            long l = this.delegate.getSize();
            return l;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countRecords() {
        this.pushSession();
        try {
            long l = this.delegate.countRecords();
            return l;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(int[] iClusterIds) {
        this.pushSession();
        try {
            long l = this.delegate.count(iClusterIds);
            return l;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object command(OCommandRequestText iCommand) {
        this.pushSession();
        try {
            Object object = this.delegate.command(iCommand);
            return object;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(OTransaction iTx, Runnable callback) {
        this.pushSession();
        try {
            this.delegate.commit(iTx, null);
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(OTransaction iTx) {
        this.pushSession();
        try {
            this.delegate.rollback(iTx);
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusterIdByName(String iClusterName) {
        this.pushSession();
        try {
            int n = this.delegate.getClusterIdByName(iClusterName);
            return n;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClusterTypeByName(String iClusterName) {
        this.pushSession();
        try {
            String string = this.delegate.getClusterTypeByName(iClusterName);
            return string;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultClusterId() {
        this.pushSession();
        try {
            int n = this.delegate.getDefaultClusterId();
            return n;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultClusterId(int defaultClusterId) {
        this.pushSession();
        try {
            this.delegate.setDefaultClusterId(defaultClusterId);
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iArguments) {
        this.pushSession();
        try {
            int n = this.delegate.addCluster(iClusterType, iClusterName, iLocation, iDataSegmentName, false, iArguments);
            return n;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCluster(String iClusterType, String iClusterName, int iRequestedId, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        this.pushSession();
        try {
            int n = this.delegate.addCluster(iClusterType, iClusterName, iRequestedId, iLocation, iDataSegmentName, forceListBased, iParameters);
            return n;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        this.pushSession();
        try {
            boolean bl = this.delegate.dropCluster(iClusterId, iTruncate);
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    public ODataSegment getDataSegmentById(int iDataSegmentId) {
        return this.delegate.getDataSegmentById(iDataSegmentId);
    }

    public int getDataSegmentIdByName(String iDataSegmentName) {
        return this.delegate.getDataSegmentIdByName(iDataSegmentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDataSegment(String iDataSegmentName) {
        this.pushSession();
        try {
            int n = this.delegate.addDataSegment(iDataSegmentName);
            return n;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDataSegment(String iSegmentName, String iSegmentFileName) {
        this.pushSession();
        try {
            int n = this.delegate.addDataSegment(iSegmentName, iSegmentFileName);
            return n;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropDataSegment(String iSegmentName) {
        this.pushSession();
        try {
            boolean bl = this.delegate.dropDataSegment(iSegmentName);
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synch() {
        this.pushSession();
        try {
            this.delegate.synch();
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPhysicalClusterNameById(int iClusterId) {
        this.pushSession();
        try {
            String string = this.delegate.getPhysicalClusterNameById(iClusterId);
            return string;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusters() {
        this.pushSession();
        try {
            int n = this.delegate.getClusterMap();
            return n;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OCluster> getClusterInstances() {
        this.pushSession();
        try {
            Collection<OCluster> collection = this.delegate.getClusterInstances();
            return collection;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCluster getClusterById(int iId) {
        this.pushSession();
        try {
            OCluster oCluster = this.delegate.getClusterById(iId);
            return oCluster;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getVersion() {
        this.pushSession();
        try {
            long l = this.delegate.getVersion();
            return l;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPermanentRequester() {
        this.pushSession();
        try {
            boolean bl = this.delegate.isPermanentRequester();
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterConfiguration(byte[] iContent) {
        this.pushSession();
        try {
            this.delegate.updateClusterConfiguration(iContent);
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageConfiguration getConfiguration() {
        this.pushSession();
        try {
            OStorageConfiguration oStorageConfiguration = this.delegate.getConfiguration();
            return oStorageConfiguration;
        }
        finally {
            this.popSession();
        }
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        this.pushSession();
        try {
            boolean bl = this.delegate.checkForRecordValidity(ppos);
            return bl;
        }
        finally {
            this.popSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        this.pushSession();
        try {
            String string = this.delegate.getName();
            return string;
        }
        finally {
            this.popSession();
        }
    }

    public String getURL() {
        return this.delegate.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginResponse(OChannelBinaryClient iNetwork) throws IOException {
        this.pushSession();
        try {
            this.delegate.beginResponse(iNetwork);
        }
        finally {
            this.popSession();
        }
    }

    public OLevel2RecordCache getLevel2Cache() {
        return this.delegate.getLevel2Cache();
    }

    public boolean existsResource(String iName) {
        return this.delegate.existsResource(iName);
    }

    public synchronized <T> T getResource(String iName, Callable<T> iCallback) {
        return (T)this.delegate.getResource(iName, iCallback);
    }

    public <T> T removeResource(String iName) {
        return (T)this.delegate.removeResource(iName);
    }

    public ODocument getClusterConfiguration() {
        return this.delegate.getClusterConfiguration();
    }

    protected void handleException(OChannelBinaryClient iNetwork, String iMessage, Exception iException) {
        this.delegate.handleException(iNetwork, iMessage, iException);
    }

    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return (V)this.delegate.callInLock(iCallable, iExclusiveLock);
    }

    public ORemoteServerEventListener getRemoteServerEventListener() {
        return this.delegate.getAsynchEventListener();
    }

    public void setRemoteServerEventListener(ORemoteServerEventListener iListener) {
        this.delegate.setAsynchEventListener(iListener);
    }

    public void removeRemoteServerEventListener() {
        this.delegate.removeRemoteServerEventListener();
    }

    public static int getNextConnectionId() {
        return sessionSerialId.decrementAndGet();
    }

    public void checkForClusterPermissions(String iClusterName) {
        this.delegate.checkForClusterPermissions(iClusterName);
    }

    public OStorage.STATUS getStatus() {
        return this.delegate.getStatus();
    }

    public String getType() {
        return this.delegate.getType();
    }

    public boolean equals(Object iOther) {
        return iOther == this || iOther == this.delegate;
    }

    protected void pushSession() {
        this.delegate.setSessionId(this.serverURL, this.sessionId);
    }

    protected void popSession() {
        this.serverURL = this.delegate.getServerURL();
        this.sessionId = this.delegate.getSessionId();
    }
}

