/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeRidBag;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OSBTreeBonsaiRemote<K, V>
implements OSBTreeBonsai<K, V> {
    private final OBonsaiCollectionPointer treePointer;
    private final OBinarySerializer<K> keySerializer;
    private final OBinarySerializer<V> valueSerializer;

    public OSBTreeBonsaiRemote(OBonsaiCollectionPointer treePointer, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        this.treePointer = treePointer;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public long getFileId() {
        return this.treePointer.getFileId();
    }

    public OBonsaiBucketPointer getRootBucketPointer() {
        return this.treePointer.getRootPointer();
    }

    public OBonsaiCollectionPointer getCollectionPointer() {
        return this.treePointer;
    }

    public V get(K key) {
        OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        byte[] keyStream = new byte[this.keySerializer.getObjectSize(key, new Object[0])];
        this.keySerializer.serialize(key, keyStream, 0, new Object[0]);
        try {
            OChannelBinaryAsynchClient client = storage.beginRequest((byte)111);
            OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer((OChannelBinary)client, this.getCollectionPointer());
            client.writeBytes(keyStream);
            storage.endRequest(client);
            storage.beginResponse(client);
            byte[] stream = client.readBytes();
            storage.endResponse(client);
            byte serializerId = OByteSerializer.INSTANCE.deserialize(stream, 0);
            OBinarySerializer serializer = OBinarySerializerFactory.INSTANCE.getObjectSerializer(serializerId);
            return (V)serializer.deserialize(stream, 1);
        }
        catch (IOException e) {
            throw new ODatabaseException("Can't get first key from sb-tree bonsai.", (Throwable)e);
        }
    }

    public boolean put(K key, V value) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public V remove(K key) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void clear() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void delete() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public long size() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Collection<V> getValuesMinor(K key, boolean inclusive, int maxValuesToFetch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void loadEntriesMinor(K key, boolean inclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Collection<V> getValuesMajor(K key, boolean inclusive, int maxValuesToFetch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void loadEntriesMajor(K key, boolean inclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        List<Map.Entry<K, V>> entries = this.fetchEntriesMajor(key, inclusive);
        while (this.pushEntriesToListener(listener, entries)) {
            K nextKey = entries.get(entries.size() - 1).getKey();
            entries = this.fetchEntriesMajor(nextKey, false);
        }
    }

    private boolean pushEntriesToListener(OTreeInternal.RangeResultListener<K, V> listener, List<Map.Entry<K, V>> entries) {
        boolean more = false;
        for (Map.Entry<K, V> entry : entries) {
            more = listener.addResult(entry);
            if (more) continue;
            return false;
        }
        return more;
    }

    private List<Map.Entry<K, V>> fetchEntriesMajor(K key, boolean inclusive) {
        byte[] keyStream = new byte[this.keySerializer.getObjectSize(key, new Object[0])];
        this.keySerializer.serialize(key, keyStream, 0, new Object[0]);
        OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        try {
            OChannelBinaryAsynchClient client = storage.beginRequest((byte)113);
            OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer((OChannelBinary)client, this.getCollectionPointer());
            client.writeBytes(keyStream);
            client.writeBoolean(inclusive);
            storage.endRequest(client);
            storage.beginResponse(client);
            byte[] stream = client.readBytes();
            int offset = 0;
            int count = OIntegerSerializer.INSTANCE.deserialize(stream, 0);
            offset += 4;
            ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(count);
            for (int i = 0; i < count; ++i) {
                Object resultKey = this.keySerializer.deserialize(stream, offset);
                offset += this.keySerializer.getObjectSize(stream, offset);
                Object resultValue = this.valueSerializer.deserialize(stream, offset);
                offset += this.valueSerializer.getObjectSize(stream, offset);
                list.add(new TreeEntry<Object, Object>(resultKey, resultValue));
            }
            storage.endResponse(client);
            return list;
        }
        catch (IOException e) {
            throw new ODatabaseException("Can't get first key from sb-tree bonsai.", (Throwable)e);
        }
    }

    public Collection<V> getValuesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, int maxValuesToFetch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public K firstKey() {
        OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        try {
            OChannelBinaryAsynchClient client = storage.beginRequest((byte)112);
            OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer((OChannelBinary)client, this.getCollectionPointer());
            storage.endRequest(client);
            storage.beginResponse(client);
            byte[] stream = client.readBytes();
            storage.endResponse(client);
            byte serializerId = OByteSerializer.INSTANCE.deserialize(stream, 0);
            OBinarySerializer serializer = OBinarySerializerFactory.INSTANCE.getObjectSerializer(serializerId);
            return (K)serializer.deserialize(stream, 1);
        }
        catch (IOException e) {
            throw new ODatabaseException("Can't get first key from sb-tree bonsai.", (Throwable)e);
        }
    }

    public K lastKey() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void loadEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public int getRealBagSize(Map<K, OSBTreeRidBag.Change> changes) {
        OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        try {
            OChannelBinaryAsynchClient client = storage.beginRequest((byte)114);
            OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer((OChannelBinary)client, this.getCollectionPointer());
            OSBTreeRidBag.ChangeSerializationHelper changeSerializer = OSBTreeRidBag.ChangeSerializationHelper.INSTANCE;
            byte[] stream = new byte[4 + changeSerializer.getChangesSerializedSize(changes.size())];
            changeSerializer.serializeChanges(changes, this.keySerializer, stream, 0);
            client.writeBytes(stream);
            storage.endRequest(client);
            storage.beginResponse(client);
            int result = client.readInt();
            storage.endResponse(client);
            return result;
        }
        catch (IOException e) {
            throw new ODatabaseException("Can't get first key from sb-tree bonsai.", (Throwable)e);
        }
    }

    public OBinarySerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public OBinarySerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    class TreeEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        TreeEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

