/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.concur.lock.OAdaptiveLock;
import com.orientechnologies.common.concur.lock.OLock;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OClusterRemote;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.OSBTreeCollectionManagerRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteAsynchEventListener;
import com.orientechnologies.orient.client.remote.OStorageRemoteThreadLocal;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCacheLevelTwoLocator;
import com.orientechnologies.orient.core.cache.OCacheLevelTwoLocatorRemote;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequestAsynch;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryProtocol;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelListener;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class OStorageRemote
extends OStorageAbstract
implements OStorageProxy,
OChannelListener {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 2424;
    private static final String ADDRESS_SEPARATOR = ";";
    public static final String PARAM_MIN_POOL = "minpool";
    public static final String PARAM_MAX_POOL = "maxpool";
    public static final String PARAM_DB_TYPE = "dbtype";
    private static final String DRIVER_NAME = "OrientDB Java";
    private final ExecutorService asynchExecutor;
    private OContextConfiguration clientConfiguration;
    private int connectionRetry;
    private int connectionRetryDelay;
    private final List<OChannelBinaryAsynchClient> networkPool = new ArrayList<OChannelBinaryAsynchClient>();
    private final OLock networkPoolLock = new OAdaptiveLock();
    private int networkPoolCursor = 0;
    protected final List<String> serverURLs = new ArrayList<String>();
    private OCluster[] clusters = new OCluster[0];
    protected final Map<String, OCluster> clusterMap = new ConcurrentHashMap<String, OCluster>();
    private int defaultClusterId;
    private int minPool;
    private int maxPool;
    private final ODocument clusterConfiguration = new ODocument();
    private ORemoteServerEventListener asynchEventListener;
    private String connectionDbType;
    private String connectionUserName;
    private String connectionUserPassword;
    private Map<String, Object> connectionOptions;
    private final String clientId;
    private final int maxReadQueue;

    public OStorageRemote(String iClientId, String iURL, String iMode) throws IOException {
        this(iClientId, iURL, iMode, null);
    }

    public OStorageRemote(String iClientId, String iURL, String iMode, OStorage.STATUS status) throws IOException {
        super(iURL, iURL, iMode, 0, (OCacheLevelTwoLocator)new OCacheLevelTwoLocatorRemote());
        if (status != null) {
            this.status = status;
        }
        this.clientId = iClientId;
        this.configuration = null;
        this.clientConfiguration = new OContextConfiguration();
        this.connectionRetry = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY);
        this.connectionRetryDelay = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY_DELAY);
        this.asynchEventListener = new OStorageRemoteAsynchEventListener(this);
        this.parseServerURLs();
        this.asynchExecutor = Executors.newSingleThreadScheduledExecutor();
        this.maxReadQueue = Runtime.getRuntime().availableProcessors() - 1;
    }

    public int getSessionId() {
        return ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId;
    }

    public String getServerURL() {
        return ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).serverURL;
    }

    public void setSessionId(String iServerURL, int iSessionId) {
        OStorageRemoteThreadLocal.OStorageRemoteSession tl = (OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get();
        tl.serverURL = iServerURL;
        tl.sessionId = iSessionId;
    }

    public ORemoteServerEventListener getAsynchEventListener() {
        return this.asynchEventListener;
    }

    public void setAsynchEventListener(ORemoteServerEventListener iListener) {
        this.asynchEventListener = iListener;
    }

    public void removeRemoteServerEventListener() {
        this.asynchEventListener = null;
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.addUser();
        this.lock.acquireExclusiveLock();
        try {
            this.connectionUserName = iUserName;
            this.connectionUserPassword = iUserPassword;
            this.connectionOptions = iOptions != null ? new HashMap<String, Object>(iOptions) : null;
            this.openRemoteDatabase();
            this.configuration = new OStorageConfiguration((OStorage)this);
            this.configuration.load();
            this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
        }
        catch (Exception e) {
            if (!OGlobalConfiguration.STORAGE_KEEP_OPEN.getValueAsBoolean()) {
                this.close();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new OStorageException("Cannot open the remote storage: " + this.name, (Throwable)e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        this.checkConnection();
        this.lock.acquireExclusiveLock();
        try {
            OChannelBinaryAsynchClient network = null;
            while (true) {
                try {
                    try {
                        network = this.beginRequest((byte)73);
                    }
                    finally {
                        this.endRequest(network);
                    }
                    try {
                        this.beginResponse(network);
                        this.readDatabaseInformation(network);
                    }
                    finally {
                        this.endResponse(network);
                    }
                }
                catch (Exception e) {
                    this.handleException(network, "Error on reloading database information", e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void create(Map<String, Object> iOptions) {
        throw new UnsupportedOperationException("Cannot create a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    public boolean exists() {
        throw new UnsupportedOperationException("Cannot check the existance of a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean iForce, boolean onDelete) {
        OChannelBinaryAsynchClient network = null;
        this.lock.acquireExclusiveLock();
        try {
            block17: {
                this.networkPoolLock.lock();
                try {
                    if (this.networkPool.size() <= 0) break block17;
                    try {
                        network = this.beginRequest((byte)5);
                    }
                    finally {
                        this.endRequest(network);
                    }
                }
                finally {
                    this.networkPoolLock.unlock();
                }
            }
            this.setSessionId(null, -1);
            if (!this.checkForClose(iForce)) {
                return;
            }
            this.networkPoolLock.lock();
            try {
                for (OChannelBinaryAsynchClient n : new ArrayList<OChannelBinaryAsynchClient>(this.networkPool)) {
                    n.close();
                }
                this.networkPool.clear();
            }
            finally {
                this.networkPoolLock.unlock();
            }
            this.level2Cache.shutdown();
            super.close(iForce, onDelete);
            this.status = OStorage.STATUS.CLOSED;
            Orient.instance().unregisterStorage((OStorage)this);
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error on closing remote connection: %s", new Object[]{network});
            network.close();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void delete() {
        throw new UnsupportedOperationException("Cannot delete a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getClusterNames() {
        this.lock.acquireSharedLock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.clusterMap.keySet());
            return hashSet;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OStorageOperationResult<OPhysicalPosition> createRecord(int iDataSegmentId, final ORecordId iRid, byte[] iContent, ORecordVersion iRecordVersion, byte iRecordType, int iMode, final ORecordCallback<OClusterPosition> iCallback) {
        this.checkConnection();
        if (iMode == 1 && iCallback == null) {
            iMode = 2;
        }
        OPhysicalPosition ppos = new OPhysicalPosition(iDataSegmentId, -1L, iRecordType);
        OChannelBinaryAsynchClient lastNetworkUsed = null;
        while (true) {
            try {
                OChannelBinaryAsynchClient network;
                lastNetworkUsed = network = this.beginRequest((byte)31);
                try {
                    if (network.getSrvProtocolVersion() >= 10) {
                        network.writeInt(iDataSegmentId);
                    }
                    network.writeShort((short)iRid.clusterId);
                    network.writeBytes(iContent);
                    network.writeByte(iRecordType);
                    network.writeByte((byte)iMode);
                }
                finally {
                    this.endRequest(network);
                }
                switch (iMode) {
                    case 0: {
                        try {
                            this.beginResponse(network);
                            ppos.clusterPosition = iRid.clusterPosition = network.readClusterPosition();
                            ppos.recordVersion = network.getSrvProtocolVersion() >= 11 ? network.readVersion() : OVersionFactory.instance().createVersion();
                            if (network.getSrvProtocolVersion() >= 20) {
                                this.readCollectionChanges(network, ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager());
                            }
                            OStorageOperationResult oStorageOperationResult = new OStorageOperationResult((Object)ppos);
                            return oStorageOperationResult;
                        }
                        finally {
                            this.endResponse(network);
                        }
                    }
                    case 1: {
                        if (iCallback == null) return new OStorageOperationResult((Object)ppos);
                        final int sessionId = this.getSessionId();
                        final OSBTreeCollectionManager collectionManager = ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager();
                        Callable<Object> response = new Callable<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object call() throws Exception {
                                OClusterPosition result;
                                try {
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = sessionId;
                                    OStorageRemote.this.beginResponse(network);
                                    result = network.readClusterPosition();
                                    if (network.getSrvProtocolVersion() >= 11) {
                                        network.readVersion();
                                    }
                                    if (network.getSrvProtocolVersion() >= 20) {
                                        OStorageRemote.this.readCollectionChanges(network, collectionManager);
                                    }
                                }
                                finally {
                                    OStorageRemote.this.endResponse(network);
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = -1;
                                }
                                iCallback.call(iRid, (Object)result);
                                return null;
                            }
                        };
                        this.asynchExecutor.submit(new FutureTask<Object>(response));
                        return new OStorageOperationResult((Object)ppos);
                    }
                }
                return new OStorageOperationResult((Object)ppos);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(lastNetworkUsed, "Error on create record in cluster: " + iRid.clusterId, e);
                continue;
            }
            break;
        }
    }

    public boolean updateReplica(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        throw new UnsupportedOperationException("updateReplica()");
    }

    public <V> V callInRecordLock(Callable<V> iCallable, ORID rid, boolean iExclusiveLock) {
        throw new UnsupportedOperationException("callInRecordLock()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORecordMetadata getRecordMetadata(ORID rid) {
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)29);
                network.writeRID(rid);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                ORecordId responseRid = network.readRID();
                ORecordVersion responseVersion = network.readVersion();
                ORecordMetadata oRecordMetadata = new ORecordMetadata((ORID)responseRid, responseVersion);
                this.endResponse(network);
                return oRecordMetadata;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on read record " + rid, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback, boolean loadTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkConnection();
        if (((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting) {
            return new OStorageOperationResult(null);
        }
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                try {
                    network = this.beginRequest((byte)30);
                    network.writeRID((ORID)iRid);
                    network.writeString(iFetchPlan != null ? iFetchPlan : "");
                    if (network.getSrvProtocolVersion() >= 9) {
                        network.writeByte((byte)(iIgnoreCache ? 1 : 0));
                    }
                    if (network.getSrvProtocolVersion() >= 13) {
                        network.writeByte(loadTombstones ? (byte)1 : 0);
                    }
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    if (network.readByte() == 0) {
                        OStorageOperationResult oStorageOperationResult = new OStorageOperationResult(null);
                        return oStorageOperationResult;
                    }
                    ORawBuffer buffer = new ORawBuffer(network.readBytes(), network.readVersion(), network.readByte());
                    ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
                    while (network.readByte() == 2) {
                        ORecordInternal record = (ORecordInternal)OChannelBinaryProtocol.readIdentifiable((OChannelBinaryAsynchClient)network);
                        if (database == null) continue;
                        database.getLevel1Cache().updateRecord(record);
                    }
                    OStorageOperationResult oStorageOperationResult = new OStorageOperationResult((Object)buffer);
                    return oStorageOperationResult;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException(network, "Error on read record " + iRid, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OStorageOperationResult<ORecordVersion> updateRecord(final ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType, int iMode, final ORecordCallback<ORecordVersion> iCallback) {
        this.checkConnection();
        if (iMode == 1 && iCallback == null) {
            iMode = 2;
        }
        OChannelBinaryAsynchClient lastNetworkUsed = null;
        while (true) {
            try {
                OChannelBinaryAsynchClient network;
                lastNetworkUsed = network = this.beginRequest((byte)32);
                try {
                    network.writeRID((ORID)iRid);
                    network.writeBytes(iContent);
                    network.writeVersion(iVersion);
                    network.writeByte(iRecordType);
                    network.writeByte((byte)iMode);
                }
                finally {
                    this.endRequest(network);
                }
                switch (iMode) {
                    case 0: {
                        try {
                            this.beginResponse(network);
                            OStorageOperationResult r = new OStorageOperationResult((Object)network.readVersion());
                            this.readCollectionChanges(network, ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager());
                            OStorageOperationResult oStorageOperationResult = r;
                            return oStorageOperationResult;
                        }
                        finally {
                            this.endResponse(network);
                        }
                    }
                    case 1: {
                        final int sessionId = this.getSessionId();
                        final OSBTreeCollectionManager collectionManager = ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager();
                        Callable<Object> response = new Callable<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object call() throws Exception {
                                ORecordVersion result;
                                try {
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = sessionId;
                                    OStorageRemote.this.beginResponse(network);
                                    result = network.readVersion();
                                    if (network.getSrvProtocolVersion() >= 20) {
                                        OStorageRemote.this.readCollectionChanges(network, collectionManager);
                                    }
                                }
                                finally {
                                    OStorageRemote.this.endResponse(network);
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = -1;
                                }
                                iCallback.call(iRid, (Object)result);
                                return null;
                            }
                        };
                        this.asynchExecutor.submit(new FutureTask<Object>(response));
                        return new OStorageOperationResult((Object)iVersion);
                    }
                }
                return new OStorageOperationResult((Object)iVersion);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(lastNetworkUsed, "Error on update record " + iRid, e);
                continue;
            }
            break;
        }
    }

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRid, ORecordVersion iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        this.checkConnection();
        if (iMode == 1 && iCallback == null) {
            iMode = 2;
        }
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)33);
                return new OStorageOperationResult((Object)this.deleteRecord(iRid, iVersion, iMode, iCallback, network));
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(network, "Error on delete record " + iRid, e);
                continue;
            }
            break;
        }
    }

    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        this.checkConnection();
        if (iMode == 1 && callback == null) {
            iMode = 2;
        }
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)38);
                return this.deleteRecord(recordId, recordVersion, iMode, callback, network);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(network, "Error on clean out record " + recordId, e);
                continue;
            }
            break;
        }
    }

    public void backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        throw new UnsupportedOperationException("backup");
    }

    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        throw new UnsupportedOperationException("restore");
    }

    public long count(int iClusterId) {
        return this.count(new int[]{iClusterId});
    }

    public long count(int iClusterId, boolean countTombstones) {
        return this.count(new int[]{iClusterId}, countTombstones);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPosition[] getClusterDataRange(int iClusterId) {
        this.checkConnection();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)13);
                network.writeShort((short)iClusterId);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                OClusterPosition[] oClusterPositionArray = new OClusterPosition[]{network.readClusterPosition(), network.readClusterPosition()};
                this.endResponse(network);
                return oClusterPositionArray;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on getting last entry position count in cluster: " + iClusterId, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPhysicalPosition[] higherPhysicalPositions(int iClusterId, OPhysicalPosition iClusterPosition) {
        this.checkConnection();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                try {
                    network = this.beginRequest((byte)36);
                    network.writeInt(iClusterId);
                    network.writeClusterPosition(iClusterPosition.clusterPosition);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException(network, "Error on retrieving higher positions after " + iClusterPosition.clusterPosition, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        this.checkConnection();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                try {
                    network = this.beginRequest((byte)42);
                    network.writeInt(clusterId);
                    network.writeClusterPosition(physicalPosition.clusterPosition);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException(network, "Error on retrieving ceiling positions after " + physicalPosition.clusterPosition, e);
                continue;
            }
            break;
        }
    }

    private OPhysicalPosition[] readPhysicalPositions(OChannelBinaryAsynchClient network, int positionsCount) throws IOException {
        OPhysicalPosition[] physicalPositions = new OPhysicalPosition[positionsCount];
        for (int i = 0; i < physicalPositions.length; ++i) {
            OPhysicalPosition position = new OPhysicalPosition();
            position.clusterPosition = network.readClusterPosition();
            position.dataSegmentId = network.readInt();
            position.dataSegmentPos = network.readLong();
            position.recordSize = network.readInt();
            position.recordVersion = network.readVersion();
            physicalPositions[i] = position;
        }
        return physicalPositions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPhysicalPosition[] lowerPhysicalPositions(int iClusterId, OPhysicalPosition physicalPosition) {
        this.checkConnection();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                try {
                    network = this.beginRequest((byte)37);
                    network.writeInt(iClusterId);
                    network.writeClusterPosition(physicalPosition.clusterPosition);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException(network, "Error on retrieving lower positions after " + physicalPosition.clusterPosition, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        this.checkConnection();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                try {
                    network = this.beginRequest((byte)39);
                    network.writeInt(clusterId);
                    network.writeClusterPosition(physicalPosition.clusterPosition);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException(network, "Error on retrieving floor positions after " + physicalPosition.clusterPosition, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        this.checkConnection();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)8);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on read database size", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countRecords() {
        this.checkConnection();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)9);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on read database record count", e);
                    continue;
                }
            }
            break;
        }
    }

    public long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(int[] iClusterIds, boolean countTombstones) {
        this.checkConnection();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)12);
                network.writeShort((short)iClusterIds.length);
                for (int iClusterId : iClusterIds) {
                    network.writeShort((short)iClusterId);
                }
                if (network.getSrvProtocolVersion() >= 13) {
                    network.writeByte(countTombstones ? (byte)1 : 0);
                }
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long arr$ = network.readLong();
                this.endResponse(network);
                return arr$;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on read record count in clusters: " + Arrays.toString(iClusterIds), e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object command(OCommandRequestText iCommand) {
        this.checkConnection();
        if (!(iCommand instanceof OSerializableStream)) {
            throw new OCommandExecutionException("Cannot serialize the command to be executed to the server side.");
        }
        OCommandRequestText command = iCommand;
        Object result = null;
        ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.get();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = true;
            OCommandRequestText aquery = iCommand;
            try {
                boolean asynch = iCommand instanceof OCommandRequestAsynch && ((OCommandRequestAsynch)iCommand).isAsynchronous();
                try {
                    network = this.beginRequest((byte)41);
                    network.writeByte((byte)(asynch ? 97 : 115));
                    network.writeBytes(OStreamSerializerAnyStreamable.INSTANCE.toStream((Object)command));
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    boolean addNextRecord = true;
                    if (asynch) {
                        byte status;
                        while ((status = network.readByte()) > 0) {
                            ORecordInternal record = (ORecordInternal)OChannelBinaryProtocol.readIdentifiable((OChannelBinaryAsynchClient)network);
                            if (record == null) continue;
                            switch (status) {
                                case 1: {
                                    if (!addNextRecord) break;
                                    addNextRecord = aquery.getResultListener().result((Object)record);
                                    database.getLevel1Cache().updateRecord(record);
                                    break;
                                }
                                case 2: {
                                    database.getLevel1Cache().updateRecord(record);
                                }
                            }
                        }
                    } else {
                        byte type = network.readByte();
                        switch (type) {
                            case 110: {
                                result = null;
                                break;
                            }
                            case 114: {
                                result = OChannelBinaryProtocol.readIdentifiable((OChannelBinaryAsynchClient)network);
                                if (!(result instanceof ORecord)) break;
                                database.getLevel1Cache().updateRecord((ORecordInternal)result);
                                break;
                            }
                            case 108: {
                                int tot = network.readInt();
                                ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>(tot);
                                for (int i = 0; i < tot; ++i) {
                                    OIdentifiable resultItem = OChannelBinaryProtocol.readIdentifiable((OChannelBinaryAsynchClient)network);
                                    if (resultItem instanceof ORecord) {
                                        database.getLevel1Cache().updateRecord((ORecordInternal)resultItem);
                                    }
                                    list.add(resultItem);
                                }
                                result = list;
                                break;
                            }
                            case 97: {
                                String value = new String(network.readBytes());
                                result = ORecordSerializerStringAbstract.fieldTypeFromStream(null, (OType)ORecordSerializerStringAbstract.getType((String)value), (Object)value);
                                break;
                            }
                            default: {
                                OLogManager.instance().warn((Object)this, "Received unexpected result from query: %d", new Object[]{type});
                            }
                        }
                        if (network.getSrvProtocolVersion() >= 17) {
                            byte status;
                            while ((status = network.readByte()) > 0) {
                                ORecordInternal record = (ORecordInternal)OChannelBinaryProtocol.readIdentifiable((OChannelBinaryAsynchClient)network);
                                if (record == null || status != 2) continue;
                                database.getLevel1Cache().updateRecord(record);
                            }
                        }
                    }
                    this.endResponse(network);
                }
                catch (Throwable throwable) {
                    try {
                        this.endResponse(network);
                        throw throwable;
                    }
                    catch (OModificationOperationProhibitedException mope) {
                        this.handleDBFreeze();
                        ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                        if (aquery.getResultListener() == null) continue;
                        aquery.getResultListener().end();
                        continue;
                    }
                    catch (Exception e) {
                        this.handleException(network, "Error on executing command: " + iCommand, e);
                        continue;
                    }
                }
            }
            finally {
                ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                if (aquery.getResultListener() == null) continue;
                aquery.getResultListener().end();
                continue;
            }
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(OTransaction iTx, Runnable callback) {
        this.checkConnection();
        ArrayList<ORecordOperation> committedEntries = new ArrayList<ORecordOperation>();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = true;
                try {
                    network = this.beginRequest((byte)60);
                    network.writeInt(iTx.getId());
                    network.writeByte((byte)(iTx.isUsingLog() ? 1 : 0));
                    ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
                    if (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                        while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                            for (ORecordOperation txEntry : iTx.getCurrentRecordEntries()) {
                                tmpEntries.add(txEntry);
                            }
                            iTx.clearRecordEntries();
                            if (tmpEntries.size() <= 0) continue;
                            for (ORecordOperation txEntry : tmpEntries) {
                                this.commitEntry(network, txEntry);
                                committedEntries.add(txEntry);
                            }
                            tmpEntries.clear();
                        }
                    } else if (committedEntries.size() > 0) {
                        for (ORecordOperation txEntry : committedEntries) {
                            this.commitEntry(network, txEntry);
                        }
                    }
                    network.writeByte((byte)0);
                    network.writeBytes(iTx.getIndexChanges().toStream());
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int createdRecords = network.readInt();
                    for (int i = 0; i < createdRecords; ++i) {
                        ORecordId currentRid = network.readRID();
                        ORecordId createdRid = network.readRID();
                        iTx.updateIdentityAfterCommit((ORID)currentRid, (ORID)createdRid);
                    }
                    int updatedRecords = network.readInt();
                    for (int i = 0; i < updatedRecords; ++i) {
                        ORecordId rid = network.readRID();
                        ORecordOperation rop = iTx.getRecordEntry((ORID)rid);
                        if (rop == null) continue;
                        rop.getRecord().getRecordVersion().copyFrom(network.readVersion());
                    }
                    committedEntries.clear();
                    if (network.getSrvProtocolVersion() >= 20) {
                        this.readCollectionChanges(network, ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager());
                    }
                }
                finally {
                    this.endResponse(network);
                }
                for (ORecordOperation txEntry : iTx.getAllRecordEntries()) {
                    txEntry.getRecord().unsetDirty();
                }
                OTransactionAbstract.updateCacheFromEntries((OTransaction)iTx, (Iterable)iTx.getAllRecordEntries(), (boolean)false);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(network, "Error on commit", e);
                continue;
            }
            finally {
                ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                continue;
            }
            break;
        }
    }

    private void readCollectionChanges(OChannelBinaryAsynchClient network, OSBTreeCollectionManager collectionManager) throws IOException {
        int count = network.readInt();
        for (int i = 0; i < count; ++i) {
            long mBitsOfId = network.readLong();
            long lBitsOfId = network.readLong();
            OBonsaiCollectionPointer pointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer((OChannelBinary)network);
            collectionManager.updateCollectionPointer(new UUID(mBitsOfId, lBitsOfId), pointer);
        }
        if (ORecordSerializationContext.getDepth() <= 1) {
            collectionManager.clearPendingCollections();
        }
    }

    public void rollback(OTransaction iTx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusterIdByName(String iClusterName) {
        this.lock.acquireSharedLock();
        try {
            this.checkConnection();
            if (iClusterName == null) {
                int n = -1;
                return n;
            }
            if (Character.isDigit(iClusterName.charAt(0))) {
                int n = Integer.parseInt(iClusterName);
                return n;
            }
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
            if (cluster == null) {
                int n = -1;
                return n;
            }
            int n = cluster.getId();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClusterTypeByName(String iClusterName) {
        this.lock.acquireSharedLock();
        try {
            this.checkConnection();
            if (iClusterName == null) {
                String string = null;
                return string;
            }
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
            if (cluster == null) {
                String string = null;
                return string;
            }
            String string = cluster.getType();
            return string;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iArguments) {
        return this.addCluster(iClusterType, iClusterName, -1, iLocation, iDataSegmentName, forceListBased, iArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCluster(String iClusterType, String iClusterName, int iRequestedId, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        this.checkConnection();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            this.lock.acquireExclusiveLock();
            try {
                try {
                    network = this.beginRequest((byte)10);
                    network.writeString(iClusterType.toString());
                    network.writeString(iClusterName);
                    if (network.getSrvProtocolVersion() >= 10 || iClusterType.equalsIgnoreCase("PHYSICAL")) {
                        network.writeString(iLocation);
                    }
                    if (network.getSrvProtocolVersion() >= 10) {
                        network.writeString(iDataSegmentName);
                    } else {
                        network.writeInt(-1);
                    }
                    if (network.getSrvProtocolVersion() >= 18) {
                        network.writeShort((short)iRequestedId);
                    }
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    short clusterId = network.readShort();
                    OClusterRemote cluster = new OClusterRemote();
                    cluster.setType(iClusterType);
                    cluster.configure((OStorage)this, clusterId, iClusterName.toLowerCase(), null, 0, new Object[0]);
                    if (this.clusters.length <= clusterId) {
                        this.clusters = Arrays.copyOf(this.clusters, clusterId + 1);
                    }
                    this.clusters[cluster.getId()] = cluster;
                    this.clusterMap.put(cluster.getName().toLowerCase(), cluster);
                    short s = clusterId;
                    this.endResponse(network);
                    return s;
                }
                catch (Throwable throwable) {
                    try {
                        this.endResponse(network);
                        throw throwable;
                    }
                    catch (OModificationOperationProhibitedException mphe) {
                        this.handleDBFreeze();
                        this.lock.releaseExclusiveLock();
                        continue;
                    }
                    catch (Exception e) {
                        this.handleException(network, "Error on add new cluster", e);
                        continue;
                    }
                }
            }
            finally {
                this.lock.releaseExclusiveLock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        this.checkConnection();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            this.lock.acquireExclusiveLock();
            try {
                try {
                    network = this.beginRequest((byte)11);
                    network.writeShort((short)iClusterId);
                }
                finally {
                    this.endRequest(network);
                }
                byte result = 0;
                try {
                    this.beginResponse(network);
                    result = network.readByte();
                }
                finally {
                    this.endResponse(network);
                }
                if (result == 1) {
                    OCluster cluster = this.clusters[iClusterId];
                    this.clusters[iClusterId] = null;
                    this.clusterMap.remove(cluster.getName());
                    if (this.configuration.clusters.size() > iClusterId) {
                        this.configuration.dropCluster(iClusterId);
                    }
                    this.getLevel2Cache().freeCluster(iClusterId);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(network, "Error on removing of cluster", e);
                continue;
            }
            finally {
                this.lock.releaseExclusiveLock();
                continue;
            }
            break;
        }
    }

    public int addDataSegment(String iDataSegmentName) {
        return this.addDataSegment(iDataSegmentName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDataSegment(String iSegmentName, String iLocation) {
        this.checkConnection();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)20);
                network.writeString(iSegmentName).writeString(iLocation);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                int n = network.readInt();
                this.endResponse(network);
                return n;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OModificationOperationProhibitedException mphe) {
                    this.handleDBFreeze();
                    continue;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on add new data segment", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropDataSegment(String iSegmentName) {
        this.checkConnection();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)21);
                network.writeString(iSegmentName);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                boolean bl = network.readByte() == 1;
                this.endResponse(network);
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OModificationOperationProhibitedException mope) {
                    this.handleDBFreeze();
                    continue;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on remove data segment", e);
                    continue;
                }
            }
            break;
        }
    }

    public void synch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPhysicalClusterNameById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            if (iClusterId >= this.clusters.length) {
                String string = null;
                return string;
            }
            OCluster cluster = this.clusters[iClusterId];
            String string = cluster != null ? cluster.getName() : null;
            return string;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusterMap() {
        this.lock.acquireSharedLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OCluster> getClusterInstances() {
        this.lock.acquireSharedLock();
        try {
            List<OCluster> list = Arrays.asList(this.clusters);
            return list;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCluster getClusterById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            OCluster oCluster = this.clusters[iClusterId];
            return oCluster;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public long getVersion() {
        throw new UnsupportedOperationException("getVersion");
    }

    public ODocument getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleException(OChannelBinaryAsynchClient iNetwork, String message, Exception exception) {
        int currentRetryDelay;
        int currentMaxRetry;
        if (exception instanceof OTimeoutException) {
            throw (OTimeoutException)exception;
        }
        if (exception instanceof OException) {
            throw (OException)exception;
        }
        if (!(exception instanceof IOException)) {
            throw new OStorageException(message, (Throwable)exception);
        }
        if (this.status != OStorage.STATUS.OPEN) {
            return;
        }
        OLogManager.instance().warn((Object)this, "Caught I/O errors from %s (local socket=%s), trying to reconnect (error: %s)", new Object[]{iNetwork, iNetwork.socket.getLocalSocketAddress(), exception});
        try {
            iNetwork.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        long lostConnectionTime = System.currentTimeMillis();
        ODocument oDocument = this.clusterConfiguration;
        synchronized (oDocument) {
            if (!this.clusterConfiguration.isEmpty()) {
                currentMaxRetry = 1;
                currentRetryDelay = 0;
            } else {
                currentMaxRetry = this.connectionRetry;
                currentRetryDelay = this.connectionRetryDelay;
            }
        }
        for (int retry = 0; retry < currentMaxRetry; ++retry) {
            if (currentRetryDelay > 0) {
                try {
                    Thread.sleep(currentRetryDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            try {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Retrying to connect to remote server #" + (retry + 1) + "/" + currentMaxRetry + "...", new Object[0]);
                }
                this.setSessionId(null, -1);
                if (this.createConnectionPool() != 0) {
                    this.openRemoteDatabase();
                    OLogManager.instance().warn((Object)this, "Connection re-acquired transparently after %dms and %d retries: no errors will be thrown at application level", new Object[]{System.currentTimeMillis() - lostConnectionTime, retry + 1});
                    return;
                }
                break;
            }
            catch (Throwable t) {
                continue;
            }
        }
        throw new OStorageException(message, (Throwable)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OChannelBinaryAsynchClient openRemoteDatabase() throws IOException {
        this.minPool = OGlobalConfiguration.CLIENT_CHANNEL_MIN_POOL.getValueAsInteger();
        this.maxPool = OGlobalConfiguration.CLIENT_CHANNEL_MAX_POOL.getValueAsInteger();
        this.connectionDbType = "document";
        if (this.connectionOptions != null && this.connectionOptions.size() > 0) {
            if (this.connectionOptions.containsKey(PARAM_MIN_POOL)) {
                this.minPool = Integer.parseInt(this.connectionOptions.get(PARAM_MIN_POOL).toString());
            }
            if (this.connectionOptions.containsKey(PARAM_MAX_POOL)) {
                this.maxPool = Integer.parseInt(this.connectionOptions.get(PARAM_MAX_POOL).toString());
            }
            if (this.connectionOptions.containsKey(PARAM_DB_TYPE)) {
                this.connectionDbType = this.connectionOptions.get(PARAM_DB_TYPE).toString();
            }
        }
        boolean availableConnections = true;
        OChannelBinaryAsynchClient network = null;
        while (availableConnections) {
            network = this.getAvailableNetwork();
            try {
                network.writeByte((byte)3);
                network.writeInt(this.getSessionId());
                this.sendClientInfo(network);
                network.writeString(this.name);
                if (network.getSrvProtocolVersion() >= 8) {
                    network.writeString(this.connectionDbType);
                }
                network.writeString(this.connectionUserName);
                network.writeString(this.connectionUserPassword);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                int sessionId = network.readInt();
                this.setSessionId(network.getServerURL(), sessionId);
                OLogManager.instance().debug((Object)this, "Client connected to %s with session id=%d", new Object[]{network.getServerURL(), sessionId});
                this.readDatabaseInformation(network);
                this.updateClusterConfiguration(network.readBytes());
                if (network.getSrvProtocolVersion() >= 14) {
                    network.readString();
                }
                this.status = OStorage.STATUS.OPEN;
                OChannelBinaryAsynchClient oChannelBinaryAsynchClient = network;
                this.endResponse(network);
                return oChannelBinaryAsynchClient;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Cannot create a connection to remote server address(es): " + this.serverURLs, e);
                    this.networkPoolLock.lock();
                    try {
                        availableConnections = !this.networkPool.isEmpty();
                    }
                    finally {
                        this.networkPoolLock.unlock();
                    }
                }
            }
        }
        throw new OStorageException("Cannot create a connection to remote server address(es): " + this.serverURLs);
    }

    protected void sendClientInfo(OChannelBinaryAsynchClient network) throws IOException {
        if (network.getSrvProtocolVersion() >= 7) {
            network.writeString(DRIVER_NAME).writeString("1.7-rc2").writeShort((short)20).writeString(this.clientId);
        }
    }

    protected void parseServerURLs() {
        int dbPos = this.url.indexOf(47);
        if (dbPos == -1) {
            this.addHost(this.url);
            this.name = this.url;
        } else {
            this.name = this.url.substring(this.url.lastIndexOf("/") + 1);
            for (String host : this.url.substring(0, dbPos).split(ADDRESS_SEPARATOR)) {
                this.addHost(host);
            }
        }
        if (this.serverURLs.size() == 1 && OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_ENABLED.getValueAsBoolean()) {
            String primaryServer = this.serverURLs.get(0);
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                env.put("com.sun.jndi.ldap.connect.timeout", OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT.getValueAsString());
                InitialDirContext ictx = new InitialDirContext(env);
                String hostName = primaryServer.indexOf(":") == -1 ? primaryServer : primaryServer.substring(0, primaryServer.indexOf(":"));
                Attributes attrs = ictx.getAttributes(hostName, new String[]{"TXT"});
                Attribute attr = attrs.get("TXT");
                if (attr != null) {
                    String configuration = (String)attr.get();
                    if (configuration.startsWith("")) {
                        configuration = configuration.substring(1, configuration.length() - 1);
                    }
                    if (configuration != null) {
                        String[] parts;
                        for (String part : parts = configuration.split(" ")) {
                            if (!part.startsWith("s=")) continue;
                            this.addHost(part.substring("s=".length()));
                        }
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    protected String addHost(String host) {
        if (host.startsWith(DEFAULT_HOST)) {
            host = "127.0.0.1" + host.substring(DEFAULT_HOST.length());
        }
        if (host.indexOf(":") == -1) {
            host = host + ":" + this.getDefaultPort();
        }
        if (!this.serverURLs.contains(host)) {
            this.serverURLs.add(host);
        }
        return host;
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    protected int getDefaultPort() {
        return 2424;
    }

    protected OChannelBinaryAsynchClient createNetworkConnection() throws IOException, UnknownHostException {
        String currentServerURL = this.getServerURL();
        if (currentServerURL != null) {
            try {
                return this.connect(currentServerURL);
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error on connecting to %s", (Throwable)e, new Object[]{currentServerURL});
            }
        }
        for (int serverIdx = 0; serverIdx < this.serverURLs.size(); ++serverIdx) {
            String server = this.serverURLs.get(serverIdx);
            try {
                OChannelBinaryAsynchClient ch = this.connect(server);
                if (serverIdx > 0) {
                    this.serverURLs.remove(serverIdx);
                    this.serverURLs.add(0, server);
                    OLogManager.instance().debug((Object)this, "New server list priority: %s...", new Object[]{this.serverURLs});
                }
                return ch;
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error on connecting to %s", (Throwable)e, new Object[]{server});
                continue;
            }
        }
        StringBuilder buffer = new StringBuilder();
        for (String server : this.serverURLs) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(server);
        }
        throw new OIOException("Cannot connect to any configured remote nodes: " + buffer);
    }

    protected OChannelBinaryAsynchClient connect(String server) throws IOException {
        OLogManager.instance().debug((Object)this, "Trying to connect to the remote host %s...", new Object[]{server});
        int sepPos = server.indexOf(":");
        String remoteHost = server.substring(0, sepPos);
        int remotePort = Integer.parseInt(server.substring(sepPos + 1));
        OChannelBinaryAsynchClient ch = new OChannelBinaryAsynchClient(remoteHost, remotePort, this.clientConfiguration, 20, this.asynchEventListener);
        ch.registerListener((Object)this);
        this.networkPool.add(ch);
        return ch;
    }

    protected void checkConnection() {
    }

    protected OChannelBinaryAsynchClient beginRequest(byte iCommand) throws IOException {
        OChannelBinaryAsynchClient network = this.getAvailableNetwork();
        network.writeByte(iCommand);
        network.writeInt(this.getSessionId());
        return network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OChannelBinaryAsynchClient getAvailableNetwork() throws IOException, UnknownHostException {
        OChannelBinaryAsynchClient network = null;
        int beginCursor = this.networkPoolCursor;
        while (network == null) {
            this.networkPoolLock.lock();
            try {
                if (this.networkPoolCursor < 0) {
                    this.networkPoolCursor = 0;
                } else if (this.networkPoolCursor >= this.networkPool.size()) {
                    this.networkPoolCursor = 0;
                }
                if (this.networkPool.size() == 0) {
                    this.createConnectionPool();
                    this.networkPoolCursor = 0;
                }
                if (this.networkPool.size() == 0) {
                    throw new ONetworkProtocolException("Connection pool closed");
                }
                network = this.networkPool.get(this.networkPoolCursor);
                ++this.networkPoolCursor;
                String serverURL = this.getServerURL();
                if ((serverURL == null || network.getServerURL().equals(serverURL)) && network.getLockWrite().tryAcquireLock()) break;
                network = null;
                if (beginCursor >= this.networkPool.size()) {
                    beginCursor = this.networkPoolCursor;
                }
                if (this.networkPoolCursor != beginCursor) continue;
                if (this.networkPool.size() < this.maxPool) {
                    network = this.createNetworkConnection();
                    network.getLockWrite().lock();
                    continue;
                }
                OLogManager.instance().info((Object)this, "Network connection pool is full (max=%d): increase max size to avoid such bottleneck on connections", new Object[]{this.maxPool});
                this.removeDeadConnections();
                long startToWait = System.currentTimeMillis();
                this.networkPoolLock.unlock();
                try {
                    List<OChannelBinaryAsynchClient> list = this.networkPool;
                    synchronized (list) {
                        this.networkPool.wait(5000L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new OStorageException("Cannot acquire a connection because the thread has been interrupted");
                }
                finally {
                    this.networkPoolLock.lock();
                }
                Orient.instance().getProfiler().stopChrono("system.network.connectionPool.waitingTime", "Waiting for a free connection from the pool of channels", startToWait);
            }
            finally {
                this.networkPoolLock.unlock();
            }
        }
        return network;
    }

    private void removeDeadConnections() {
        int removedDeadConnections = 0;
        for (OChannelBinaryAsynchClient n : new ArrayList<OChannelBinaryAsynchClient>(this.networkPool)) {
            if (n == null || n.isConnected()) continue;
            try {
                n.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.networkPool.remove(n);
            ++removedDeadConnections;
        }
        OLogManager.instance().debug((Object)this, "Found and removed %d dead connections from the network pool", new Object[]{removedDeadConnections});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRequest(OChannelBinaryAsynchClient iNetwork) throws IOException {
        if (iNetwork == null) {
            return;
        }
        try {
            iNetwork.flush();
        }
        catch (IOException e) {
            try {
                iNetwork.close();
            }
            catch (Exception exception) {
                this.networkPoolLock.lock();
                try {
                    this.networkPool.remove(iNetwork);
                }
                finally {
                    this.networkPoolLock.unlock();
                }
            }
            finally {
                this.networkPoolLock.lock();
                try {
                    this.networkPool.remove(iNetwork);
                }
                finally {
                    this.networkPoolLock.unlock();
                }
            }
            throw e;
        }
        finally {
            iNetwork.releaseWriteLock();
            this.networkPoolLock.lock();
            try {
                List<OChannelBinaryAsynchClient> list = this.networkPool;
                synchronized (list) {
                    this.networkPool.notifyAll();
                }
            }
            finally {
                this.networkPoolLock.unlock();
            }
        }
    }

    protected void beginResponse(OChannelBinaryAsynchClient iNetwork) throws IOException {
        iNetwork.beginResponse(this.getSessionId());
    }

    public void endResponse(OChannelBinaryAsynchClient iNetwork) {
        iNetwork.endResponse();
    }

    public boolean isPermanentRequester() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getResponse(OChannelBinaryAsynchClient iNetwork) throws IOException {
        try {
            this.beginResponse(iNetwork);
        }
        finally {
            this.endResponse(iNetwork);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterConfiguration(byte[] obj) {
        if (obj == null) {
            return;
        }
        ODocument oDocument = this.clusterConfiguration;
        synchronized (oDocument) {
            this.clusterConfiguration.fromStream(obj);
            List members = (List)this.clusterConfiguration.field("members");
            if (members != null) {
                this.serverURLs.clear();
                this.parseServerURLs();
                for (ODocument m : members) {
                    if (m == null || this.serverURLs.contains((String)m.field("name"))) continue;
                    for (Map listener : (Collection)m.field("listeners")) {
                        String url;
                        if (!((String)listener.get("protocol")).equals("ONetworkProtocolBinary") || this.serverURLs.contains(url = (String)listener.get("listen"))) continue;
                        this.addHost(url);
                    }
                }
            }
        }
    }

    private void commitEntry(OChannelBinaryAsynchClient iNetwork, ORecordOperation txEntry) throws IOException {
        if (txEntry.type == 0) {
            return;
        }
        byte[] stream = null;
        try {
            switch (txEntry.type) {
                case 1: 
                case 3: {
                    stream = txEntry.getRecord().toStream();
                }
            }
        }
        catch (Exception e) {
            iNetwork.writeByte((byte)-1);
            throw new OTransactionException("Error on transaction commit", (Throwable)e);
        }
        iNetwork.writeByte((byte)1);
        iNetwork.writeByte(txEntry.type);
        iNetwork.writeRID(txEntry.getRecord().getIdentity());
        iNetwork.writeByte(txEntry.getRecord().getRecordType());
        switch (txEntry.type) {
            case 3: {
                iNetwork.writeBytes(stream);
                break;
            }
            case 1: {
                iNetwork.writeVersion(txEntry.getRecord().getRecordVersion());
                iNetwork.writeBytes(stream);
                break;
            }
            case 2: {
                iNetwork.writeVersion(txEntry.getRecord().getRecordVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int createConnectionPool() throws IOException, UnknownHostException {
        this.networkPoolLock.lock();
        try {
            if (this.networkPool.isEmpty()) {
                this.createNetworkConnection();
            }
            for (int i = this.networkPool.size(); i < this.minPool; ++i) {
                this.createNetworkConnection();
            }
            int n = this.networkPool.size();
            return n;
        }
        finally {
            this.networkPoolLock.unlock();
        }
    }

    private boolean handleDBFreeze() {
        OLogManager.instance().warn((Object)this, "DB is frozen will wait for " + OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT.getValue() + " ms. and then retry.", new Object[0]);
        boolean retry = true;
        try {
            Thread.sleep(OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT.getValueAsInteger());
        }
        catch (InterruptedException ie) {
            retry = false;
            Thread.currentThread().interrupt();
        }
        return retry;
    }

    private void readDatabaseInformation(OChannelBinaryAsynchClient network) throws IOException {
        int tot = network.getSrvProtocolVersion() >= 7 ? network.readShort() : network.readInt();
        this.clusters = new OCluster[tot];
        this.clusterMap.clear();
        for (int i = 0; i < tot; ++i) {
            OClusterRemote cluster = new OClusterRemote();
            String clusterName = network.readString();
            if (clusterName != null) {
                clusterName = clusterName.toLowerCase();
            }
            short clusterId = network.readShort();
            String clusterType = network.readString();
            short dataSegmentId = network.getSrvProtocolVersion() >= 12 ? network.readShort() : (short)0;
            cluster.setType(clusterType);
            cluster.configure((OStorage)this, clusterId, clusterName, null, dataSegmentId, new Object[0]);
            if (clusterId >= this.clusters.length) {
                this.clusters = Arrays.copyOf(this.clusters, clusterId + 1);
            }
            this.clusters[clusterId] = cluster;
            this.clusterMap.put(clusterName, cluster);
        }
        this.defaultClusterId = this.clusterMap.get("default").getId();
    }

    public String getURL() {
        return "remote:" + this.url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getDataSegmentIdByName(String iName) {
        if (iName == null) {
            return 0;
        }
        throw new UnsupportedOperationException("getDataSegmentIdByName()");
    }

    public ODataSegment getDataSegmentById(int iDataSegmentId) {
        throw new UnsupportedOperationException("getDataSegmentById()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusters() {
        this.lock.acquireSharedLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    public String getType() {
        return "remote";
    }

    public Class<OSBTreeCollectionManagerRemote> getCollectionManagerClass() {
        return OSBTreeCollectionManagerRemote.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelClose(OChannel iChannel) {
        this.networkPoolLock.lock();
        try {
            this.networkPool.remove(iChannel);
        }
        finally {
            this.networkPoolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteRecord(final ORecordId iRid, ORecordVersion iVersion, int iMode, final ORecordCallback<Boolean> iCallback, final OChannelBinaryAsynchClient network) throws IOException {
        try {
            network.writeRID((ORID)iRid);
            network.writeVersion(iVersion);
            network.writeByte((byte)iMode);
        }
        finally {
            this.endRequest(network);
        }
        switch (iMode) {
            case 0: {
                try {
                    this.beginResponse(network);
                    boolean bl = network.readByte() == 1;
                    return bl;
                }
                finally {
                    this.endResponse(network);
                }
            }
            case 1: {
                if (iCallback == null) break;
                final int sessionId = this.getSessionId();
                Callable<Object> response = new Callable<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object call() throws Exception {
                        Boolean result;
                        try {
                            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = sessionId;
                            OStorageRemote.this.beginResponse(network);
                            result = network.readByte() == 1;
                        }
                        finally {
                            OStorageRemote.this.endResponse(network);
                            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = -1;
                        }
                        iCallback.call(iRid, (Object)result);
                        return null;
                    }
                };
                this.asynchExecutor.submit(new FutureTask<Object>(response));
            }
        }
        return false;
    }
}

