/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelListener;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ORemoteConnectionManager
implements OChannelListener {
    public static final String PARAM_MAX_POOL = "maxpool";
    protected final ConcurrentHashMap<String, OResourcePool<String, OChannelBinaryAsynchClient>> connections = new ConcurrentHashMap();
    protected final long timeout;

    public ORemoteConnectionManager(int iMaxConnectionPerURL, long iTimeout) {
        this.timeout = iTimeout;
    }

    public void close() {
        for (Map.Entry<String, OResourcePool<String, OChannelBinaryAsynchClient>> entry : this.connections.entrySet()) {
            entry.getValue().close();
        }
        this.connections.clear();
    }

    public OChannelBinaryAsynchClient acquire(String iServerURL, OContextConfiguration clientConfiguration, Map<String, Object> iConfiguration, ORemoteServerEventListener iListener) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.get(iServerURL);
        if (pool == null) {
            OResourcePool<String, OChannelBinaryAsynchClient> prev;
            int maxPool = OGlobalConfiguration.CLIENT_CHANNEL_MAX_POOL.getValueAsInteger();
            if (iConfiguration != null && iConfiguration.size() > 0 && iConfiguration.containsKey(PARAM_MAX_POOL)) {
                maxPool = Integer.parseInt(iConfiguration.get(PARAM_MAX_POOL).toString());
            }
            if ((prev = this.connections.putIfAbsent(iServerURL, pool = new OResourcePool<String, OChannelBinaryAsynchClient>(maxPool, (OResourcePoolListener)new OResourcePoolListener<String, OChannelBinaryAsynchClient>(){

                public OChannelBinaryAsynchClient createNewResource(String iKey, Object ... iAdditionalArgs) {
                    return ORemoteConnectionManager.this.createNetworkConnection(iKey, (OContextConfiguration)iAdditionalArgs[0], (Map)iAdditionalArgs[1], (ORemoteServerEventListener)iAdditionalArgs[2]);
                }

                public boolean reuseResource(String iKey, Object[] iAdditionalArgs, OChannelBinaryAsynchClient iValue) {
                    return true;
                }
            }))) != null) {
                pool.close();
                pool = prev;
            }
        }
        try {
            return (OChannelBinaryAsynchClient)pool.getResource((Object)iServerURL, this.timeout, new Object[]{clientConfiguration, iConfiguration, iListener});
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on retrieving the connection from pool: " + iServerURL, (Throwable)e, new Object[0]);
            this.connections.remove(iServerURL);
            return null;
        }
    }

    public void release(OChannelBinaryAsynchClient conn) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.get(conn.getServerURL());
        if (pool != null) {
            if (!conn.isConnected()) {
                OLogManager.instance().debug((Object)this, "Network connection pool is receiving a closed connection to reuse: discard it", new Object[0]);
                pool.remove((Object)conn);
            } else {
                pool.returnResource((Object)conn);
            }
        }
    }

    public void remove(OChannelBinaryAsynchClient conn) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool;
        if (conn.isConnected()) {
            try {
                conn.unlock();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                conn.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((pool = this.connections.get(conn.getServerURL())) == null) {
            throw new IllegalStateException("Connection cannot be released because the pool doesn't exist anymore");
        }
        pool.remove((Object)conn);
    }

    public void onChannelClose(OChannel channel) {
        this.remove((OChannelBinaryAsynchClient)channel);
    }

    public int getMaxResources(String url) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getMaxResources();
    }

    public int getAvailableConnections(String url) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getAvailableResources();
    }

    public void closePool(String url) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.remove(url);
        if (pool == null) {
            return;
        }
        this.closePool(pool);
    }

    protected void closePool(OResourcePool<String, OChannelBinaryAsynchClient> pool) {
        ArrayList conns = new ArrayList(pool.getResources());
        for (OChannelBinaryAsynchClient c : conns) {
            try {
                c.close();
            }
            catch (Exception e) {}
        }
    }

    protected OChannelBinaryAsynchClient createNetworkConnection(String iServerURL, OContextConfiguration clientConfiguration, Map<String, Object> iAdditionalArg, ORemoteServerEventListener asynchEventListener) throws OIOException {
        if (iServerURL == null) {
            throw new IllegalArgumentException("server url is null");
        }
        try {
            String databaseName;
            String serverURL;
            OLogManager.instance().debug((Object)this, "Trying to connect to the remote host %s...", new Object[]{iServerURL});
            int sepPos = iServerURL.indexOf("/");
            if (sepPos > -1) {
                serverURL = iServerURL.substring(0, sepPos);
                databaseName = iServerURL.substring(sepPos + 1);
            } else {
                serverURL = iServerURL;
                databaseName = null;
            }
            sepPos = serverURL.indexOf(":");
            String remoteHost = serverURL.substring(0, sepPos);
            int remotePort = Integer.parseInt(serverURL.substring(sepPos + 1));
            OChannelBinaryAsynchClient ch = new OChannelBinaryAsynchClient(remoteHost, remotePort, databaseName, clientConfiguration, 21, asynchEventListener);
            ch.registerListener((Object)this);
            return ch;
        }
        catch (OIOException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error on connecting to %s", (Throwable)e, new Object[]{iServerURL});
            throw new OIOException("Error on connecting to " + iServerURL, (Throwable)e);
        }
    }
}

