/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.client.remote.OClusterRemote;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.OEngineRemote;
import com.orientechnologies.orient.client.remote.OSBTreeCollectionManagerRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteAsynchEventListener;
import com.orientechnologies.orient.client.remote.OStorageRemoteConfiguration;
import com.orientechnologies.orient.client.remote.OStorageRemoteThreadLocal;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequestAsynch;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.sql.query.OLiveQuery;
import com.orientechnologies.orient.core.sql.query.OLiveResultListener;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryProtocol;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class OStorageRemote
extends OStorageAbstract
implements OStorageProxy {
    public static final String PARAM_MIN_POOL = "minpool";
    public static final String PARAM_MAX_POOL = "maxpool";
    public static final String PARAM_DB_TYPE = "dbtype";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 2424;
    private static final int DEFAULT_SSL_PORT = 2434;
    private static final String ADDRESS_SEPARATOR = ";";
    private static final String DRIVER_NAME = "OrientDB Java";
    protected final List<String> serverURLs = new ArrayList<String>();
    protected final Map<String, OCluster> clusterMap = new ConcurrentHashMap<String, OCluster>();
    private final ExecutorService asynchExecutor;
    private final ODocument clusterConfiguration = new ODocument();
    private final String clientId;
    private OContextConfiguration clientConfiguration;
    private int connectionRetry;
    private int connectionRetryDelay;
    @Deprecated
    private int networkPoolCursor = 0;
    private OCluster[] clusters = OCommonConst.EMPTY_CLUSTER_ARRAY;
    private int defaultClusterId;
    @Deprecated
    private int minPool;
    @Deprecated
    private int maxPool;
    private ORemoteServerEventListener asynchEventListener;
    private String connectionDbType;
    private volatile String connectionUserName;
    private String connectionUserPassword;
    private Map<String, Object> connectionOptions;
    private OEngineRemote engine;
    private String recordFormat;

    public OStorageRemote(String iClientId, String iURL, String iMode) throws IOException {
        this(iClientId, iURL, iMode, null);
    }

    public OStorageRemote(String iClientId, String iURL, String iMode, OStorage.STATUS status) throws IOException {
        super(iURL, iURL, iMode, 0);
        if (status != null) {
            this.status = status;
        }
        this.clientId = iClientId;
        this.configuration = null;
        this.clientConfiguration = new OContextConfiguration();
        this.connectionRetry = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY);
        this.connectionRetryDelay = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY_DELAY);
        this.asynchEventListener = new OStorageRemoteAsynchEventListener(this);
        this.parseServerURLs();
        this.asynchExecutor = Executors.newSingleThreadScheduledExecutor();
        this.engine = (OEngineRemote)Orient.instance().getEngine("remote");
    }

    public boolean isAssigningClusterIds() {
        return false;
    }

    public int getSessionId() {
        OStorageRemoteThreadLocal instance = OStorageRemoteThreadLocal.INSTANCE;
        return instance != null ? ((OStorageRemoteThreadLocal.OStorageRemoteSession)instance.get()).sessionId : -1;
    }

    public String getServerURL() {
        OStorageRemoteThreadLocal instance = OStorageRemoteThreadLocal.INSTANCE;
        return instance != null ? ((OStorageRemoteThreadLocal.OStorageRemoteSession)instance.get()).serverURL : null;
    }

    public byte[] getSessionToken() {
        OStorageRemoteThreadLocal instance = OStorageRemoteThreadLocal.INSTANCE;
        return instance != null ? ((OStorageRemoteThreadLocal.OStorageRemoteSession)instance.get()).token : null;
    }

    public void setSessionId(String iServerURL, int iSessionId, byte[] token) {
        OStorageRemoteThreadLocal instance = OStorageRemoteThreadLocal.INSTANCE;
        if (instance != null) {
            OStorageRemoteThreadLocal.OStorageRemoteSession tl = (OStorageRemoteThreadLocal.OStorageRemoteSession)instance.get();
            tl.serverURL = iServerURL;
            tl.sessionId = iSessionId;
            tl.token = token;
        }
    }

    public void clearToken() {
        OStorageRemoteThreadLocal instance = OStorageRemoteThreadLocal.INSTANCE;
        if (instance != null) {
            OStorageRemoteThreadLocal.OStorageRemoteSession tl = (OStorageRemoteThreadLocal.OStorageRemoteSession)instance.get();
            tl.token = null;
        }
    }

    public void clearSession() {
        OStorageRemoteThreadLocal instance = OStorageRemoteThreadLocal.INSTANCE;
        if (instance != null) {
            instance.remove();
        }
    }

    public ORemoteServerEventListener getAsynchEventListener() {
        return this.asynchEventListener;
    }

    public void setAsynchEventListener(ORemoteServerEventListener iListener) {
        this.asynchEventListener = iListener;
    }

    public void removeRemoteServerEventListener() {
        this.asynchEventListener = null;
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.addUser();
        this.stateLock.acquireWriteLock();
        try {
            this.connectionUserName = iUserName;
            this.connectionUserPassword = iUserPassword;
            this.connectionOptions = iOptions != null ? new HashMap<String, Object>(iOptions) : null;
            this.openRemoteDatabase();
            OStorageRemoteConfiguration storageConfiguration = new OStorageRemoteConfiguration(this, this.recordFormat);
            storageConfiguration.load();
            this.configuration = storageConfiguration;
            this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new OStorageException("Cannot open the remote storage: " + this.name, (Throwable)e);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        this.stateLock.acquireWriteLock();
        try {
            OChannelBinaryAsynchClient network = null;
            while (true) {
                try {
                    try {
                        network = this.beginRequest((byte)73);
                    }
                    finally {
                        this.endRequest(network);
                    }
                    try {
                        this.beginResponse(network);
                        this.readDatabaseInformation(network);
                    }
                    finally {
                        this.endResponse(network);
                    }
                }
                catch (Exception e) {
                    this.handleException(network, "Error on reloading database information", e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    public void create(Map<String, Object> iOptions) {
        throw new UnsupportedOperationException("Cannot create a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    public boolean exists() {
        throw new UnsupportedOperationException("Cannot check the existance of a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean iForce, boolean onDelete) {
        if (this.status == OStorage.STATUS.CLOSED) {
            return;
        }
        OChannelBinaryAsynchClient network = null;
        this.stateLock.acquireWriteLock();
        try {
            if (this.status == OStorage.STATUS.CLOSED) {
                return;
            }
            network = this.beginRequest((byte)5);
            try {
                this.setSessionId(null, -1, null);
            }
            finally {
                this.endRequest(network);
                this.engine.getConnectionManager().release(network);
            }
            if (!this.checkForClose(iForce)) {
                return;
            }
            this.status = OStorage.STATUS.CLOSING;
            this.engine.getConnectionManager().closePool(this.getCurrentServerURL());
            super.close(iForce, onDelete);
            this.status = OStorage.STATUS.CLOSED;
            Orient.instance().unregisterStorage((OStorage)this);
        }
        catch (Exception e) {
            if (network != null) {
                OLogManager.instance().debug((Object)this, "Error on closing remote connection: %s", (Throwable)e, new Object[]{network});
                try {
                    network.close();
                }
                catch (Exception e2) {
                    OLogManager.instance().debug((Object)this, "Error on closing socket: %s", (Throwable)e2, new Object[]{network});
                }
            }
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    private boolean checkForClose(boolean force) {
        if (this.status == OStorage.STATUS.CLOSED) {
            return false;
        }
        if (this.status == OStorage.STATUS.CLOSED) {
            return false;
        }
        int remainingUsers = this.getUsers() > 0 ? this.removeUser() : 0;
        return force || remainingUsers == 0;
    }

    public int getUsers() {
        return this.dataLock.getUsers();
    }

    public int addUser() {
        return this.dataLock.addUser();
    }

    public int removeUser() {
        return this.dataLock.removeUser();
    }

    public void delete() {
        throw new UnsupportedOperationException("Cannot delete a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    public Set<String> getClusterNames() {
        this.stateLock.acquireReadLock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.clusterMap.keySet());
            return hashSet;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OStorageOperationResult<OPhysicalPosition> createRecord(final ORecordId iRid, byte[] iContent, ORecordVersion iRecordVersion, byte iRecordType, int iMode, final ORecordCallback<Long> iCallback) {
        if (iMode == 1 && iCallback == null) {
            iMode = 2;
        }
        OPhysicalPosition ppos = new OPhysicalPosition(iRecordType);
        OChannelBinaryAsynchClient lastNetworkUsed = null;
        while (true) {
            try {
                OChannelBinaryAsynchClient network;
                lastNetworkUsed = network = this.beginRequest((byte)31);
                try {
                    network.writeShort((short)iRid.clusterId);
                    network.writeBytes(iContent);
                    network.writeByte(iRecordType);
                    network.writeByte((byte)iMode);
                }
                finally {
                    this.endRequest(network);
                }
                switch (iMode) {
                    case 0: {
                        try {
                            this.beginResponse(network);
                            if (network.getSrvProtocolVersion() > 25) {
                                iRid.clusterId = network.readShort();
                            }
                            ppos.clusterPosition = iRid.clusterPosition = network.readLong();
                            ppos.recordVersion = network.getSrvProtocolVersion() >= 11 ? network.readVersion() : OVersionFactory.instance().createVersion();
                            if (network.getSrvProtocolVersion() >= 20) {
                                this.readCollectionChanges(network, ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager());
                            }
                            OStorageOperationResult oStorageOperationResult = new OStorageOperationResult((Object)ppos);
                            return oStorageOperationResult;
                        }
                        finally {
                            this.endResponse(network);
                        }
                    }
                    case 1: {
                        if (iCallback == null) return new OStorageOperationResult((Object)ppos);
                        final int sessionId = this.getSessionId();
                        final byte[] token = this.getSessionToken();
                        final OSBTreeCollectionManager collectionManager = ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager();
                        Callable<Object> response = new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                long result;
                                try {
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = sessionId;
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).token = token;
                                    OStorageRemote.this.beginResponse(network);
                                    if (network.getSrvProtocolVersion() > 25) {
                                        iRid.clusterId = network.readShort();
                                    }
                                    result = network.readLong();
                                    if (network.getSrvProtocolVersion() >= 11) {
                                        network.readVersion();
                                    }
                                    if (network.getSrvProtocolVersion() >= 20) {
                                        OStorageRemote.this.readCollectionChanges(network, collectionManager);
                                    }
                                }
                                catch (Exception e) {
                                    OLogManager.instance().error((Object)this, "Exception on async query", (Throwable)e, new Object[0]);
                                    throw e;
                                }
                                finally {
                                    OStorageRemote.this.endResponse(network);
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = -1;
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).token = null;
                                }
                                iCallback.call(iRid, (Object)result);
                                return null;
                            }
                        };
                        this.asynchExecutor.submit(new FutureTask<Object>(response));
                        return new OStorageOperationResult((Object)ppos);
                    }
                    case 2: {
                        this.engine.getConnectionManager().release(network);
                        return new OStorageOperationResult((Object)ppos);
                    }
                }
                return new OStorageOperationResult((Object)ppos);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(lastNetworkUsed, "Error on create record in cluster: " + iRid.clusterId, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORecordMetadata getRecordMetadata(ORID rid) {
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)29);
                network.writeRID(rid);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                ORecordId responseRid = network.readRID();
                ORecordVersion responseVersion = network.readVersion();
                ORecordMetadata oRecordMetadata = new ORecordMetadata((ORID)responseRid, responseVersion);
                this.endResponse(network);
                return oRecordMetadata;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on read record " + rid, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(ORecordId rid, String fetchPlan, boolean ignoreCache, ORecordVersion recordVersion) throws ORecordNotFoundException {
        if (((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting) {
            return new OStorageOperationResult(null);
        }
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                try {
                    network = this.beginRequest((byte)44);
                    network.writeRID((ORID)rid);
                    network.writeVersion(recordVersion);
                    network.writeString(fetchPlan != null ? fetchPlan : "");
                    network.writeByte((byte)(ignoreCache ? 1 : 0));
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    if (network.readByte() == 0) {
                        OStorageOperationResult oStorageOperationResult = new OStorageOperationResult(null);
                        return oStorageOperationResult;
                    }
                    byte type = network.readByte();
                    ORecordVersion recVersion = network.readVersion();
                    byte[] bytes = network.readBytes();
                    ORawBuffer buffer = new ORawBuffer(bytes, recVersion, type);
                    ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
                    while (network.readByte() == 2) {
                        ORecord record = (ORecord)OChannelBinaryProtocol.readIdentifiable((OChannelBinaryAsynchClient)network);
                        if (database == null) continue;
                        database.getLocalCache().updateRecord(record);
                    }
                    OStorageOperationResult oStorageOperationResult = new OStorageOperationResult((Object)buffer);
                    return oStorageOperationResult;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException(network, "Error on read record " + rid, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object indexGet(String iIndexName, Object iKey, String iFetchPlan) {
        if (iIndexName == null || iIndexName.isEmpty()) {
            throw new IllegalArgumentException("Index name is mandatory");
        }
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)120);
                network.writeString(iIndexName);
                if (iKey instanceof OCompositeKey) {
                    iKey = ((OCompositeKey)iKey).getKeys();
                }
                network.writeBytes(new ODocument().field("key", iKey).toStream());
                network.writeString(iFetchPlan != null ? iFetchPlan : "");
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                Object object = this.readSynchResult(network, (ODatabaseDocument)ODatabaseRecordThreadLocal.INSTANCE.get());
                this.endResponse(network);
                return object;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on index get for key: " + iKey, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void indexPut(String iIndexName, Object iKey, OIdentifiable iValue) {
        if (iIndexName == null || iIndexName.isEmpty()) {
            throw new IllegalArgumentException("Index name is mandatory");
        }
        network = null;
        while (true) {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    try {
                        network = this.beginRequest((byte)121);
                        network.writeString(iIndexName);
                        if (iKey instanceof OCompositeKey) {
                            iKey = ((OCompositeKey)iKey).getKeys();
                        }
                        network.writeBytes(new ODocument().field("key", iKey).toStream());
                        network.writeRID(iValue.getIdentity());
                    }
                    finally {
                        this.endRequest(network);
                    }
                    try {
                        this.beginResponse(network);
                    }
                    finally {
                        this.endResponse(network);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.handleException(network, "Error on index put for key: " + iKey, e);
                continue;
            }
            ** GOTO lbl-1000
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexRemove(String iIndexName, Object iKey) {
        if (iIndexName == null || iIndexName.isEmpty()) {
            throw new IllegalArgumentException("Index name is mandatory");
        }
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)122);
                network.writeString(iIndexName);
                if (iKey instanceof OCompositeKey) {
                    iKey = ((OCompositeKey)iKey).getKeys();
                }
                network.writeBytes(new ODocument().field("key", iKey).toStream());
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                boolean bl = network.readBoolean();
                this.endResponse(network);
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on index remove for key: " + iKey, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback) {
        if (((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting) {
            return new OStorageOperationResult(null);
        }
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                try {
                    network = this.beginRequest((byte)30);
                    network.writeRID((ORID)iRid);
                    network.writeString(iFetchPlan != null ? iFetchPlan : "");
                    if (network.getSrvProtocolVersion() >= 9) {
                        network.writeByte((byte)(iIgnoreCache ? 1 : 0));
                    }
                    if (network.getSrvProtocolVersion() >= 13) {
                        network.writeByte((byte)0);
                    }
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    ORawBuffer buffer;
                    this.beginResponse(network);
                    if (network.readByte() == 0) {
                        OStorageOperationResult oStorageOperationResult = new OStorageOperationResult(null);
                        return oStorageOperationResult;
                    }
                    if (network.getSrvProtocolVersion() <= 27) {
                        buffer = new ORawBuffer(network.readBytes(), network.readVersion(), network.readByte());
                    } else {
                        byte type = network.readByte();
                        ORecordVersion recVersion = network.readVersion();
                        byte[] bytes = network.readBytes();
                        buffer = new ORawBuffer(bytes, recVersion, type);
                    }
                    ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
                    while (network.readByte() == 2) {
                        ORecord record = (ORecord)OChannelBinaryProtocol.readIdentifiable((OChannelBinaryAsynchClient)network);
                        if (database == null) continue;
                        database.getLocalCache().updateRecord(record);
                    }
                    OStorageOperationResult oStorageOperationResult = new OStorageOperationResult((Object)buffer);
                    return oStorageOperationResult;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException(network, "Error on read record " + iRid, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OStorageOperationResult<ORecordVersion> updateRecord(final ORecordId iRid, boolean updateContent, byte[] iContent, ORecordVersion iVersion, byte iRecordType, int iMode, final ORecordCallback<ORecordVersion> iCallback) {
        if (iMode == 1 && iCallback == null) {
            iMode = 2;
        }
        OChannelBinaryAsynchClient lastNetworkUsed = null;
        while (true) {
            try {
                OChannelBinaryAsynchClient network;
                lastNetworkUsed = network = this.beginRequest((byte)32);
                try {
                    network.writeRID((ORID)iRid);
                    if (network.getSrvProtocolVersion() >= 23) {
                        network.writeBoolean(updateContent);
                    }
                    network.writeBytes(iContent);
                    network.writeVersion(iVersion);
                    network.writeByte(iRecordType);
                    network.writeByte((byte)iMode);
                }
                finally {
                    this.endRequest(network);
                }
                switch (iMode) {
                    case 0: {
                        try {
                            this.beginResponse(network);
                            OStorageOperationResult r = new OStorageOperationResult((Object)network.readVersion());
                            this.readCollectionChanges(network, ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager());
                            OStorageOperationResult oStorageOperationResult = r;
                            return oStorageOperationResult;
                        }
                        finally {
                            this.endResponse(network);
                        }
                    }
                    case 1: {
                        final int sessionId = this.getSessionId();
                        final OSBTreeCollectionManager collectionManager = ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager();
                        Callable<Object> response = new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                ORecordVersion result;
                                try {
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = sessionId;
                                    OStorageRemote.this.beginResponse(network);
                                    result = network.readVersion();
                                    if (network.getSrvProtocolVersion() >= 20) {
                                        OStorageRemote.this.readCollectionChanges(network, collectionManager);
                                    }
                                }
                                finally {
                                    OStorageRemote.this.endResponse(network);
                                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = -1;
                                }
                                iCallback.call(iRid, (Object)result);
                                return null;
                            }
                        };
                        this.asynchExecutor.submit(new FutureTask<Object>(response));
                        return new OStorageOperationResult((Object)iVersion);
                    }
                }
                return new OStorageOperationResult((Object)iVersion);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(lastNetworkUsed, "Error on update record " + iRid, e);
                continue;
            }
            break;
        }
    }

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRid, ORecordVersion iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        if (iMode == 1 && iCallback == null) {
            iMode = 2;
        }
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)33);
                return new OStorageOperationResult((Object)this.deleteRecord(iRid, iVersion, iMode, iCallback, network));
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(network, "Error on delete record " + iRid, e);
                continue;
            }
            break;
        }
    }

    public OStorageOperationResult<Boolean> hideRecord(ORecordId recordId, int mode, ORecordCallback<Boolean> callback) {
        if (mode == 1 && callback == null) {
            mode = 2;
        }
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)43);
                return new OStorageOperationResult((Object)this.hideRecord(recordId, mode, callback, network));
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(network, "Error on delete record " + recordId, e);
                continue;
            }
            break;
        }
    }

    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        if (iMode == 1 && callback == null) {
            iMode = 2;
        }
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)38);
                return this.deleteRecord(recordId, recordVersion, iMode, callback, network);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(network, "Error on clean out record " + recordId, e);
                continue;
            }
            break;
        }
    }

    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        throw new UnsupportedOperationException("backup is not supported against remote storage. Open the database with plocal or use Enterprise Edition");
    }

    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        throw new UnsupportedOperationException("restore is not supported against remote storage. Open the database with plocal or use Enterprise Edition");
    }

    public long count(int iClusterId) {
        return this.count(new int[]{iClusterId});
    }

    public long count(int iClusterId, boolean countTombstones) {
        return this.count(new int[]{iClusterId}, countTombstones);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getClusterDataRange(int iClusterId) {
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)13);
                network.writeShort((short)iClusterId);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long[] lArray = new long[]{network.readLong(), network.readLong()};
                this.endResponse(network);
                return lArray;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on getting last entry position count in cluster: " + iClusterId, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPhysicalPosition[] higherPhysicalPositions(int iClusterId, OPhysicalPosition iClusterPosition) {
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                try {
                    network = this.beginRequest((byte)36);
                    network.writeInt(iClusterId);
                    network.writeLong(iClusterPosition.clusterPosition);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException(network, "Error on retrieving higher positions after " + iClusterPosition.clusterPosition, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                try {
                    network = this.beginRequest((byte)42);
                    network.writeInt(clusterId);
                    network.writeLong(physicalPosition.clusterPosition);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException(network, "Error on retrieving ceiling positions after " + physicalPosition.clusterPosition, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPhysicalPosition[] lowerPhysicalPositions(int iClusterId, OPhysicalPosition physicalPosition) {
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                try {
                    network = this.beginRequest((byte)37);
                    network.writeInt(iClusterId);
                    network.writeLong(physicalPosition.clusterPosition);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException(network, "Error on retrieving lower positions after " + physicalPosition.clusterPosition, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                try {
                    network = this.beginRequest((byte)39);
                    network.writeInt(clusterId);
                    network.writeLong(physicalPosition.clusterPosition);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (Exception e) {
                this.handleException(network, "Error on retrieving floor positions after " + physicalPosition.clusterPosition, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)8);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on read database size", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countRecords() {
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)9);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on read database record count", e);
                    continue;
                }
            }
            break;
        }
    }

    public long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(int[] iClusterIds, boolean countTombstones) {
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                network = this.beginRequest((byte)12);
                network.writeShort((short)iClusterIds.length);
                for (int iClusterId : iClusterIds) {
                    network.writeShort((short)iClusterId);
                }
                if (network.getSrvProtocolVersion() >= 13) {
                    network.writeByte(countTombstones ? (byte)1 : 0);
                }
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (Exception e) {
                    this.handleException(network, "Error on read record count in clusters: " + Arrays.toString(iClusterIds), e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object command(OCommandRequestText iCommand) {
        block34: {
            if (!(iCommand instanceof OSerializableStream)) {
                throw new OCommandExecutionException("Cannot serialize the command to be executed to the server side.");
            }
            result = null;
            live = iCommand instanceof OLiveQuery;
            database = ODatabaseRecordThreadLocal.INSTANCE.get();
            network = null;
            while (true) lbl-1000:
            // 4 sources

            {
                ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = true;
                try {
                    asynch = iCommand instanceof OCommandRequestAsynch != false && ((OCommandRequestAsynch)iCommand).isAsynchronous() != false;
                    try {
                        network = this.beginRequest((byte)41);
                        if (live) {
                            network.writeByte((byte)108);
                        } else {
                            network.writeByte((byte)(asynch != false ? 97 : 115));
                        }
                        network.writeBytes(OStreamSerializerAnyStreamable.INSTANCE.toStream((Object)iCommand));
                    }
                    finally {
                        this.endRequest(network);
                    }
                    try {
                        this.beginResponse(network);
                        addNextRecord = true;
                        if (asynch) {
                            while ((status = network.readByte()) > 0) {
                                record = (ORecord)OChannelBinaryProtocol.readIdentifiable((OChannelBinaryAsynchClient)network);
                                if (record == null) continue;
                                switch (status) {
                                    case 1: {
                                        if (!addNextRecord) break;
                                        addNextRecord = iCommand.getResultListener().result((Object)record);
                                        database.getLocalCache().updateRecord(record);
                                        break;
                                    }
                                    case 2: {
                                        database.getLocalCache().updateRecord(record);
                                    }
                                }
                            }
                        } else {
                            result = this.readSynchResult(network, (ODatabaseDocument)database);
                            if (live) {
                                doc = (ODocument)((List)result).get(0);
                                token = (Integer)doc.field("token");
                                unsubscribe = (Boolean)doc.field("unsubscribe");
                                if (token != null) {
                                    if (Boolean.TRUE.equals(unsubscribe)) {
                                        this.asynchEventListener.unregisterLiveListener(token);
                                    } else {
                                        listener = (OLiveResultListener)iCommand.getResultListener();
                                        this.asynchEventListener.registerLiveListener(token, listener);
                                    }
                                } else {
                                    throw new OStorageException("Cannot execute live query, returned null token");
                                }
                            }
                        }
                        this.endResponse(network);
                        break block34;
                    }
                    catch (Throwable var12_18) {
                        try {
                            this.endResponse(network);
                            throw var12_18;
                        }
                        catch (OModificationOperationProhibitedException mope) {
                            this.handleDBFreeze();
                            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                        }
                        catch (Exception e) {
                            this.handleException(network, "Error on executing command: " + iCommand, e);
                        }
                    }
                }
                finally {
                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (iCommand.getResultListener() != null && !live) {
                    iCommand.getResultListener().end();
                }
            }
        }
        return result;
    }

    protected Object readSynchResult(OChannelBinaryAsynchClient network, ODatabaseDocument database) throws IOException {
        Object result;
        byte type = network.readByte();
        switch (type) {
            case 110: {
                result = null;
                break;
            }
            case 114: {
                result = OChannelBinaryProtocol.readIdentifiable((OChannelBinaryAsynchClient)network);
                if (!(result instanceof ORecord)) break;
                database.getLocalCache().updateRecord((ORecord)result);
                break;
            }
            case 108: 
            case 115: {
                int tot = network.readInt();
                AbstractCollection coll = type == 115 ? new HashSet(tot) : new ArrayList(tot);
                for (int i = 0; i < tot; ++i) {
                    OIdentifiable resultItem = OChannelBinaryProtocol.readIdentifiable((OChannelBinaryAsynchClient)network);
                    if (resultItem instanceof ORecord) {
                        database.getLocalCache().updateRecord((ORecord)resultItem);
                    }
                    coll.add(resultItem);
                }
                result = coll;
                break;
            }
            case 105: {
                byte status;
                AbstractCollection coll = new ArrayList();
                while ((status = network.readByte()) > 0) {
                    OIdentifiable record = OChannelBinaryProtocol.readIdentifiable((OChannelBinaryAsynchClient)network);
                    if (record == null || status != 1) continue;
                    if (record instanceof ORecord) {
                        database.getLocalCache().updateRecord((ORecord)record);
                    }
                    coll.add(record);
                }
                result = coll;
                break;
            }
            case 97: {
                String value = new String(network.readBytes());
                result = ORecordSerializerStringAbstract.fieldTypeFromStream(null, (OType)ORecordSerializerStringAbstract.getType((String)value), (Object)value);
                break;
            }
            default: {
                OLogManager.instance().warn((Object)this, "Received unexpected result from query: %d", new Object[]{type});
                result = null;
            }
        }
        if (network.getSrvProtocolVersion() >= 17) {
            byte status;
            while ((status = network.readByte()) > 0) {
                ORecord record = (ORecord)OChannelBinaryProtocol.readIdentifiable((OChannelBinaryAsynchClient)network);
                if (record == null || status != 2) continue;
                database.getLocalCache().updateRecord(record);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(OTransaction iTx, Runnable callback) {
        ArrayList<ORecordOperation> committedEntries = new ArrayList<ORecordOperation>();
        OChannelBinaryAsynchClient network = null;
        while (true) {
            try {
                ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = true;
                try {
                    network = this.beginRequest((byte)60);
                    network.writeInt(iTx.getId());
                    network.writeByte((byte)(iTx.isUsingLog() ? 1 : 0));
                    ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
                    if (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                        for (ORecordOperation txEntry : iTx.getCurrentRecordEntries()) {
                            committedEntries.add(txEntry);
                        }
                        while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                            for (ORecordOperation txEntry : iTx.getCurrentRecordEntries()) {
                                tmpEntries.add(txEntry);
                            }
                            iTx.clearRecordEntries();
                            if (tmpEntries.size() <= 0) continue;
                            for (ORecordOperation txEntry : tmpEntries) {
                                this.commitEntry(network, txEntry);
                            }
                            tmpEntries.clear();
                        }
                    } else if (committedEntries.size() > 0) {
                        tmpEntries.addAll(committedEntries);
                        while (!tmpEntries.isEmpty()) {
                            iTx.clearRecordEntries();
                            for (ORecordOperation txEntry : tmpEntries) {
                                ORecordInternal.clearSource((ORecord)txEntry.getRecord());
                                this.commitEntry(network, txEntry);
                            }
                            tmpEntries.clear();
                            for (ORecordOperation txEntry : iTx.getCurrentRecordEntries()) {
                                tmpEntries.add(txEntry);
                            }
                        }
                    }
                    network.writeByte((byte)0);
                    network.writeBytes(iTx.getIndexChanges().toStream());
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int createdRecords = network.readInt();
                    for (int i = 0; i < createdRecords; ++i) {
                        ORecordId currentRid = network.readRID();
                        ORecordId createdRid = network.readRID();
                        iTx.updateIdentityAfterCommit((ORID)currentRid, (ORID)createdRid);
                    }
                    int updatedRecords = network.readInt();
                    for (int i = 0; i < updatedRecords; ++i) {
                        ORecordId rid = network.readRID();
                        ORecordOperation rop = iTx.getRecordEntry((ORID)rid);
                        if (rop == null) continue;
                        rop.getRecord().getRecordVersion().copyFrom(network.readVersion());
                    }
                    if (network.getSrvProtocolVersion() >= 20) {
                        this.readCollectionChanges(network, ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager());
                    }
                }
                finally {
                    this.endResponse(network);
                }
                committedEntries.clear();
                for (ORecordOperation txEntry : iTx.getAllRecordEntries()) {
                    ORecordInternal.unsetDirty((ORecord)txEntry.getRecord());
                }
                OTransactionAbstract.updateCacheFromEntries((OTransaction)iTx, (Iterable)iTx.getAllRecordEntries(), (boolean)false);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(network, "Error on commit", e);
                iTx.restore();
                continue;
            }
            finally {
                ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                continue;
            }
            break;
        }
    }

    public void rollback(OTransaction iTx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusterIdByName(String iClusterName) {
        this.stateLock.acquireReadLock();
        try {
            if (iClusterName == null) {
                int n = -1;
                return n;
            }
            if (Character.isDigit(iClusterName.charAt(0))) {
                int n = Integer.parseInt(iClusterName);
                return n;
            }
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
            if (cluster == null) {
                int n = -1;
                return n;
            }
            int n = cluster.getId();
            return n;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    public int addCluster(String iClusterName, boolean forceListBased, Object ... iArguments) {
        return this.addCluster(iClusterName, -1, forceListBased, iArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCluster(String iClusterName, int iRequestedId, boolean forceListBased, Object ... iParameters) {
        OChannelBinaryAsynchClient network = null;
        while (true) {
            this.stateLock.acquireWriteLock();
            try {
                try {
                    network = this.beginRequest((byte)10);
                    network.writeString(iClusterName);
                    if (network.getSrvProtocolVersion() >= 18) {
                        network.writeShort((short)iRequestedId);
                    }
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    short clusterId = network.readShort();
                    OClusterRemote cluster = new OClusterRemote();
                    cluster.configure((OStorage)this, clusterId, iClusterName.toLowerCase(), new Object[0]);
                    if (this.clusters.length <= clusterId) {
                        this.clusters = Arrays.copyOf(this.clusters, clusterId + 1);
                    }
                    this.clusters[cluster.getId()] = cluster;
                    this.clusterMap.put(cluster.getName().toLowerCase(), cluster);
                    short s = clusterId;
                    this.endResponse(network);
                    return s;
                }
                catch (Throwable throwable) {
                    try {
                        this.endResponse(network);
                        throw throwable;
                    }
                    catch (OModificationOperationProhibitedException mphe) {
                        this.handleDBFreeze();
                        this.stateLock.releaseWriteLock();
                        continue;
                    }
                    catch (Exception e) {
                        this.handleException(network, "Error on add new cluster", e);
                        continue;
                    }
                }
            }
            finally {
                this.stateLock.releaseWriteLock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        OChannelBinaryAsynchClient network = null;
        while (true) {
            this.stateLock.acquireWriteLock();
            try {
                try {
                    network = this.beginRequest((byte)11);
                    network.writeShort((short)iClusterId);
                }
                finally {
                    this.endRequest(network);
                }
                byte result = 0;
                try {
                    this.beginResponse(network);
                    result = network.readByte();
                }
                finally {
                    this.endResponse(network);
                }
                if (result == 1) {
                    OCluster cluster = this.clusters[iClusterId];
                    this.clusters[iClusterId] = null;
                    this.clusterMap.remove(cluster.getName());
                    if (this.configuration.clusters.size() > iClusterId) {
                        this.configuration.dropCluster(iClusterId);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (Exception e) {
                this.handleException(network, "Error on removing of cluster", e);
                continue;
            }
            finally {
                this.stateLock.releaseWriteLock();
                continue;
            }
            break;
        }
    }

    public void synch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPhysicalClusterNameById(int iClusterId) {
        this.stateLock.acquireReadLock();
        try {
            if (iClusterId >= this.clusters.length) {
                String string = null;
                return string;
            }
            OCluster cluster = this.clusters[iClusterId];
            String string = cluster != null ? cluster.getName() : null;
            return string;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public int getClusterMap() {
        this.stateLock.acquireReadLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public Collection<OCluster> getClusterInstances() {
        this.stateLock.acquireReadLock();
        try {
            List<OCluster> list = Arrays.asList(this.clusters);
            return list;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public OCluster getClusterById(int iClusterId) {
        this.stateLock.acquireReadLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            OCluster oCluster = this.clusters[iClusterId];
            return oCluster;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public long getVersion() {
        throw new UnsupportedOperationException("getVersion");
    }

    public ODocument getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    public void endRequest(OChannelBinaryAsynchClient iNetwork) throws IOException {
        if (iNetwork == null) {
            return;
        }
        try {
            iNetwork.flush();
            iNetwork.releaseWriteLock();
        }
        catch (IOException e) {
            this.engine.getConnectionManager().remove(iNetwork);
            throw e;
        }
    }

    public void endResponse(OChannelBinaryAsynchClient iNetwork) {
        try {
            iNetwork.endResponse();
            this.engine.getConnectionManager().release(iNetwork);
        }
        catch (IOException e) {
            this.engine.getConnectionManager().remove(iNetwork);
            OLogManager.instance().warn((Object)this, "dirty data left in the socket closing", (Throwable)e, new Object[0]);
        }
    }

    public boolean isRemote() {
        return true;
    }

    public boolean isPermanentRequester() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterConfiguration(String iConnectedURL, byte[] obj) {
        List members;
        if (obj == null) {
            return;
        }
        OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.setValue((Object)Integer.MAX_VALUE);
        Object object = this.clusterConfiguration;
        synchronized (object) {
            this.clusterConfiguration.fromStream(obj);
            this.clusterConfiguration.toString();
            members = (List)this.clusterConfiguration.field("members");
        }
        object = this.serverURLs;
        synchronized (object) {
            if (members != null) {
                this.addHost(iConnectedURL);
                for (ODocument m : members) {
                    if (m == null) continue;
                    Collection listeners = (Collection)m.field("listeners");
                    if (listeners == null) {
                        throw new ODatabaseException("Received bad distributed configuration: missing 'listeners' array field");
                    }
                    for (Map listener : listeners) {
                        String url;
                        if (!((String)listener.get("protocol")).equals("ONetworkProtocolBinary") || this.serverURLs.contains(url = (String)listener.get("listen"))) continue;
                        this.addHost(url);
                    }
                }
            }
        }
    }

    public OCluster getClusterByName(String iClusterName) {
        throw new UnsupportedOperationException("getClusterByName()");
    }

    public ORecordConflictStrategy getConflictStrategy() {
        throw new UnsupportedOperationException("getConflictStrategy");
    }

    public void setConflictStrategy(ORecordConflictStrategy iResolver) {
        throw new UnsupportedOperationException("setConflictStrategy");
    }

    public String getURL() {
        return "remote:" + this.url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getClusters() {
        this.stateLock.acquireReadLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public String getType() {
        return "remote";
    }

    public Class<OSBTreeCollectionManagerRemote> getCollectionManagerClass() {
        return OSBTreeCollectionManagerRemote.class;
    }

    public OEngineRemote getEngine() {
        return this.engine;
    }

    public String getUserName() {
        return this.connectionUserName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleException(OChannelBinaryAsynchClient iNetwork, String message, Exception exception) {
        int currentRetryDelay;
        int currentMaxRetry;
        int urlSize;
        Throwable firstCause = OException.getFirstCause((Throwable)exception);
        if (!(firstCause instanceof IOException) && !(firstCause instanceof OIOException)) {
            if (exception instanceof OException) {
                throw (OException)exception;
            }
            throw new OStorageException(message, (Throwable)exception);
        }
        if (iNetwork != null) {
            OLogManager.instance().warn((Object)this, "Caught I/O errors from %s (local socket=%s), trying to reconnect (error: %s)", new Object[]{iNetwork, iNetwork.getLocalSocketAddress(), firstCause});
            OLogManager.instance().debug((Object)this, "I/O error stack: ", firstCause, new Object[0]);
            try {
                this.engine.getConnectionManager().remove(iNetwork);
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Cannot remove connection from connection manager", (Throwable)e, new Object[0]);
            }
        } else {
            OLogManager.instance().warn((Object)this, "Caught I/O errors, trying to reconnect (error: %s)", new Object[]{firstCause.toString()});
            OLogManager.instance().debug((Object)this, "I/O error stack: ", firstCause, new Object[0]);
        }
        long lostConnectionTime = System.currentTimeMillis();
        List<String> list = this.serverURLs;
        synchronized (list) {
            urlSize = this.serverURLs.size();
        }
        if (urlSize > 1) {
            currentMaxRetry = 1;
            currentRetryDelay = 0;
        } else {
            currentMaxRetry = this.connectionRetry;
            currentRetryDelay = this.connectionRetryDelay;
        }
        for (int retry = 0; retry < currentMaxRetry; ++retry) {
            if (retry > 0 && currentRetryDelay > 0) {
                try {
                    Thread.sleep(currentRetryDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            try {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Retrying to connect to remote server #" + (retry + 1) + "/" + currentMaxRetry + "...", new Object[0]);
                }
                this.setSessionId(null, -1, null);
                String currentURL = this.openRemoteDatabase();
                OLogManager.instance().warn((Object)this, "Connection re-acquired transparently after %dms and %d retries to server '%s': no errors will be thrown at application level", new Object[]{System.currentTimeMillis() - lostConnectionTime, retry + 1, currentURL});
                return;
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error during exception handling", t, new Object[0]);
                continue;
            }
        }
        throw new OStorageException(message, (Throwable)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String openRemoteDatabase() throws IOException {
        this.connectionDbType = "document";
        if (this.connectionOptions != null && this.connectionOptions.size() > 0 && this.connectionOptions.containsKey(PARAM_DB_TYPE)) {
            this.connectionDbType = this.connectionOptions.get(PARAM_DB_TYPE).toString();
        }
        OChannelBinaryAsynchClient network = null;
        String currentURL = this.getCurrentServerURL();
        do {
            this.clearToken();
            network = this.getAvailableNetwork(currentURL);
            try {
                network.writeByte((byte)3);
                network.writeInt(this.getSessionId());
                this.sendClientInfo(network);
                network.writeString(this.name);
                if (network.getSrvProtocolVersion() >= 8) {
                    network.writeString(this.connectionDbType);
                }
                network.writeString(this.connectionUserName);
                network.writeString(this.connectionUserPassword);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                int sessionId = network.readInt();
                byte[] token = network.readBytes();
                if (token.length == 0) {
                    token = null;
                } else {
                    network.getServiceThread().setTokenBased(true);
                }
                this.setSessionId(network.getServerURL(), sessionId, token);
                OLogManager.instance().debug((Object)this, "Client connected to %s with session id=%d", new Object[]{network.getServerURL(), sessionId});
                this.readDatabaseInformation(network);
                this.updateClusterConfiguration(network.getServerURL(), network.readBytes());
                if (network.getSrvProtocolVersion() >= 14) {
                    network.readString();
                }
                this.status = OStorage.STATUS.OPEN;
                String string = currentURL;
                this.endResponse(network);
                return string;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OIOException e) {
                    if (network != null) {
                        this.engine.getConnectionManager().remove(network);
                        network = null;
                    }
                    OLogManager.instance().error((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (network != null) {
                        try {
                            this.engine.getConnectionManager().remove(network);
                        }
                        catch (Exception ex) {
                            OLogManager.instance().debug((Object)this, "Cannot remove connection or database url=" + currentURL, (Throwable)e, new Object[0]);
                        }
                        network = null;
                    }
                    OLogManager.instance().error((Object)this, "Cannot open database url=" + currentURL, (Throwable)e, new Object[0]);
                }
            }
        } while (this.engine.getConnectionManager().getReusableConnections(currentURL) > 0 || (currentURL = this.useNewServerURL(currentURL)) != null);
        this.parseServerURLs();
        List<String> list = this.serverURLs;
        synchronized (list) {
            throw new OStorageException("Cannot create a connection to remote server address(es): " + this.serverURLs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String useNewServerURL(String iUrl) {
        int pos = iUrl.indexOf(47);
        if (pos >= iUrl.length() - 1) {
            pos = -1;
        }
        String postFix = pos > -1 ? iUrl.substring(pos) : "";
        String url = pos > -1 ? iUrl.substring(0, pos) : iUrl;
        List<String> list = this.serverURLs;
        synchronized (list) {
            this.serverURLs.remove(url);
            OLogManager.instance().debug((Object)this, "Updated server list: %s...", new Object[]{this.serverURLs});
            if (!this.serverURLs.isEmpty()) {
                return this.serverURLs.get(0) + postFix;
            }
        }
        return null;
    }

    protected void sendClientInfo(OChannelBinaryAsynchClient network) throws IOException {
        if (network.getSrvProtocolVersion() >= 7) {
            network.writeString(DRIVER_NAME).writeString("2.1.10").writeShort((short)32).writeString(this.clientId);
        }
        if (network.getSrvProtocolVersion() > 21) {
            network.writeString(ODatabaseDocumentTx.getDefaultSerializer().toString());
            this.recordFormat = ODatabaseDocumentTx.getDefaultSerializer().toString();
        } else {
            this.recordFormat = "ORecordDocument2csv";
        }
        if (network.getSrvProtocolVersion() > 26) {
            network.writeBoolean(OGlobalConfiguration.CLIENT_SESSION_TOKEN_BASED.getValueAsBoolean());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseServerURLs() {
        String[] stringArray;
        String lastHost = null;
        int dbPos = this.url.indexOf(47);
        if (dbPos == -1) {
            this.addHost(this.url);
            lastHost = this.url;
            this.name = this.url;
        } else {
            this.name = this.url.substring(this.url.lastIndexOf("/") + 1);
            stringArray = this.url.substring(0, dbPos).split(ADDRESS_SEPARATOR);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String host;
                lastHost = host = stringArray[i];
                this.addHost(host);
            }
        }
        stringArray = this.serverURLs;
        synchronized (this.serverURLs) {
            if (this.serverURLs.size() == 1 && OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_ENABLED.getValueAsBoolean()) {
                String primaryServer = lastHost;
                OLogManager.instance().debug((Object)this, "Retrieving URLs from DNS '%s' (timeout=%d)...", new Object[]{primaryServer, OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT.getValueAsInteger()});
                try {
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                    env.put("com.sun.jndi.ldap.connect.timeout", OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT.getValueAsString());
                    InitialDirContext ictx = new InitialDirContext(env);
                    String hostName = !primaryServer.contains(":") ? primaryServer : primaryServer.substring(0, primaryServer.indexOf(":"));
                    Attributes attrs = ictx.getAttributes(hostName, new String[]{"TXT"});
                    Attribute attr = attrs.get("TXT");
                    if (attr != null) {
                        for (int i = 0; i < attr.size(); ++i) {
                            String[] parts;
                            String configuration = (String)attr.get(i);
                            if (configuration.startsWith("\"")) {
                                configuration = configuration.substring(1, configuration.length() - 1);
                            }
                            if (configuration == null) continue;
                            this.serverURLs.clear();
                            for (String part : parts = configuration.split(" ")) {
                                if (!part.startsWith("s=")) continue;
                                this.addHost(part.substring("s=".length()));
                            }
                        }
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addHost(String host) {
        if (host.startsWith(DEFAULT_HOST)) {
            host = "127.0.0.1" + host.substring(DEFAULT_HOST.length());
        }
        if (!host.contains(":")) {
            host = host + ":" + (this.clientConfiguration.getValueAsBoolean(OGlobalConfiguration.CLIENT_USE_SSL) ? this.getDefaultSSLPort() : this.getDefaultPort());
        }
        if (host.contains("/")) {
            host = host.substring(0, host.indexOf("/"));
        }
        List<String> list = this.serverURLs;
        synchronized (list) {
            if (!this.serverURLs.contains(host)) {
                this.serverURLs.add(host);
                OLogManager.instance().debug((Object)this, "Registered the new available server '%s'", new Object[]{host});
            }
        }
        return host;
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    protected int getDefaultPort() {
        return 2424;
    }

    protected int getDefaultSSLPort() {
        return 2434;
    }

    protected OChannelBinaryAsynchClient beginRequest(byte iCommand) throws IOException {
        OChannelBinaryAsynchClient network = this.getAvailableNetwork(this.getCurrentServerURL());
        network.writeByte(iCommand);
        network.writeInt(this.getSessionId());
        byte[] token = this.getSessionToken();
        if (token != null) {
            network.writeBytes(token);
        }
        return network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCurrentServerURL() {
        List<String> list = this.serverURLs;
        synchronized (list) {
            if (this.serverURLs.isEmpty()) {
                this.parseServerURLs();
                if (this.serverURLs.isEmpty()) {
                    throw new OStorageException("Cannot create a connection to remote server because url list is empty");
                }
            }
            return this.serverURLs.get(0) + "/" + this.getName();
        }
    }

    protected OChannelBinaryAsynchClient getAvailableNetwork(String iCurrentURL) throws IOException {
        OChannelBinaryAsynchClient network;
        String lastURL = iCurrentURL;
        do {
            Exception cause = null;
            try {
                network = this.engine.getConnectionManager().acquire(lastURL, this.clientConfiguration, this.connectionOptions, this.asynchEventListener);
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error during acquiring of connection to URL " + lastURL, (Throwable)e, new Object[0]);
                network = null;
                cause = e;
            }
            if (network == null) {
                if ((lastURL = this.useNewServerURL(lastURL)) != null) continue;
                this.parseServerURLs();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new OIOException("Cannot open a connection to remote server: " + iCurrentURL, (Throwable)cause);
            }
            if (!network.isConnected()) {
                OLogManager.instance().error((Object)this, "Removing disconnected network channel '%s'...", new Object[]{lastURL});
                this.engine.getConnectionManager().remove(network);
                network = null;
                continue;
            }
            if (network.tryLock()) continue;
            OLogManager.instance().error((Object)this, "Removing locked network channel '%s'...", new Object[]{lastURL});
            this.engine.getConnectionManager().remove(network);
            network = null;
        } while (network == null);
        return network;
    }

    protected void beginResponse(OChannelBinaryAsynchClient iNetwork) throws IOException {
        byte[] newToken = iNetwork.beginResponse(this.getSessionId(), this.getSessionToken() != null);
        if (newToken != null && newToken.length > 0) {
            this.setSessionId(this.getServerURL(), this.getSessionId(), newToken);
        }
    }

    protected void getResponse(OChannelBinaryAsynchClient iNetwork) throws IOException {
        try {
            this.beginResponse(iNetwork);
        }
        finally {
            this.endResponse(iNetwork);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hideRecord(final ORecordId rid, int mode, final ORecordCallback<Boolean> callback, final OChannelBinaryAsynchClient network) throws IOException {
        try {
            network.writeRID((ORID)rid);
            network.writeByte((byte)mode);
        }
        finally {
            this.endRequest(network);
        }
        switch (mode) {
            case 0: {
                try {
                    this.beginResponse(network);
                    boolean bl = network.readByte() == 1;
                    return bl;
                }
                finally {
                    this.endResponse(network);
                }
            }
            case 1: {
                if (callback == null) break;
                final int sessionId = this.getSessionId();
                Callable<Object> response = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Boolean result;
                        try {
                            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = sessionId;
                            OStorageRemote.this.beginResponse(network);
                            result = network.readByte() == 1;
                        }
                        finally {
                            OStorageRemote.this.endResponse(network);
                            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = -1;
                        }
                        callback.call(rid, (Object)result);
                        return null;
                    }
                };
                this.asynchExecutor.submit(new FutureTask<Object>(response));
            }
        }
        return false;
    }

    private OPhysicalPosition[] readPhysicalPositions(OChannelBinaryAsynchClient network, int positionsCount) throws IOException {
        OPhysicalPosition[] physicalPositions = new OPhysicalPosition[positionsCount];
        for (int i = 0; i < physicalPositions.length; ++i) {
            OPhysicalPosition position = new OPhysicalPosition();
            position.clusterPosition = network.readLong();
            position.recordSize = network.readInt();
            position.recordVersion = network.readVersion();
            physicalPositions[i] = position;
        }
        return physicalPositions;
    }

    private void readCollectionChanges(OChannelBinaryAsynchClient network, OSBTreeCollectionManager collectionManager) throws IOException {
        int count = network.readInt();
        for (int i = 0; i < count; ++i) {
            long mBitsOfId = network.readLong();
            long lBitsOfId = network.readLong();
            OBonsaiCollectionPointer pointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer((OChannelBinary)network);
            if (collectionManager == null) continue;
            collectionManager.updateCollectionPointer(new UUID(mBitsOfId, lBitsOfId), pointer);
        }
        if (ORecordSerializationContext.getDepth() <= 1 && collectionManager != null) {
            collectionManager.clearPendingCollections();
        }
    }

    private void commitEntry(OChannelBinaryAsynchClient iNetwork, ORecordOperation txEntry) throws IOException {
        if (txEntry.type == 0) {
            return;
        }
        byte[] stream = null;
        try {
            switch (txEntry.type) {
                case 1: 
                case 3: {
                    stream = txEntry.getRecord().toStream();
                }
            }
        }
        catch (Exception e) {
            iNetwork.writeByte((byte)-1);
            throw new OTransactionException("Error on transaction commit", (Throwable)e);
        }
        iNetwork.writeByte((byte)1);
        iNetwork.writeByte(txEntry.type);
        iNetwork.writeRID(txEntry.getRecord().getIdentity());
        iNetwork.writeByte(ORecordInternal.getRecordType((ORecord)txEntry.getRecord()));
        switch (txEntry.type) {
            case 3: {
                iNetwork.writeBytes(stream);
                break;
            }
            case 1: {
                iNetwork.writeVersion(txEntry.getRecord().getRecordVersion());
                iNetwork.writeBytes(stream);
                if (iNetwork.getSrvProtocolVersion() < 23) break;
                iNetwork.writeBoolean(ORecordInternal.isContentChanged((ORecord)txEntry.getRecord()));
                break;
            }
            case 2: {
                iNetwork.writeVersion(txEntry.getRecord().getRecordVersion());
            }
        }
    }

    private boolean handleDBFreeze() {
        OLogManager.instance().warn((Object)this, "DB is frozen will wait for " + OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT.getValue() + " ms. and then retry.", new Object[0]);
        boolean retry = true;
        try {
            Thread.sleep(OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT.getValueAsInteger());
        }
        catch (InterruptedException ie) {
            retry = false;
            Thread.currentThread().interrupt();
        }
        return retry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDatabaseInformation(OChannelBinaryAsynchClient network) throws IOException {
        int tot = network.getSrvProtocolVersion() >= 7 ? network.readShort() : network.readInt();
        this.stateLock.acquireWriteLock();
        try {
            this.clusters = new OCluster[tot];
            this.clusterMap.clear();
            for (int i = 0; i < tot; ++i) {
                OClusterRemote cluster = new OClusterRemote();
                String clusterName = network.readString();
                short clusterId = network.readShort();
                if (clusterName == null) continue;
                clusterName = clusterName.toLowerCase();
                if (network.getSrvProtocolVersion() < 24) {
                    network.readString();
                }
                short dataSegmentId = network.getSrvProtocolVersion() >= 12 && network.getSrvProtocolVersion() < 24 ? network.readShort() : (short)0;
                cluster.configure((OStorage)this, clusterId, clusterName, new Object[0]);
                if (clusterId >= this.clusters.length) {
                    this.clusters = Arrays.copyOf(this.clusters, clusterId + 1);
                }
                this.clusters[clusterId] = cluster;
                this.clusterMap.put(clusterName, cluster);
            }
            this.defaultClusterId = this.clusterMap.get("default").getId();
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteRecord(final ORecordId iRid, ORecordVersion iVersion, int iMode, final ORecordCallback<Boolean> iCallback, final OChannelBinaryAsynchClient network) throws IOException {
        try {
            network.writeRID((ORID)iRid);
            network.writeVersion(iVersion);
            network.writeByte((byte)iMode);
        }
        finally {
            this.endRequest(network);
        }
        switch (iMode) {
            case 0: {
                try {
                    this.beginResponse(network);
                    boolean bl = network.readByte() == 1;
                    return bl;
                }
                finally {
                    this.endResponse(network);
                }
            }
            case 1: {
                if (iCallback == null) break;
                final int sessionId = this.getSessionId();
                Callable<Object> response = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Boolean result;
                        try {
                            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = sessionId;
                            OStorageRemote.this.beginResponse(network);
                            result = network.readByte() == 1;
                        }
                        finally {
                            OStorageRemote.this.endResponse(network);
                            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = -1;
                        }
                        iCallback.call(iRid, (Object)result);
                        return null;
                    }
                };
                this.asynchExecutor.submit(new FutureTask<Object>(response));
            }
        }
        return false;
    }
}

