/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.db;

import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ODatabaseHelper {
    public static void createDatabase(ODatabase database, String url) throws IOException {
        ODatabaseHelper.createDatabase(database, url, "server", "plocal");
    }

    public static void createDatabase(ODatabase database, String url, String type) throws IOException {
        ODatabaseHelper.createDatabase(database, url, "server", type);
    }

    public static void createDatabase(ODatabase database, String url, String directory, String type) throws IOException {
        if (url.startsWith("remote")) {
            new OServerAdmin(url).connect("root", ODatabaseHelper.getServerRootPassword(directory)).createDatabase("document", type).close();
        } else {
            database.create();
            database.close();
        }
    }

    public static void deleteDatabase(ODatabase database, String storageType) throws IOException {
        ODatabaseHelper.deleteDatabase(database, "server", storageType);
    }

    @Deprecated
    public static void deleteDatabase(ODatabase database, String directory, String storageType) throws IOException {
        ODatabaseHelper.dropDatabase(database, directory, storageType);
    }

    public static void dropDatabase(ODatabase database, String storageType) throws IOException {
        ODatabaseHelper.dropDatabase(database, "server", storageType);
    }

    public static void dropDatabase(ODatabase database, String directory, String storageType) throws IOException {
        if (ODatabaseHelper.existsDatabase(database, storageType)) {
            if (database.getURL().startsWith("remote:")) {
                database.activateOnCurrentThread();
                database.close();
                OServerAdmin admin = new OServerAdmin(database.getURL()).connect("root", ODatabaseHelper.getServerRootPassword(directory));
                admin.dropDatabase(storageType);
                admin.close();
            } else {
                if (database.isClosed()) {
                    database.open("admin", "admin");
                } else {
                    database.activateOnCurrentThread();
                }
                database.drop();
            }
        }
    }

    public static boolean existsDatabase(ODatabase database, String storageType) throws IOException {
        database.activateOnCurrentThread();
        if (database.getURL().startsWith("remote")) {
            OServerAdmin admin = new OServerAdmin(database.getURL()).connect("root", ODatabaseHelper.getServerRootPassword());
            boolean exist = admin.existsDatabase(storageType);
            admin.close();
            return exist;
        }
        return database.exists();
    }

    public static boolean existsDatabase(String url) throws IOException {
        if (url.startsWith("remote")) {
            OServerAdmin admin = new OServerAdmin(url).connect("root", ODatabaseHelper.getServerRootPassword());
            boolean exist = admin.existsDatabase();
            admin.close();
            return exist;
        }
        return new ODatabaseDocumentTx(url).exists();
    }

    public static void freezeDatabase(ODatabase database) throws IOException {
        database.activateOnCurrentThread();
        if (database.getURL().startsWith("remote")) {
            OServerAdmin serverAdmin = new OServerAdmin(database.getURL());
            serverAdmin.connect("root", ODatabaseHelper.getServerRootPassword()).freezeDatabase("plocal");
            serverAdmin.close();
        } else {
            database.freeze();
        }
    }

    public static void releaseDatabase(ODatabase database) throws IOException {
        database.activateOnCurrentThread();
        if (database.getURL().startsWith("remote")) {
            OServerAdmin serverAdmin = new OServerAdmin(database.getURL());
            serverAdmin.connect("root", ODatabaseHelper.getServerRootPassword()).releaseDatabase("plocal");
            serverAdmin.close();
        } else {
            database.release();
        }
    }

    public static File getConfigurationFile() {
        return ODatabaseHelper.getConfigurationFile(null);
    }

    public static String getServerRootPassword() throws IOException {
        return ODatabaseHelper.getServerRootPassword("server");
    }

    protected static String getServerRootPassword(String iDirectory) throws IOException {
        File file = ODatabaseHelper.getConfigurationFile(iDirectory);
        FileReader f = new FileReader(file);
        char[] buffer = new char[(int)file.length()];
        f.read(buffer);
        f.close();
        String fileContent = new String(buffer);
        int pos = fileContent.indexOf("password=\"");
        return fileContent.substring(pos += "password=\"".length(), fileContent.indexOf(34, pos));
    }

    protected static File getConfigurationFile(String iDirectory) {
        String sysProperty = System.getProperty("orientdb.config.file");
        File file = new File(sysProperty != null ? sysProperty : "");
        if (!file.exists()) {
            sysProperty = System.getenv("CONFIG_FILE");
            file = new File(sysProperty != null ? sysProperty : "");
        }
        if (!file.exists()) {
            file = new File("../releases/orientdb-2.1.25/config/orientdb-server-config.xml");
        }
        if (!file.exists()) {
            file = new File("../releases/orientdb-community-2.1.25/config/orientdb-server-config.xml");
        }
        if (!file.exists()) {
            file = new File("../../releases/orientdb-2.1.25/config/orientdb-server-config.xml");
        }
        if (!file.exists()) {
            file = new File("../../releases/orientdb-community-2.1.25/config/orientdb-server-config.xml");
        }
        if (!file.exists() && iDirectory != null && !(file = new File(iDirectory + "/config/orientdb-server-config.xml")).exists()) {
            file = new File("../" + iDirectory + "/config/orientdb-server-config.xml");
        }
        if (!file.exists()) {
            file = new File(OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}/config/orientdb-server-config.xml"));
        }
        if (!file.exists()) {
            throw new OConfigurationException("Cannot load file orientdb-server-config.xml to execute remote tests. Current directory is " + new File(".").getAbsolutePath());
        }
        return file;
    }
}

