/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import java.util.HashSet;
import java.util.Set;

public class OStorageRemoteThreadLocal
extends ThreadLocal<OStorageRemoteSession> {
    public static volatile OStorageRemoteThreadLocal INSTANCE = new OStorageRemoteThreadLocal();

    @Override
    protected OStorageRemoteSession initialValue() {
        return new OStorageRemoteSession();
    }

    static {
        Orient.instance().registerListener((OOrientListener)new OOrientListenerAbstract(){

            public void onStartup() {
                if (INSTANCE == null) {
                    INSTANCE = new OStorageRemoteThreadLocal();
                }
            }

            public void onShutdown() {
                INSTANCE = null;
            }
        });
    }

    public class OStorageRemoteSession {
        public boolean commandExecuting = false;
        public Integer sessionId = -1;
        public String serverURL = null;
        public int serverURLIndex = -1;
        public Set<OChannelBinary> connections = new HashSet<OChannelBinary>();

        public boolean has(OChannelBinary connection) {
            return this.connections.contains(connection);
        }

        public void add(OChannelBinary connection) {
            this.connections.add(connection);
        }

        public void clear() {
            this.connections.clear();
        }
    }
}

