/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OSystemException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.client.remote.OStorageRemoteNodeSession;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import com.orientechnologies.orient.enterprise.channel.OSocketFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OAsynchChannelServiceThread;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import com.orientechnologies.orient.enterprise.channel.binary.OResponseProcessingException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class OChannelBinaryAsynchClient
extends OChannelBinary {
    protected final int socketTimeout;
    protected final short srvProtocolVersion;
    private final Condition readCondition = this.getLockRead().getUnderlying().newCondition();
    private final int maxUnreadResponses;
    private String serverURL;
    private volatile boolean channelRead = false;
    private byte currentStatus;
    private int currentSessionId;
    private volatile OAsynchChannelServiceThread serviceThread;

    public OChannelBinaryAsynchClient(String remoteHost, int remotePort, String iDatabaseName, OContextConfiguration iConfig, int iProtocolVersion) throws IOException {
        this(remoteHost, remotePort, iDatabaseName, iConfig, iProtocolVersion, null);
    }

    public OChannelBinaryAsynchClient(String remoteHost, int remotePort, String iDatabaseName, OContextConfiguration iConfig, int protocolVersion, ORemoteServerEventListener asynchEventListener) throws IOException {
        super(OSocketFactory.instance((OContextConfiguration)iConfig).createSocket(), iConfig);
        try {
            this.maxUnreadResponses = OGlobalConfiguration.NETWORK_BINARY_READ_RESPONSE_MAX_TIMES.getValueAsInteger();
            this.serverURL = remoteHost + ":" + remotePort;
            if (iDatabaseName != null) {
                this.serverURL = this.serverURL + "/" + iDatabaseName;
            }
            this.socketTimeout = iConfig.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_TIMEOUT);
            try {
                this.socket.connect(new InetSocketAddress(remoteHost, remotePort), this.socketTimeout);
                this.setReadResponseTimeout();
                this.connected();
            }
            catch (SocketTimeoutException e) {
                throw new IOException("Cannot connect to host " + remoteHost + ":" + remotePort, e);
            }
            try {
                this.inStream = new BufferedInputStream(this.socket.getInputStream(), this.socketBufferSize);
                this.outStream = new BufferedOutputStream(this.socket.getOutputStream(), this.socketBufferSize);
                this.in = new DataInputStream(this.inStream);
                this.out = new DataOutputStream(this.outStream);
                this.srvProtocolVersion = this.readShort();
            }
            catch (IOException e) {
                throw new ONetworkProtocolException("Cannot read protocol version from remote server " + this.socket.getRemoteSocketAddress() + ": " + e);
            }
            if (this.srvProtocolVersion != protocolVersion) {
                OLogManager.instance().warn((Object)this, "The Client driver version is different than Server version: client=" + protocolVersion + ", server=" + this.srvProtocolVersion + ". You could not use the full features of the newer version. Assure to have the same versions on both", new Object[0]);
            }
            if (asynchEventListener != null) {
                this.serviceThread = new OAsynchChannelServiceThread(asynchEventListener, this);
            }
        }
        catch (RuntimeException e) {
            if (this.socket.isConnected()) {
                this.socket.close();
            }
            throw e;
        }
    }

    private static RuntimeException createException(String iClassName, String iMessage, Exception iPrevious) {
        OException rootException = null;
        Constructor<?> c = null;
        try {
            Class<?> excClass = Class.forName(iClassName);
            if (iPrevious != null) {
                try {
                    c = excClass.getConstructor(String.class, Throwable.class);
                }
                catch (NoSuchMethodException e) {
                    c = excClass.getConstructor(String.class, Exception.class);
                }
            }
            if (c == null) {
                c = excClass.getConstructor(String.class);
            }
        }
        catch (Exception e) {
            rootException = OException.wrapException((OException)new OSystemException(iMessage), (Throwable)iPrevious);
        }
        if (c != null) {
            try {
                Exception cause = c.getParameterTypes().length > 1 ? (Exception)c.newInstance(iMessage, iPrevious) : (Exception)c.newInstance(iMessage);
                rootException = OException.wrapException((OException)new OSystemException("Data processing exception"), (Throwable)cause);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return rootException;
    }

    public byte[] beginResponse(int iRequesterId, boolean token) throws IOException {
        return this.beginResponse(iRequesterId, this.timeout, token);
    }

    /*
     * Unable to fully structure code
     */
    public byte[] beginResponse(int iRequesterId, long iTimeout, boolean token) throws IOException {
        try {
            unreadResponse = 0;
            v0 = startClock = iTimeout > 0L ? System.currentTimeMillis() : 0L;
            while (true) lbl-1000:
            // 3 sources

            {
                if (iTimeout <= 0L) {
                    this.acquireReadLock();
                } else if (!this.getLockRead().tryAcquireLock(iTimeout, TimeUnit.MILLISECONDS)) {
                    throw new OTimeoutException("Cannot acquire read lock against channel: " + (Object)this);
                }
                readLock = true;
                if (!this.isConnected()) {
                    this.releaseReadLock();
                    throw new IOException("Channel is closed");
                }
                if (!this.channelRead) {
                    this.channelRead = true;
                    try {
                        this.setWaitResponseTimeout();
                        this.currentStatus = this.readByte();
                        this.currentSessionId = this.readInt();
                        if (this.debug) {
                            OLogManager.instance().debug((Object)this, "%s - Read response: %d-%d", new Object[]{this.socket.getLocalAddress(), (int)this.currentStatus, this.currentSessionId});
                        }
                    }
                    catch (IOException e) {
                        this.channelRead = false;
                        this.readCondition.signalAll();
                        this.releaseReadLock();
                        readLock = false;
                        this.close();
                        throw e;
                    }
                    finally {
                        this.setReadResponseTimeout();
                    }
                }
                if (this.currentSessionId == iRequesterId) ** break;
                try {
                    if (this.debug) {
                        OLogManager.instance().debug((Object)this, "%s - Session %d skip response, it is for %d", new Object[]{this.socket.getLocalAddress(), iRequesterId, this.currentSessionId});
                    }
                    if (iTimeout > 0L && System.currentTimeMillis() - startClock > iTimeout) {
                        this.close();
                        readLock = false;
                        throw new OTimeoutException("Timeout on reading response from the server " + (this.socket != null ? this.socket.getRemoteSocketAddress() : "") + " for the request " + iRequesterId);
                    }
                    if (unreadResponse > this.maxUnreadResponses && iRequesterId != -2147483648) {
                        if (this.debug) {
                            OLogManager.instance().info((Object)this, "Unread responses %d > %d, consider the buffer as dirty: clean it", new Object[]{unreadResponse, this.maxUnreadResponses});
                        }
                        this.close();
                        readLock = false;
                        throw new IOException("Timeout on reading response");
                    }
                    this.readCondition.signalAll();
                    if (this.debug) {
                        OLogManager.instance().debug((Object)this, "Session %d is going to sleep...", new Object[]{iRequesterId});
                    }
                    start = System.currentTimeMillis();
                    this.readCondition.await(30L, TimeUnit.SECONDS);
                    if (this.debug) {
                        now = System.currentTimeMillis();
                        OLogManager.instance().debug((Object)this, "Waked up: slept %dms, checking again from %s for session %d", new Object[]{now - start, this.socket.getLocalAddress(), iRequesterId});
                    }
                    ++unreadResponse;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw OException.wrapException((OException)new OInterruptedException("Thread interrupted while waiting for request"), (Throwable)e);
                }
                finally {
                    if (!readLock) continue;
                    this.releaseReadLock();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            if (this.debug) {
                OLogManager.instance().debug((Object)this, "%s - Session %d handle response", new Object[]{this.socket.getLocalAddress(), iRequesterId});
            }
            tokenBytes = token != false ? this.readBytes() : null;
            this.handleStatus(this.currentStatus, this.currentSessionId);
            return tokenBytes;
        }
        catch (OLockException e) {
            Thread.currentThread().interrupt();
            OLogManager.instance().error((Object)this, "Unexpected error on reading response from channel", (Throwable)e, new Object[0]);
            return null;
        }
    }

    public void endResponse() throws IOException {
        this.channelRead = false;
        try {
            this.readCondition.signalAll();
        }
        catch (IllegalMonitorStateException e) {
            OLogManager.instance().debug((Object)this, "Error on signaling waiting clients after reading response", new Object[0]);
        }
        try {
            this.releaseReadLock();
        }
        catch (IllegalMonitorStateException e) {
            OLogManager.instance().debug((Object)this, "Error on unlocking network channel after reading response", new Object[0]);
        }
    }

    public void close() {
        if (this.getLockRead().tryAcquireLock()) {
            try {
                this.readCondition.signalAll();
            }
            finally {
                this.releaseReadLock();
            }
        }
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.serviceThread != null) {
            OAsynchChannelServiceThread s = this.serviceThread;
            this.serviceThread = null;
            if (s != null) {
                s.sendShutdown();
            }
        }
    }

    public void clearInput() throws IOException {
        this.acquireReadLock();
        try {
            super.clearInput();
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean isConnected() {
        Socket s = this.socket;
        return s != null && !s.isClosed() && s.isConnected() && !s.isInputShutdown() && !s.isOutputShutdown();
    }

    public short getSrvProtocolVersion() {
        return this.srvProtocolVersion;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public boolean tryLock() {
        return this.getLockWrite().tryAcquireLock();
    }

    public void unlock() {
        this.getLockWrite().unlock();
    }

    public OAsynchChannelServiceThread getServiceThread() {
        return this.serviceThread;
    }

    protected int handleStatus(byte iResult, int iClientTxId) throws IOException {
        if (iResult == 0 || iResult == 3) {
            return iClientTxId;
        }
        if (iResult == 1) {
            ArrayList<OPair> exceptions = new ArrayList<OPair>();
            while (this.readByte() == 1) {
                String excClassName = this.readString();
                String excMessage = this.readString();
                exceptions.add(new OPair((Comparable)((Object)excClassName), (Object)excMessage));
            }
            byte[] serializedException = null;
            if (this.srvProtocolVersion >= 19) {
                serializedException = this.readBytes();
            }
            RuntimeException previous = null;
            if (serializedException != null && serializedException.length > 0) {
                this.throwSerializedException(serializedException);
            }
            for (int i = exceptions.size() - 1; i > -1; --i) {
                previous = OChannelBinaryAsynchClient.createException((String)((Object)((OPair)exceptions.get(i)).getKey()), (String)((OPair)exceptions.get(i)).getValue(), previous);
            }
            if (previous != null) {
                throw new RuntimeException(previous);
            }
            throw new ONetworkProtocolException("Network response error");
        }
        throw new ONetworkProtocolException("Error on reading response from the server");
    }

    private void setReadResponseTimeout() throws SocketException {
        Socket s = this.socket;
        if (s != null && s.isConnected() && !s.isClosed()) {
            s.setSoTimeout(this.socketTimeout);
        }
    }

    private void setWaitResponseTimeout() throws SocketException {
        Socket s = this.socket;
        if (s != null) {
            s.setSoTimeout(OGlobalConfiguration.NETWORK_REQUEST_TIMEOUT.getValueAsInteger());
        }
    }

    private void throwSerializedException(byte[] serializedException) throws IOException {
        OMemoryInputStream inputStream = new OMemoryInputStream(serializedException);
        ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)inputStream);
        Object throwable = null;
        try {
            throwable = objectInputStream.readObject();
        }
        catch (ClassNotFoundException e) {
            OLogManager.instance().error((Object)this, "Error during exception deserialization", (Throwable)e, new Object[0]);
            throw new IOException("Error during exception deserialization: " + e.toString());
        }
        objectInputStream.close();
        if (throwable instanceof OException) {
            try {
                Class<?> cls = throwable.getClass();
                Constructor<?> constructor = cls.getConstructor(cls);
                OException proxyInstance = (OException)constructor.newInstance(throwable);
                throw proxyInstance;
            }
            catch (NoSuchMethodException e) {
                OLogManager.instance().error((Object)this, "Error during exception deserialization", (Throwable)e, new Object[0]);
            }
            catch (InvocationTargetException e) {
                OLogManager.instance().error((Object)this, "Error during exception deserialization", (Throwable)e, new Object[0]);
            }
            catch (InstantiationException e) {
                OLogManager.instance().error((Object)this, "Error during exception deserialization", (Throwable)e, new Object[0]);
            }
            catch (IllegalAccessException e) {
                OLogManager.instance().error((Object)this, "Error during exception deserialization", (Throwable)e, new Object[0]);
            }
        }
        if (throwable instanceof Throwable) {
            throw new OResponseProcessingException("Exception during response processing", (Throwable)throwable);
        }
        OLogManager.instance().error((Object)this, "Error during exception serialization, serialized exception is not Throwable, exception type is " + (throwable != null ? throwable.getClass().getName() : "null"), new Object[0]);
    }

    public void beginRequest(byte iCommand, OStorageRemoteSession session) throws IOException {
        OStorageRemoteNodeSession nodeSession = session.get(this.getServerURL());
        this.writeByte(iCommand);
        this.writeInt(nodeSession.getSessionId());
        if (nodeSession.getToken() != null) {
            if (!session.has(this)) {
                this.writeBytes(nodeSession.getToken());
                session.add(this);
            } else {
                this.writeBytes(new byte[0]);
            }
        }
    }
}

