/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteNodeSession;
import com.orientechnologies.orient.client.remote.OStorageRemoteOperation;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OCredentialInterceptor;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class OServerAdmin {
    protected OStorageRemote storage;
    protected OStorageRemoteSession session = new OStorageRemoteSession(-1);
    protected String clientType = "OrientDB Java";
    protected boolean collectStats = true;

    public OServerAdmin(String iURL) throws IOException {
        if (iURL.startsWith("remote")) {
            iURL = iURL.substring("remote".length() + 1);
        }
        if (!iURL.contains("/")) {
            iURL = iURL + "/";
        }
        this.storage = new OStorageRemote(null, iURL, "", OStorage.STATUS.OPEN, true){

            @Override
            protected OStorageRemoteSession getCurrentSession() {
                return OServerAdmin.this.session;
            }
        };
    }

    public OServerAdmin(OStorageRemote iStorage) {
        this.storage = iStorage;
    }

    public synchronized OServerAdmin connect(final String iUserName, final String iUserPassword) throws IOException {
        this.networkAdminOperation(new OStorageRemoteOperation<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute(OChannelBinaryAsynchClient network) throws IOException {
                OStorageRemoteNodeSession nodeSession = OServerAdmin.this.storage.getCurrentSession().getOrCreate(network.getServerURL());
                try {
                    OServerAdmin.this.storage.beginRequest(network, (byte)2);
                    OServerAdmin.this.storage.sendClientInfo(network, OServerAdmin.this.clientType, false, OServerAdmin.this.collectStats);
                    String username = iUserName;
                    String password = iUserPassword;
                    OCredentialInterceptor ci = OSecurityManager.instance().newCredentialInterceptor();
                    if (ci != null) {
                        ci.intercept(OServerAdmin.this.storage.getURL(), iUserName, iUserPassword);
                        username = ci.getUsername();
                        password = ci.getPassword();
                    }
                    network.writeString(username);
                    network.writeString(password);
                }
                finally {
                    OServerAdmin.this.storage.endRequest(network);
                }
                try {
                    network.beginResponse(nodeSession.getSessionId(), false);
                    int sessionId = network.readInt();
                    byte[] sessionToken = network.readBytes();
                    if (sessionToken.length == 0) {
                        sessionToken = null;
                    }
                    nodeSession.setSession(sessionId, sessionToken);
                }
                finally {
                    OServerAdmin.this.storage.endResponse(network);
                }
                return null;
            }
        }, "Cannot connect to the remote server/database '" + this.storage.getURL() + "'");
        return this;
    }

    public synchronized Map<String, String> listDatabases() throws IOException {
        return this.networkAdminOperation(new OStorageRemoteOperation<Map<String, String>>(){

            @Override
            public Map<String, String> execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OServerAdmin.this.storage.beginRequest(network, (byte)74);
                }
                finally {
                    OServerAdmin.this.storage.endRequest(network);
                }
                ODocument result = new ODocument();
                try {
                    OServerAdmin.this.storage.beginResponse(network);
                    result.fromStream(network.readBytes());
                }
                finally {
                    OServerAdmin.this.storage.endResponse(network);
                }
                return (Map)result.field("databases");
            }
        }, "Cannot retrieve the configuration list");
    }

    public synchronized ODocument getServerInfo() throws IOException {
        return this.networkAdminOperation(new OStorageRemoteOperation<ODocument>(){

            @Override
            public ODocument execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OServerAdmin.this.storage.beginRequest(network, (byte)75);
                }
                finally {
                    OServerAdmin.this.storage.endRequest(network);
                }
                ODocument result = new ODocument();
                try {
                    OServerAdmin.this.storage.beginResponse(network);
                    result.fromJSON(network.readString());
                }
                finally {
                    OServerAdmin.this.storage.endResponse(network);
                }
                return result;
            }
        }, "Cannot retrieve server information");
    }

    public int getSessionId() {
        return this.session.getSessionId();
    }

    @Deprecated
    public synchronized OServerAdmin createDatabase(String iStorageMode) throws IOException {
        return this.createDatabase("document", iStorageMode);
    }

    public synchronized OServerAdmin createDatabase(String iDatabaseType, String iStorageMode) throws IOException {
        return this.createDatabase(this.storage.getName(), iDatabaseType, iStorageMode);
    }

    public synchronized String getStorageName() {
        return this.storage.getName();
    }

    public synchronized OServerAdmin createDatabase(String iDatabaseName, String iDatabaseType, String iStorageMode) throws IOException {
        return this.createDatabase(iDatabaseName, iDatabaseType, iStorageMode, null);
    }

    public synchronized OServerAdmin createDatabase(final String iDatabaseName, final String iDatabaseType, final String iStorageMode, final String backupPath) throws IOException {
        if (iDatabaseName == null || iDatabaseName.length() <= 0) {
            String message = "Cannot create unnamed remote storage. Check your syntax";
            OLogManager.instance().error((Object)this, "Cannot create unnamed remote storage. Check your syntax", new Object[0]);
            throw new OStorageException("Cannot create unnamed remote storage. Check your syntax");
        }
        this.networkAdminOperation(new OStorageRemoteOperation<Void>(){

            @Override
            public Void execute(OChannelBinaryAsynchClient network) throws IOException {
                String storageMode = iStorageMode == null ? "csv" : iStorageMode;
                try {
                    OServerAdmin.this.storage.beginRequest(network, (byte)4);
                    network.writeString(iDatabaseName);
                    if (network.getSrvProtocolVersion() >= 8) {
                        network.writeString(iDatabaseType);
                    }
                    network.writeString(storageMode);
                    if (network.getSrvProtocolVersion() > 35) {
                        network.writeString(backupPath);
                    }
                }
                finally {
                    OServerAdmin.this.storage.endRequest(network);
                }
                OServerAdmin.this.storage.getResponse(network);
                return null;
            }
        }, "Cannot create the remote storage: " + this.storage.getName());
        return this;
    }

    public synchronized boolean existsDatabase() throws IOException {
        return this.existsDatabase(null);
    }

    public synchronized boolean existsDatabase(final String iDatabaseName, final String storageType) throws IOException {
        return this.networkAdminOperation(new OStorageRemoteOperation<Boolean>(){

            @Override
            public Boolean execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OServerAdmin.this.storage.beginRequest(network, (byte)6);
                    network.writeString(iDatabaseName);
                    network.writeString(storageType);
                }
                finally {
                    OServerAdmin.this.storage.endRequest(network);
                }
                try {
                    OServerAdmin.this.storage.beginResponse(network);
                    Boolean bl = network.readByte() == 1;
                    return bl;
                }
                finally {
                    OServerAdmin.this.storage.endResponse(network);
                }
            }
        }, "Error on checking existence of the remote storage: " + this.storage.getName());
    }

    public synchronized boolean existsDatabase(String storageType) throws IOException {
        return this.existsDatabase(this.storage.getName(), storageType);
    }

    @Deprecated
    public OServerAdmin deleteDatabase(String storageType) throws IOException {
        return this.dropDatabase(storageType);
    }

    public synchronized OServerAdmin dropDatabase(final String iDatabaseName, final String storageType) throws IOException {
        boolean retry = true;
        while (retry) {
            retry = this.networkAdminOperation(new OStorageRemoteOperation<Boolean>(){

                @Override
                public Boolean execute(OChannelBinaryAsynchClient network) throws IOException {
                    try {
                        try {
                            OServerAdmin.this.storage.beginRequest(network, (byte)7);
                            network.writeString(iDatabaseName);
                            network.writeString(storageType);
                        }
                        finally {
                            OServerAdmin.this.storage.endRequest(network);
                        }
                        OServerAdmin.this.storage.getResponse(network);
                        return false;
                    }
                    catch (OModificationOperationProhibitedException oope) {
                        return OServerAdmin.this.handleDBFreeze();
                    }
                }
            }, "Cannot delete the remote storage: " + this.storage.getName());
        }
        HashSet<OStorage> underlyingStorages = new HashSet<OStorage>();
        for (OStorage s : Orient.instance().getStorages()) {
            if (!s.getType().equals(this.storage.getType()) || !s.getName().equals(this.storage.getName())) continue;
            underlyingStorages.add(s.getUnderlying());
        }
        for (OStorage s : underlyingStorages) {
            s.close(true, true);
        }
        ODatabaseRecordThreadLocal.INSTANCE.remove();
        return this;
    }

    public synchronized OServerAdmin dropDatabase(String storageType) throws IOException {
        return this.dropDatabase(this.storage.getName(), storageType);
    }

    public synchronized OServerAdmin freezeDatabase(final String storageType) throws IOException {
        this.networkAdminOperation(new OStorageRemoteOperation<Void>(){

            @Override
            public Void execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OServerAdmin.this.storage.beginRequest(network, (byte)94);
                    network.writeString(OServerAdmin.this.storage.getName());
                    network.writeString(storageType);
                }
                finally {
                    OServerAdmin.this.storage.endRequest(network);
                }
                OServerAdmin.this.storage.getResponse(network);
                return null;
            }
        }, "Cannot freeze the remote storage: " + this.storage.getName());
        return this;
    }

    public synchronized OServerAdmin releaseDatabase(final String storageType) throws IOException {
        this.networkAdminOperation(new OStorageRemoteOperation<Void>(){

            @Override
            public Void execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OServerAdmin.this.storage.beginRequest(network, (byte)95);
                    network.writeString(OServerAdmin.this.storage.getName());
                    network.writeString(storageType);
                }
                finally {
                    OServerAdmin.this.storage.endRequest(network);
                }
                OServerAdmin.this.storage.getResponse(network);
                return null;
            }
        }, "Cannot release the remote storage: " + this.storage.getName());
        return this;
    }

    public synchronized OServerAdmin freezeCluster(final int clusterId, final String storageType) throws IOException {
        this.networkAdminOperation(new OStorageRemoteOperation<Void>(){

            @Override
            public Void execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OServerAdmin.this.storage.beginRequest(network, (byte)96);
                    network.writeString(OServerAdmin.this.storage.getName());
                    network.writeShort((short)clusterId);
                    network.writeString(storageType);
                }
                finally {
                    OServerAdmin.this.storage.endRequest(network);
                }
                OServerAdmin.this.storage.getResponse(network);
                return null;
            }
        }, "Cannot freeze the remote cluster " + clusterId + " on storage: " + this.storage.getName());
        return this;
    }

    public synchronized OServerAdmin releaseCluster(final int clusterId, final String storageType) throws IOException {
        this.networkAdminOperation(new OStorageRemoteOperation<Void>(){

            @Override
            public Void execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OServerAdmin.this.storage.beginRequest(network, (byte)97);
                    network.writeString(OServerAdmin.this.storage.getName());
                    network.writeShort((short)clusterId);
                    network.writeString(storageType);
                }
                finally {
                    OServerAdmin.this.storage.endRequest(network);
                }
                OServerAdmin.this.storage.getResponse(network);
                return null;
            }
        }, "Cannot release the remote cluster " + clusterId + " on storage: " + this.storage.getName());
        return this;
    }

    public ODocument clusterStatus() {
        ODocument response = this.sendRequest((byte)92, new ODocument().field("operation", (Object)"status"), "Cluster status");
        OLogManager.instance().debug((Object)this, "Cluster status %s", new Object[]{response.toJSON("prettyPrint")});
        return response;
    }

    public synchronized OServerAdmin copyDatabase(final String databaseName, final String iDatabaseUserName, final String iDatabaseUserPassword, final String iRemoteName, final String iRemoteEngine) throws IOException {
        this.networkAdminOperation(new OStorageRemoteOperation<Void>(){

            @Override
            public Void execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OServerAdmin.this.storage.beginRequest(network, (byte)90);
                    network.writeString(databaseName);
                    network.writeString(iDatabaseUserName);
                    network.writeString(iDatabaseUserPassword);
                    network.writeString(iRemoteName);
                    network.writeString(iRemoteEngine);
                }
                finally {
                    OServerAdmin.this.storage.endRequest(network);
                }
                OServerAdmin.this.storage.getResponse(network);
                OLogManager.instance().debug((Object)this, "Database '%s' has been copied to the server '%s'", new Object[]{databaseName, iRemoteName});
                return null;
            }
        }, "Cannot copy the database: " + databaseName);
        return this;
    }

    public synchronized Map<String, String> getGlobalConfigurations() throws IOException {
        return this.networkAdminOperation(new OStorageRemoteOperation<Map<String, String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, String> execute(OChannelBinaryAsynchClient network) throws IOException {
                HashMap<String, String> config = new HashMap<String, String>();
                OServerAdmin.this.storage.beginRequest(network, (byte)72);
                OServerAdmin.this.storage.endRequest(network);
                try {
                    OServerAdmin.this.storage.beginResponse(network);
                    int num = network.readShort();
                    for (int i = 0; i < num; ++i) {
                        config.put(network.readString(), network.readString());
                    }
                }
                finally {
                    OServerAdmin.this.storage.endResponse(network);
                }
                return config;
            }
        }, "Cannot retrieve the configuration list");
    }

    public synchronized String getGlobalConfiguration(final OGlobalConfiguration config) throws IOException {
        return this.networkAdminOperation(new OStorageRemoteOperation<String>(){

            @Override
            public String execute(OChannelBinaryAsynchClient network) throws IOException {
                OServerAdmin.this.storage.beginRequest(network, (byte)70);
                network.writeString(config.getKey());
                OServerAdmin.this.storage.endRequest(network);
                try {
                    OServerAdmin.this.storage.beginResponse(network);
                    String string = network.readString();
                    return string;
                }
                finally {
                    OServerAdmin.this.storage.endResponse(network);
                }
            }
        }, "Cannot retrieve the configuration value: " + config.getKey());
    }

    public synchronized OServerAdmin setGlobalConfiguration(final OGlobalConfiguration config, final Object iValue) throws IOException {
        this.networkAdminOperation(new OStorageRemoteOperation<Void>(){

            @Override
            public Void execute(OChannelBinaryAsynchClient network) throws IOException {
                OServerAdmin.this.storage.beginRequest(network, (byte)71);
                network.writeString(config.getKey());
                network.writeString(iValue != null ? iValue.toString() : "");
                OServerAdmin.this.storage.endRequest(network);
                OServerAdmin.this.storage.getResponse(network);
                return null;
            }
        }, "Cannot set the configuration value: " + config.getKey());
        return this;
    }

    public synchronized void close() {
        this.storage.close();
    }

    public synchronized void close(boolean iForce) {
        this.storage.close(iForce, false);
    }

    public synchronized String getURL() {
        return this.storage != null ? this.storage.getURL() : null;
    }

    public boolean isConnected() {
        return this.storage != null && !this.storage.isClosed();
    }

    protected ODocument sendRequest(final byte iRequest, final ODocument iPayLoad, String iActivity) {
        return this.storage.networkOperation(new OStorageRemoteOperation<ODocument>(){

            @Override
            public ODocument execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OServerAdmin.this.storage.beginRequest(network, iRequest);
                    network.writeBytes(iPayLoad.toStream());
                }
                finally {
                    OServerAdmin.this.storage.endRequest(network);
                }
                try {
                    OServerAdmin.this.storage.beginResponse(network);
                    ODocument oDocument = new ODocument(network.readBytes());
                    return oDocument;
                }
                finally {
                    OServerAdmin.this.storage.endResponse(network);
                }
            }
        }, "Error on executing  '" + iActivity + "'");
    }

    private boolean handleDBFreeze() {
        OLogManager.instance().warn((Object)this, "DB is frozen will wait for " + OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT.getValue() + " ms. and then retry.", new Object[0]);
        boolean retry = true;
        try {
            Thread.sleep(OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT.getValueAsInteger());
        }
        catch (InterruptedException ie) {
            retry = false;
            Thread.currentThread().interrupt();
        }
        return retry;
    }

    protected <T> T networkAdminOperation(OStorageRemoteOperation<T> operation, String errorMessage) {
        OChannelBinaryAsynchClient network = null;
        try {
            network = this.storage.getNetwork(this.storage.getCurrentServerURL());
            return operation.execute(network);
        }
        catch (Exception e) {
            this.storage.close(true, false);
            throw OException.wrapException((OException)new OStorageException(errorMessage), (Throwable)e);
        }
    }
}

