/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.client.remote.OClusterRemote;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.OEngineRemote;
import com.orientechnologies.orient.client.remote.ORemoteConnectionPool;
import com.orientechnologies.orient.client.remote.OSBTreeCollectionManagerRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteAsynchEventListener;
import com.orientechnologies.orient.client.remote.OStorageRemoteConfiguration;
import com.orientechnologies.orient.client.remote.OStorageRemoteNodeSession;
import com.orientechnologies.orient.client.remote.OStorageRemoteOperation;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.core.OUncompletedCommit;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequestAsynch;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseSessionMetadata;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTxInternal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.OTokenException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OCredentialInterceptor;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.sql.query.OLiveQuery;
import com.orientechnologies.orient.core.sql.query.OLiveResultListener;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryProtocol;
import com.orientechnologies.orient.enterprise.channel.binary.OTokenSecurityException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class OStorageRemote
extends OStorageAbstract
implements OStorageProxy {
    public static final String PARAM_CONNECTION_STRATEGY = "connectionStrategy";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 2424;
    private static final int DEFAULT_SSL_PORT = 2434;
    private static final String ADDRESS_SEPARATOR = ";";
    public static final String DRIVER_NAME = "OrientDB Java";
    private static AtomicInteger sessionSerialId = new AtomicInteger(-1);
    private CONNECTION_STRATEGY connectionStrategy = CONNECTION_STRATEGY.STICKY;
    private final OSBTreeCollectionManagerRemote sbTreeCollectionManager = new OSBTreeCollectionManagerRemote();
    protected final List<String> serverURLs = new ArrayList<String>();
    protected final Map<String, OCluster> clusterMap = new ConcurrentHashMap<String, OCluster>();
    private final ExecutorService asynchExecutor;
    private final ODocument clusterConfiguration = new ODocument();
    private final String clientId;
    private OContextConfiguration clientConfiguration;
    private int connectionRetry;
    private int connectionRetryDelay;
    private OCluster[] clusters = OCommonConst.EMPTY_CLUSTER_ARRAY;
    private int defaultClusterId;
    private OStorageRemoteAsynchEventListener asynchEventListener;
    private Map<String, Object> connectionOptions;
    private OEngineRemote engine;
    private String recordFormat;

    public OStorageRemote(String iClientId, String iURL, String iMode) throws IOException {
        this(iClientId, iURL, iMode, null, true);
    }

    public OStorageRemote(String iClientId, String iURL, String iMode, OStorage.STATUS status, boolean managePushMessages) throws IOException {
        super(iURL, iURL, iMode, 0);
        if (status != null) {
            this.status = status;
        }
        this.clientId = iClientId;
        this.configuration = null;
        this.clientConfiguration = new OContextConfiguration();
        this.connectionRetry = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY);
        this.connectionRetryDelay = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY_DELAY);
        if (managePushMessages) {
            this.asynchEventListener = new OStorageRemoteAsynchEventListener(this);
        }
        this.parseServerURLs();
        this.asynchExecutor = Executors.newSingleThreadScheduledExecutor();
        this.engine = (OEngineRemote)Orient.instance().getRunningEngine("remote");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <T> T networkOperation(OStorageRemoteOperation<T> operation, String errorMessage) {
        int retry = this.connectionRetry;
        OStorageRemoteSession session = this.getCurrentSession();
        while (true) {
            OChannelBinaryAsynchClient network = null;
            String serverUrl = this.getNextAvailableServerURL(false, session);
            do {
                try {
                    network = this.getNetwork(serverUrl);
                }
                catch (OException e) {
                    serverUrl = this.useNewServerURL(serverUrl);
                    if (serverUrl != null) continue;
                    throw e;
                }
            } while (network == null);
            try {
                OStorageRemoteNodeSession nodeSession = session.get(network.getServerURL());
                if (nodeSession == null || !nodeSession.isValid()) {
                    this.openRemoteDatabase(network);
                    if (!network.tryLock()) continue;
                }
                return operation.execute(network);
            }
            catch (OModificationOperationProhibitedException mope) {
                this.handleDBFreeze();
                continue;
            }
            catch (OTokenException e) {
                session.remove(network.getServerURL());
                if (--retry > 0) continue;
                throw OException.wrapException((OException)new OStorageException(errorMessage), (Throwable)e);
            }
            catch (OTokenSecurityException e) {
                session.remove(network.getServerURL());
                if (--retry > 0) continue;
                throw OException.wrapException((OException)new OStorageException(errorMessage), (Throwable)e);
            }
            catch (OOfflineNodeException e) {
                List<String> list = this.serverURLs;
                synchronized (list) {
                    this.serverURLs.remove(serverUrl);
                    continue;
                }
            }
            catch (IOException e) {
                retry = this.handleIOException(retry, network, e);
                continue;
            }
            catch (OIOException e) {
                retry = this.handleIOException(retry, network, (Exception)((Object)e));
                continue;
            }
            catch (OException e) {
                throw e;
            }
            break;
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OStorageException(errorMessage), (Throwable)e);
        }
    }

    private int handleIOException(int retry, OChannelBinaryAsynchClient network, Exception e) {
        OLogManager.instance().warn((Object)this, "Caught I/O errors, trying to reconnect (error: %s)", new Object[]{e.getMessage()});
        OLogManager.instance().debug((Object)this, "I/O error stack: ", (Throwable)e, new Object[0]);
        this.engine.getConnectionManager().remove(network);
        if (--retry <= 0) {
            throw OException.wrapException((OException)((Object)new OIOException(e.getMessage())), (Throwable)e);
        }
        try {
            Thread.sleep(this.connectionRetryDelay);
        }
        catch (InterruptedException e1) {
            throw OException.wrapException((OException)new OInterruptedException(e1.getMessage()), (Throwable)e);
        }
        return retry;
    }

    public boolean isAssigningClusterIds() {
        return false;
    }

    public int getSessionId() {
        OStorageRemoteSession session = this.getCurrentSession();
        return session != null ? session.getSessionId() : -1;
    }

    public String getServerURL() {
        OStorageRemoteSession session = this.getCurrentSession();
        return session != null ? session.getServerUrl() : null;
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.stateLock.acquireWriteLock();
        this.addUser();
        try {
            OStorageRemoteSession session = this.getCurrentSession();
            if (this.status == OStorage.STATUS.CLOSED || !iUserName.equals(session.connectionUserName) || !iUserPassword.equals(session.connectionUserPassword) || session.sessions.isEmpty()) {
                OCredentialInterceptor ci = OSecurityManager.instance().newCredentialInterceptor();
                if (ci != null) {
                    ci.intercept(this.getURL(), iUserName, iUserPassword);
                    session.connectionUserName = ci.getUsername();
                    session.connectionUserPassword = ci.getPassword();
                } else {
                    session.connectionUserName = iUserName;
                    session.connectionUserPassword = iUserPassword;
                }
                this.parseOptions(iOptions);
                this.openRemoteDatabase();
                OStorageRemoteConfiguration storageConfiguration = new OStorageRemoteConfiguration(this, this.recordFormat);
                storageConfiguration.load(iOptions);
                this.configuration = storageConfiguration;
                this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
            } else {
                this.reopenRemoteDatabase();
            }
        }
        catch (Exception e) {
            this.removeUser();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw OException.wrapException((OException)new OStorageException("Cannot open the remote storage: " + this.name), (Throwable)e);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    private void parseOptions(Map<String, Object> iOptions) {
        if (iOptions == null || iOptions.size() == 0) {
            return;
        }
        Object connType = iOptions.get(PARAM_CONNECTION_STRATEGY.toLowerCase());
        if (connType != null) {
            this.connectionStrategy = CONNECTION_STRATEGY.valueOf(connType.toString().toUpperCase());
        }
        this.connectionOptions = new HashMap<String, Object>(iOptions);
    }

    public OSBTreeCollectionManager getSBtreeCollectionManager() {
        return this.sbTreeCollectionManager;
    }

    public void reload() {
        this.networkOperation(new OStorageRemoteOperation<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute(OChannelBinaryAsynchClient network) throws IOException {
                OStorageRemote.this.stateLock.acquireWriteLock();
                try {
                    try {
                        OStorageRemote.this.beginRequest(network, (byte)73);
                    }
                    finally {
                        OStorageRemote.this.endRequest(network);
                    }
                    try {
                        OStorageRemote.this.beginResponse(network);
                        OStorageRemote.this.readDatabaseInformation(network);
                    }
                    finally {
                        OStorageRemote.this.endResponse(network);
                    }
                    Void void_ = null;
                    return void_;
                }
                finally {
                    OStorageRemote.this.stateLock.releaseWriteLock();
                }
            }
        }, "Error on reloading database information");
    }

    public void create(Map<String, Object> iOptions) {
        throw new UnsupportedOperationException("Cannot create a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    public boolean exists() {
        throw new UnsupportedOperationException("Cannot check the existence of a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean iForce, boolean onDelete) {
        if (this.status == OStorage.STATUS.CLOSED) {
            return;
        }
        OChannelBinaryAsynchClient network = null;
        this.stateLock.acquireWriteLock();
        try {
            if (this.status == OStorage.STATUS.CLOSED) {
                return;
            }
            OStorageRemoteSession session = this.getCurrentSession();
            if (session != null) {
                Collection<OStorageRemoteNodeSession> nodes = session.getAll();
                if (!nodes.isEmpty()) {
                    for (OStorageRemoteNodeSession nodeSession : nodes) {
                        try {
                            network = this.getNetwork(nodeSession.getServerURL());
                            network.beginRequest((byte)5, session);
                            this.endRequest(network);
                            this.engine.getConnectionManager().release(network);
                        }
                        catch (OIOException ex) {
                            OLogManager.instance().debug((Object)this, "Impossible to comunicate to the server for close: %s", (Throwable)ex, new Object[0]);
                        }
                        catch (IOException ex) {
                            OLogManager.instance().debug((Object)this, "Impossible to comunicate to the server for close: %s", (Throwable)ex, new Object[0]);
                        }
                    }
                    session.close();
                    if (!this.checkForClose(iForce)) {
                        return;
                    }
                } else if (!iForce) {
                    return;
                }
            }
            this.status = OStorage.STATUS.CLOSING;
            for (String url : this.serverURLs) {
                this.engine.getConnectionManager().closePool(url);
            }
            this.sbTreeCollectionManager.close();
            super.close(iForce, onDelete);
            this.status = OStorage.STATUS.CLOSED;
            Orient.instance().unregisterStorage((OStorage)this);
        }
        catch (Exception e) {
            if (network != null) {
                OLogManager.instance().debug((Object)this, "Error on closing remote connection: %s", (Throwable)e, new Object[]{network});
                try {
                    network.close();
                }
                catch (Exception e2) {
                    OLogManager.instance().debug((Object)this, "Error on closing socket: %s", (Throwable)e2, new Object[]{network});
                }
            }
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    private boolean checkForClose(boolean force) {
        if (this.status == OStorage.STATUS.CLOSED) {
            return false;
        }
        if (this.status == OStorage.STATUS.CLOSED) {
            return false;
        }
        int remainingUsers = this.getUsers() > 0 ? this.removeUser() : 0;
        return force || remainingUsers == 0;
    }

    public int getUsers() {
        return this.dataLock.getUsers();
    }

    public int addUser() {
        return this.dataLock.addUser();
    }

    public int removeUser() {
        return this.dataLock.removeUser();
    }

    public void delete() {
        throw new UnsupportedOperationException("Cannot delete a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    public Set<String> getClusterNames() {
        this.stateLock.acquireReadLock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.clusterMap.keySet());
            return hashSet;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public OStorageOperationResult<OPhysicalPosition> createRecord(final ORecordId iRid, final byte[] iContent, int iRecordVersion, final byte iRecordType, final int iMode, final ORecordCallback<Long> iCallback) {
        return this.networkOperation(new OStorageRemoteOperation<OStorageOperationResult<OPhysicalPosition>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OStorageOperationResult<OPhysicalPosition> execute(final OChannelBinaryAsynchClient network) throws IOException {
                int mode = iMode == 1 && iCallback == null ? 2 : iMode;
                OPhysicalPosition ppos = new OPhysicalPosition(iRecordType);
                try {
                    OStorageRemote.this.beginRequest(network, (byte)31);
                    network.writeShort((short)iRid.clusterId);
                    network.writeBytes(iContent);
                    network.writeByte(iRecordType);
                    network.writeByte((byte)mode);
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                switch (mode) {
                    case 0: {
                        try {
                            OStorageRemote.this.beginResponse(network);
                            if (network.getSrvProtocolVersion() > 25) {
                                iRid.clusterId = network.readShort();
                            }
                            ppos.clusterPosition = iRid.clusterPosition = network.readLong();
                            ppos.recordVersion = network.getSrvProtocolVersion() >= 11 ? network.readVersion() : 0;
                            if (network.getSrvProtocolVersion() >= 20) {
                                OStorageRemote.this.readCollectionChanges(network, ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager());
                            }
                            OStorageOperationResult oStorageOperationResult = new OStorageOperationResult((Object)ppos);
                            return oStorageOperationResult;
                        }
                        finally {
                            OStorageRemote.this.endResponse(network);
                        }
                    }
                    case 1: {
                        if (iCallback == null) break;
                        final OStorageRemoteSession session = OStorageRemote.this.getCurrentSession();
                        final OSBTreeCollectionManager collectionManager = ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager();
                        Callable<Object> response = new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                long result;
                                try {
                                    OStorageRemote.this.beginResponse(network, session);
                                    if (network.getSrvProtocolVersion() > 25) {
                                        iRid.clusterId = network.readShort();
                                    }
                                    result = network.readLong();
                                    if (network.getSrvProtocolVersion() >= 11) {
                                        network.readVersion();
                                    }
                                    if (network.getSrvProtocolVersion() >= 20) {
                                        OStorageRemote.this.readCollectionChanges(network, collectionManager);
                                    }
                                }
                                catch (Exception e) {
                                    OLogManager.instance().error((Object)this, "Exception on async query", (Throwable)e, new Object[0]);
                                    throw e;
                                }
                                finally {
                                    OStorageRemote.this.endResponse(network);
                                }
                                iCallback.call(iRid, (Object)result);
                                return null;
                            }
                        };
                        OStorageRemote.this.asynchExecutor.submit(new FutureTask<Object>(response));
                        break;
                    }
                    case 2: {
                        OStorageRemote.this.engine.getConnectionManager().release(network);
                    }
                }
                return new OStorageOperationResult((Object)ppos);
            }
        }, "Error on create record in cluster " + iRid.clusterId);
    }

    public ORecordMetadata getRecordMetadata(final ORID rid) {
        return this.networkOperation(new OStorageRemoteOperation<ORecordMetadata>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ORecordMetadata execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OStorageRemote.this.beginRequest(network, (byte)29);
                    network.writeRID(rid);
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                try {
                    OStorageRemote.this.beginResponse(network);
                    ORecordId responseRid = network.readRID();
                    int responseVersion = network.readVersion();
                    ORecordMetadata oRecordMetadata = new ORecordMetadata((ORID)responseRid, responseVersion);
                    return oRecordMetadata;
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                }
            }
        }, "Error on record metadata read " + rid);
    }

    public OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(final ORecordId rid, final String fetchPlan, final boolean ignoreCache, final int recordVersion) throws ORecordNotFoundException {
        if (this.getCurrentSession().commandExecuting) {
            return new OStorageOperationResult(null);
        }
        return this.networkOperation(new OStorageRemoteOperation<OStorageOperationResult<ORawBuffer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OStorageOperationResult<ORawBuffer> execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OStorageRemote.this.beginRequest(network, (byte)44);
                    network.writeRID((ORID)rid);
                    network.writeVersion(recordVersion);
                    network.writeString(fetchPlan != null ? fetchPlan : "");
                    network.writeByte((byte)(ignoreCache ? 1 : 0));
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                try {
                    OStorageRemote.this.beginResponse(network);
                    if (network.readByte() == 0) {
                        OStorageOperationResult oStorageOperationResult = new OStorageOperationResult(null);
                        return oStorageOperationResult;
                    }
                    byte type = network.readByte();
                    int recVersion = network.readVersion();
                    byte[] bytes = network.readBytes();
                    ORawBuffer buffer = new ORawBuffer(bytes, recVersion, type);
                    ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
                    while (network.readByte() == 2) {
                        ORecord record = (ORecord)OChannelBinaryProtocol.readIdentifiable((OChannelBinary)network);
                        if (database == null) continue;
                        database.getLocalCache().updateRecord(record);
                    }
                    OStorageOperationResult oStorageOperationResult = new OStorageOperationResult((Object)buffer);
                    return oStorageOperationResult;
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                }
            }
        }, "Error on read record " + rid);
    }

    public OStorageOperationResult<ORawBuffer> readRecord(final ORecordId iRid, final String iFetchPlan, final boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback) {
        if (this.getCurrentSession().commandExecuting) {
            return new OStorageOperationResult(null);
        }
        return this.networkOperation(new OStorageRemoteOperation<OStorageOperationResult<ORawBuffer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OStorageOperationResult<ORawBuffer> execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OStorageRemote.this.beginRequest(network, (byte)30);
                    network.writeRID((ORID)iRid);
                    network.writeString(iFetchPlan != null ? iFetchPlan : "");
                    if (network.getSrvProtocolVersion() >= 9) {
                        network.writeByte((byte)(iIgnoreCache ? 1 : 0));
                    }
                    if (network.getSrvProtocolVersion() >= 13) {
                        network.writeByte((byte)0);
                    }
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                try {
                    ORawBuffer buffer;
                    OStorageRemote.this.beginResponse(network);
                    if (network.readByte() == 0) {
                        OStorageOperationResult oStorageOperationResult = new OStorageOperationResult(null);
                        return oStorageOperationResult;
                    }
                    if (network.getSrvProtocolVersion() <= 27) {
                        buffer = new ORawBuffer(network.readBytes(), network.readVersion(), network.readByte());
                    } else {
                        byte type = network.readByte();
                        int recVersion = network.readVersion();
                        byte[] bytes = network.readBytes();
                        buffer = new ORawBuffer(bytes, recVersion, type);
                    }
                    ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
                    while (network.readByte() == 2) {
                        ORecord record = (ORecord)OChannelBinaryProtocol.readIdentifiable((OChannelBinary)network);
                        if (database == null) continue;
                        database.getLocalCache().updateRecord(record);
                    }
                    OStorageOperationResult oStorageOperationResult = new OStorageOperationResult((Object)buffer);
                    return oStorageOperationResult;
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                }
            }
        }, "Error on read record " + iRid);
    }

    public String incrementalBackup(final String backupDirectory) {
        return this.networkOperation(new OStorageRemoteOperation<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    network = OStorageRemote.this.beginRequest(network, (byte)27);
                    network.writeString(backupDirectory);
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                try {
                    String fileName;
                    OStorageRemote.this.beginResponse(network);
                    String string = fileName = network.readString();
                    return string;
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                }
            }
        }, "Error on incremental backup");
    }

    public void restoreFromIncrementalBackup(String filePath) {
        throw new UnsupportedOperationException("This operations is part of internal API and is not supported in remote storage");
    }

    public OStorageOperationResult<Integer> updateRecord(final ORecordId iRid, final boolean updateContent, final byte[] iContent, final int iVersion, final byte iRecordType, final int iMode, final ORecordCallback<Integer> iCallback) {
        return this.networkOperation(new OStorageRemoteOperation<OStorageOperationResult<Integer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OStorageOperationResult<Integer> execute(final OChannelBinaryAsynchClient network) throws IOException {
                int mode = iMode == 1 && iCallback == null ? 2 : iMode;
                try {
                    OStorageRemote.this.beginRequest(network, (byte)32);
                    network.writeRID((ORID)iRid);
                    if (network.getSrvProtocolVersion() >= 23) {
                        network.writeBoolean(updateContent);
                    }
                    network.writeBytes(iContent);
                    network.writeVersion(iVersion);
                    network.writeByte(iRecordType);
                    network.writeByte((byte)mode);
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                switch (mode) {
                    case 0: {
                        try {
                            OStorageRemote.this.beginResponse(network);
                            OStorageOperationResult r = new OStorageOperationResult((Object)network.readVersion());
                            OStorageRemote.this.readCollectionChanges(network, ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager());
                            OStorageOperationResult oStorageOperationResult = r;
                            return oStorageOperationResult;
                        }
                        finally {
                            OStorageRemote.this.endResponse(network);
                        }
                    }
                    case 1: {
                        final OStorageRemoteSession session = OStorageRemote.this.getCurrentSession();
                        final OSBTreeCollectionManager collectionManager = ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager();
                        Callable<Object> response = new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                int result;
                                try {
                                    OStorageRemote.this.beginResponse(network, session);
                                    result = network.readVersion();
                                    if (network.getSrvProtocolVersion() >= 20) {
                                        OStorageRemote.this.readCollectionChanges(network, collectionManager);
                                    }
                                }
                                finally {
                                    OStorageRemote.this.endResponse(network);
                                }
                                iCallback.call(iRid, (Object)result);
                                return null;
                            }
                        };
                        OStorageRemote.this.asynchExecutor.submit(new FutureTask<Object>(response));
                    }
                }
                return new OStorageOperationResult((Object)iVersion);
            }
        }, "Error on update record " + iRid);
    }

    public OStorageOperationResult<Integer> recyclePosition(ORecordId iRecordId, byte[] iContent, int iVersion, byte recordType) {
        throw new UnsupportedOperationException("recyclePosition");
    }

    public OStorageOperationResult<Boolean> deleteRecord(final ORecordId iRid, final int iVersion, final int iMode, final ORecordCallback<Boolean> iCallback) {
        return this.networkOperation(new OStorageRemoteOperation<OStorageOperationResult<Boolean>>(){

            @Override
            public OStorageOperationResult<Boolean> execute(OChannelBinaryAsynchClient network) throws IOException {
                int mode = iMode == 1 && iCallback == null ? 2 : iMode;
                return new OStorageOperationResult((Object)OStorageRemote.this.deleteRecord((byte)33, iRid, iVersion, mode, (ORecordCallback<Boolean>)iCallback, network));
            }
        }, "Error on delete record " + iRid);
    }

    public OStorageOperationResult<Boolean> hideRecord(final ORecordId recordId, final int mode, final ORecordCallback<Boolean> callback) {
        return this.networkOperation(new OStorageRemoteOperation<OStorageOperationResult<Boolean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OStorageOperationResult<Boolean> execute(final OChannelBinaryAsynchClient network) throws IOException {
                int pMode = mode == 1 && callback == null ? 2 : mode;
                try {
                    OStorageRemote.this.beginRequest(network, (byte)43);
                    network.writeRID((ORID)recordId);
                    network.writeByte((byte)pMode);
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                switch (pMode) {
                    case 0: {
                        try {
                            OStorageRemote.this.beginResponse(network);
                            OStorageOperationResult oStorageOperationResult = new OStorageOperationResult((Object)(network.readByte() == 1 ? 1 : 0));
                            return oStorageOperationResult;
                        }
                        finally {
                            OStorageRemote.this.endResponse(network);
                        }
                    }
                    case 1: {
                        if (callback == null) break;
                        final OStorageRemoteSession session = OStorageRemote.this.getCurrentSession();
                        Callable<Object> response = new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                Boolean result;
                                try {
                                    OStorageRemote.this.beginResponse(network, session);
                                    result = network.readByte() == 1;
                                }
                                finally {
                                    OStorageRemote.this.endResponse(network);
                                }
                                callback.call(recordId, (Object)result);
                                return null;
                            }
                        };
                        OStorageRemote.this.asynchExecutor.submit(new FutureTask<Object>(response));
                    }
                }
                return new OStorageOperationResult((Object)false);
            }
        }, "Error on hide record " + recordId);
    }

    public boolean cleanOutRecord(final ORecordId recordId, final int recordVersion, final int iMode, final ORecordCallback<Boolean> callback) {
        return this.networkOperation(new OStorageRemoteOperation<Boolean>(){

            @Override
            public Boolean execute(OChannelBinaryAsynchClient network) throws IOException {
                int mode = iMode == 1 && callback == null ? 2 : iMode;
                return OStorageRemote.this.deleteRecord((byte)38, recordId, recordVersion, mode, (ORecordCallback<Boolean>)callback, network);
            }
        }, "Error on clean out record " + recordId);
    }

    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        throw new UnsupportedOperationException("backup is not supported against remote storage. Open the database with plocal or use Enterprise Edition");
    }

    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        throw new UnsupportedOperationException("restore is not supported against remote storage. Open the database with plocal or use Enterprise Edition");
    }

    public OContextConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public long count(int iClusterId) {
        return this.count(new int[]{iClusterId});
    }

    public long count(int iClusterId, boolean countTombstones) {
        return this.count(new int[]{iClusterId}, countTombstones);
    }

    public long[] getClusterDataRange(final int iClusterId) {
        return this.networkOperation(new OStorageRemoteOperation<long[]>(){

            @Override
            public long[] execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OStorageRemote.this.beginRequest(network, (byte)13);
                    network.writeShort((short)iClusterId);
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                try {
                    OStorageRemote.this.beginResponse(network);
                    long[] lArray = new long[]{network.readLong(), network.readLong()};
                    return lArray;
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                }
            }
        }, "Error on getting last entry position count in cluster: " + iClusterId);
    }

    public OPhysicalPosition[] higherPhysicalPositions(final int iClusterId, final OPhysicalPosition iClusterPosition) {
        return this.networkOperation(new OStorageRemoteOperation<OPhysicalPosition[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OPhysicalPosition[] execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OStorageRemote.this.beginRequest(network, (byte)36);
                    network.writeInt(iClusterId);
                    network.writeLong(iClusterPosition.clusterPosition);
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                try {
                    OStorageRemote.this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = OStorageRemote.this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                }
            }
        }, "Error on retrieving higher positions after " + iClusterPosition.clusterPosition);
    }

    public OPhysicalPosition[] ceilingPhysicalPositions(final int clusterId, final OPhysicalPosition physicalPosition) {
        return this.networkOperation(new OStorageRemoteOperation<OPhysicalPosition[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OPhysicalPosition[] execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OStorageRemote.this.beginRequest(network, (byte)42);
                    network.writeInt(clusterId);
                    network.writeLong(physicalPosition.clusterPosition);
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                try {
                    OStorageRemote.this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = OStorageRemote.this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                }
            }
        }, "Error on retrieving ceiling positions after " + physicalPosition.clusterPosition);
    }

    public OPhysicalPosition[] lowerPhysicalPositions(final int iClusterId, final OPhysicalPosition physicalPosition) {
        return this.networkOperation(new OStorageRemoteOperation<OPhysicalPosition[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OPhysicalPosition[] execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OStorageRemote.this.beginRequest(network, (byte)37);
                    network.writeInt(iClusterId);
                    network.writeLong(physicalPosition.clusterPosition);
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                try {
                    OStorageRemote.this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = OStorageRemote.this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                }
            }
        }, "Error on retrieving lower positions after " + physicalPosition.clusterPosition);
    }

    public OPhysicalPosition[] floorPhysicalPositions(final int clusterId, final OPhysicalPosition physicalPosition) {
        return this.networkOperation(new OStorageRemoteOperation<OPhysicalPosition[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OPhysicalPosition[] execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OStorageRemote.this.beginRequest(network, (byte)39);
                    network.writeInt(clusterId);
                    network.writeLong(physicalPosition.clusterPosition);
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                try {
                    OStorageRemote.this.beginResponse(network);
                    int positionsCount = network.readInt();
                    if (positionsCount == 0) {
                        OPhysicalPosition[] oPhysicalPositionArray = OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
                        return oPhysicalPositionArray;
                    }
                    OPhysicalPosition[] oPhysicalPositionArray = OStorageRemote.this.readPhysicalPositions(network, positionsCount);
                    return oPhysicalPositionArray;
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                }
            }
        }, "Error on retrieving floor positions after " + physicalPosition.clusterPosition);
    }

    public long getSize() {
        return this.networkOperation(new OStorageRemoteOperation<Long>(){

            @Override
            public Long execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OStorageRemote.this.beginRequest(network, (byte)8);
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                try {
                    OStorageRemote.this.beginResponse(network);
                    Long l = network.readLong();
                    return l;
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                }
            }
        }, "Error on read database size");
    }

    public long countRecords() {
        return this.networkOperation(new OStorageRemoteOperation<Long>(){

            @Override
            public Long execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OStorageRemote.this.beginRequest(network, (byte)9);
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                try {
                    OStorageRemote.this.beginResponse(network);
                    Long l = network.readLong();
                    return l;
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                }
            }
        }, "Error on read database record count");
    }

    public long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    public long count(final int[] iClusterIds, final boolean countTombstones) {
        return this.networkOperation(new OStorageRemoteOperation<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long execute(OChannelBinaryAsynchClient network) throws IOException {
                try {
                    OStorageRemote.this.beginRequest(network, (byte)12);
                    network.writeShort((short)iClusterIds.length);
                    for (int iClusterId : iClusterIds) {
                        network.writeShort((short)iClusterId);
                    }
                    if (network.getSrvProtocolVersion() >= 13) {
                        network.writeByte(countTombstones ? (byte)1 : 0);
                    }
                }
                finally {
                    OStorageRemote.this.endRequest(network);
                }
                try {
                    OStorageRemote.this.beginResponse(network);
                    Long l = network.readLong();
                    return l;
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                }
            }
        }, "Error on read record count in clusters: " + Arrays.toString(iClusterIds));
    }

    public Object command(final OCommandRequestText iCommand) {
        if (!(iCommand instanceof OSerializableStream)) {
            throw new OCommandExecutionException("Cannot serialize the command to be executed to the server side.");
        }
        final boolean live = iCommand instanceof OLiveQuery;
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.get();
        return this.networkOperation(new OStorageRemoteOperation<Object>((ODatabaseDocument)database){
            final /* synthetic */ ODatabaseDocument val$database;
            {
                this.val$database = oDatabaseDocument;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute(OChannelBinaryAsynchClient network) throws IOException {
                Object result = null;
                OStorageRemote.this.getCurrentSession().commandExecuting = true;
                try {
                    boolean asynch = iCommand instanceof OCommandRequestAsynch && ((OCommandRequestAsynch)iCommand).isAsynchronous();
                    try {
                        OStorageRemote.this.beginRequest(network, (byte)41);
                        if (live) {
                            network.writeByte((byte)108);
                        } else {
                            network.writeByte((byte)(asynch ? 97 : 115));
                        }
                        network.writeBytes(OStreamSerializerAnyStreamable.INSTANCE.toStream((Object)iCommand));
                    }
                    finally {
                        OStorageRemote.this.endRequest(network);
                    }
                    try {
                        OStorageRemote.this.beginResponse(network);
                        boolean addNextRecord = true;
                        if (asynch) {
                            byte status;
                            while ((status = network.readByte()) > 0) {
                                ORecord record = (ORecord)OChannelBinaryProtocol.readIdentifiable((OChannelBinary)network);
                                if (record == null) continue;
                                switch (status) {
                                    case 1: {
                                        if (!addNextRecord) break;
                                        addNextRecord = iCommand.getResultListener().result((Object)record);
                                        this.val$database.getLocalCache().updateRecord(record);
                                        break;
                                    }
                                    case 2: {
                                        this.val$database.getLocalCache().updateRecord(record);
                                    }
                                }
                            }
                        } else {
                            result = OStorageRemote.this.readSynchResult(network, this.val$database);
                            if (live) {
                                ODocument doc = (ODocument)((List)result).get(0);
                                Integer token = (Integer)doc.field("token");
                                Boolean unsubscribe = (Boolean)doc.field("unsubscribe");
                                if (token != null) {
                                    if (Boolean.TRUE.equals(unsubscribe)) {
                                        if (OStorageRemote.this.asynchEventListener != null) {
                                            OStorageRemote.this.asynchEventListener.unregisterLiveListener(token);
                                        }
                                    } else {
                                        OLiveResultListener listener = (OLiveResultListener)iCommand.getResultListener();
                                        ORemoteConnectionPool pool = OStorageRemote.this.engine.getConnectionManager().getPool(network.getServerURL());
                                        OStorageRemote.this.asynchEventListener.registerLiveListener(pool, token, listener);
                                    }
                                } else {
                                    throw new OStorageException("Cannot execute live query, returned null token");
                                }
                            }
                        }
                        Object object = result;
                        OStorageRemote.this.endResponse(network);
                        return object;
                    }
                    catch (Throwable throwable) {
                        OStorageRemote.this.endResponse(network);
                        throw throwable;
                    }
                }
                finally {
                    OStorageRemote.this.getCurrentSession().commandExecuting = false;
                    if (iCommand.getResultListener() != null && !live) {
                        iCommand.getResultListener().end();
                    }
                }
            }
        }, "Error on executing command: " + iCommand);
    }

    protected Object readSynchResult(OChannelBinaryAsynchClient network, ODatabaseDocument database) throws IOException {
        Object result;
        byte type = network.readByte();
        switch (type) {
            case 110: {
                result = null;
                break;
            }
            case 114: {
                result = OChannelBinaryProtocol.readIdentifiable((OChannelBinary)network);
                if (!(result instanceof ORecord)) break;
                database.getLocalCache().updateRecord((ORecord)result);
                break;
            }
            case 108: 
            case 115: {
                int tot = network.readInt();
                AbstractCollection coll = type == 115 ? new HashSet(tot) : new ArrayList(tot);
                for (int i = 0; i < tot; ++i) {
                    OIdentifiable resultItem = OChannelBinaryProtocol.readIdentifiable((OChannelBinary)network);
                    if (resultItem instanceof ORecord) {
                        database.getLocalCache().updateRecord((ORecord)resultItem);
                    }
                    coll.add(resultItem);
                }
                result = coll;
                break;
            }
            case 105: {
                OIdentifiable record;
                byte status;
                AbstractCollection coll = new ArrayList();
                while ((status = network.readByte()) > 0) {
                    record = OChannelBinaryProtocol.readIdentifiable((OChannelBinary)network);
                    if (record == null || status != 1) continue;
                    if (record instanceof ORecord) {
                        database.getLocalCache().updateRecord((ORecord)record);
                    }
                    coll.add(record);
                }
                result = coll;
                break;
            }
            case 119: {
                OIdentifiable record = OChannelBinaryProtocol.readIdentifiable((OChannelBinary)network);
                result = ((ODocument)record).field("result");
                break;
            }
            default: {
                OLogManager.instance().warn((Object)this, "Received unexpected result from query: %d", new Object[]{type});
                result = null;
            }
        }
        if (network.getSrvProtocolVersion() >= 17) {
            byte status;
            while ((status = network.readByte()) > 0) {
                ORecord record = (ORecord)OChannelBinaryProtocol.readIdentifiable((OChannelBinary)network);
                if (record == null || status != 2) continue;
                database.getLocalCache().updateRecord(record);
            }
        }
        return result;
    }

    public List<ORecordOperation> commit(final OTransaction iTx, Runnable callback) {
        this.networkOperation(new OStorageRemoteOperation<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute(OChannelBinaryAsynchClient network) throws IOException {
                ArrayList committedEntries = new ArrayList();
                try {
                    OStorageRemote.this.getCurrentSession().commandExecuting = true;
                    try {
                        OStorageRemote.this.beginRequest(network, (byte)60);
                        network.writeInt(iTx.getId());
                        network.writeByte((byte)(iTx.isUsingLog() ? 1 : 0));
                        for (ORecordOperation txEntry : iTx.getAllRecordEntries()) {
                            OStorageRemote.this.commitEntry(network, txEntry);
                        }
                        network.writeByte((byte)0);
                        network.writeBytes(iTx.getIndexChanges().toStream());
                    }
                    finally {
                        OStorageRemote.this.endRequest(network);
                    }
                    try {
                        OStorageRemote.this.beginResponse(network);
                        int createdRecords = network.readInt();
                        for (int i = 0; i < createdRecords; ++i) {
                            ORecordId currentRid = network.readRID();
                            ORecordId createdRid = network.readRID();
                            iTx.updateIdentityAfterCommit((ORID)currentRid, (ORID)createdRid);
                        }
                        int updatedRecords = network.readInt();
                        for (int i = 0; i < updatedRecords; ++i) {
                            ORecordId rid = network.readRID();
                            ORecordOperation rop = iTx.getRecordEntry((ORID)rid);
                            if (rop == null) continue;
                            ORecordInternal.setVersion((ORecord)rop.getRecord(), (int)network.readVersion());
                        }
                        if (network.getSrvProtocolVersion() >= 20) {
                            OStorageRemote.this.readCollectionChanges(network, ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager());
                        }
                    }
                    finally {
                        OStorageRemote.this.endResponse(network);
                    }
                    committedEntries.clear();
                    for (ORecordOperation txEntry : iTx.getAllRecordEntries()) {
                        ORecordInternal.unsetDirty((ORecord)txEntry.getRecord());
                    }
                    OTransactionAbstract.updateCacheFromEntries((OTransaction)iTx, (Iterable)iTx.getAllRecordEntries(), (boolean)false);
                    Iterator iterator = null;
                    return iterator;
                }
                finally {
                    OStorageRemote.this.getCurrentSession().commandExecuting = false;
                }
            }
        }, "Error on commit");
        return null;
    }

    public OUncompletedCommit<List<ORecordOperation>> initiateCommit(OTransaction iTx, Runnable callback) {
        throw new UnsupportedOperationException("Uncompleted commits are not supported by the remote storage.");
    }

    public void rollback(OTransaction iTx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusterIdByName(String iClusterName) {
        this.stateLock.acquireReadLock();
        try {
            if (iClusterName == null) {
                int n = -1;
                return n;
            }
            if (Character.isDigit(iClusterName.charAt(0))) {
                int n = Integer.parseInt(iClusterName);
                return n;
            }
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
            if (cluster == null) {
                int n = -1;
                return n;
            }
            int n = cluster.getId();
            return n;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    public int addCluster(String iClusterName, boolean forceListBased, Object ... iArguments) {
        return this.addCluster(iClusterName, -1, forceListBased, iArguments);
    }

    public int addCluster(final String iClusterName, final int iRequestedId, boolean forceListBased, Object ... iParameters) {
        return this.networkOperation(new OStorageRemoteOperation<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer execute(OChannelBinaryAsynchClient network) throws IOException {
                OStorageRemote.this.stateLock.acquireWriteLock();
                try {
                    try {
                        OStorageRemote.this.beginRequest(network, (byte)10);
                        network.writeString(iClusterName);
                        if (network.getSrvProtocolVersion() >= 18) {
                            network.writeShort((short)iRequestedId);
                        }
                    }
                    finally {
                        OStorageRemote.this.endRequest(network);
                    }
                    try {
                        OStorageRemote.this.beginResponse(network);
                        short clusterId = network.readShort();
                        OClusterRemote cluster = new OClusterRemote();
                        cluster.configure((OStorage)OStorageRemote.this, clusterId, iClusterName.toLowerCase(), new Object[0]);
                        if (OStorageRemote.this.clusters.length <= clusterId) {
                            OStorageRemote.access$1202(OStorageRemote.this, Arrays.copyOf(OStorageRemote.this.clusters, clusterId + 1));
                        }
                        ((OStorageRemote)OStorageRemote.this).clusters[cluster.getId()] = cluster;
                        OStorageRemote.this.clusterMap.put(cluster.getName().toLowerCase(), cluster);
                        Integer n = clusterId;
                        OStorageRemote.this.endResponse(network);
                        return n;
                    }
                    catch (Throwable throwable) {
                        OStorageRemote.this.endResponse(network);
                        throw throwable;
                    }
                }
                finally {
                    OStorageRemote.this.stateLock.releaseWriteLock();
                }
            }
        }, "Error on add new cluster");
    }

    public boolean dropCluster(final int iClusterId, boolean iTruncate) {
        return this.networkOperation(new OStorageRemoteOperation<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean execute(OChannelBinaryAsynchClient network) throws IOException {
                OStorageRemote.this.stateLock.acquireWriteLock();
                try {
                    try {
                        OStorageRemote.this.beginRequest(network, (byte)11);
                        network.writeShort((short)iClusterId);
                    }
                    finally {
                        OStorageRemote.this.endRequest(network);
                    }
                    byte result = 0;
                    try {
                        OStorageRemote.this.beginResponse(network);
                        result = network.readByte();
                    }
                    finally {
                        OStorageRemote.this.endResponse(network);
                    }
                    if (result == 1) {
                        OCluster cluster = OStorageRemote.this.clusters[iClusterId];
                        ((OStorageRemote)OStorageRemote.this).clusters[iClusterId] = null;
                        OStorageRemote.this.clusterMap.remove(cluster.getName());
                        if (((OStorageRemote)OStorageRemote.this).configuration.clusters.size() > iClusterId) {
                            OStorageRemote.this.configuration.dropCluster(iClusterId);
                        }
                        Boolean bl = true;
                        return bl;
                    }
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    OStorageRemote.this.stateLock.releaseWriteLock();
                }
            }
        }, "Error on removing of cluster");
    }

    public void synch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPhysicalClusterNameById(int iClusterId) {
        this.stateLock.acquireReadLock();
        try {
            if (iClusterId >= this.clusters.length) {
                String string = null;
                return string;
            }
            OCluster cluster = this.clusters[iClusterId];
            String string = cluster != null ? cluster.getName() : null;
            return string;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public int getClusterMap() {
        this.stateLock.acquireReadLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public Collection<OCluster> getClusterInstances() {
        this.stateLock.acquireReadLock();
        try {
            List<OCluster> list = Arrays.asList(this.clusters);
            return list;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public OCluster getClusterById(int iClusterId) {
        this.stateLock.acquireReadLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            OCluster oCluster = this.clusters[iClusterId];
            return oCluster;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public long getVersion() {
        throw new UnsupportedOperationException("getVersion");
    }

    public ODocument getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    public void endRequest(OChannelBinaryAsynchClient iNetwork) throws IOException {
        if (iNetwork == null) {
            return;
        }
        try {
            iNetwork.flush();
            iNetwork.releaseWriteLock();
        }
        catch (IOException e) {
            this.engine.getConnectionManager().remove(iNetwork);
            throw e;
        }
    }

    public void endResponse(OChannelBinaryAsynchClient iNetwork) {
        try {
            iNetwork.endResponse();
            this.engine.getConnectionManager().release(iNetwork);
        }
        catch (IOException e) {
            this.engine.getConnectionManager().remove(iNetwork);
            OLogManager.instance().warn((Object)this, "dirty data left in the socket closing", (Throwable)e, new Object[0]);
        }
    }

    public boolean isRemote() {
        return true;
    }

    public boolean isPermanentRequester() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterConfiguration(String iConnectedURL, byte[] obj) {
        List members;
        if (obj == null) {
            return;
        }
        OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.setValue((Object)Integer.MAX_VALUE);
        Object object = this.clusterConfiguration;
        synchronized (object) {
            this.clusterConfiguration.fromStream(obj);
            this.clusterConfiguration.toString();
            members = (List)this.clusterConfiguration.field("members");
        }
        object = this.serverURLs;
        synchronized (object) {
            if (members != null) {
                if (iConnectedURL != null) {
                    this.addHost(iConnectedURL);
                }
                for (ODocument m : members) {
                    Collection listeners;
                    if (m == null) continue;
                    String nodeStatus = (String)m.field("status");
                    if (m == null || "OFFLINE".equals(nodeStatus) || (listeners = (Collection)m.field("listeners")) == null) continue;
                    for (Map listener : listeners) {
                        String url;
                        if (!((String)listener.get("protocol")).equals("ONetworkProtocolBinary") || this.serverURLs.contains(url = (String)listener.get("listen"))) continue;
                        this.addHost(url);
                    }
                }
            }
        }
    }

    public OCluster getClusterByName(String iClusterName) {
        throw new UnsupportedOperationException("getClusterByName()");
    }

    public ORecordConflictStrategy getConflictStrategy() {
        throw new UnsupportedOperationException("getConflictStrategy");
    }

    public void setConflictStrategy(ORecordConflictStrategy iResolver) {
        throw new UnsupportedOperationException("setConflictStrategy");
    }

    public String getURL() {
        return "remote:" + this.url;
    }

    public int getClusters() {
        this.stateLock.acquireReadLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public String getType() {
        return "remote";
    }

    public OEngineRemote getEngine() {
        return this.engine;
    }

    public String getUserName() {
        OStorageRemoteSession session = this.getCurrentSession();
        if (session == null) {
            return null;
        }
        return session.connectionUserName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String reopenRemoteDatabase() throws IOException {
        String currentURL = this.getCurrentServerURL();
        do {
            OChannelBinaryAsynchClient network = this.getNetwork(currentURL);
            OStorageRemoteSession session = this.getCurrentSession();
            OStorageRemoteNodeSession nodeSession = session.getOrCreate(network.getServerURL());
            if (nodeSession == null || !nodeSession.isValid()) {
                this.openRemoteDatabase(network);
                return network.getServerURL();
            }
            try {
                network.writeByte((byte)17);
                network.writeInt(nodeSession.getSessionId());
                network.writeBytes(nodeSession.getToken());
            }
            finally {
                this.endRequest(network);
            }
            try {
                byte[] newToken = network.beginResponse(nodeSession.getSessionId(), true);
                int sessionId = network.readInt();
                if (newToken != null && newToken.length > 0) {
                    nodeSession.setSession(sessionId, newToken);
                } else {
                    nodeSession.setSession(sessionId, nodeSession.getToken());
                }
                OLogManager.instance().debug((Object)this, "Client connected to %s with session id=%d", new Object[]{network.getServerURL(), sessionId});
                String string = currentURL;
                this.endResponse(network);
                return string;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OIOException e) {
                    if (network != null) {
                        this.engine.getConnectionManager().remove(network);
                    }
                    OLogManager.instance().error((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
                }
                catch (OOfflineNodeException e) {
                    if (network != null) {
                        this.engine.getConnectionManager().remove(network);
                    }
                    OLogManager.instance().debug((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
                }
                catch (OSecurityException ex) {
                    OLogManager.instance().debug((Object)this, "Invalidate token for url=%s", (Throwable)ex, new Object[]{currentURL});
                    OStorageRemoteSession session2 = this.getCurrentSession();
                    session2.remove(currentURL);
                    if (network == null) continue;
                    try {
                        this.engine.getConnectionManager().remove(network);
                    }
                    catch (Exception e) {
                        OLogManager.instance().debug((Object)this, "Cannot remove connection or database url=" + currentURL, (Throwable)e, new Object[0]);
                    }
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    OLogManager.instance().debug((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
                    if (network == null) continue;
                    try {
                        this.engine.getConnectionManager().remove(network);
                    }
                    catch (Exception ex) {
                        OLogManager.instance().debug((Object)this, "Cannot remove connection or database url=" + currentURL, (Throwable)e, new Object[0]);
                    }
                }
            }
        } while (this.engine.getConnectionManager().getAvailableConnections(currentURL) > 0 || (currentURL = this.useNewServerURL(currentURL)) != null);
        this.parseServerURLs();
        List<String> list = this.serverURLs;
        synchronized (list) {
            throw new OStorageException("Cannot create a connection to remote server address(es): " + this.serverURLs);
        }
    }

    protected synchronized String openRemoteDatabase() throws IOException {
        String currentURL = this.getNextAvailableServerURL(true, this.getCurrentSession());
        return this.openRemoteDatabase(currentURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openRemoteDatabase(OChannelBinaryAsynchClient network) throws IOException {
        this.stateLock.acquireWriteLock();
        try {
            OStorageRemoteSession session = this.getCurrentSession();
            OStorageRemoteNodeSession nodeSession = session.getOrCreate(network.getServerURL());
            try {
                network.writeByte((byte)3);
                network.writeInt(nodeSession.getSessionId());
                this.sendClientInfo(network, DRIVER_NAME, true, true);
                network.writeString(this.name);
                network.writeString(session.connectionUserName);
                network.writeString(session.connectionUserPassword);
            }
            finally {
                this.endRequest(network);
            }
            try {
                network.beginResponse(nodeSession.getSessionId(), false);
                int sessionId = network.readInt();
                byte[] token = network.readBytes();
                if (token.length == 0) {
                    token = null;
                }
                nodeSession.setSession(sessionId, token);
                OLogManager.instance().debug((Object)this, "Client connected to %s with session id=%d", new Object[]{network.getServerURL(), sessionId});
                this.readDatabaseInformation(network);
                this.updateClusterConfiguration(network.getServerURL(), network.readBytes());
                if (network.getSrvProtocolVersion() >= 14) {
                    network.readString();
                }
                this.status = OStorage.STATUS.OPEN;
            }
            finally {
                this.endResponse(network);
            }
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    protected String openRemoteDatabase(String currentURL) {
        do {
            OChannelBinaryAsynchClient network = null;
            network = this.getNetwork(currentURL);
            try {
                this.openRemoteDatabase(network);
                return currentURL;
            }
            catch (OIOException e) {
                if (network != null) {
                    this.engine.getConnectionManager().remove(network);
                    network = null;
                }
                OLogManager.instance().error((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                if (network != null) {
                    try {
                        this.engine.getConnectionManager().remove(network);
                    }
                    catch (Exception ex) {
                        OLogManager.instance().debug((Object)this, "Cannot remove connection or database url=" + currentURL, (Throwable)e, new Object[0]);
                    }
                    network = null;
                }
                OLogManager.instance().error((Object)this, "Cannot open database url=" + currentURL, (Throwable)e, new Object[0]);
            }
        } while (this.engine.getConnectionManager().getReusableConnections(currentURL) > 0 || (currentURL = this.useNewServerURL(currentURL)) != null);
        this.parseServerURLs();
        List<String> list = this.serverURLs;
        synchronized (list) {
            throw new OStorageException("Cannot create a connection to remote server address(es): " + this.serverURLs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String useNewServerURL(String iUrl) {
        int pos = iUrl.indexOf(47);
        if (pos >= iUrl.length() - 1) {
            pos = -1;
        }
        String postFix = pos > -1 ? iUrl.substring(pos) : "";
        String url = pos > -1 ? iUrl.substring(0, pos) : iUrl;
        List<String> list = this.serverURLs;
        synchronized (list) {
            this.serverURLs.remove(url);
            OLogManager.instance().debug((Object)this, "Updated server list: %s...", new Object[]{this.serverURLs});
            if (!this.serverURLs.isEmpty()) {
                return this.serverURLs.get(0) + postFix;
            }
        }
        return null;
    }

    protected void sendClientInfo(OChannelBinaryAsynchClient network, String driverName, boolean supportsPushMessages, boolean collectStats) throws IOException {
        if (network.getSrvProtocolVersion() >= 7) {
            network.writeString(driverName).writeString("2.2.1").writeShort((short)36).writeString(this.clientId);
        }
        if (network.getSrvProtocolVersion() > 21) {
            network.writeString(ODatabaseDocumentTx.getDefaultSerializer().toString());
            this.recordFormat = ODatabaseDocumentTx.getDefaultSerializer().toString();
        } else {
            this.recordFormat = "ORecordDocument2csv";
        }
        if (network.getSrvProtocolVersion() > 26) {
            network.writeBoolean(true);
        }
        if (network.getSrvProtocolVersion() > 33) {
            network.writeBoolean(supportsPushMessages);
            network.writeBoolean(collectStats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseServerURLs() {
        String[] stringArray;
        String lastHost = null;
        int dbPos = this.url.indexOf(47);
        if (dbPos == -1) {
            this.addHost(this.url);
            lastHost = this.url;
            this.name = this.url;
        } else {
            this.name = this.url.substring(this.url.lastIndexOf("/") + 1);
            stringArray = this.url.substring(0, dbPos).split(ADDRESS_SEPARATOR);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String host;
                lastHost = host = stringArray[i];
                this.addHost(host);
            }
        }
        stringArray = this.serverURLs;
        synchronized (this.serverURLs) {
            if (this.serverURLs.size() == 1 && OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_ENABLED.getValueAsBoolean()) {
                String primaryServer = lastHost;
                OLogManager.instance().debug((Object)this, "Retrieving URLs from DNS '%s' (timeout=%d)...", new Object[]{primaryServer, OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT.getValueAsInteger()});
                try {
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                    env.put("com.sun.jndi.ldap.connect.timeout", OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT.getValueAsString());
                    InitialDirContext ictx = new InitialDirContext(env);
                    String hostName = !primaryServer.contains(":") ? primaryServer : primaryServer.substring(0, primaryServer.indexOf(":"));
                    Attributes attrs = ictx.getAttributes(hostName, new String[]{"TXT"});
                    Attribute attr = attrs.get("TXT");
                    if (attr != null) {
                        for (int i = 0; i < attr.size(); ++i) {
                            String[] parts;
                            String configuration = (String)attr.get(i);
                            if (configuration.startsWith("\"")) {
                                configuration = configuration.substring(1, configuration.length() - 1);
                            }
                            if (configuration == null) continue;
                            this.serverURLs.clear();
                            for (String part : parts = configuration.split(" ")) {
                                if (!part.startsWith("s=")) continue;
                                this.addHost(part.substring("s=".length()));
                            }
                        }
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addHost(String host) {
        if (host.startsWith(DEFAULT_HOST)) {
            host = "127.0.0.1" + host.substring(DEFAULT_HOST.length());
        }
        if (host.contains("/")) {
            host = host.substring(0, host.indexOf("/"));
        }
        if (!host.contains(":")) {
            host = host + ":" + (this.clientConfiguration.getValueAsBoolean(OGlobalConfiguration.CLIENT_USE_SSL) ? this.getDefaultSSLPort() : this.getDefaultPort());
        } else if (host.split(":").length < 2 || host.split(":")[1].trim().length() == 0) {
            host = host + (this.clientConfiguration.getValueAsBoolean(OGlobalConfiguration.CLIENT_USE_SSL) ? this.getDefaultSSLPort() : this.getDefaultPort());
        }
        List<String> list = this.serverURLs;
        synchronized (list) {
            if (!this.serverURLs.contains(host)) {
                this.serverURLs.add(host);
                OLogManager.instance().info((Object)this, "Registered the new available server '%s'", new Object[]{host});
            }
        }
        return host;
    }

    protected int getDefaultPort() {
        return 2424;
    }

    protected int getDefaultSSLPort() {
        return 2434;
    }

    public OChannelBinaryAsynchClient beginRequest(OChannelBinaryAsynchClient network, byte iCommand) throws IOException {
        OStorageRemoteSession session = this.getCurrentSession();
        network.beginRequest(iCommand, session);
        return network;
    }

    protected String getNextAvailableServerURL(boolean iIsConnectOperation, OStorageRemoteSession session) {
        String url = null;
        switch (this.connectionStrategy) {
            case STICKY: {
                String string = url = session != null ? session.getServerUrl() : null;
                if (url != null) break;
                url = this.getServerURFromList(false, session);
                break;
            }
            case ROUND_ROBIN_CONNECT: {
                if (!iIsConnectOperation) {
                    String string = url = session != null ? session.getServerUrl() : null;
                }
                if (url != null) break;
                url = this.getServerURFromList(iIsConnectOperation, session);
                break;
            }
            case ROUND_ROBIN_REQUEST: {
                url = this.getServerURFromList(true, session);
                break;
            }
            default: {
                throw new OConfigurationException("Connection mode " + (Object)((Object)this.connectionStrategy) + " is not supported");
            }
        }
        return url;
    }

    protected String getCurrentServerURL() {
        return this.getServerURFromList(false, this.getCurrentSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServerURFromList(boolean iNextAvailable, OStorageRemoteSession session) {
        List<String> list = this.serverURLs;
        synchronized (list) {
            if (this.serverURLs.isEmpty()) {
                this.parseServerURLs();
                if (this.serverURLs.isEmpty()) {
                    throw new OStorageException("Cannot create a connection to remote server because url list is empty");
                }
            }
            int serverURLIndex = session != null ? session.serverURLIndex : 0;
            if (iNextAvailable) {
                ++serverURLIndex;
            }
            if (serverURLIndex < 0 || serverURLIndex >= this.serverURLs.size()) {
                serverURLIndex = 0;
            }
            String serverURL = this.serverURLs.get(serverURLIndex) + "/" + this.getName();
            if (session != null) {
                session.serverURLIndex = serverURLIndex;
            }
            return serverURL;
        }
    }

    public OChannelBinaryAsynchClient getNetwork(String iCurrentURL) {
        OChannelBinaryAsynchClient network;
        do {
            try {
                network = this.engine.getConnectionManager().acquire(iCurrentURL, this.clientConfiguration, this.connectionOptions, this.asynchEventListener);
            }
            catch (Exception cause) {
                throw OException.wrapException((OException)new OStorageException("Cannot open a connection to remote server: " + iCurrentURL), (Throwable)cause);
            }
            if (network.tryLock()) continue;
            OLogManager.instance().error((Object)this, "Removing locked network channel '%s'...", new Object[]{iCurrentURL});
            this.engine.getConnectionManager().remove(network);
            network = null;
        } while (network == null);
        return network;
    }

    public void beginResponse(OChannelBinaryAsynchClient iNetwork) throws IOException {
        OStorageRemoteSession session = this.getCurrentSession();
        this.beginResponse(iNetwork, session);
    }

    private void beginResponse(OChannelBinaryAsynchClient iNetwork, OStorageRemoteSession session) throws IOException {
        OStorageRemoteNodeSession nodeSession = session.get(iNetwork.getServerURL());
        byte[] newToken = iNetwork.beginResponse(nodeSession.getSessionId(), true);
        if (newToken != null && newToken.length > 0) {
            nodeSession.setSession(nodeSession.getSessionId(), newToken);
        }
    }

    protected void getResponse(OChannelBinaryAsynchClient iNetwork) throws IOException {
        try {
            this.beginResponse(iNetwork);
        }
        finally {
            this.endResponse(iNetwork);
        }
    }

    private OPhysicalPosition[] readPhysicalPositions(OChannelBinaryAsynchClient network, int positionsCount) throws IOException {
        OPhysicalPosition[] physicalPositions = new OPhysicalPosition[positionsCount];
        for (int i = 0; i < physicalPositions.length; ++i) {
            OPhysicalPosition position = new OPhysicalPosition();
            position.clusterPosition = network.readLong();
            position.recordSize = network.readInt();
            position.recordVersion = network.readVersion();
            physicalPositions[i] = position;
        }
        return physicalPositions;
    }

    private void readCollectionChanges(OChannelBinaryAsynchClient network, OSBTreeCollectionManager collectionManager) throws IOException {
        int count = network.readInt();
        for (int i = 0; i < count; ++i) {
            long mBitsOfId = network.readLong();
            long lBitsOfId = network.readLong();
            OBonsaiCollectionPointer pointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer(network);
            if (collectionManager == null) continue;
            collectionManager.updateCollectionPointer(new UUID(mBitsOfId, lBitsOfId), pointer);
        }
        if (ORecordSerializationContext.getDepth() <= 1 && collectionManager != null) {
            collectionManager.clearPendingCollections();
        }
    }

    private void commitEntry(OChannelBinaryAsynchClient iNetwork, ORecordOperation txEntry) throws IOException {
        if (txEntry.type == 0) {
            return;
        }
        byte[] stream = null;
        try {
            switch (txEntry.type) {
                case 1: 
                case 3: {
                    stream = txEntry.getRecord().toStream();
                }
            }
        }
        catch (Exception e) {
            iNetwork.writeByte((byte)-1);
            throw OException.wrapException((OException)new OTransactionException("Error on transaction commit"), (Throwable)e);
        }
        iNetwork.writeByte((byte)1);
        iNetwork.writeByte(txEntry.type);
        iNetwork.writeRID(txEntry.getRecord().getIdentity());
        iNetwork.writeByte(ORecordInternal.getRecordType((ORecord)txEntry.getRecord()));
        switch (txEntry.type) {
            case 3: {
                iNetwork.writeBytes(stream);
                break;
            }
            case 1: {
                iNetwork.writeVersion(txEntry.getRecord().getVersion());
                iNetwork.writeBytes(stream);
                if (iNetwork.getSrvProtocolVersion() < 23) break;
                iNetwork.writeBoolean(ORecordInternal.isContentChanged((ORecord)txEntry.getRecord()));
                break;
            }
            case 2: {
                iNetwork.writeVersion(txEntry.getRecord().getVersion());
            }
        }
    }

    private boolean handleDBFreeze() {
        OLogManager.instance().warn((Object)this, "DB is frozen will wait for " + OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT.getValue() + " ms. and then retry.", new Object[0]);
        boolean retry = true;
        try {
            Thread.sleep(OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT.getValueAsInteger());
        }
        catch (InterruptedException ie) {
            retry = false;
            Thread.currentThread().interrupt();
        }
        return retry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDatabaseInformation(OChannelBinaryAsynchClient network) throws IOException {
        int tot = network.getSrvProtocolVersion() >= 7 ? network.readShort() : network.readInt();
        this.stateLock.acquireWriteLock();
        try {
            this.clusters = new OCluster[tot];
            this.clusterMap.clear();
            for (int i = 0; i < tot; ++i) {
                OClusterRemote cluster = new OClusterRemote();
                String clusterName = network.readString();
                short clusterId = network.readShort();
                if (clusterName == null) continue;
                clusterName = clusterName.toLowerCase();
                if (network.getSrvProtocolVersion() < 24) {
                    network.readString();
                }
                short dataSegmentId = network.getSrvProtocolVersion() >= 12 && network.getSrvProtocolVersion() < 24 ? network.readShort() : (short)0;
                cluster.configure((OStorage)this, clusterId, clusterName, new Object[0]);
                if (clusterId >= this.clusters.length) {
                    this.clusters = Arrays.copyOf(this.clusters, clusterId + 1);
                }
                this.clusters[clusterId] = cluster;
                this.clusterMap.put(clusterName, cluster);
            }
            OCluster defaultCluster = this.clusterMap.get("default");
            if (defaultCluster != null) {
                this.defaultClusterId = this.clusterMap.get("default").getId();
            }
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteRecord(byte command, final ORecordId iRid, int iVersion, int iMode, final ORecordCallback<Boolean> iCallback, final OChannelBinaryAsynchClient network) throws IOException {
        try {
            this.beginRequest(network, command);
            network.writeRID((ORID)iRid);
            network.writeVersion(iVersion);
            network.writeByte((byte)iMode);
        }
        finally {
            this.endRequest(network);
        }
        switch (iMode) {
            case 0: {
                try {
                    this.beginResponse(network);
                    boolean bl = network.readByte() == 1;
                    return bl;
                }
                finally {
                    this.endResponse(network);
                }
            }
            case 1: {
                if (iCallback == null) break;
                final OStorageRemoteSession session = this.getCurrentSession();
                Callable<Object> response = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Boolean result;
                        try {
                            OStorageRemote.this.beginResponse(network, session);
                            result = network.readByte() == 1;
                        }
                        finally {
                            OStorageRemote.this.endResponse(network);
                        }
                        iCallback.call(iRid, (Object)result);
                        return null;
                    }
                };
                this.asynchExecutor.submit(new FutureTask<Object>(response));
            }
        }
        return false;
    }

    protected OStorageRemoteSession getCurrentSession() {
        ODatabaseDocumentTx db = (ODatabaseDocumentTx)ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db == null) {
            return null;
        }
        OStorageRemoteSession session = (OStorageRemoteSession)ODatabaseDocumentTxInternal.getSessionMetadata((ODatabaseDocumentTx)db);
        if (session == null) {
            session = new OStorageRemoteSession(sessionSerialId.decrementAndGet());
            ODatabaseDocumentTxInternal.setSessionMetadata((ODatabaseDocumentTx)db, (ODatabaseSessionMetadata)session);
        }
        return session;
    }

    public boolean isClosed() {
        if (super.isClosed()) {
            return true;
        }
        OStorageRemoteSession session = this.getCurrentSession();
        if (session == null) {
            return false;
        }
        return session.getAll().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageRemote copy(ODatabaseDocumentTx source, ODatabaseDocumentTx dest) {
        ODatabaseDocumentInternal origin = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        OStorageRemoteSession session = (OStorageRemoteSession)ODatabaseDocumentTxInternal.getSessionMetadata((ODatabaseDocumentTx)source);
        if (session != null) {
            OStorageRemoteSession newSession = new OStorageRemoteSession(sessionSerialId.decrementAndGet());
            newSession.connectionUserName = session.connectionUserName;
            newSession.connectionUserPassword = session.connectionUserPassword;
            ODatabaseDocumentTxInternal.setSessionMetadata((ODatabaseDocumentTx)dest, (ODatabaseSessionMetadata)newSession);
        }
        try {
            dest.activateOnCurrentThread();
            this.openRemoteDatabase();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ODatabaseRecordThreadLocal.INSTANCE.set(origin);
        }
        return this;
    }

    static /* synthetic */ OCluster[] access$1202(OStorageRemote x0, OCluster[] x1) {
        x0.clusters = x1;
        return x1;
    }

    public static enum CONNECTION_STRATEGY {
        STICKY,
        ROUND_ROBIN_CONNECT,
        ROUND_ROBIN_REQUEST;

    }
}

