/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.client.remote.ORemoteConnectionPool;
import com.orientechnologies.orient.client.remote.OStorageRemoteAsynchEventListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ORemoteConnectionManager {
    public static final String PARAM_MAX_POOL = "maxpool";
    protected final ConcurrentMap<String, ORemoteConnectionPool> connections = new ConcurrentHashMap<String, ORemoteConnectionPool>();
    protected final long timeout;

    public ORemoteConnectionManager(long iTimeout) {
        this.timeout = iTimeout;
    }

    public void close() {
        for (Map.Entry entry : this.connections.entrySet()) {
            this.closePool((ORemoteConnectionPool)entry.getValue());
        }
        this.connections.clear();
    }

    public OChannelBinaryAsynchClient acquire(String iServerURL, OContextConfiguration clientConfiguration, Map<String, Object> iConfiguration, OStorageRemoteAsynchEventListener iListener) {
        if (iServerURL.startsWith("remote:")) {
            iServerURL = iServerURL.substring("remote:".length());
        }
        if (iServerURL.endsWith("/")) {
            iServerURL = iServerURL.substring(0, iServerURL.length() - 1);
        }
        long localTimeout = this.timeout;
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(iServerURL);
        if (pool == null) {
            ORemoteConnectionPool prev;
            int maxPool = OGlobalConfiguration.CLIENT_CHANNEL_MAX_POOL.getValueAsInteger();
            if (iConfiguration != null && iConfiguration.size() > 0) {
                if (iConfiguration.containsKey(PARAM_MAX_POOL)) {
                    maxPool = Integer.parseInt(iConfiguration.get(PARAM_MAX_POOL).toString());
                }
                if (iConfiguration.containsKey(PARAM_MAX_POOL)) {
                    maxPool = Integer.parseInt(iConfiguration.get(PARAM_MAX_POOL).toString());
                }
            }
            if (clientConfiguration != null) {
                Object netLockTimeout;
                Object max = clientConfiguration.getValue(OGlobalConfiguration.CLIENT_CHANNEL_MAX_POOL);
                if (max != null) {
                    maxPool = Integer.parseInt(max.toString());
                }
                if ((netLockTimeout = clientConfiguration.getValue(OGlobalConfiguration.NETWORK_LOCK_TIMEOUT)) != null) {
                    localTimeout = Integer.parseInt(netLockTimeout.toString());
                }
            }
            if ((prev = this.connections.putIfAbsent(iServerURL, pool = new ORemoteConnectionPool(maxPool, iListener != null))) != null) {
                pool.getPool().close();
                pool = prev;
            }
        }
        try {
            OChannelBinaryAsynchClient ret = pool.acquire(iServerURL, localTimeout, clientConfiguration, iConfiguration, iListener);
            return ret;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error on retrieving the connection from pool: " + iServerURL, (Throwable)e, new Object[0]);
            return null;
        }
    }

    public void release(OChannelBinaryAsynchClient conn) {
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(conn.getServerURL());
        if (pool != null) {
            if (!conn.isConnected()) {
                OLogManager.instance().debug((Object)this, "Network connection pool is receiving a closed connection to reuse: discard it", new Object[0]);
                this.remove(conn);
            } else {
                pool.getPool().returnResource((Object)conn);
            }
        }
    }

    public void remove(OChannelBinaryAsynchClient conn) {
        try {
            conn.unlock();
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Cannot unlock connection lock", (Throwable)e, new Object[0]);
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Cannot close connection", (Throwable)e, new Object[0]);
        }
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(conn.getServerURL());
        if (pool == null) {
            throw new IllegalStateException("Connection cannot be released because the pool doesn't exist anymore");
        }
        pool.getPool().remove((Object)conn);
    }

    public Set<String> getURLs() {
        return this.connections.keySet();
    }

    public int getMaxResources(String url) {
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getPool().getMaxResources();
    }

    public int getAvailableConnections(String url) {
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getPool().getAvailableResources();
    }

    public int getReusableConnections(String url) {
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getPool().getInPoolResources();
    }

    public int getCreatedInstancesInPool(String url) {
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getPool().getCreatedInstances();
    }

    public void closePool(String url) {
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.remove(url);
        if (pool == null) {
            return;
        }
        this.closePool(pool);
    }

    protected void closePool(ORemoteConnectionPool pool) {
        ArrayList conns = new ArrayList(pool.getPool().getAllResources());
        for (OChannelBinaryAsynchClient c : conns) {
            try {
                c.unregisterListener(pool);
                c.close();
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Cannot close binary channel", (Throwable)e, new Object[0]);
            }
        }
        pool.getPool().close();
    }

    public ORemoteConnectionPool getPool(String url) {
        return (ORemoteConnectionPool)this.connections.get(url);
    }
}

