/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.binary;

import com.orientechnologies.common.thread.OSoftThread;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.IOException;

public class OAsynchChannelServiceThread
extends OSoftThread {
    private OChannelBinaryAsynchClient network;
    private int sessionId = Integer.MIN_VALUE;
    private ORemoteServerEventListener remoteServerEventListener;

    public OAsynchChannelServiceThread(ORemoteServerEventListener iRemoteServerEventListener, OChannelBinaryAsynchClient iChannel) {
        super(Orient.instance().getThreadGroup(), "OrientDB <- Asynch Client (" + iChannel.socket.getRemoteSocketAddress() + ")");
        this.remoteServerEventListener = iRemoteServerEventListener;
        this.network = iChannel;
        this.setDumpExceptions(false);
        this.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute() throws Exception {
        try {
            byte request;
            byte[] obj = null;
            try {
                this.network.beginResponse(this.sessionId, 0L, false);
                request = this.network.readByte();
                switch (request) {
                    case 80: 
                    case 81: {
                        obj = this.network.readBytes();
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                if (this.network == null) throw ioe;
                OChannelBinaryAsynchClient n = this.network;
                this.network = null;
                n.close();
                throw ioe;
            }
            finally {
                if (this.network != null) {
                    this.network.endResponse();
                }
            }
            if (this.remoteServerEventListener == null) return;
            this.remoteServerEventListener.onRequest(request, (Object)obj);
            return;
        }
        catch (IOException ioe) {
            this.sendShutdown();
        }
    }
}

