/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.index.OIndexManagerRemote;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibraryImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaRemote;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryImpl;
import com.orientechnologies.orient.core.schedule.OSchedulerImpl;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.storage.OStorage;

public class OSharedContextRemote
extends OSharedContext {
    public OSharedContextRemote(OStorage storage) {
        this.schema = new OSchemaRemote();
        this.security = OSecurityManager.instance().newSecurity();
        this.indexManager = new OIndexManagerRemote(storage);
        this.functionLibrary = new OFunctionLibraryImpl();
        this.scheduler = new OSchedulerImpl();
        this.sequenceLibrary = new OSequenceLibraryImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(ODatabaseDocumentInternal database) {
        long timer = PROFILER.startChrono();
        try {
            if (!this.loaded) {
                this.schema.load(database);
                this.indexManager.load(database);
                this.schema.forceSnapshot();
                this.security.load();
                this.sequenceLibrary.load(database);
                this.schema.onPostIndexManagement();
                this.loaded = true;
            }
        }
        finally {
            PROFILER.stopChrono(PROFILER.getDatabaseMetric(database.getStorage().getName(), "metadata.load"), "Loading of database metadata", timer, "db.*.metadata.load");
        }
    }

    public synchronized void close() {
        this.schema.close();
        this.security.close(false);
        this.indexManager.close();
        this.sequenceLibrary.close();
    }

    public synchronized void reload(ODatabaseDocumentInternal database) {
        this.schema.reload();
        this.indexManager.reload();
        this.schema.forceSnapshot();
        this.security.load();
        this.scheduler.load(database);
    }
}

