/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.orient.client.remote.message.OReloadResponse37;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class OStorageConfigurationRemote
implements OStorageConfiguration {
    private OContextConfiguration contextConfiguration;
    private String dateFormat;
    private String dateTimeFormat;
    private String name;
    private int version;
    private String directory;
    private Map<String, OStorageEntryConfiguration> properties;
    private String schemaRecordId;
    private String indexMgrRecordId;
    private String clusterSelection;
    private String conflictStrategy;
    private boolean validationEnabled;
    private String localeLanguage;
    private int minimumClusters;
    private boolean strictSql;
    private String charset;
    private TimeZone timeZone;
    private String localeCountry;
    private String recordSerializer;
    private int recordSerializerVersion;
    private int binaryFormatVersion;
    private List<OStorageClusterConfiguration> clusters;
    private String networkRecordSerializer;

    public OStorageConfigurationRemote(String networkRecordSerializer, OReloadResponse37 response, OContextConfiguration contextConfiguration) {
        this.networkRecordSerializer = networkRecordSerializer;
        this.contextConfiguration = contextConfiguration;
        this.dateFormat = response.getDateFormat();
        this.dateTimeFormat = response.getDateTimeFormat();
        this.name = response.getName();
        this.version = response.getVersion();
        this.directory = response.getDirectory();
        this.properties = new HashMap<String, OStorageEntryConfiguration>();
        for (OStorageEntryConfiguration conf : response.getProperties()) {
            this.properties.put(conf.name, conf);
        }
        this.schemaRecordId = response.getSchemaRecordId().toString();
        this.indexMgrRecordId = response.getIndexMgrRecordId().toString();
        this.clusterSelection = response.getClusterSelection();
        this.conflictStrategy = response.getConflictStrategy();
        this.validationEnabled = response.isValidationEnabled();
        this.localeLanguage = response.getLocaleLanguage();
        this.minimumClusters = response.getMinimumClusters();
        this.strictSql = response.isStrictSql();
        this.charset = response.getCharset();
        this.timeZone = response.getTimeZone();
        this.localeCountry = response.getLocaleCountry();
        this.recordSerializer = response.getRecordSerializer();
        this.recordSerializerVersion = response.getRecordSerializerVersion();
        this.binaryFormatVersion = response.getBinaryFormatVersion();
        this.clusters = response.getClusters();
    }

    public SimpleDateFormat getDateTimeFormatInstance() {
        return new SimpleDateFormat(this.dateTimeFormat);
    }

    public SimpleDateFormat getDateFormatInstance() {
        return new SimpleDateFormat(this.dateFormat);
    }

    public String getCharset() {
        return this.charset;
    }

    public Locale getLocaleInstance() {
        return Locale.forLanguageTag(this.localeCountry);
    }

    public String getSchemaRecordId() {
        return this.schemaRecordId;
    }

    public void setSchemaRecordId(String s) {
        throw new UnsupportedOperationException();
    }

    public void update() {
        throw new UnsupportedOperationException();
    }

    public int getMinimumClusters() {
        return this.minimumClusters;
    }

    public boolean isStrictSql() {
        return this.strictSql;
    }

    public OStorageConfiguration load(OContextConfiguration contextConfiguration) {
        this.contextConfiguration = contextConfiguration;
        return null;
    }

    public String getIndexMgrRecordId() {
        return this.indexMgrRecordId;
    }

    public void setIndexMgrRecordId(String indexMgrRecordId) {
        throw new UnsupportedOperationException();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public OContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    public String getLocaleCountry() {
        return this.localeCountry;
    }

    public String getLocaleLanguage() {
        return this.localeLanguage;
    }

    public List<OStorageEntryConfiguration> getProperties() {
        return new ArrayList<OStorageEntryConfiguration>(this.properties.values());
    }

    public String getClusterSelection() {
        return this.clusterSelection;
    }

    public String getConflictStrategy() {
        return this.conflictStrategy;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setDateFormat(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setDateTimeFormat(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setTimeZone(TimeZone timeZoneValue) {
        throw new UnsupportedOperationException();
    }

    public void setLocaleCountry(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setLocaleLanguage(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setCharset(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setClusterSelection(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setMinimumClusters(int i) {
        throw new UnsupportedOperationException();
    }

    public void setConflictStrategy(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setValidation(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String iName, String iValue) {
        throw new UnsupportedOperationException();
    }

    public void removeProperty(String iName) {
        throw new UnsupportedOperationException();
    }

    public void clearProperties() {
        throw new UnsupportedOperationException();
    }

    public String getRecordSerializer() {
        return this.networkRecordSerializer;
    }

    public int getRecordSerializerVersion() {
        return this.recordSerializerVersion;
    }

    public int getBinaryFormatVersion() {
        return this.binaryFormatVersion;
    }

    public void dropCluster(int iClusterId) {
        throw new UnsupportedOperationException();
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getProperty(String graphConsistencyMode) {
        return this.properties.get((Object)graphConsistencyMode).value;
    }

    public String getDirectory() {
        return this.directory;
    }

    public List<OStorageClusterConfiguration> getClusters() {
        return this.clusters;
    }
}

