/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentRemote;

public class ODatabaseDocumentRemotePooled
extends ODatabaseDocumentRemote {
    private ODatabasePoolInternal pool;

    public ODatabaseDocumentRemotePooled(ODatabasePoolInternal pool, OStorageRemote storage) {
        super(storage);
        this.pool = pool;
    }

    public void close() {
        this.closeActiveQueries();
        super.setStatus(ODatabase.STATUS.CLOSED);
        this.getLocalCache().clear();
        ODatabaseRecordThreadLocal.instance().remove();
        this.pool.release((ODatabaseDocumentInternal)this);
    }

    @Override
    public ODatabaseDocumentInternal copy() {
        return (ODatabaseDocumentInternal)this.pool.acquire();
    }

    public void reuse() {
        this.activateOnCurrentThread();
        this.setStatus(ODatabase.STATUS.OPEN);
    }

    public void realClose() {
        this.activateOnCurrentThread();
        super.close();
    }
}

