/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OLiveQueryClientListener;
import com.orientechnologies.orient.client.remote.ORemoteQueryResult;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.ORemoteResultSet;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OLiveQueryMonitor;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.db.document.OSharedContextRemote;
import com.orientechnologies.orient.core.db.document.OTransactionOptimisticClient;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.security.OImmutableUser;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OMicroTransaction;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;

public class ODatabaseDocumentRemote
extends ODatabaseDocumentAbstract {
    protected OStorageRemoteSession sessionMetadata;
    private OrientDBConfig config;
    private OStorageRemote storage;

    public ODatabaseDocumentRemote(OStorageRemote storage) {
        this.activateOnCurrentThread();
        try {
            this.status = ODatabase.STATUS.CLOSED;
            this.url = storage.getURL();
            this.storage = storage;
            this.componentsFactory = storage.getComponentsFactory();
            this.unmodifiableHooks = Collections.unmodifiableMap(this.hooks);
            this.localCache = new OLocalRecordCache();
            this.init();
            this.databaseOwner = this;
        }
        catch (Exception t) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw OException.wrapException((OException)new ODatabaseException("Error on opening database "), (Throwable)t);
        }
    }

    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Use OrientDB");
    }

    @Deprecated
    public <DB extends ODatabase> DB open(OToken iToken) {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    public <DB extends ODatabase> DB create() {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    public <DB extends ODatabase> DB create(String incrementalBackupPath) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public <DB extends ODatabase> DB create(Map<OGlobalConfiguration, Object> iInitialSettings) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public void drop() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <DB extends ODatabase> DB set(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        if (iAttribute == ODatabase.ATTRIBUTES.CUSTOM) {
            int indx;
            String stringValue = iValue.toString();
            int n = indx = stringValue != null ? stringValue.indexOf(61) : -1;
            if (indx < 0) {
                if (!"clear".equalsIgnoreCase(stringValue)) throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                String query = "alter database CUSTOM 'clear'";
                ORemoteQueryResult result = this.getStorage().command(this, query, new Object[]{iValue});
                result.getResult().close();
                return (DB)((Object)this);
            } else {
                String customName = stringValue.substring(0, indx).trim();
                String customValue = stringValue.substring(indx + 1).trim();
                this.setCustom(customName, customValue);
            }
            return (DB)((Object)this);
        } else {
            String query = "alter database " + iAttribute.name() + " ? ";
            ORemoteQueryResult result = this.getStorage().command(this, query, new Object[]{iValue});
            result.getResult().close();
            this.getStorage().reload();
        }
        return (DB)((Object)this);
    }

    public <DB extends ODatabase> DB setCustom(String name, Object iValue) {
        if ("clear".equals(name) && iValue == null) {
            String query = "alter database CUSTOM 'clear'";
            ORemoteQueryResult result = this.getStorage().command(this, query, new Object[0]);
            result.getResult().close();
        } else {
            String query = "alter database CUSTOM  " + name + " = ?";
            ORemoteQueryResult result = this.getStorage().command(this, query, new Object[]{iValue});
            result.getResult().close();
            this.getStorage().reload();
        }
        return (DB)((Object)this);
    }

    public ODatabaseDocumentInternal copy() {
        ODatabaseDocumentRemote database = new ODatabaseDocumentRemote(this.storage);
        database.storage = this.storage.copy(this, database);
        database.storage.addUser();
        database.status = ODatabase.STATUS.OPEN;
        database.applyAttributes(this.config);
        database.initAtFirstOpen();
        database.user = this.user;
        this.activateOnCurrentThread();
        return database;
    }

    public boolean exists() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public void internalOpen(String user, String password, OrientDBConfig config) {
        this.config = config;
        this.applyAttributes(config);
        this.applyListeners(config);
        try {
            this.storage.open(user, password, config.getConfigurations());
            this.status = ODatabase.STATUS.OPEN;
            this.initAtFirstOpen();
            this.user = new OImmutableUser(-1L, new OUser(user, OUser.encryptPassword((String)password)).addRole((OSecurityRole)new ORole("passthrough", null, OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT)));
            this.callOnOpenListeners();
        }
        catch (OException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw OException.wrapException((OException)new ODatabaseException("Cannot open database url=" + this.getURL()), (Throwable)e);
        }
    }

    private void applyAttributes(OrientDBConfig config) {
        for (Map.Entry attrs : config.getAttributes().entrySet()) {
            this.set((ODatabase.ATTRIBUTES)attrs.getKey(), attrs.getValue());
        }
    }

    private void initAtFirstOpen() {
        if (this.initialized) {
            return;
        }
        ORecordSerializerFactory serializerFactory = ORecordSerializerFactory.instance();
        this.serializer = serializerFactory.getFormat("onet_ser_v37");
        this.localCache.startup();
        this.componentsFactory = this.getStorage().getComponentsFactory();
        this.user = null;
        this.loadMetadata();
        this.initialized = true;
    }

    protected void loadMetadata() {
        this.metadata = new OMetadataDefault((ODatabaseDocumentInternal)this);
        this.sharedContext = (OSharedContext)this.getStorage().getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextRemote shared = new OSharedContextRemote();
                return shared;
            }
        });
        this.metadata.init(this.sharedContext);
        this.sharedContext.load((ODatabaseDocumentInternal)this);
    }

    private void applyListeners(OrientDBConfig config) {
        for (ODatabaseListener listener : config.getListeners()) {
            this.registerListener(listener);
        }
    }

    public ODatabaseDocumentAbstract begin(OTransaction.TXTYPE iType) {
        this.checkOpenness();
        this.checkIfActive();
        if (this.currentTx.isActive()) {
            if (iType == OTransaction.TXTYPE.OPTIMISTIC && this.currentTx instanceof OTransactionOptimistic) {
                this.currentTx.begin();
                return this;
            }
            this.currentTx.rollback(true, 0);
        }
        if (!this.inHook.isEmpty()) {
            throw new IllegalStateException("Cannot begin a transaction while a hook is executing");
        }
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxBegin((ODatabase)this);
            }
            catch (Exception t) {
                OLogManager.instance().error((Object)this, "Error before tx begin", (Throwable)t, new Object[0]);
            }
            catch (Error e) {
                OLogManager.instance().error((Object)this, "Error before tx begin", (Throwable)e, new Object[0]);
                throw e;
            }
        }
        switch (iType) {
            case NOTX: {
                this.setDefaultTransactionMode();
                break;
            }
            case OPTIMISTIC: {
                this.currentTx = new OTransactionOptimisticClient((ODatabaseDocumentInternal)this);
                break;
            }
            case PESSIMISTIC: {
                throw new UnsupportedOperationException("Pessimistic transaction");
            }
        }
        this.currentTx.begin();
        return this;
    }

    public OStorageRemoteSession getSessionMetadata() {
        return this.sessionMetadata;
    }

    public void setSessionMetadata(OStorageRemoteSession sessionMetadata) {
        this.sessionMetadata = sessionMetadata;
    }

    public OStorageRemote getStorage() {
        return this.storage;
    }

    public void replaceStorage(OStorage iNewStorage) {
        throw new UnsupportedOperationException("unsupported replace of storage for remote database");
    }

    private void checkAndSendTransaction() {
        if (this.currentTx.isActive() && ((OTransactionOptimistic)this.currentTx).isChanged()) {
            if (((OTransactionOptimistic)this.getTransaction()).isAlreadyCleared()) {
                this.storage.reBeginTransaction(this, (OTransactionOptimistic)this.currentTx);
            } else {
                this.storage.beginTransaction(this, (OTransactionOptimistic)this.currentTx);
            }
            ((OTransactionOptimistic)this.currentTx).resetChangesTracking();
        }
    }

    private void fetchTransacion() {
        this.storage.fetchTransaction(this);
    }

    public OResultSet query(String query, Object[] args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.query(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        return result.getResult();
    }

    public OResultSet query(String query, Map args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.query(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        return result.getResult();
    }

    public OResultSet command(String query, Object ... args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.command(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        return result.getResult();
    }

    public OResultSet command(String query, Map args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.command(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        return result.getResult();
    }

    public OResultSet execute(String language, String script, Object ... args) throws OCommandExecutionException, OCommandScriptException {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.execute(this, language, script, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        return result.getResult();
    }

    public OResultSet execute(String language, String script, Map<String, ?> args) throws OCommandExecutionException, OCommandScriptException {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.execute(this, language, script, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        return result.getResult();
    }

    public void closeQuery(String queryId) {
        this.storage.closeQuery(this, queryId);
    }

    public void queryStarted(String id, OResultSet rs) {
    }

    public void fetchNextPage(ORemoteResultSet rs) {
        this.storage.fetchNextPage(this, rs);
    }

    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Object ... args) {
        return this.storage.liveQuery(this, query, new OLiveQueryClientListener((ODatabaseDocument)this.copy(), listener), args);
    }

    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Map<String, ?> args) {
        return this.storage.liveQuery(this, query, new OLiveQueryClientListener((ODatabaseDocument)this.copy(), listener), args);
    }

    public void recycle(ORecord record) {
        throw new UnsupportedOperationException();
    }

    protected OMicroTransaction beginMicroTransaction() {
        return null;
    }

    public static void deInit(OStorageRemote storage) {
        OSharedContext sharedContext = (OSharedContext)storage.removeResource(OSharedContext.class.getName());
        if (sharedContext != null) {
            sharedContext.close();
        }
    }
}

