/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.orient.client.remote.message.push.OStorageConfigurationPayload;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class OStorageConfigurationRemote
implements OStorageConfiguration {
    private OContextConfiguration contextConfiguration;
    private String dateFormat;
    private String dateTimeFormat;
    private String name;
    private int version;
    private String directory;
    private Map<String, OStorageEntryConfiguration> properties;
    private String schemaRecordId;
    private String indexMgrRecordId;
    private String clusterSelection;
    private String conflictStrategy;
    private boolean validationEnabled;
    private String localeLanguage;
    private int minimumClusters;
    private boolean strictSql;
    private String charset;
    private TimeZone timeZone;
    private String localeCountry;
    private String recordSerializer;
    private int recordSerializerVersion;
    private int binaryFormatVersion;
    private List<OStorageClusterConfiguration> clusters;
    private String networkRecordSerializer;

    public OStorageConfigurationRemote(String networkRecordSerializer, OStorageConfigurationPayload payload, OContextConfiguration contextConfiguration) {
        this.networkRecordSerializer = networkRecordSerializer;
        this.contextConfiguration = contextConfiguration;
        this.dateFormat = payload.getDateFormat();
        this.dateTimeFormat = payload.getDateTimeFormat();
        this.name = payload.getName();
        this.version = payload.getVersion();
        this.directory = payload.getDirectory();
        this.properties = new HashMap<String, OStorageEntryConfiguration>();
        for (OStorageEntryConfiguration conf : payload.getProperties()) {
            this.properties.put(conf.name, conf);
        }
        this.schemaRecordId = payload.getSchemaRecordId().toString();
        this.indexMgrRecordId = payload.getIndexMgrRecordId().toString();
        this.clusterSelection = payload.getClusterSelection();
        this.conflictStrategy = payload.getConflictStrategy();
        this.validationEnabled = payload.isValidationEnabled();
        this.localeLanguage = payload.getLocaleLanguage();
        this.minimumClusters = payload.getMinimumClusters();
        this.strictSql = payload.isStrictSql();
        this.charset = payload.getCharset();
        this.timeZone = payload.getTimeZone();
        this.localeCountry = payload.getLocaleCountry();
        this.recordSerializer = payload.getRecordSerializer();
        this.recordSerializerVersion = payload.getRecordSerializerVersion();
        this.binaryFormatVersion = payload.getBinaryFormatVersion();
        this.clusters = payload.getClusters();
    }

    public SimpleDateFormat getDateTimeFormatInstance() {
        return new SimpleDateFormat(this.dateTimeFormat);
    }

    public SimpleDateFormat getDateFormatInstance() {
        return new SimpleDateFormat(this.dateFormat);
    }

    public String getCharset() {
        return this.charset;
    }

    public Locale getLocaleInstance() {
        return Locale.forLanguageTag(this.localeCountry);
    }

    public String getSchemaRecordId() {
        return this.schemaRecordId;
    }

    public void setSchemaRecordId(String s) {
        throw new UnsupportedOperationException();
    }

    public void update() {
        throw new UnsupportedOperationException();
    }

    public int getMinimumClusters() {
        return this.minimumClusters;
    }

    public boolean isStrictSql() {
        return this.strictSql;
    }

    public OStorageConfiguration load(OContextConfiguration contextConfiguration) {
        this.contextConfiguration = contextConfiguration;
        return null;
    }

    public String getIndexMgrRecordId() {
        return this.indexMgrRecordId;
    }

    public void setIndexMgrRecordId(String indexMgrRecordId) {
        throw new UnsupportedOperationException();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public OContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    public String getLocaleCountry() {
        return this.localeCountry;
    }

    public String getLocaleLanguage() {
        return this.localeLanguage;
    }

    public List<OStorageEntryConfiguration> getProperties() {
        return new ArrayList<OStorageEntryConfiguration>(this.properties.values());
    }

    public String getClusterSelection() {
        return this.clusterSelection;
    }

    public String getConflictStrategy() {
        return this.conflictStrategy;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setDateFormat(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setDateTimeFormat(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setTimeZone(TimeZone timeZoneValue) {
        throw new UnsupportedOperationException();
    }

    public void setLocaleCountry(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setLocaleLanguage(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setCharset(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setClusterSelection(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setMinimumClusters(int i) {
        throw new UnsupportedOperationException();
    }

    public void setConflictStrategy(String stringValue) {
        throw new UnsupportedOperationException();
    }

    public void setValidation(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String iName, String iValue) {
        throw new UnsupportedOperationException();
    }

    public void removeProperty(String iName) {
        throw new UnsupportedOperationException();
    }

    public void clearProperties() {
        throw new UnsupportedOperationException();
    }

    public String getRecordSerializer() {
        return this.networkRecordSerializer;
    }

    public int getRecordSerializerVersion() {
        return this.recordSerializerVersion;
    }

    public int getBinaryFormatVersion() {
        return this.binaryFormatVersion;
    }

    public void dropCluster(int iClusterId) {
        this.clusters.set(iClusterId, null);
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getProperty(String graphConsistencyMode) {
        return this.properties.get((Object)graphConsistencyMode).value;
    }

    public String getDirectory() {
        return this.directory;
    }

    public List<OStorageClusterConfiguration> getClusters() {
        return this.clusters;
    }
}

