/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OInfoExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInfoExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OQueryResponse
implements OBinaryResponse {
    public static final byte RECORD_TYPE_BLOB = 0;
    public static final byte RECORD_TYPE_VERTEX = 1;
    public static final byte RECORD_TYPE_EDGE = 2;
    public static final byte RECORD_TYPE_ELEMENT = 3;
    public static final byte RECORD_TYPE_PROJECTION = 4;
    private String queryId;
    private boolean txChanges;
    private List<OResultInternal> result;
    private Optional<OExecutionPlan> executionPlan;
    private boolean hasNextPage;
    private Map<String, Long> queryStats;
    private boolean reloadMetadata;

    public OQueryResponse(String queryId, boolean txChanges, List<OResultInternal> result, Optional<OExecutionPlan> executionPlan, boolean hasNextPage, Map<String, Long> queryStats, boolean reloadMetadata) {
        this.queryId = queryId;
        this.txChanges = txChanges;
        this.result = result;
        this.executionPlan = executionPlan;
        this.hasNextPage = hasNextPage;
        this.queryStats = queryStats;
        this.reloadMetadata = reloadMetadata;
    }

    public OQueryResponse() {
    }

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        channel.writeString(this.queryId);
        channel.writeBoolean(this.txChanges);
        this.writeExecutionPlan(this.executionPlan, channel, serializer);
        channel.writeInt(this.result.size());
        for (OResult oResult : this.result) {
            OMessageHelper.writeResult(oResult, channel, serializer);
        }
        channel.writeBoolean(this.hasNextPage);
        this.writeQueryStats(this.queryStats, channel);
        channel.writeBoolean(this.reloadMetadata);
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        this.queryId = network.readString();
        this.txChanges = network.readBoolean();
        this.executionPlan = this.readExecutionPlan(network);
        int size = network.readInt();
        this.result = new ArrayList<OResultInternal>(size);
        while (size-- > 0) {
            this.result.add(OMessageHelper.readResult(network));
        }
        this.hasNextPage = network.readBoolean();
        this.queryStats = this.readQueryStats(network);
        this.reloadMetadata = network.readBoolean();
    }

    private void writeQueryStats(Map<String, Long> queryStats, OChannelDataOutput channel) throws IOException {
        if (queryStats == null) {
            channel.writeInt(0);
            return;
        }
        channel.writeInt(queryStats.size());
        for (Map.Entry<String, Long> entry : queryStats.entrySet()) {
            channel.writeString(entry.getKey());
            channel.writeLong(entry.getValue().longValue());
        }
    }

    private Map<String, Long> readQueryStats(OChannelDataInput channel) throws IOException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        int size = channel.readInt();
        for (int i = 0; i < size; ++i) {
            String key = channel.readString();
            Long val = channel.readLong();
            result.put(key, val);
        }
        return result;
    }

    private void writeExecutionPlan(Optional<OExecutionPlan> executionPlan, OChannelDataOutput channel, ORecordSerializer recordSerializer) throws IOException {
        if (executionPlan.isPresent()) {
            channel.writeBoolean(true);
            OMessageHelper.writeResult(executionPlan.get().toResult(), channel, recordSerializer);
        } else {
            channel.writeBoolean(false);
        }
    }

    private Optional<OExecutionPlan> readExecutionPlan(OChannelDataInput network) throws IOException {
        boolean present = network.readBoolean();
        if (!present) {
            return Optional.empty();
        }
        OInfoExecutionPlan result = new OInfoExecutionPlan();
        OResultInternal read = OMessageHelper.readResult(network);
        result.setCost(Integer.valueOf(((Number)read.getProperty("cost")).intValue()));
        result.setType((String)read.getProperty("type"));
        result.setJavaType((String)read.getProperty("javaType"));
        result.setPrettyPrint((String)read.getProperty("prettyPrint"));
        result.setStmText((String)read.getProperty("stmText"));
        List subSteps = (List)read.getProperty("steps");
        if (subSteps != null) {
            subSteps.forEach(x -> result.getSteps().add(this.toInfoStep((OResult)x)));
        }
        return Optional.of(result);
    }

    public String getQueryId() {
        return this.queryId;
    }

    public List<OResultInternal> getResult() {
        return this.result;
    }

    public Optional<OExecutionPlan> getExecutionPlan() {
        return this.executionPlan;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public Map<String, Long> getQueryStats() {
        return this.queryStats;
    }

    private OExecutionStep toInfoStep(OResult x) {
        OInfoExecutionStep result = new OInfoExecutionStep();
        result.setName((String)x.getProperty("name"));
        result.setType((String)x.getProperty("type"));
        result.setTargetNode((String)x.getProperty("targetNode"));
        result.setJavaType((String)x.getProperty("javaType"));
        result.setCost(x.getProperty("cost") == null ? -1L : (Long)x.getProperty("cost"));
        List ssteps = (List)x.getProperty("subSteps");
        if (ssteps != null) {
            ssteps.stream().forEach(sstep -> result.getSubSteps().add(this.toInfoStep((OResult)sstep)));
        }
        result.setDescription((String)x.getProperty("description"));
        return result;
    }

    public boolean isTxChanges() {
        return this.txChanges;
    }

    public boolean isReloadMetadata() {
        return this.reloadMetadata;
    }
}

