package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentRemote;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * Created by luigidellaquila on 05/12/16.
 */
public class ORemoteResultSet implements OResultSet {

  private       String                  queryId;
  private final ODatabaseDocumentRemote db;

  private List<OResult> currentPage = new ArrayList<>();
  private OExecutionPlan    executionPlan;
  private Map<String, Long> queryStats;
  private boolean hasNextPage = false;

  public ORemoteResultSet(ODatabaseDocumentRemote db) {
    this.db = db;
  }

  protected void setQueryId(String queryId) {
    this.queryId = queryId;
  }

  @Override public boolean hasNext() {
    if (!currentPage.isEmpty()) {
      return true;
    }
    if (!hasNextPage()) {
      return false;
    }
    fetchNextPage();
    return !currentPage.isEmpty();
  }

  private void fetchNextPage() {
    db.fetchNextPage(this);
  }

  @Override public OResult next() {
    if (currentPage.isEmpty()) {
      if (!hasNextPage()) {
        throw new IllegalStateException();
      }
      fetchNextPage();
    }
    if (currentPage.isEmpty()) {
      throw new IllegalStateException();
    }
    return currentPage.remove(0);
  }

  @Override public void close() {
    db.closeQuery(queryId);
  }

  @Override public Optional<OExecutionPlan> getExecutionPlan() {
    return Optional.ofNullable(executionPlan);
  }

  @Override public Map<String, Long> getQueryStats() {
    return queryStats;
  }

  public void setQueryStats(Map<String, Long> queryStats) {
    this.queryStats = queryStats;
  }

  public void add(OResult item) {
    currentPage.add(item);
  }

  public void setExecutionPlan(OExecutionPlan executionPlan) {
    this.executionPlan = executionPlan;
  }

  public boolean hasNextPage() {
    return hasNextPage;
  }

  public void setHasNextPage(boolean b) {
    this.hasNextPage = b;
  }

  public String getQueryId() {
    return queryId;
  }

  public void setCurrentPage(List<OResult> currentPage) {
    this.currentPage = currentPage;
  }

  public List<OResult> getCurrentPage() {
    return currentPage;
  }
}
