/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.client.remote.OBinaryAsyncRequest;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OClusterRemote;
import com.orientechnologies.orient.client.remote.OEngineRemote;
import com.orientechnologies.orient.client.remote.ORemoteConnectionManager;
import com.orientechnologies.orient.client.remote.ORemoteQueryResult;
import com.orientechnologies.orient.client.remote.OSBTreeCollectionManagerRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteAsynchEventListener;
import com.orientechnologies.orient.client.remote.OStorageRemoteConfiguration;
import com.orientechnologies.orient.client.remote.OStorageRemoteNodeSession;
import com.orientechnologies.orient.client.remote.OStorageRemoteOperation;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OAddClusterRequest;
import com.orientechnologies.orient.client.remote.message.OAddClusterResponse;
import com.orientechnologies.orient.client.remote.message.OBeginTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OCeilingPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OCeilingPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OCleanOutRecordRequest;
import com.orientechnologies.orient.client.remote.message.OCleanOutRecordResponse;
import com.orientechnologies.orient.client.remote.message.OCloseQueryRequest;
import com.orientechnologies.orient.client.remote.message.OCloseQueryResponse;
import com.orientechnologies.orient.client.remote.message.OCloseRequest;
import com.orientechnologies.orient.client.remote.message.OCommandRequest;
import com.orientechnologies.orient.client.remote.message.OCommandResponse;
import com.orientechnologies.orient.client.remote.message.OCommit37Request;
import com.orientechnologies.orient.client.remote.message.OCommitResponse;
import com.orientechnologies.orient.client.remote.message.OCountRecordsRequest;
import com.orientechnologies.orient.client.remote.message.OCountRecordsResponse;
import com.orientechnologies.orient.client.remote.message.OCountRequest;
import com.orientechnologies.orient.client.remote.message.OCountResponse;
import com.orientechnologies.orient.client.remote.message.OCreateRecordRequest;
import com.orientechnologies.orient.client.remote.message.OCreateRecordResponse;
import com.orientechnologies.orient.client.remote.message.ODeleteRecordRequest;
import com.orientechnologies.orient.client.remote.message.ODeleteRecordResponse;
import com.orientechnologies.orient.client.remote.message.ODropClusterRequest;
import com.orientechnologies.orient.client.remote.message.ODropClusterResponse;
import com.orientechnologies.orient.client.remote.message.OFetchTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OFetchTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OFloorPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OFloorPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OGetClusterDataRangeRequest;
import com.orientechnologies.orient.client.remote.message.OGetClusterDataRangeResponse;
import com.orientechnologies.orient.client.remote.message.OGetRecordMetadataRequest;
import com.orientechnologies.orient.client.remote.message.OGetRecordMetadataResponse;
import com.orientechnologies.orient.client.remote.message.OGetSizeRequest;
import com.orientechnologies.orient.client.remote.message.OGetSizeResponse;
import com.orientechnologies.orient.client.remote.message.OHideRecordRequest;
import com.orientechnologies.orient.client.remote.message.OHideRecordResponse;
import com.orientechnologies.orient.client.remote.message.OHigherPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OHigherPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OImportRequest;
import com.orientechnologies.orient.client.remote.message.OImportResponse;
import com.orientechnologies.orient.client.remote.message.OIncrementalBackupRequest;
import com.orientechnologies.orient.client.remote.message.OIncrementalBackupResponse;
import com.orientechnologies.orient.client.remote.message.OLowerPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OLowerPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OOpenRequest;
import com.orientechnologies.orient.client.remote.message.OOpenResponse;
import com.orientechnologies.orient.client.remote.message.OQueryNextPageRequest;
import com.orientechnologies.orient.client.remote.message.OQueryRequest;
import com.orientechnologies.orient.client.remote.message.OQueryResponse;
import com.orientechnologies.orient.client.remote.message.OReadRecordIfVersionIsNotLatestRequest;
import com.orientechnologies.orient.client.remote.message.OReadRecordIfVersionIsNotLatestResponse;
import com.orientechnologies.orient.client.remote.message.OReadRecordRequest;
import com.orientechnologies.orient.client.remote.message.OReadRecordResponse;
import com.orientechnologies.orient.client.remote.message.ORebeginTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OReloadRequest;
import com.orientechnologies.orient.client.remote.message.OReloadResponse;
import com.orientechnologies.orient.client.remote.message.ORemoteResultSet;
import com.orientechnologies.orient.client.remote.message.OReopenRequest;
import com.orientechnologies.orient.client.remote.message.OReopenResponse;
import com.orientechnologies.orient.client.remote.message.ORollbackTransactionRequest;
import com.orientechnologies.orient.client.remote.message.ORollbackTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OUpdateRecordRequest;
import com.orientechnologies.orient.client.remote.message.OUpdateRecordResponse;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequestAsynch;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentRemote;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTxInternal;
import com.orientechnologies.orient.core.db.document.OTransactionOptimisticClient;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.OTokenException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OCredentialInterceptor;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.query.OLiveQuery;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import com.orientechnologies.orient.enterprise.channel.binary.ODistributedRedirectException;
import com.orientechnologies.orient.enterprise.channel.binary.OTokenSecurityException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class OStorageRemote
extends OStorageAbstract
implements OStorageProxy {
    @Deprecated
    public static final String PARAM_CONNECTION_STRATEGY = "connectionStrategy";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 2424;
    private static final int DEFAULT_SSL_PORT = 2434;
    private static final String ADDRESS_SEPARATOR = ";";
    public static final String DRIVER_NAME = "OrientDB Java";
    private static final String LOCAL_IP = "127.0.0.1";
    private static final String LOCALHOST = "localhost";
    private static AtomicInteger sessionSerialId = new AtomicInteger(-1);
    private CONNECTION_STRATEGY connectionStrategy = CONNECTION_STRATEGY.STICKY;
    private final OSBTreeCollectionManagerRemote sbTreeCollectionManager = new OSBTreeCollectionManagerRemote((OStorage)this);
    protected final List<String> serverURLs = new ArrayList<String>();
    protected final Map<String, OCluster> clusterMap = new ConcurrentHashMap<String, OCluster>();
    private final ExecutorService asynchExecutor;
    private final ODocument clusterConfiguration = new ODocument();
    private final String clientId;
    private final AtomicInteger users = new AtomicInteger(0);
    private OContextConfiguration clientConfiguration;
    private int connectionRetry;
    private int connectionRetryDelay;
    OCluster[] clusters = OCommonConst.EMPTY_CLUSTER_ARRAY;
    private int defaultClusterId;
    public OStorageRemoteAsynchEventListener asynchEventListener;
    public ORemoteConnectionManager connectionManager;
    private final Set<OStorageRemoteSession> sessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public OStorageRemote(String iClientId, String iURL, String iMode) throws IOException {
        this(iClientId, iURL, iMode, null, true);
    }

    public OStorageRemote(String iClientId, String iURL, String iMode, OStorage.STATUS status, boolean managePushMessages) throws IOException {
        super(iURL, iURL, iMode, 0);
        if (status != null) {
            this.status = status;
        }
        this.clientId = iClientId;
        this.configuration = null;
        this.clientConfiguration = new OContextConfiguration();
        this.connectionRetry = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY);
        this.connectionRetryDelay = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY_DELAY);
        if (managePushMessages) {
            this.asynchEventListener = new OStorageRemoteAsynchEventListener(this);
        }
        this.parseServerURLs();
        this.asynchExecutor = Executors.newSingleThreadScheduledExecutor();
        OEngineRemote engine = (OEngineRemote)Orient.instance().getRunningEngine("remote");
        this.connectionManager = engine.getConnectionManager();
    }

    public <T extends OBinaryResponse> T asyncNetworkOperation(final OBinaryAsyncRequest<T> request, int mode, final ORecordId recordId, final ORecordCallback<T> callback, String errorMessage) {
        final int pMode = mode == 1 && callback == null ? 2 : mode;
        request.setMode((byte)pMode);
        return (T)((OBinaryResponse)this.baseNetworkOperation(new OStorageRemoteOperation<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T execute(final OChannelBinaryAsynchClient network, final OStorageRemoteSession session) throws IOException {
                try {
                    network.beginRequest(request.getCommand(), session);
                    request.write((OChannelDataOutput)network, session);
                }
                finally {
                    network.endRequest();
                }
                Object response = request.createResponse();
                Object ret = null;
                if (pMode == 0) {
                    try {
                        OStorageRemote.this.beginResponse(network, session);
                        response.read((OChannelDataInput)network, session);
                    }
                    finally {
                        OStorageRemote.this.endResponse(network);
                    }
                    ret = response;
                    OStorageRemote.this.connectionManager.release(network);
                } else if (pMode == 1) {
                    OStorageRemote.this.asynchExecutor.submit(new Runnable((OBinaryResponse)response){
                        final /* synthetic */ OBinaryResponse val$response;
                        {
                            this.val$response = oBinaryResponse;
                        }

                        @Override
                        public void run() {
                            try {
                                try {
                                    OStorageRemote.this.beginResponse(network, session);
                                    this.val$response.read((OChannelDataInput)network, session);
                                }
                                finally {
                                    OStorageRemote.this.endResponse(network);
                                }
                                callback.call(recordId, (Object)this.val$response);
                                OStorageRemote.this.connectionManager.release(network);
                            }
                            catch (Throwable e) {
                                OStorageRemote.this.connectionManager.remove(network);
                                OLogManager.instance().error((Object)this, "Exception on async query", e, new Object[0]);
                            }
                        }
                    });
                } else {
                    OStorageRemote.this.connectionManager.release(network);
                }
                return ret;
            }
        }, errorMessage, this.connectionRetry));
    }

    public <T extends OBinaryResponse> T networkOperationRetryTimeout(final OBinaryRequest<T> request, String errorMessage, int retry, final int timeout) {
        return (T)((OBinaryResponse)this.baseNetworkOperation(new OStorageRemoteOperation<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T execute(OChannelBinaryAsynchClient network, OStorageRemoteSession session) throws IOException {
                try {
                    network.beginRequest(request.getCommand(), session);
                    request.write((OChannelDataOutput)network, session);
                }
                finally {
                    network.endRequest();
                }
                int prev = network.getSocketTimeout();
                Object response = request.createResponse();
                try {
                    if (timeout > 0) {
                        network.setSocketTimeout(timeout);
                    }
                    OStorageRemote.this.beginResponse(network, session);
                    response.read((OChannelDataInput)network, session);
                }
                finally {
                    OStorageRemote.this.endResponse(network);
                    if (timeout > 0) {
                        network.setSocketTimeout(prev);
                    }
                }
                OStorageRemote.this.connectionManager.release(network);
                return response;
            }
        }, errorMessage, retry));
    }

    public <T extends OBinaryResponse> T networkOperation(OBinaryRequest<T> request, String errorMessage) {
        return this.networkOperationRetryTimeout(request, errorMessage, this.connectionRetry, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T baseNetworkOperation(OStorageRemoteOperation<T> operation, String errorMessage, int retry) {
        OStorageRemoteSession session = this.getCurrentSession();
        if (session.commandExecuting) {
            throw new ODatabaseException("Cannot execute the request because an asynchronous operation is in progress. Please use a different connection");
        }
        String serverUrl = null;
        while (true) {
            Object object;
            session.commandExecuting = true;
            OChannelBinaryAsynchClient network = null;
            if (serverUrl == null) {
                serverUrl = this.getNextAvailableServerURL(false, session);
            }
            do {
                try {
                    network = this.getNetwork(serverUrl);
                }
                catch (OException e) {
                    serverUrl = this.useNewServerURL(serverUrl);
                    if (serverUrl != null) continue;
                    throw e;
                }
            } while (network == null);
            try {
                OStorageRemoteNodeSession nodeSession = session.getServerSession(network.getServerURL());
                if (nodeSession == null || !nodeSession.isValid()) {
                    this.openRemoteDatabase(network);
                    if (!network.tryLock()) continue;
                }
                object = operation.execute(network, session);
                return (T)object;
            }
            catch (ODistributedRedirectException e) {
                this.connectionManager.release(network);
                OLogManager.instance().debug((Object)this, "Redirecting the request from server '%s' to the server '%s' because %s", new Object[]{e.getFromServer(), e.toString(), e.getMessage()});
                serverUrl = e.getToServerAddress();
                continue;
            }
            catch (OModificationOperationProhibitedException mope) {
                this.connectionManager.release(network);
                this.handleDBFreeze();
                serverUrl = null;
                continue;
            }
            catch (OTokenException e) {
                this.connectionManager.release(network);
                session.removeServerSession(network.getServerURL());
                if (--retry <= 0) {
                    throw OException.wrapException((OException)new OStorageException(errorMessage), (Throwable)e);
                }
                serverUrl = null;
                continue;
            }
            catch (OTokenSecurityException e) {
                this.connectionManager.release(network);
                session.removeServerSession(network.getServerURL());
                if (--retry <= 0) {
                    throw OException.wrapException((OException)new OStorageException(errorMessage), (Throwable)e);
                }
                serverUrl = null;
                continue;
            }
            catch (OOfflineNodeException e) {
                this.connectionManager.release(network);
                object = this.serverURLs;
                synchronized (object) {
                    this.serverURLs.remove(serverUrl);
                }
                for (OStorageRemoteSession activeSession : this.sessions) {
                    activeSession.removeServerSession(serverUrl);
                }
                serverUrl = null;
                continue;
            }
            catch (IOException e) {
                this.connectionManager.release(network);
                retry = this.handleIOException(retry, network, e);
                serverUrl = null;
                continue;
            }
            catch (OIOException e) {
                this.connectionManager.release(network);
                retry = this.handleIOException(retry, network, (Exception)((Object)e));
                serverUrl = null;
                continue;
            }
            catch (OException e) {
                this.connectionManager.release(network);
                throw e;
            }
            catch (Exception e) {
                this.connectionManager.release(network);
                throw OException.wrapException((OException)new OStorageException(errorMessage), (Throwable)e);
            }
            finally {
                session.commandExecuting = false;
                continue;
            }
            break;
        }
    }

    private int handleIOException(int retry, OChannelBinaryAsynchClient network, Exception e) {
        OLogManager.instance().info((Object)this, "Caught Network I/O errors on %s, trying an automatic reconnection... (error: %s)", new Object[]{network.getServerURL(), e.getMessage()});
        OLogManager.instance().debug((Object)this, "I/O error stack: ", (Throwable)e, new Object[0]);
        this.connectionManager.remove(network);
        if (--retry <= 0) {
            throw OException.wrapException((OException)((Object)new OIOException(e.getMessage())), (Throwable)e);
        }
        try {
            Thread.sleep(this.connectionRetryDelay);
        }
        catch (InterruptedException e1) {
            throw OException.wrapException((OException)new OInterruptedException(e1.getMessage()), (Throwable)e);
        }
        return retry;
    }

    public boolean isAssigningClusterIds() {
        return false;
    }

    public int getSessionId() {
        OStorageRemoteSession session = this.getCurrentSession();
        return session != null ? session.getSessionId() : -1;
    }

    public String getServerURL() {
        OStorageRemoteSession session = this.getCurrentSession();
        return session != null ? session.getServerUrl() : null;
    }

    public void open(String iUserName, String iUserPassword, OContextConfiguration conf) {
        this.stateLock.acquireWriteLock();
        this.addUser();
        try {
            OStorageRemoteSession session = this.getCurrentSession();
            if (this.status == OStorage.STATUS.CLOSED || !iUserName.equals(session.connectionUserName) || !iUserPassword.equals(session.connectionUserPassword) || session.sessions.isEmpty()) {
                OCredentialInterceptor ci = OSecurityManager.instance().newCredentialInterceptor();
                if (ci != null) {
                    ci.intercept(this.getURL(), iUserName, iUserPassword);
                    session.connectionUserName = ci.getUsername();
                    session.connectionUserPassword = ci.getPassword();
                } else {
                    session.connectionUserName = iUserName;
                    session.connectionUserPassword = iUserPassword;
                }
                String strategy = conf.getValueAsString(OGlobalConfiguration.CLIENT_CONNECTION_STRATEGY);
                if (strategy != null) {
                    this.connectionStrategy = CONNECTION_STRATEGY.valueOf(strategy.toUpperCase());
                }
                this.openRemoteDatabase();
                OStorageRemoteConfiguration storageConfiguration = new OStorageRemoteConfiguration(this, ORecordSerializerFactory.instance().getDefaultRecordSerializer().toString());
                storageConfiguration.load(conf);
                this.configuration = storageConfiguration;
                this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
            } else {
                this.reopenRemoteDatabase();
            }
        }
        catch (Exception e) {
            this.removeUser();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw OException.wrapException((OException)new OStorageException("Cannot open the remote storage: " + this.name), (Throwable)e);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    public OSBTreeCollectionManager getSBtreeCollectionManager() {
        return this.sbTreeCollectionManager;
    }

    public void reload() {
        OReloadRequest request = new OReloadRequest();
        OReloadResponse response = this.networkOperation(request, "Error on reloading database information");
        this.updateStorageInformations(response.getClusters());
    }

    public void create(OContextConfiguration contextConfiguration) {
        throw new UnsupportedOperationException("Cannot create a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    public boolean exists() {
        throw new UnsupportedOperationException("Cannot check the existence of a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean iForce, boolean onDelete) {
        if (this.status == OStorage.STATUS.CLOSED) {
            return;
        }
        this.stateLock.acquireWriteLock();
        try {
            if (this.status == OStorage.STATUS.CLOSED) {
                return;
            }
            OStorageRemoteSession session = this.getCurrentSession();
            if (session != null) {
                Collection<OStorageRemoteNodeSession> nodes = session.getAllServerSessions();
                if (!nodes.isEmpty()) {
                    for (OStorageRemoteNodeSession nodeSession : nodes) {
                        OChannelBinaryAsynchClient network = null;
                        try {
                            network = this.getNetwork(nodeSession.getServerURL());
                            OCloseRequest request = new OCloseRequest();
                            network.beginRequest(request.getCommand(), session);
                            request.write((OChannelDataOutput)network, session);
                            this.endRequest(network);
                            this.connectionManager.release(network);
                        }
                        catch (OIOException ex) {
                            OLogManager.instance().debug((Object)this, "Impossible to comunicate to the server for close: %s", (Throwable)ex, new Object[0]);
                            this.connectionManager.remove(network);
                        }
                        catch (IOException ex) {
                            OLogManager.instance().debug((Object)this, "Impossible to comunicate to the server for close: %s", (Throwable)ex, new Object[0]);
                            this.connectionManager.remove(network);
                        }
                    }
                    session.close();
                    this.sessions.remove(session);
                    if (!this.checkForClose(iForce)) {
                        return;
                    }
                } else if (!iForce) {
                    return;
                }
            }
            this.status = OStorage.STATUS.CLOSING;
            for (String url : this.serverURLs) {
                this.connectionManager.closePool(url);
            }
            this.sbTreeCollectionManager.close();
            super.close(iForce, onDelete);
            this.status = OStorage.STATUS.CLOSED;
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    private boolean checkForClose(boolean force) {
        if (this.status == OStorage.STATUS.CLOSED) {
            return false;
        }
        if (this.status == OStorage.STATUS.CLOSED) {
            return false;
        }
        int remainingUsers = this.getUsers() > 0 ? this.removeUser() : 0;
        return force || remainingUsers == 0;
    }

    public int getUsers() {
        return this.users.get();
    }

    public int addUser() {
        return this.users.incrementAndGet();
    }

    public int removeUser() {
        if (this.users.get() < 1) {
            throw new IllegalStateException("Cannot remove user of the remote storage '" + this.toString() + "' because no user is using it");
        }
        return this.users.decrementAndGet();
    }

    public void delete() {
        throw new UnsupportedOperationException("Cannot delete a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    public Set<String> getClusterNames() {
        this.stateLock.acquireReadLock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.clusterMap.keySet());
            return hashSet;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public OStorageOperationResult<OPhysicalPosition> createRecord(ORecordId iRid, byte[] iContent, int iRecordVersion, byte iRecordType, int iMode, ORecordCallback<Long> iCallback) {
        OSBTreeCollectionManager collectionManager = ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager();
        ORecordCallback realCallback = null;
        if (iCallback != null) {
            realCallback = (iRID, response) -> {
                iCallback.call(response.getIdentity(), (Object)response.getIdentity().getClusterPosition());
                this.updateCollectionsFromChanges(collectionManager, response.getChangedIds());
            };
        }
        OPhysicalPosition ppos = new OPhysicalPosition(iRecordType);
        OCreateRecordRequest request = new OCreateRecordRequest(iContent, iRid, iRecordType);
        OCreateRecordResponse response2 = this.asyncNetworkOperation(request, iMode, iRid, realCallback, "Error on create record in cluster " + iRid.getClusterId());
        if (response2 != null) {
            ppos.clusterPosition = response2.getIdentity().getClusterPosition();
            ppos.recordVersion = response2.getVersion();
            if (iMode == 0) {
                iRid.setClusterId(response2.getIdentity().getClusterId());
                iRid.setClusterPosition(response2.getIdentity().getClusterPosition());
            }
            this.updateCollectionsFromChanges(collectionManager, response2.getChangedIds());
        }
        return new OStorageOperationResult((Object)ppos);
    }

    private void updateCollectionsFromChanges(OSBTreeCollectionManager collectionManager, Map<UUID, OBonsaiCollectionPointer> changes) {
        if (collectionManager != null) {
            for (Map.Entry<UUID, OBonsaiCollectionPointer> coll : changes.entrySet()) {
                collectionManager.updateCollectionPointer(coll.getKey(), coll.getValue());
            }
            if (ORecordSerializationContext.getDepth() <= 1) {
                collectionManager.clearPendingCollections();
            }
        }
    }

    public ORecordMetadata getRecordMetadata(ORID rid) {
        OGetRecordMetadataRequest request = new OGetRecordMetadataRequest(rid);
        OGetRecordMetadataResponse response = this.networkOperation(request, "Error on record metadata read " + rid);
        return response.getMetadata();
    }

    public OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(ORecordId rid, String fetchPlan, boolean ignoreCache, int recordVersion) throws ORecordNotFoundException {
        if (this.getCurrentSession().commandExecuting) {
            return new OStorageOperationResult(null);
        }
        OReadRecordIfVersionIsNotLatestRequest request = new OReadRecordIfVersionIsNotLatestRequest(rid, recordVersion, fetchPlan, ignoreCache);
        OReadRecordIfVersionIsNotLatestResponse response = this.networkOperation(request, "Error on read record " + rid);
        return new OStorageOperationResult((Object)response.getResult());
    }

    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, boolean prefetchRecords, ORecordCallback<ORawBuffer> iCallback) {
        if (this.getCurrentSession().commandExecuting) {
            return new OStorageOperationResult(null);
        }
        OReadRecordRequest request = new OReadRecordRequest(iIgnoreCache, iRid, iFetchPlan, false);
        OReadRecordResponse response = this.networkOperation(request, "Error on read record " + iRid);
        return new OStorageOperationResult((Object)response.getResult());
    }

    public String incrementalBackup(String backupDirectory) {
        OIncrementalBackupRequest request = new OIncrementalBackupRequest(backupDirectory);
        OIncrementalBackupResponse response = this.networkOperation(request, "Error on incremental backup");
        return response.getFileName();
    }

    public void restoreFromIncrementalBackup(String filePath) {
        throw new UnsupportedOperationException("This operations is part of internal API and is not supported in remote storage");
    }

    public OStorageOperationResult<Integer> updateRecord(ORecordId iRid, boolean updateContent, byte[] iContent, int iVersion, byte iRecordType, int iMode, ORecordCallback<Integer> iCallback) {
        OSBTreeCollectionManager collectionManager = ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager();
        ORecordCallback realCallback = null;
        if (iCallback != null) {
            realCallback = (iRID, response) -> {
                iCallback.call(iRID, (Object)response.getVersion());
                this.updateCollectionsFromChanges(collectionManager, response.getChanges());
            };
        }
        OUpdateRecordRequest request = new OUpdateRecordRequest(iRid, iContent, iVersion, updateContent, iRecordType);
        OUpdateRecordResponse response2 = this.asyncNetworkOperation(request, iMode, iRid, realCallback, "Error on update record " + iRid);
        Integer resVersion = null;
        if (response2 != null) {
            resVersion = response2.getVersion();
            this.updateCollectionsFromChanges(collectionManager, response2.getChanges());
        }
        return new OStorageOperationResult((Object)resVersion);
    }

    public OStorageOperationResult<Integer> recyclePosition(ORecordId iRecordId, byte[] iContent, int iVersion, byte recordType) {
        throw new UnsupportedOperationException("recyclePosition");
    }

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRid, int iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        ORecordCallback realCallback = null;
        if (iCallback != null) {
            realCallback = (iRID, response) -> iCallback.call(iRID, (Object)response.getResult());
        }
        ODeleteRecordRequest request = new ODeleteRecordRequest(iRid, iVersion);
        ODeleteRecordResponse response2 = this.asyncNetworkOperation(request, iMode, iRid, realCallback, "Error on delete record " + iRid);
        Boolean resDelete = null;
        if (response2 != null) {
            resDelete = response2.getResult();
        }
        return new OStorageOperationResult((Object)resDelete);
    }

    public OStorageOperationResult<Boolean> hideRecord(ORecordId recordId, int mode, ORecordCallback<Boolean> callback) {
        ORecordCallback realCallback = null;
        if (callback != null) {
            realCallback = (iRID, response) -> callback.call(iRID, (Object)response.getResult());
        }
        OHideRecordRequest request = new OHideRecordRequest(recordId);
        OHideRecordResponse response2 = this.asyncNetworkOperation(request, mode, recordId, realCallback, "Error on hide record " + recordId);
        Boolean resHide = null;
        if (response2 != null) {
            resHide = response2.getResult();
        }
        return new OStorageOperationResult((Object)resHide);
    }

    public boolean cleanOutRecord(ORecordId recordId, int recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        ORecordCallback realCallback = null;
        if (callback != null) {
            realCallback = (iRID, response) -> callback.call(iRID, (Object)response.getResult());
        }
        OCleanOutRecordRequest request = new OCleanOutRecordRequest(recordVersion, recordId);
        OCleanOutRecordResponse response2 = this.asyncNetworkOperation(request, iMode, recordId, realCallback, "Error on delete record " + recordId);
        Boolean result = null;
        if (response2 != null) {
            result = response2.getResult();
        }
        return result;
    }

    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        throw new UnsupportedOperationException("backup is not supported against remote storage. Open the database with plocal or use the incremental backup in the Enterprise Edition");
    }

    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        throw new UnsupportedOperationException("restore is not supported against remote storage. Open the database with plocal or use Enterprise Edition");
    }

    public OContextConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public long count(int iClusterId) {
        return this.count(new int[]{iClusterId});
    }

    public long count(int iClusterId, boolean countTombstones) {
        return this.count(new int[]{iClusterId}, countTombstones);
    }

    public long[] getClusterDataRange(int iClusterId) {
        OGetClusterDataRangeRequest request = new OGetClusterDataRangeRequest(iClusterId);
        OGetClusterDataRangeResponse response = this.networkOperation(request, "Error on getting last entry position count in cluster: " + iClusterId);
        return response.getPos();
    }

    public OPhysicalPosition[] higherPhysicalPositions(int iClusterId, OPhysicalPosition iClusterPosition) {
        OHigherPhysicalPositionsRequest request = new OHigherPhysicalPositionsRequest(iClusterId, iClusterPosition);
        OHigherPhysicalPositionsResponse response = this.networkOperation(request, "Error on retrieving higher positions after " + iClusterPosition.clusterPosition);
        return response.getNextPositions();
    }

    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        OCeilingPhysicalPositionsRequest request = new OCeilingPhysicalPositionsRequest(clusterId, physicalPosition);
        OCeilingPhysicalPositionsResponse response = this.networkOperation(request, "Error on retrieving ceiling positions after " + physicalPosition.clusterPosition);
        return response.getPositions();
    }

    public OPhysicalPosition[] lowerPhysicalPositions(int iClusterId, OPhysicalPosition physicalPosition) {
        OLowerPhysicalPositionsRequest request = new OLowerPhysicalPositionsRequest(physicalPosition, iClusterId);
        OLowerPhysicalPositionsResponse response = this.networkOperation(request, "Error on retrieving lower positions after " + physicalPosition.clusterPosition);
        return response.getPreviousPositions();
    }

    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        OFloorPhysicalPositionsRequest request = new OFloorPhysicalPositionsRequest(physicalPosition, clusterId);
        OFloorPhysicalPositionsResponse response = this.networkOperation(request, "Error on retrieving floor positions after " + physicalPosition.clusterPosition);
        return response.getPositions();
    }

    public long getSize() {
        OGetSizeRequest request = new OGetSizeRequest();
        OGetSizeResponse response = this.networkOperation(request, "Error on read database size");
        return response.getSize();
    }

    public long countRecords() {
        OCountRecordsRequest request = new OCountRecordsRequest();
        OCountRecordsResponse response = this.networkOperation(request, "Error on read database record count");
        return response.getCountRecords();
    }

    public long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    public long count(int[] iClusterIds, boolean countTombstones) {
        OCountRequest request = new OCountRequest(iClusterIds, countTombstones);
        OCountResponse response = this.networkOperation(request, "Error on read record count in clusters: " + Arrays.toString(iClusterIds));
        return response.getCount();
    }

    public Object command(OCommandRequestText iCommand) {
        boolean live = iCommand instanceof OLiveQuery;
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.get();
        boolean asynch = iCommand instanceof OCommandRequestAsynch && ((OCommandRequestAsynch)iCommand).isAsynchronous();
        OCommandRequest request = new OCommandRequest(database, asynch, iCommand, live);
        OCommandResponse response = this.networkOperation(request, "Error on executing command: " + iCommand);
        return response.getResult();
    }

    public ORemoteQueryResult query(ODatabase db, String query, Object[] args) {
        OQueryRequest request = new OQueryRequest("sql", query, args, true, ((ODatabaseDocumentInternal)db).getSerializer(), 100);
        OQueryResponse response = this.networkOperation(request, "Error on executing command: " + query);
        return new ORemoteQueryResult(response.getResult(), response.isTxChanges());
    }

    public ORemoteQueryResult query(ODatabase db, String query, Map args) {
        OQueryRequest request = new OQueryRequest("sql", query, args, true, ((ODatabaseDocumentInternal)db).getSerializer(), 100);
        OQueryResponse response = this.networkOperation(request, "Error on executing command: " + query);
        return new ORemoteQueryResult(response.getResult(), response.isTxChanges());
    }

    public ORemoteQueryResult command(ODatabase db, String language, String query, Object[] args) {
        OQueryRequest request = new OQueryRequest(language, query, args, false, ((ODatabaseDocumentInternal)db).getSerializer(), 100);
        OQueryResponse response = this.networkOperation(request, "Error on executing command: " + query);
        return new ORemoteQueryResult(response.getResult(), response.isTxChanges());
    }

    public ORemoteQueryResult command(ODatabase db, String language, String query, Map args) {
        OQueryRequest request = new OQueryRequest(language, query, args, false, ((ODatabaseDocumentInternal)db).getSerializer(), 100);
        OQueryResponse response = this.networkOperation(request, "Error on executing command: " + query);
        return new ORemoteQueryResult(response.getResult(), response.isTxChanges());
    }

    public void closeQuery(ODatabaseDocumentRemote database, String queryId) {
        OCloseQueryRequest request = new OCloseQueryRequest(queryId);
        OCloseQueryResponse response = this.networkOperation(request, "Error closing query: " + queryId);
    }

    public void fetchNextPage(ODatabaseDocumentRemote database, ORemoteResultSet rs) {
        OQueryNextPageRequest request = new OQueryNextPageRequest(rs.getQueryId(), 100);
        OQueryResponse response = this.networkOperation(request, "Error on fetching next page for statment: " + rs.getQueryId());
        ORemoteResultSet remoteRs = (ORemoteResultSet)response.getResult();
        rs.setCurrentPage(remoteRs.getCurrentPage());
        rs.setHasNextPage(remoteRs.hasNextPage());
        Map<String, Long> newQueryStats = remoteRs.getQueryStats();
        if (newQueryStats != null) {
            rs.setQueryStats(newQueryStats);
        }
        remoteRs.getExecutionPlan().ifPresent(x -> rs.setExecutionPlan((OExecutionPlan)x));
    }

    public List<ORecordOperation> commit(OTransaction iTx, Runnable callback) {
        OCommit37Request request = ((OTransactionOptimistic)iTx).isChanged() ? new OCommit37Request(iTx.getId(), true, iTx.isUsingLog(), iTx.getAllRecordEntries(), ((OTransactionOptimistic)iTx).getIndexEntries()) : new OCommit37Request(iTx.getId(), false, iTx.isUsingLog(), null, null);
        OCommitResponse response = this.networkOperation(request, "Error on commit");
        for (OCommitResponse.OCreatedRecordResponse created : response.getCreated()) {
            iTx.updateIdentityAfterCommit((ORID)created.getCurrentRid(), (ORID)created.getCreatedRid());
        }
        for (OCommitResponse.OUpdatedRecordResponse updated : response.getUpdated()) {
            ORecordOperation rop = iTx.getRecordEntry((ORID)updated.getRid());
            if (rop == null) continue;
            if (updated.getVersion() > rop.getRecord().getVersion() + 1) {
                rop.getRecord().unload();
            }
            ORecordInternal.setVersion((ORecord)rop.getRecord(), (int)updated.getVersion());
        }
        this.updateCollectionsFromChanges(ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager(), response.getCollectionChanges());
        for (ORecordOperation txEntry : iTx.getAllRecordEntries()) {
            ORecordInternal.unsetDirty((ORecord)txEntry.getRecord());
        }
        OTransactionAbstract.updateCacheFromEntries((OTransaction)iTx, (Iterable)iTx.getAllRecordEntries(), (boolean)true);
        return null;
    }

    public void rollback(OTransaction iTx) {
        if (((OTransactionOptimistic)iTx).isAlreadyCleared()) {
            ORollbackTransactionRequest request = new ORollbackTransactionRequest(iTx.getId());
            ORollbackTransactionResponse oRollbackTransactionResponse = this.networkOperation(request, "Error on fetching next page for statment: " + request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusterIdByName(String iClusterName) {
        this.stateLock.acquireReadLock();
        try {
            if (iClusterName == null) {
                int n = -1;
                return n;
            }
            if (Character.isDigit(iClusterName.charAt(0))) {
                int n = Integer.parseInt(iClusterName);
                return n;
            }
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
            if (cluster == null) {
                int n = -1;
                return n;
            }
            int n = cluster.getId();
            return n;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    public int addCluster(String iClusterName, boolean forceListBased, Object ... iArguments) {
        return this.addCluster(iClusterName, -1, forceListBased, iArguments);
    }

    public int addCluster(String iClusterName, int iRequestedId, boolean forceListBased, Object ... iParameters) {
        OAddClusterRequest request = new OAddClusterRequest(iRequestedId, iClusterName);
        OAddClusterResponse response = this.networkOperation(request, "Error on add new cluster");
        this.addNewClusterToConfiguration(response.getClusterId(), iClusterName);
        return response.getClusterId();
    }

    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        ODropClusterRequest request = new ODropClusterRequest(iClusterId);
        ODropClusterResponse response = this.networkOperation(request, "Error on removing of cluster");
        if (response.getResult()) {
            this.removeClusterFromConfiguration(iClusterId);
        }
        return response.getResult();
    }

    public void removeClusterFromConfiguration(int iClusterId) {
        this.stateLock.acquireWriteLock();
        try {
            OCluster cluster = this.clusters[iClusterId];
            this.clusters[iClusterId] = null;
            this.clusterMap.remove(cluster.getName());
            if (this.configuration.clusters.size() > iClusterId) {
                this.configuration.dropCluster(iClusterId);
            }
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    public void synch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPhysicalClusterNameById(int iClusterId) {
        this.stateLock.acquireReadLock();
        try {
            if (iClusterId >= this.clusters.length) {
                String string = null;
                return string;
            }
            OCluster cluster = this.clusters[iClusterId];
            String string = cluster != null ? cluster.getName() : null;
            return string;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public int getClusterMap() {
        this.stateLock.acquireReadLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public Collection<OCluster> getClusterInstances() {
        this.stateLock.acquireReadLock();
        try {
            List<OCluster> list = Arrays.asList(this.clusters);
            return list;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public OCluster getClusterById(int iClusterId) {
        this.stateLock.acquireReadLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            OCluster oCluster = this.clusters[iClusterId];
            return oCluster;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public long getVersion() {
        throw new UnsupportedOperationException("getVersion");
    }

    public ODocument getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    public void endRequest(OChannelBinaryAsynchClient iNetwork) throws IOException {
        if (iNetwork == null) {
            return;
        }
        iNetwork.flush();
        iNetwork.releaseWriteLock();
    }

    public void endResponse(OChannelBinaryAsynchClient iNetwork) throws IOException {
        iNetwork.endResponse();
    }

    public boolean isRemote() {
        return true;
    }

    public boolean isPermanentRequester() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterConfiguration(String iConnectedURL, byte[] obj) {
        List members;
        if (obj == null) {
            return;
        }
        OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.setValue((Object)Integer.MAX_VALUE);
        Object object = this.clusterConfiguration;
        synchronized (object) {
            this.clusterConfiguration.fromStream(obj);
            this.clusterConfiguration.toString();
            members = (List)this.clusterConfiguration.field("members");
        }
        object = this.serverURLs;
        synchronized (object) {
            if (members != null) {
                if (iConnectedURL != null) {
                    this.addHost(iConnectedURL);
                }
                for (ODocument m : members) {
                    Collection listeners;
                    if (m == null) continue;
                    String nodeStatus = (String)m.field("status");
                    if (m == null || "OFFLINE".equals(nodeStatus) || (listeners = (Collection)m.field("listeners")) == null) continue;
                    for (Map listener : listeners) {
                        String url;
                        if (!((String)listener.get("protocol")).equals("ONetworkProtocolBinary") || this.serverURLs.contains(url = (String)listener.get("listen"))) continue;
                        this.addHost(url);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessions(String url) {
        List<String> list = this.serverURLs;
        synchronized (list) {
            this.serverURLs.remove(url);
        }
        for (OStorageRemoteSession session : this.sessions) {
            session.removeServerSession(url + "/" + this.getName());
        }
    }

    public OCluster getClusterByName(String iClusterName) {
        throw new UnsupportedOperationException("getClusterByName()");
    }

    public ORecordConflictStrategy getConflictStrategy() {
        throw new UnsupportedOperationException("getConflictStrategy");
    }

    public void setConflictStrategy(ORecordConflictStrategy iResolver) {
        throw new UnsupportedOperationException("setConflictStrategy");
    }

    public String getURL() {
        return "remote:" + this.url;
    }

    public int getClusters() {
        this.stateLock.acquireReadLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public String getType() {
        return "remote";
    }

    public String getUserName() {
        OStorageRemoteSession session = this.getCurrentSession();
        if (session == null) {
            return null;
        }
        return session.connectionUserName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String reopenRemoteDatabase() throws IOException {
        String currentURL = this.getCurrentServerURL();
        do {
            String string;
            OChannelBinaryAsynchClient network = this.getNetwork(currentURL);
            OStorageRemoteSession session = this.getCurrentSession();
            OStorageRemoteNodeSession nodeSession = session.getOrCreateServerSession(network.getServerURL());
            if (nodeSession == null || !nodeSession.isValid()) {
                this.openRemoteDatabase(network);
                return network.getServerURL();
            }
            OReopenRequest request = new OReopenRequest();
            try {
                network.writeByte(request.getCommand());
                network.writeInt(nodeSession.getSessionId());
                network.writeBytes(nodeSession.getToken());
                request.write((OChannelDataOutput)network, session);
            }
            finally {
                this.endRequest(network);
            }
            OReopenResponse response = request.createResponse();
            try {
                byte[] newToken = network.beginResponse(nodeSession.getSessionId(), true);
                response.read((OChannelDataInput)network, session);
                if (newToken != null && newToken.length > 0) {
                    nodeSession.setSession(response.getSessionId(), newToken);
                } else {
                    nodeSession.setSession(response.getSessionId(), nodeSession.getToken());
                }
                OLogManager.instance().debug((Object)this, "Client connected to %s with session id=%d", new Object[]{network.getServerURL(), response.getSessionId()});
                string = currentURL;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    this.connectionManager.release(network);
                    throw throwable;
                }
                catch (OIOException e) {
                    if (network != null) {
                        this.connectionManager.remove(network);
                    }
                    OLogManager.instance().error((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
                    continue;
                }
                catch (OOfflineNodeException e) {
                    if (network != null) {
                        this.connectionManager.remove(network);
                    }
                    OLogManager.instance().debug((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
                    continue;
                }
                catch (OSecurityException ex) {
                    OLogManager.instance().debug((Object)this, "Invalidate token for url=%s", (Throwable)ex, new Object[]{currentURL});
                    OStorageRemoteSession session2 = this.getCurrentSession();
                    session2.removeServerSession(currentURL);
                    if (network == null) continue;
                    try {
                        this.connectionManager.remove(network);
                    }
                    catch (Exception e) {
                        OLogManager.instance().debug((Object)this, "Cannot remove connection or database url=" + currentURL, (Throwable)e, new Object[0]);
                    }
                    continue;
                }
                catch (OException e) {
                    this.connectionManager.release(network);
                    throw e;
                }
                catch (Exception e) {
                    OLogManager.instance().debug((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
                    if (network == null) continue;
                    try {
                        this.connectionManager.remove(network);
                        continue;
                    }
                    catch (Exception ex) {
                        OLogManager.instance().debug((Object)this, "Cannot remove connection or database url=" + currentURL, (Throwable)e, new Object[0]);
                    }
                }
            }
            this.endResponse(network);
            this.connectionManager.release(network);
            return string;
        } while (this.connectionManager.getAvailableConnections(currentURL) > 0 || (currentURL = this.useNewServerURL(currentURL)) != null);
        this.parseServerURLs();
        List<String> list = this.serverURLs;
        synchronized (list) {
            throw new OStorageException("Cannot create a connection to remote server address(es): " + this.serverURLs);
        }
    }

    protected synchronized void openRemoteDatabase() throws IOException {
        String currentURL = this.getNextAvailableServerURL(true, this.getCurrentSession());
        this.openRemoteDatabase(currentURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openRemoteDatabase(OChannelBinaryAsynchClient network) throws IOException {
        this.stateLock.acquireWriteLock();
        try {
            OStorageRemoteSession session = this.getCurrentSession();
            OStorageRemoteNodeSession nodeSession = session.getOrCreateServerSession(network.getServerURL());
            OOpenRequest request = new OOpenRequest(this.name, session.connectionUserName, session.connectionUserPassword);
            try {
                network.writeByte(request.getCommand());
                network.writeInt(nodeSession.getSessionId());
                request.write((OChannelDataOutput)network, session);
            }
            finally {
                this.endRequest(network);
            }
            OOpenResponse response = request.createResponse();
            try {
                network.beginResponse(nodeSession.getSessionId(), false);
                response.read((OChannelDataInput)network, session);
            }
            finally {
                this.endResponse(network);
                this.connectionManager.release(network);
            }
            int sessionId = response.getSessionId();
            byte[] token = response.getSessionToken();
            if (token.length == 0) {
                token = null;
            }
            nodeSession.setSession(sessionId, token);
            OLogManager.instance().debug((Object)this, "Client connected to %s with session id=%d", new Object[]{network.getServerURL(), sessionId});
            OCluster[] cl = response.getClusterIds();
            this.updateStorageInformations(cl);
            this.updateClusterConfiguration(network.getServerURL(), response.getDistributedConfiguration());
            this.status = OStorage.STATUS.OPEN;
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    protected void openRemoteDatabase(String currentURL) {
        do {
            OChannelBinaryAsynchClient network = null;
            try {
                network = this.getNetwork(currentURL);
                short serverVersion = network.getSrvProtocolVersion();
                this.openRemoteDatabase(network);
                return;
            }
            catch (OIOException e) {
                if (network != null) {
                    this.connectionManager.remove(network);
                }
                OLogManager.instance().debug((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
            }
            catch (OException e) {
                this.connectionManager.release(network);
                throw e;
            }
            catch (Exception e) {
                if (network != null) {
                    try {
                        this.connectionManager.remove(network);
                    }
                    catch (Exception ex) {
                        OLogManager.instance().debug((Object)this, "Cannot remove connection or database url=" + currentURL, (Throwable)e, new Object[0]);
                    }
                }
                OLogManager.instance().error((Object)this, "Cannot open database url=" + currentURL, (Throwable)e, new Object[0]);
            }
        } while (this.connectionManager.getReusableConnections(currentURL) > 0 || (currentURL = this.useNewServerURL(currentURL)) != null);
        this.parseServerURLs();
        List<String> list = this.serverURLs;
        synchronized (list) {
            throw new OStorageException("Cannot create a connection to remote server address(es): " + this.serverURLs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String useNewServerURL(String iUrl) {
        int pos = iUrl.indexOf(47);
        if (pos >= iUrl.length() - 1) {
            pos = -1;
        }
        String postFix = pos > -1 ? iUrl.substring(pos) : "";
        String url = pos > -1 ? iUrl.substring(0, pos) : iUrl;
        List<String> list = this.serverURLs;
        synchronized (list) {
            this.serverURLs.remove(url);
            for (OStorageRemoteSession activeSession : this.sessions) {
                activeSession.removeServerSession(url + "/" + this.getName());
            }
            OLogManager.instance().debug((Object)this, "Updated server list: %s...", new Object[]{this.serverURLs});
            if (!this.serverURLs.isEmpty()) {
                return this.serverURLs.get(0) + postFix;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseServerURLs() {
        String[] stringArray;
        String lastHost = null;
        int dbPos = this.url.indexOf(47);
        if (dbPos == -1) {
            this.addHost(this.url);
            lastHost = this.url;
            this.name = this.url;
        } else {
            this.name = this.url.substring(this.url.lastIndexOf("/") + 1);
            stringArray = this.url.substring(0, dbPos).split(ADDRESS_SEPARATOR);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String host;
                lastHost = host = stringArray[i];
                this.addHost(host);
            }
        }
        stringArray = this.serverURLs;
        synchronized (this.serverURLs) {
            if (this.serverURLs.size() == 1 && this.getClientConfiguration().getValueAsBoolean(OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_ENABLED)) {
                String primaryServer = lastHost;
                OLogManager.instance().debug((Object)this, "Retrieving URLs from DNS '%s' (timeout=%d)...", new Object[]{primaryServer, this.getClientConfiguration().getValueAsInteger(OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT)});
                try {
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                    env.put("com.sun.jndi.ldap.connect.timeout", this.getClientConfiguration().getValueAsString(OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT));
                    InitialDirContext ictx = new InitialDirContext(env);
                    String hostName = !primaryServer.contains(":") ? primaryServer : primaryServer.substring(0, primaryServer.indexOf(":"));
                    Attributes attrs = ictx.getAttributes(hostName, new String[]{"TXT"});
                    Attribute attr = attrs.get("TXT");
                    if (attr != null) {
                        for (int i = 0; i < attr.size(); ++i) {
                            String[] parts;
                            String configuration = (String)attr.get(i);
                            if (configuration.startsWith("\"")) {
                                configuration = configuration.substring(1, configuration.length() - 1);
                            }
                            if (configuration == null) continue;
                            this.serverURLs.clear();
                            for (String part : parts = configuration.split(" ")) {
                                if (!part.startsWith("s=")) continue;
                                this.addHost(part.substring("s=".length()));
                            }
                        }
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addHost(String host) {
        if (host.startsWith("localhost")) {
            host = LOCAL_IP + host.substring("localhost".length());
        }
        if (host.contains("/")) {
            host = host.substring(0, host.indexOf("/"));
        }
        if (!host.contains(":")) {
            host = host + ":" + (this.clientConfiguration.getValueAsBoolean(OGlobalConfiguration.CLIENT_USE_SSL) ? this.getDefaultSSLPort() : this.getDefaultPort());
        } else if (host.split(":").length < 2 || host.split(":")[1].trim().length() == 0) {
            host = host + (this.clientConfiguration.getValueAsBoolean(OGlobalConfiguration.CLIENT_USE_SSL) ? this.getDefaultSSLPort() : this.getDefaultPort());
        }
        List<String> list = this.serverURLs;
        synchronized (list) {
            if (!this.serverURLs.contains(host)) {
                this.serverURLs.add(host);
                OLogManager.instance().debug((Object)this, "Registered the new available server '%s'", new Object[]{host});
            }
        }
        return host;
    }

    protected int getDefaultPort() {
        return 2424;
    }

    protected int getDefaultSSLPort() {
        return 2434;
    }

    public OChannelBinaryAsynchClient beginRequest(OChannelBinaryAsynchClient network, byte iCommand, OStorageRemoteSession session) throws IOException {
        network.beginRequest(iCommand, session);
        return network;
    }

    protected String getNextAvailableServerURL(boolean iIsConnectOperation, OStorageRemoteSession session) {
        String url = null;
        switch (this.connectionStrategy) {
            case STICKY: {
                String string = url = session != null ? session.getServerUrl() : null;
                if (url != null) break;
                url = this.getServerURFromList(false, session);
                break;
            }
            case ROUND_ROBIN_CONNECT: {
                if (!iIsConnectOperation) {
                    String string = url = session != null ? session.getServerUrl() : null;
                }
                if (url == null) {
                    url = this.getServerURFromList(iIsConnectOperation, session);
                }
                OLogManager.instance().debug((Object)this, "ROUND_ROBIN_CONNECT: Next remote operation will be executed on server: %s (isConnectOperation=%s)", new Object[]{url, iIsConnectOperation});
                break;
            }
            case ROUND_ROBIN_REQUEST: {
                url = this.getServerURFromList(true, session);
                OLogManager.instance().debug((Object)this, "ROUND_ROBIN_REQUEST: Next remote operation will be executed on server: %s (isConnectOperation=%s)", new Object[]{url, iIsConnectOperation});
                break;
            }
            default: {
                throw new OConfigurationException("Connection mode " + (Object)((Object)this.connectionStrategy) + " is not supported");
            }
        }
        return url;
    }

    protected String getCurrentServerURL() {
        return this.getServerURFromList(false, this.getCurrentSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServerURFromList(boolean iNextAvailable, OStorageRemoteSession session) {
        List<String> list = this.serverURLs;
        synchronized (list) {
            if (this.serverURLs.isEmpty()) {
                this.parseServerURLs();
                if (this.serverURLs.isEmpty()) {
                    throw new OStorageException("Cannot create a connection to remote server because url list is empty");
                }
            }
            int serverURLIndex = session != null ? session.serverURLIndex : 0;
            if (iNextAvailable) {
                ++serverURLIndex;
            }
            if (serverURLIndex < 0 || serverURLIndex >= this.serverURLs.size()) {
                serverURLIndex = 0;
            }
            String serverURL = this.serverURLs.get(serverURLIndex) + "/" + this.getName();
            if (session != null) {
                session.serverURLIndex = serverURLIndex;
            }
            return serverURL;
        }
    }

    public OChannelBinaryAsynchClient getNetwork(String iCurrentURL) {
        OChannelBinaryAsynchClient network;
        do {
            try {
                network = this.connectionManager.acquire(iCurrentURL, this.clientConfiguration, this.asynchEventListener);
            }
            catch (OIOException cause) {
                throw cause;
            }
            catch (Exception cause) {
                throw OException.wrapException((OException)new OStorageException("Cannot open a connection to remote server: " + iCurrentURL), (Throwable)cause);
            }
            if (network.tryLock()) continue;
            OLogManager.instance().error((Object)this, "Removing locked network channel '%s' (connected=%s)...", new Object[]{iCurrentURL, network.isConnected()});
            this.connectionManager.remove(network);
            network = null;
        } while (network == null);
        return network;
    }

    public void beginResponse(OChannelBinaryAsynchClient iNetwork, OStorageRemoteSession session) throws IOException {
        OStorageRemoteNodeSession nodeSession = session.getServerSession(iNetwork.getServerURL());
        byte[] newToken = iNetwork.beginResponse(nodeSession.getSessionId(), true);
        if (newToken != null && newToken.length > 0) {
            nodeSession.setSession(nodeSession.getSessionId(), newToken);
        }
    }

    private boolean handleDBFreeze() {
        OLogManager.instance().warn((Object)this, "DB is frozen will wait for " + this.getClientConfiguration().getValue(OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT) + " ms. and then retry.", new Object[0]);
        boolean retry = true;
        try {
            Thread.sleep(this.getClientConfiguration().getValueAsInteger(OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT));
        }
        catch (InterruptedException ie) {
            retry = false;
            Thread.currentThread().interrupt();
        }
        return retry;
    }

    public void updateStorageInformations(OCluster[] clusters) {
        this.stateLock.acquireWriteLock();
        try {
            this.clusters = clusters;
            this.clusterMap.clear();
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null) continue;
                this.clusterMap.put(clusters[i].getName(), clusters[i]);
            }
            OCluster defaultCluster = this.clusterMap.get("default");
            if (defaultCluster != null) {
                this.defaultClusterId = this.clusterMap.get("default").getId();
            }
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    protected OStorageRemoteSession getCurrentSession() {
        ODatabaseDocumentRemote remote;
        ODatabaseDocumentInternal db = null;
        if (ODatabaseRecordThreadLocal.INSTANCE != null) {
            db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        }
        if ((remote = (ODatabaseDocumentRemote)ODatabaseDocumentTxInternal.getInternal(db)) == null) {
            return null;
        }
        OStorageRemoteSession session = remote.getSessionMetadata();
        if (session == null) {
            session = new OStorageRemoteSession(sessionSerialId.decrementAndGet());
            this.sessions.add(session);
            remote.setSessionMetadata(session);
        }
        return session;
    }

    public boolean isClosed() {
        if (super.isClosed()) {
            return true;
        }
        OStorageRemoteSession session = this.getCurrentSession();
        if (session == null) {
            return false;
        }
        return session.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageRemote copy(ODatabaseDocumentRemote source, ODatabaseDocumentRemote dest) {
        ODatabaseDocumentInternal origin = null;
        if (ODatabaseRecordThreadLocal.INSTANCE != null) {
            origin = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        }
        origin = ODatabaseDocumentTxInternal.getInternal(origin);
        OStorageRemoteSession session = source.getSessionMetadata();
        if (session != null) {
            OStorageRemoteSession newSession = new OStorageRemoteSession(sessionSerialId.decrementAndGet());
            newSession.connectionUserName = session.connectionUserName;
            newSession.connectionUserPassword = session.connectionUserPassword;
            dest.setSessionMetadata(newSession);
        }
        try {
            dest.activateOnCurrentThread();
            this.openRemoteDatabase();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ODatabaseRecordThreadLocal.INSTANCE.set(origin);
        }
        return this;
    }

    public void importDatabase(String options, InputStream inputStream, String name, OCommandOutputListener listener) {
        OImportRequest request = new OImportRequest(inputStream, options, name);
        OImportResponse response = this.networkOperationRetryTimeout(request, "Error sending import request", 0, this.getClientConfiguration().getValueAsInteger(OGlobalConfiguration.NETWORK_REQUEST_TIMEOUT));
        for (String message : response.getMessages()) {
            listener.onMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewClusterToConfiguration(int clusterId, String iClusterName) {
        this.stateLock.acquireWriteLock();
        try {
            OClusterRemote cluster = new OClusterRemote();
            cluster.configure((OStorage)this, clusterId, iClusterName.toLowerCase(), new Object[0]);
            if (this.clusters.length <= clusterId) {
                this.clusters = Arrays.copyOf(this.clusters, clusterId + 1);
            }
            this.clusters[cluster.getId()] = cluster;
            this.clusterMap.put(cluster.getName().toLowerCase(), cluster);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    public void beginTransaction(ODatabaseDocumentRemote database, OTransactionOptimistic transaction) {
        OBeginTransactionRequest request = new OBeginTransactionRequest(transaction.getId(), transaction.isUsingLog(), transaction.getAllRecordEntries(), transaction.getIndexEntries());
        OBinaryResponse response = this.networkOperation(request, "Error on remote treansaction begin");
    }

    public void reBeginTransaction(ODatabaseDocumentRemote database, OTransactionOptimistic transaction) {
        ORebeginTransactionRequest request = new ORebeginTransactionRequest(transaction.getId(), transaction.isUsingLog(), transaction.getAllRecordEntries(), transaction.getIndexEntries());
        OBinaryResponse response = this.networkOperation(request, "Error on remote treansaction begin");
    }

    public void fetchTransaction(ODatabaseDocumentRemote remote) {
        OTransactionOptimisticClient transaction = (OTransactionOptimisticClient)remote.getTransaction();
        OFetchTransactionRequest request = new OFetchTransactionRequest(transaction.getId());
        OFetchTransactionResponse respose = this.networkOperation(request, "Error fetching transaction from server side");
        transaction.replaceContent(respose.getOperations(), respose.getIndexChanges());
    }

    public static enum CONNECTION_STRATEGY {
        STICKY,
        ROUND_ROBIN_CONNECT,
        ROUND_ROBIN_REQUEST;

    }
}

