/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OBeginTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.tx.IndexChange;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetwork;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OBeginTransactionRequest
implements OBinaryRequest<OBinaryResponse> {
    private int txId;
    private boolean usingLog;
    private List<ORecordOperationRequest> operations;
    private List<IndexChange> indexChanges;

    public OBeginTransactionRequest(int txId, boolean usingLog, Iterable<ORecordOperation> operations, Map<String, OTransactionIndexChanges> indexChanges) {
        this.txId = txId;
        this.usingLog = usingLog;
        this.indexChanges = new ArrayList<IndexChange>();
        ArrayList<ORecordOperationRequest> netOperations = new ArrayList<ORecordOperationRequest>();
        for (ORecordOperation oRecordOperation : operations) {
            if (oRecordOperation.type == 0) continue;
            ORecordOperationRequest request = new ORecordOperationRequest();
            request.setType(oRecordOperation.type);
            request.setVersion(oRecordOperation.getRecord().getVersion());
            request.setId(oRecordOperation.getRecord().getIdentity());
            request.setRecordType(ORecordInternal.getRecordType((ORecord)oRecordOperation.getRecord()));
            switch (oRecordOperation.type) {
                case 1: 
                case 3: {
                    request.setRecord(oRecordOperation.getRecord());
                    request.setContentChanged(ORecordInternal.isContentChanged((ORecord)oRecordOperation.getRecord()));
                }
            }
            netOperations.add(request);
        }
        this.operations = netOperations;
        for (Map.Entry entry : indexChanges.entrySet()) {
            this.indexChanges.add(new IndexChange((String)entry.getKey(), (OTransactionIndexChanges)entry.getValue()));
        }
    }

    public OBeginTransactionRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        ORecordSerializerNetwork serializer = ORecordSerializerNetwork.INSTANCE;
        network.writeInt(this.txId);
        network.writeBoolean(this.usingLog);
        for (ORecordOperationRequest txEntry : this.operations) {
            OMessageHelper.writeTransactionEntry(network, txEntry, (ORecordSerializer)serializer);
        }
        network.writeByte((byte)0);
        OMessageHelper.writeTransactionIndexChanges(network, serializer, this.indexChanges);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        byte hasEntry;
        assert (serializer instanceof ORecordSerializerNetwork);
        this.txId = channel.readInt();
        this.usingLog = channel.readBoolean();
        this.operations = new ArrayList<ORecordOperationRequest>();
        do {
            if ((hasEntry = channel.readByte()) != 1) continue;
            ORecordOperationRequest entry = OMessageHelper.readTransactionEntry(channel, serializer);
            this.operations.add(entry);
        } while (hasEntry == 1);
        this.indexChanges = OMessageHelper.readTransactionIndexChanges(channel, (ORecordSerializerNetwork)serializer);
    }

    @Override
    public byte getCommand() {
        return 61;
    }

    @Override
    public OBinaryResponse createResponse() {
        return new OBeginTransactionResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeBeginTransaction(this);
    }

    @Override
    public String getDescription() {
        return "Begin Transaction";
    }

    public List<ORecordOperationRequest> getOperations() {
        return this.operations;
    }

    public List<IndexChange> getIndexChanges() {
        return this.indexChanges;
    }

    public int getTxId() {
        return this.txId;
    }

    public boolean isUsingLog() {
        return this.usingLog;
    }
}

