/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OCommitResponse;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class OCommitRequest
implements OBinaryRequest<OCommitResponse> {
    private int txId;
    private boolean usingLong;
    private List<ORecordOperationRequest> operations;
    private ODocument indexChanges;

    public OCommitRequest(int txId, boolean usingLog, Iterable<ORecordOperation> operations, ODocument indexChanges) {
        this.txId = txId;
        this.usingLong = usingLog;
        this.indexChanges = indexChanges;
        ArrayList<ORecordOperationRequest> netOperations = new ArrayList<ORecordOperationRequest>();
        for (ORecordOperation txEntry : operations) {
            if (txEntry.type == 0) continue;
            ORecordOperationRequest request = new ORecordOperationRequest();
            request.setType(txEntry.type);
            request.setVersion(txEntry.getRecord().getVersion());
            request.setId(txEntry.getRecord().getIdentity());
            request.setRecordType(ORecordInternal.getRecordType((ORecord)txEntry.getRecord()));
            switch (txEntry.type) {
                case 1: 
                case 3: {
                    request.setRecord(txEntry.getRecord());
                    request.setContentChanged(ORecordInternal.isContentChanged((ORecord)txEntry.getRecord()));
                }
            }
            netOperations.add(request);
        }
        this.operations = netOperations;
    }

    public OCommitRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        ORecordSerializer serializer = ODatabaseRecordThreadLocal.INSTANCE.get().getSerializer();
        network.writeInt(this.txId);
        network.writeBoolean(this.usingLong);
        for (ORecordOperationRequest txEntry : this.operations) {
            OMessageHelper.writeTransactionEntry(network, txEntry, serializer);
        }
        network.writeByte((byte)0);
        network.writeBytes(this.indexChanges.toStream());
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        byte hasEntry;
        this.txId = channel.readInt();
        this.usingLong = channel.readBoolean();
        this.operations = new ArrayList<ORecordOperationRequest>();
        do {
            if ((hasEntry = channel.readByte()) != 1) continue;
            ORecordOperationRequest entry = OMessageHelper.readTransactionEntry(channel, serializer);
            this.operations.add(entry);
        } while (hasEntry == 1);
        this.indexChanges = new ODocument(channel.readBytes());
    }

    @Override
    public byte getCommand() {
        return 60;
    }

    @Override
    public String getDescription() {
        return "Transaction commit";
    }

    public ODocument getIndexChanges() {
        return this.indexChanges;
    }

    public List<ORecordOperationRequest> getOperations() {
        return this.operations;
    }

    public int getTxId() {
        return this.txId;
    }

    public boolean isUsingLong() {
        return this.usingLong;
    }

    @Override
    public OCommitResponse createResponse() {
        return new OCommitResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeCommit(this);
    }
}

