/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class OCommitResponse
implements OBinaryResponse {
    private List<OCreatedRecordResponse> created;
    private List<OUpdatedRecordResponse> updated;
    private Map<UUID, OBonsaiCollectionPointer> collectionChanges;

    public OCommitResponse(List<OCreatedRecordResponse> created, List<OUpdatedRecordResponse> updated, Map<UUID, OBonsaiCollectionPointer> collectionChanges) {
        this.created = created;
        this.updated = updated;
        this.collectionChanges = collectionChanges;
    }

    public OCommitResponse() {
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        int createdRecords = network.readInt();
        this.created = new ArrayList<OCreatedRecordResponse>(createdRecords);
        for (int i = 0; i < createdRecords; ++i) {
            ORecordId currentRid = network.readRID();
            ORecordId createdRid = network.readRID();
            this.created.add(new OCreatedRecordResponse(currentRid, createdRid));
        }
        int updatedRecords = network.readInt();
        this.updated = new ArrayList<OUpdatedRecordResponse>(updatedRecords);
        for (int i = 0; i < updatedRecords; ++i) {
            ORecordId rid = network.readRID();
            int version = network.readVersion();
            this.updated.add(new OUpdatedRecordResponse(rid, version));
        }
        this.collectionChanges = OMessageHelper.readCollectionChanges(network);
    }

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        channel.writeInt(this.created.size());
        for (OCreatedRecordResponse createdRecord : this.created) {
            channel.writeRID((ORID)createdRecord.currentRid);
            channel.writeRID((ORID)createdRecord.createdRid);
        }
        channel.writeInt(this.updated.size());
        for (OUpdatedRecordResponse updatedRecord : this.updated) {
            channel.writeRID((ORID)updatedRecord.rid);
            channel.writeVersion(updatedRecord.version);
        }
        if (protocolVersion >= 20) {
            OMessageHelper.writeCollectionChanges(channel, this.collectionChanges);
        }
    }

    public List<OCreatedRecordResponse> getCreated() {
        return this.created;
    }

    public List<OUpdatedRecordResponse> getUpdated() {
        return this.updated;
    }

    public Map<UUID, OBonsaiCollectionPointer> getCollectionChanges() {
        return this.collectionChanges;
    }

    public static class OUpdatedRecordResponse {
        private final ORecordId rid;
        private final int version;

        public OUpdatedRecordResponse(ORecordId rid, int version) {
            this.rid = rid;
            this.version = version;
        }

        public ORecordId getRid() {
            return this.rid;
        }

        public int getVersion() {
            return this.version;
        }
    }

    public static class OCreatedRecordResponse {
        private final ORecordId currentRid;
        private final ORecordId createdRid;

        public OCreatedRecordResponse(ORecordId currentRid, ORecordId createdRid) {
            this.currentRid = currentRid;
            this.createdRid = createdRid;
        }

        public ORecordId getCreatedRid() {
            return this.createdRid;
        }

        public ORecordId getCurrentRid() {
            return this.currentRid;
        }
    }
}

