/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OConnectResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OConnectRequest
implements OBinaryRequest<OConnectResponse> {
    private String username;
    private String password;
    private String driverName = "OrientDB Java";
    private String driverVersion = "3.0.0m1";
    private short protocolVersion = (short)37;
    private String clientId = null;
    private String recordFormat = "onet_ser_v0";
    private boolean tokenBased = true;
    private boolean supportPush = true;
    private boolean collectStats = true;

    public OConnectRequest(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public OConnectRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeString(this.driverName);
        network.writeString(this.driverVersion);
        network.writeShort(this.protocolVersion);
        network.writeString(this.clientId);
        network.writeString(this.recordFormat);
        network.writeBoolean(this.tokenBased);
        network.writeBoolean(this.supportPush);
        network.writeBoolean(this.collectStats);
        network.writeString(this.username);
        network.writeString(this.password);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.driverName = channel.readString();
        this.driverVersion = channel.readString();
        this.protocolVersion = channel.readShort();
        this.clientId = channel.readString();
        this.recordFormat = channel.readString();
        this.tokenBased = this.protocolVersion > 26 ? channel.readBoolean() : false;
        if (this.protocolVersion > 33) {
            this.supportPush = channel.readBoolean();
            this.collectStats = channel.readBoolean();
        } else {
            this.supportPush = true;
            this.collectStats = true;
        }
        this.username = channel.readString();
        this.password = channel.readString();
    }

    @Override
    public byte getCommand() {
        return 2;
    }

    @Override
    public String getDescription() {
        return "Connect";
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String getPassword() {
        return this.password;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRecordFormat() {
        return this.recordFormat;
    }

    public boolean isCollectStats() {
        return this.collectStats;
    }

    public boolean isSupportPush() {
        return this.supportPush;
    }

    public boolean isTokenBased() {
        return this.tokenBased;
    }

    @Override
    public boolean requireDatabaseSession() {
        return false;
    }

    @Override
    public OConnectResponse createResponse() {
        return new OConnectResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeConnect(this);
    }
}

