/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.client.remote.OClusterRemote;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.message.tx.IndexChange;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetwork;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public class OMessageHelper {
    public static void writeIdentifiable(OChannelDataOutput channel, OIdentifiable o, ORecordSerializer serializer) throws IOException {
        if (o == null) {
            channel.writeShort((short)-2);
        } else if (o instanceof ORecordId) {
            channel.writeShort((short)-3);
            channel.writeRID((ORID)o);
        } else {
            OMessageHelper.writeRecord(channel, o.getRecord(), serializer);
        }
    }

    public static void writeRecord(OChannelDataOutput channel, ORecord iRecord, ORecordSerializer serializer) throws IOException {
        channel.writeShort((short)0);
        channel.writeByte(ORecordInternal.getRecordType((ORecord)iRecord));
        channel.writeRID(iRecord.getIdentity());
        channel.writeVersion(iRecord.getVersion());
        try {
            byte[] stream = OMessageHelper.getRecordBytes(iRecord, serializer);
            channel.writeBytes(stream);
        }
        catch (Exception e) {
            channel.writeBytes(null);
            String message = "Error on unmarshalling record " + iRecord.getIdentity().toString() + " (" + e + ")";
            throw OException.wrapException((OException)new OSerializationException(message), (Throwable)e);
        }
    }

    public static byte[] getRecordBytes(ORecord iRecord, ORecordSerializer serializer) {
        byte[] stream;
        String dbSerializerName = null;
        if (ODatabaseRecordThreadLocal.INSTANCE.getIfDefined() != null) {
            dbSerializerName = ((ODatabaseDocumentInternal)iRecord.getDatabase()).getSerializer().toString();
        }
        if (!(ORecordInternal.getRecordType((ORecord)iRecord) != 100 || dbSerializerName != null && dbSerializerName.equals(serializer.toString()))) {
            ((ODocument)iRecord).deserializeFields(new String[0]);
            stream = serializer.toStream(iRecord, false);
        } else {
            stream = iRecord.toStream();
        }
        return stream;
    }

    public static Map<UUID, OBonsaiCollectionPointer> readCollectionChanges(OChannelDataInput network) throws IOException {
        HashMap<UUID, OBonsaiCollectionPointer> collectionsUpdates = new HashMap<UUID, OBonsaiCollectionPointer>();
        int count = network.readInt();
        for (int i = 0; i < count; ++i) {
            long mBitsOfId = network.readLong();
            long lBitsOfId = network.readLong();
            OBonsaiCollectionPointer pointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer(network);
            collectionsUpdates.put(new UUID(mBitsOfId, lBitsOfId), pointer);
        }
        return collectionsUpdates;
    }

    public static void writeCollectionChanges(OChannelDataOutput channel, Map<UUID, OBonsaiCollectionPointer> changedIds) throws IOException {
        channel.writeInt(changedIds.size());
        for (Map.Entry<UUID, OBonsaiCollectionPointer> entry : changedIds.entrySet()) {
            channel.writeLong(entry.getKey().getMostSignificantBits());
            channel.writeLong(entry.getKey().getLeastSignificantBits());
            OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(channel, entry.getValue());
        }
    }

    public static void writePhysicalPositions(OChannelDataOutput channel, OPhysicalPosition[] previousPositions) throws IOException {
        if (previousPositions == null) {
            channel.writeInt(0);
        } else {
            channel.writeInt(previousPositions.length);
            for (OPhysicalPosition physicalPosition : previousPositions) {
                channel.writeLong(physicalPosition.clusterPosition);
                channel.writeInt(physicalPosition.recordSize);
                channel.writeVersion(physicalPosition.recordVersion);
            }
        }
    }

    public static OPhysicalPosition[] readPhysicalPositions(OChannelDataInput network) throws IOException {
        OPhysicalPosition[] physicalPositions;
        int positionsCount = network.readInt();
        if (positionsCount == 0) {
            physicalPositions = OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
        } else {
            physicalPositions = new OPhysicalPosition[positionsCount];
            for (int i = 0; i < physicalPositions.length; ++i) {
                OPhysicalPosition position = new OPhysicalPosition();
                position.clusterPosition = network.readLong();
                position.recordSize = network.readInt();
                position.recordVersion = network.readVersion();
                physicalPositions[i] = position;
            }
        }
        return physicalPositions;
    }

    public static OCluster[] readClustersArray(OChannelDataInput network) throws IOException {
        int tot = network.readShort();
        OCluster[] clusters = new OCluster[tot];
        for (int i = 0; i < tot; ++i) {
            OClusterRemote cluster = new OClusterRemote();
            String clusterName = network.readString();
            short clusterId = network.readShort();
            if (clusterName == null) continue;
            clusterName = clusterName.toLowerCase();
            cluster.configure(null, clusterId, clusterName, new Object[0]);
            if (clusterId >= clusters.length) {
                clusters = Arrays.copyOf(clusters, clusterId + 1);
            }
            clusters[clusterId] = cluster;
        }
        return clusters;
    }

    public static void writeClustersArray(OChannelDataOutput channel, OCluster[] clusters, int protocolVersion) throws IOException {
        int clusterCount = 0;
        for (OCluster c : clusters) {
            if (c == null) continue;
            ++clusterCount;
        }
        channel.writeShort((short)clusterCount);
        for (OCluster c : clusters) {
            if (c == null) continue;
            channel.writeString(c.getName());
            channel.writeShort((short)c.getId());
            if (protocolVersion >= 24) continue;
            channel.writeString("none");
            channel.writeShort((short)-1);
        }
    }

    static void writeTransactionEntry(OChannelDataOutput iNetwork, ORecordOperationRequest txEntry, ORecordSerializer serializer) throws IOException {
        iNetwork.writeByte((byte)1);
        iNetwork.writeByte(txEntry.getType());
        iNetwork.writeRID(txEntry.getId());
        iNetwork.writeByte(txEntry.getRecordType());
        switch (txEntry.getType()) {
            case 3: {
                iNetwork.writeBytes(serializer.toStream(txEntry.getRecord(), false));
                break;
            }
            case 1: {
                iNetwork.writeVersion(txEntry.getVersion());
                iNetwork.writeBytes(serializer.toStream(txEntry.getRecord(), false));
                iNetwork.writeBoolean(txEntry.isContentChanged());
                break;
            }
            case 2: {
                iNetwork.writeVersion(txEntry.getVersion());
            }
        }
    }

    static ORecordOperationRequest readTransactionEntry(OChannelDataInput channel, ORecordSerializer ser) throws IOException {
        ORecordOperationRequest entry = new ORecordOperationRequest();
        entry.setType(channel.readByte());
        entry.setId((ORID)channel.readRID());
        entry.setRecordType(channel.readByte());
        ORecord record = Orient.instance().getRecordFactoryManager().newInstance(entry.getRecordType());
        switch (entry.getType()) {
            case 3: {
                entry.setRecord(ser.fromStream(channel.readBytes(), record, null));
                break;
            }
            case 1: {
                entry.setVersion(channel.readVersion());
                entry.setRecord(ser.fromStream(channel.readBytes(), record, null));
                entry.setContentChanged(channel.readBoolean());
                break;
            }
            case 2: {
                entry.setVersion(channel.readVersion());
                break;
            }
        }
        return entry;
    }

    static void writeTransactionIndexChanges(OChannelDataOutput network, ORecordSerializerNetwork serializer, List<IndexChange> changes) throws IOException {
        network.writeInt(changes.size());
        for (IndexChange indexChange : changes) {
            network.writeString(indexChange.getName());
            network.writeBoolean(indexChange.getKeyChanges().cleared);
            if (indexChange.getKeyChanges().cleared) continue;
            int size = indexChange.getKeyChanges().changesPerKey.size();
            if (indexChange.getKeyChanges().nullKeyChanges != null) {
                ++size;
            }
            network.writeInt(size);
            if (indexChange.getKeyChanges().nullKeyChanges != null) {
                network.writeByte((byte)-1);
                network.writeInt(indexChange.getKeyChanges().nullKeyChanges.entries.size());
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry perKeyChange : indexChange.getKeyChanges().nullKeyChanges.entries) {
                    network.writeInt(perKeyChange.operation.ordinal());
                    network.writeRID(perKeyChange.value.getIdentity());
                }
            }
            for (OTransactionIndexChangesPerKey change : indexChange.getKeyChanges().changesPerKey.values()) {
                OType type = OType.getTypeByValue((Object)change.key);
                byte[] value = serializer.serializeValue(change.key, type);
                network.writeByte((byte)type.getId());
                network.writeBytes(value);
                network.writeInt(change.entries.size());
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry perKeyChange : change.entries) {
                    OTransactionIndexChanges.OPERATION op = perKeyChange.operation;
                    if (op == OTransactionIndexChanges.OPERATION.REMOVE && perKeyChange.value == null) {
                        op = OTransactionIndexChanges.OPERATION.CLEAR;
                    }
                    network.writeInt(op.ordinal());
                    if (op == OTransactionIndexChanges.OPERATION.CLEAR) continue;
                    network.writeRID(perKeyChange.value.getIdentity());
                }
            }
        }
    }

    static List<IndexChange> readTransactionIndexChanges(OChannelDataInput channel, ORecordSerializerNetwork serializer) throws IOException {
        ArrayList<IndexChange> changes = new ArrayList<IndexChange>();
        int val = channel.readInt();
        while (val-- > 0) {
            String indexName = channel.readString();
            boolean cleared = channel.readBoolean();
            OTransactionIndexChanges entry = new OTransactionIndexChanges();
            entry.cleared = cleared;
            if (!cleared) {
                int changeCount = channel.readInt();
                TreeMap<Object, OTransactionIndexChangesPerKey> entries = new TreeMap<Object, OTransactionIndexChangesPerKey>();
                while (changeCount-- > 0) {
                    Object key;
                    byte bt = channel.readByte();
                    if (bt == -1) {
                        key = null;
                    } else {
                        OType type = OType.getById((byte)bt);
                        key = serializer.deserializeValue(channel.readBytes(), type);
                    }
                    OTransactionIndexChangesPerKey changesPerKey = new OTransactionIndexChangesPerKey(key);
                    int keyChangeCount = channel.readInt();
                    while (keyChangeCount-- > 0) {
                        ORecordId id;
                        int op = channel.readInt();
                        OTransactionIndexChanges.OPERATION oper = OTransactionIndexChanges.OPERATION.values()[op];
                        if (oper == OTransactionIndexChanges.OPERATION.CLEAR) {
                            oper = OTransactionIndexChanges.OPERATION.REMOVE;
                            id = null;
                        } else {
                            id = channel.readRID();
                        }
                        changesPerKey.add((OIdentifiable)id, oper);
                    }
                    if (key == null) {
                        entry.nullKeyChanges = changesPerKey;
                        continue;
                    }
                    entries.put(changesPerKey.key, changesPerKey);
                }
                entry.changesPerKey = entries;
            }
            changes.add(new IndexChange(indexName, entry));
        }
        return changes;
    }
}

