/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OOpenResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OOpenRequest
implements OBinaryRequest<OOpenResponse> {
    private String driverName = "OrientDB Java";
    private String driverVersion = "3.0.0m1";
    private short protocolVersion = (short)37;
    private String clientId = null;
    private String recordFormat = "onet_ser_v0";
    private boolean useToken = true;
    private boolean supportsPush = true;
    private boolean collectStats = true;
    private String databaseName;
    private String userName;
    private String userPassword;
    private String dbType;

    public OOpenRequest(String databaseName, String userName, String userPassword) {
        this.databaseName = databaseName;
        this.userName = userName;
        this.userPassword = userPassword;
    }

    public OOpenRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeString(this.driverName);
        network.writeString(this.driverVersion);
        network.writeShort(this.protocolVersion);
        network.writeString(this.clientId);
        network.writeString(this.recordFormat);
        network.writeBoolean(this.useToken);
        network.writeBoolean(this.supportsPush);
        network.writeBoolean(this.collectStats);
        network.writeString(this.databaseName);
        network.writeString(this.userName);
        network.writeString(this.userPassword);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.driverName = channel.readString();
        this.driverVersion = channel.readString();
        this.protocolVersion = channel.readShort();
        this.clientId = channel.readString();
        this.recordFormat = channel.readString();
        this.useToken = this.protocolVersion > 26 ? channel.readBoolean() : false;
        if (this.protocolVersion > 33) {
            this.supportsPush = channel.readBoolean();
            this.collectStats = channel.readBoolean();
        } else {
            this.supportsPush = true;
            this.collectStats = true;
        }
        this.databaseName = channel.readString();
        if (this.protocolVersion <= 32) {
            this.dbType = channel.readString();
        }
        this.userName = channel.readString();
        this.userPassword = channel.readString();
    }

    @Override
    public byte getCommand() {
        return 3;
    }

    @Override
    public String getDescription() {
        return "Open Database";
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String getClientId() {
        return this.clientId;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getRecordFormat() {
        return this.recordFormat;
    }

    public boolean isCollectStats() {
        return this.collectStats;
    }

    public boolean isSupportsPush() {
        return this.supportsPush;
    }

    public boolean isUseToken() {
        return this.useToken;
    }

    @Override
    public boolean requireDatabaseSession() {
        return false;
    }

    @Override
    public OOpenResponse createResponse() {
        return new OOpenResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeDatabaseOpen(this);
    }
}

