/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.OQueryResponse;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class OQueryRequest
implements OBinaryRequest<OQueryResponse> {
    private int recordsPerPage = 100;
    private ORecordSerializer serializer;
    private String language;
    private String statement;
    private boolean idempotent;
    private Map<String, Object> params;
    private boolean namedParams;

    public OQueryRequest(String language, String iCommand, Object[] positionalParams, boolean idempotent, ORecordSerializer serializer, int recordsPerPage) {
        this.language = language;
        this.statement = iCommand;
        this.params = new HashMap<String, Object>();
        if (positionalParams != null) {
            for (int i = 0; i < positionalParams.length; ++i) {
                this.params.put(Integer.toString(i), positionalParams[i]);
            }
        }
        this.namedParams = false;
        this.serializer = serializer;
        this.recordsPerPage = recordsPerPage;
        if (this.recordsPerPage <= 0) {
            this.recordsPerPage = 100;
        }
    }

    public OQueryRequest(String language, String iCommand, Map<String, Object> namedParams, boolean idempotent, ORecordSerializer serializer, int recordsPerPage) {
        this.language = language;
        this.statement = iCommand;
        this.params = namedParams;
        this.namedParams = true;
        this.serializer = serializer;
        this.recordsPerPage = recordsPerPage;
        if (this.recordsPerPage <= 0) {
            this.recordsPerPage = 100;
        }
    }

    public OQueryRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeString(this.language);
        network.writeString(this.statement);
        network.writeBoolean(this.idempotent);
        network.writeInt(this.recordsPerPage);
        ODocument parms = new ODocument();
        parms.field("params", this.params);
        byte[] bytes = OMessageHelper.getRecordBytes((ORecord)parms, this.serializer);
        network.writeBytes(bytes);
        network.writeBoolean(this.namedParams);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.language = channel.readString();
        this.statement = channel.readString();
        this.idempotent = channel.readBoolean();
        this.recordsPerPage = channel.readInt();
        ODocument paramsDoc = new ODocument();
        byte[] bytes = channel.readBytes();
        serializer.fromStream(bytes, (ORecord)paramsDoc, null);
        this.params = (Map)paramsDoc.field("params");
        this.namedParams = channel.readBoolean();
    }

    @Override
    public byte getCommand() {
        return 45;
    }

    @Override
    public String getDescription() {
        return "Execute remote query";
    }

    @Override
    public OQueryResponse createResponse() {
        return new OQueryResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeQuery(this);
    }

    public String getStatement() {
        return this.statement;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public boolean isNamedParams() {
        return this.namedParams;
    }

    public Map getNamedParameters() {
        return this.params;
    }

    public Object[] getPositionalParameters() {
        Object[] result = new Object[this.params.size()];
        this.params.entrySet().forEach(e -> {
            result[Integer.parseInt((String)((String)e.getKey()))] = e.getValue();
        });
        return result;
    }

    public int getRecordsPerPage() {
        return this.recordsPerPage;
    }

    public ORecordSerializer getSerializer() {
        return this.serializer;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

