/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.ORemoteResultSet;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentRemote;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTxInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.OEdgeDelegate;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.record.impl.OVertexDelegate;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.result.binary.OResultSerializerNetwork;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OInfoExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInfoExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSetLifecycleDecorator;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryProtocol;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OQueryResponse
implements OBinaryResponse {
    private static final byte RECORD_TYPE_BLOB = 0;
    private static final byte RECORD_TYPE_VERTEX = 1;
    private static final byte RECORD_TYPE_EDGE = 2;
    private static final byte RECORD_TYPE_ELEMENT = 3;
    private static final byte RECORD_TYPE_PROJECTION = 4;
    private OResultSet result;
    private boolean txChanges;

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        if (!(this.result instanceof OLocalResultSetLifecycleDecorator)) {
            throw new IllegalStateException();
        }
        channel.writeString(((OLocalResultSetLifecycleDecorator)this.result).getQueryId());
        channel.writeBoolean(this.txChanges);
        this.writeExecutionPlan(this.result.getExecutionPlan(), channel, serializer);
        while (this.result.hasNext()) {
            OResult row = this.result.next();
            channel.writeBoolean(true);
            this.writeResult(row, channel, serializer);
        }
        channel.writeBoolean(false);
        channel.writeBoolean(((OLocalResultSetLifecycleDecorator)this.result).hasNextPage());
        this.writeQueryStats(this.result.getQueryStats(), channel);
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        ORemoteResultSet rs = new ORemoteResultSet((ODatabaseDocumentRemote)ODatabaseDocumentTxInternal.getInternal((ODatabaseDocumentInternal)ODatabaseRecordThreadLocal.INSTANCE.get()));
        this.doRead(network, rs);
        this.result = rs;
    }

    protected void doRead(OChannelDataInput network, ORemoteResultSet rs) throws IOException {
        rs.setQueryId(network.readString());
        this.txChanges = network.readBoolean();
        rs.setExecutionPlan(this.readExecutionPlan(network));
        boolean hasNext = network.readBoolean();
        while (hasNext) {
            OResult item = this.readResult(network);
            rs.add(item);
            hasNext = network.readBoolean();
        }
        rs.setHasNextPage(network.readBoolean());
        rs.setQueryStats(this.readQueryStats(network));
    }

    private void writeQueryStats(Map<String, Long> queryStats, OChannelDataOutput channel) throws IOException {
        if (queryStats == null) {
            channel.writeInt(0);
            return;
        }
        channel.writeInt(queryStats.size());
        for (Map.Entry<String, Long> entry : queryStats.entrySet()) {
            channel.writeString(entry.getKey());
            channel.writeLong(entry.getValue().longValue());
        }
    }

    private Map<String, Long> readQueryStats(OChannelDataInput channel) throws IOException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        int size = channel.readInt();
        for (int i = 0; i < size; ++i) {
            String key = channel.readString();
            Long val = channel.readLong();
            result.put(key, val);
        }
        return result;
    }

    private void writeExecutionPlan(Optional<OExecutionPlan> executionPlan, OChannelDataOutput channel, ORecordSerializer recordSerializer) throws IOException {
        if (executionPlan.isPresent()) {
            channel.writeBoolean(true);
            this.writeResult(executionPlan.get().toResult(), channel, recordSerializer);
        } else {
            channel.writeBoolean(false);
        }
    }

    private OExecutionPlan readExecutionPlan(OChannelDataInput network) throws IOException {
        boolean present = network.readBoolean();
        if (!present) {
            return null;
        }
        OInfoExecutionPlan result = new OInfoExecutionPlan();
        OResult read = this.readResult(network);
        result.setCost(Integer.valueOf(((Number)read.getProperty("cost")).intValue()));
        result.setType((String)read.getProperty("type"));
        result.setJavaType((String)read.getProperty("javaType"));
        result.setPrettyPrint((String)read.getProperty("prettyPrint"));
        result.setStmText((String)read.getProperty("stmText"));
        List subSteps = (List)read.getProperty("steps");
        if (subSteps != null) {
            subSteps.forEach(x -> result.getSteps().add(this.toInfoStep((OResult)x)));
        }
        return result;
    }

    private OExecutionStep toInfoStep(OResult x) {
        OInfoExecutionStep result = new OInfoExecutionStep();
        result.setName((String)x.getProperty("name"));
        result.setType((String)x.getProperty("type"));
        result.setTargetNode((String)x.getProperty("targetNode"));
        result.setJavaType((String)x.getProperty("javaType"));
        result.setCost(x.getProperty("cost") == null ? -1L : (Long)x.getProperty("cost"));
        List ssteps = (List)x.getProperty("subSteps");
        if (ssteps != null) {
            ssteps.stream().forEach(sstep -> result.getSubSteps().add(this.toInfoStep((OResult)sstep)));
        }
        result.setDescription((String)x.getProperty("description"));
        return result;
    }

    private void writeResult(OResult row, OChannelDataOutput channel, ORecordSerializer recordSerializer) throws IOException {
        if (row.isBlob()) {
            this.writeBlob(row, channel, recordSerializer);
        } else if (row.isVertex()) {
            this.writeVertex(row, channel, recordSerializer);
        } else if (row.isEdge()) {
            this.writeEdge(row, channel, recordSerializer);
        } else if (row.isElement()) {
            this.writeElement(row, channel, recordSerializer);
        } else {
            this.writeProjection(row, channel);
        }
    }

    private void writeElement(OResult row, OChannelDataOutput channel, ORecordSerializer recordSerializer) throws IOException {
        channel.writeByte((byte)3);
        this.writeDocument(channel, (ODocument)((OElement)row.getElement().get()).getRecord(), recordSerializer);
    }

    private void writeEdge(OResult row, OChannelDataOutput channel, ORecordSerializer recordSerializer) throws IOException {
        channel.writeByte((byte)2);
        this.writeDocument(channel, (ODocument)((OElement)row.getElement().get()).getRecord(), recordSerializer);
    }

    private void writeVertex(OResult row, OChannelDataOutput channel, ORecordSerializer recordSerializer) throws IOException {
        channel.writeByte((byte)1);
        this.writeDocument(channel, (ODocument)((OElement)row.getElement().get()).getRecord(), recordSerializer);
    }

    private void writeBlob(OResult row, OChannelDataOutput channel, ORecordSerializer recordSerializer) throws IOException {
        channel.writeByte((byte)0);
        channel.writeBytes(((OBlob)row.getBlob().get()).toStream());
    }

    private OResult readBlob(OChannelDataInput channel) throws IOException {
        ORecordBytes bytes = new ORecordBytes();
        bytes.fromStream(channel.readBytes());
        OResultInternal result = new OResultInternal();
        result.setElement((OIdentifiable)bytes);
        return result;
    }

    private OResult readResult(OChannelDataInput channel) throws IOException {
        byte type = channel.readByte();
        switch (type) {
            case 0: {
                return this.readBlob(channel);
            }
            case 1: {
                return this.readVertex(channel);
            }
            case 2: {
                return this.readEdge(channel);
            }
            case 3: {
                return this.readElement(channel);
            }
            case 4: {
                return this.readProjection(channel);
            }
        }
        return new OResultInternal();
    }

    private OResult readElement(OChannelDataInput channel) throws IOException {
        OResultInternal result = new OResultInternal();
        result.setElement((OIdentifiable)this.readDocument(channel));
        return result;
    }

    private OResult readVertex(OChannelDataInput channel) throws IOException {
        OResultInternal result = new OResultInternal();
        result.setElement((OIdentifiable)new OVertexDelegate((ODocument)this.readDocument(channel)));
        return result;
    }

    private OResult readEdge(OChannelDataInput channel) throws IOException {
        OResultInternal result = new OResultInternal();
        result.setElement((OIdentifiable)new OEdgeDelegate((ODocument)this.readDocument(channel)));
        return result;
    }

    private ORecord readDocument(OChannelDataInput channel) throws IOException {
        ORecord record = (ORecord)OChannelBinaryProtocol.readIdentifiable((OChannelDataInput)channel);
        return record;
    }

    private void writeDocument(OChannelDataOutput channel, ODocument doc, ORecordSerializer serializer) throws IOException {
        OMessageHelper.writeIdentifiable(channel, (OIdentifiable)doc, serializer);
    }

    private OResult readProjection(OChannelDataInput channel) throws IOException {
        OResultSerializerNetwork ser = new OResultSerializerNetwork();
        return ser.fromStream(channel);
    }

    private void writeProjection(OResult item, OChannelDataOutput channel) throws IOException {
        channel.writeByte((byte)4);
        OResultSerializerNetwork ser = new OResultSerializerNetwork();
        ser.toStream(item, channel);
    }

    public void setResult(OLocalResultSetLifecycleDecorator result) {
        this.result = result;
    }

    public OResultSet getResult() {
        return this.result;
    }

    public boolean isTxChanges() {
        return this.txChanges;
    }

    public void setTxChanges(boolean txChanges) {
        this.txChanges = txChanges;
    }
}

