/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentRemote;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ORemoteResultSet
implements OResultSet {
    private String queryId;
    private final ODatabaseDocumentRemote db;
    private List<OResult> currentPage = new ArrayList<OResult>();
    private OExecutionPlan executionPlan;
    private Map<String, Long> queryStats;
    private boolean hasNextPage = false;

    public ORemoteResultSet(ODatabaseDocumentRemote db) {
        this.db = db;
    }

    protected void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public boolean hasNext() {
        if (!this.currentPage.isEmpty()) {
            return true;
        }
        if (!this.hasNextPage()) {
            return false;
        }
        this.fetchNextPage();
        return !this.currentPage.isEmpty();
    }

    private void fetchNextPage() {
        this.db.fetchNextPage(this);
    }

    public OResult next() {
        if (this.currentPage.isEmpty()) {
            if (!this.hasNextPage()) {
                throw new IllegalStateException();
            }
            this.fetchNextPage();
        }
        if (this.currentPage.isEmpty()) {
            throw new IllegalStateException();
        }
        return this.currentPage.remove(0);
    }

    public void close() {
        this.db.closeQuery(this.queryId);
    }

    public Optional<OExecutionPlan> getExecutionPlan() {
        return Optional.ofNullable(this.executionPlan);
    }

    public Map<String, Long> getQueryStats() {
        return this.queryStats;
    }

    public void setQueryStats(Map<String, Long> queryStats) {
        this.queryStats = queryStats;
    }

    public void add(OResult item) {
        this.currentPage.add(item);
    }

    public void setExecutionPlan(OExecutionPlan executionPlan) {
        this.executionPlan = executionPlan;
    }

    public boolean hasNextPage() {
        return this.hasNextPage;
    }

    public void setHasNextPage(boolean b) {
        this.hasNextPage = b;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void setCurrentPage(List<OResult> currentPage) {
        this.currentPage = currentPage;
    }

    public List<OResult> getCurrentPage() {
        return this.currentPage;
    }
}

