/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OSBTFetchEntriesMajorResponse;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OSBTFetchEntriesMajorRequest<K, V>
implements OBinaryRequest<OSBTFetchEntriesMajorResponse<K, V>> {
    private boolean inclusive;
    private byte[] keyStream;
    private OBonsaiCollectionPointer pointer;
    private int pageSize;
    private OBinarySerializer<K> keySerializer;
    private OBinarySerializer<V> valueSerializer;

    public OSBTFetchEntriesMajorRequest(boolean inclusive, byte[] keyStream, OBonsaiCollectionPointer pointer, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        this.inclusive = inclusive;
        this.keyStream = keyStream;
        this.pointer = pointer;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public OSBTFetchEntriesMajorRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(network, this.pointer);
        network.writeBytes(this.keyStream);
        network.writeBoolean(this.inclusive);
        network.writeInt(128);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.pointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer(channel);
        this.keyStream = channel.readBytes();
        this.inclusive = channel.readBoolean();
        this.pageSize = protocolVersion >= 21 ? channel.readInt() : 128;
    }

    @Override
    public byte getCommand() {
        return 113;
    }

    @Override
    public String getDescription() {
        return "SB-Tree bonsai get values major";
    }

    public byte[] getKeyStream() {
        return this.keyStream;
    }

    public OBonsaiCollectionPointer getPointer() {
        return this.pointer;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public OSBTFetchEntriesMajorResponse<K, V> createResponse() {
        return new OSBTFetchEntriesMajorResponse<K, V>(this.keySerializer, this.valueSerializer);
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeSBTFetchEntriesMajor(this);
    }
}

