/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OSBTGetRealBagSizeResponse;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeRidBag;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.Map;

public class OSBTGetRealBagSizeRequest
implements OBinaryRequest<OSBTGetRealBagSizeResponse> {
    private OBonsaiCollectionPointer collectionPointer;
    private Map<OIdentifiable, OSBTreeRidBag.Change> changes;
    private OBinarySerializer<OIdentifiable> keySerializer;

    public OSBTGetRealBagSizeRequest() {
    }

    public OSBTGetRealBagSizeRequest(OBinarySerializer<OIdentifiable> keySerializer, OBonsaiCollectionPointer collectionPointer, Map<OIdentifiable, OSBTreeRidBag.Change> changes) {
        this.collectionPointer = collectionPointer;
        this.changes = changes;
        this.keySerializer = keySerializer;
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(network, this.collectionPointer);
        OSBTreeRidBag.ChangeSerializationHelper changeSerializer = OSBTreeRidBag.ChangeSerializationHelper.INSTANCE;
        byte[] stream = new byte[4 + changeSerializer.getChangesSerializedSize(this.changes.size())];
        changeSerializer.serializeChanges(this.changes, this.keySerializer, stream, 0);
        network.writeBytes(stream);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.collectionPointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer(channel);
        byte[] stream = channel.readBytes();
        OSBTreeRidBag.ChangeSerializationHelper changeSerializer = OSBTreeRidBag.ChangeSerializationHelper.INSTANCE;
        this.changes = changeSerializer.deserializeChanges(stream, 0);
    }

    @Override
    public byte getCommand() {
        return 114;
    }

    @Override
    public String getDescription() {
        return "RidBag get size";
    }

    public Map<OIdentifiable, OSBTreeRidBag.Change> getChanges() {
        return this.changes;
    }

    public OBonsaiCollectionPointer getCollectionPointer() {
        return this.collectionPointer;
    }

    @Override
    public OSBTGetRealBagSizeResponse createResponse() {
        return new OSBTGetRealBagSizeResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeSBTGetRealSize(this);
    }
}

