/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OEngineRemote;
import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabasePoolImpl;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.ORemoteDatabasePool;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentRemote;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OrientDBRemote
implements OrientDBInternal {
    private final Map<String, OStorageRemote> storages = new HashMap<String, OStorageRemote>();
    private final Set<ODatabasePoolInternal> pools = new HashSet<ODatabasePoolInternal>();
    private final String[] hosts;
    private final OEngineRemote remote;
    private final OrientDBConfig configurations;
    private final Thread shutdownThread;
    private final Orient orient;
    private volatile boolean open = true;

    public OrientDBRemote(String[] hosts, OrientDBConfig configurations, Orient orient) {
        this.hosts = hosts;
        this.orient = orient;
        this.remote = (OEngineRemote)orient.getEngine("remote");
        this.configurations = configurations != null ? configurations : OrientDBConfig.defaultConfig();
        this.shutdownThread = new Thread(() -> this.internalClose());
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    private String buildUrl(String name) {
        return String.join((CharSequence)",", this.hosts) + "/" + name;
    }

    public ODatabaseDocument open(String name, String user, String password) {
        return this.open(name, user, password, null);
    }

    public synchronized ODatabaseDocument open(String name, String user, String password, OrientDBConfig config) {
        this.checkOpen();
        try {
            OStorageRemote storage = this.storages.get(name);
            if (storage == null) {
                storage = this.remote.createStorage(this.buildUrl(name), new HashMap<String, String>());
                this.storages.put(name, storage);
            }
            ODatabaseDocumentRemote db = new ODatabaseDocumentRemote(storage);
            db.internalOpen(user, password, this.solveConfig(config));
            return db;
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new ODatabaseException("Cannot open database '" + name + "'"), (Throwable)e);
        }
    }

    public void create(String name, String user, String password, ODatabaseType databaseType) {
        this.create(name, user, password, databaseType, null);
    }

    public synchronized void create(String name, String user, String password, ODatabaseType databaseType, OrientDBConfig config) {
        this.connectEndExecute(name, user, password, admin -> {
            String sendType = null;
            if (databaseType == ODatabaseType.MEMORY) {
                sendType = "memory";
            } else if (databaseType == ODatabaseType.PLOCAL) {
                sendType = "plocal";
            }
            admin.createDatabase(name, null, sendType);
            return null;
        });
    }

    public synchronized ORemoteDatabasePool poolOpen(String name, String user, String password, ODatabasePoolInternal pool) {
        OStorageRemote storage = this.storages.get(name);
        if (storage == null) {
            storage = this.remote.createStorage(this.buildUrl(name), new HashMap<String, String>());
        }
        ORemoteDatabasePool db = new ORemoteDatabasePool(pool, storage);
        db.internalOpen(user, password, pool.getConfig());
        return db;
    }

    private <T> T connectEndExecute(String name, String user, String password, Operation<T> operation) {
        this.checkOpen();
        try (OServerAdmin admin = null;){
            admin = new OServerAdmin(this.buildUrl(name));
            admin.connect(user, password);
            T t = operation.execute(admin);
            return t;
        }
    }

    public synchronized boolean exists(String name, String user, String password) {
        return this.connectEndExecute(name, user, password, admin -> admin.existsDatabase(name, null));
    }

    public synchronized void drop(String name, String user, String password) {
        this.connectEndExecute(name, user, password, admin -> admin.dropDatabase(name, null));
    }

    public Set<String> listDatabases(String user, String password) {
        return this.connectEndExecute("", user, password, admin -> admin.listDatabases().keySet());
    }

    public ODatabasePoolInternal openPool(String name, String user, String password) {
        return this.openPool(name, user, password, null);
    }

    public ODatabasePoolInternal openPool(String name, String user, String password, OrientDBConfig config) {
        this.checkOpen();
        ODatabasePoolImpl pool = new ODatabasePoolImpl((OrientDBInternal)this, name, user, password, this.solveConfig(config));
        this.pools.add((ODatabasePoolInternal)pool);
        return pool;
    }

    public void removePool(ODatabasePoolInternal pool) {
        this.pools.remove(pool);
    }

    public synchronized void close() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        this.internalClose();
    }

    public synchronized void internalClose() {
        ArrayList<OStorageRemote> storagesCopy = new ArrayList<OStorageRemote>(this.storages.values());
        for (OStorage oStorage : storagesCopy) {
            try {
                OLogManager.instance().info((Object)this, "- shutdown storage: " + oStorage.getName() + "...", new Object[0]);
                oStorage.shutdown();
            }
            catch (Throwable e) {
                OLogManager.instance().warn((Object)this, "-- error on shutdown storage", e, new Object[0]);
            }
        }
        this.storages.clear();
        this.remote.shutdown();
        this.open = false;
    }

    private OrientDBConfig solveConfig(OrientDBConfig config) {
        if (config != null) {
            config.setParent(this.configurations);
            return config;
        }
        return this.configurations;
    }

    public OrientDBConfig getConfigurations() {
        return this.configurations;
    }

    private void checkOpen() {
        if (!this.open) {
            throw new ODatabaseException("OrientDB Instance is closed");
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    private static interface Operation<T> {
        public T execute(OServerAdmin var1) throws IOException;
    }
}

