/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.ORemoteQueryResult;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.ORemoteResultSet;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.db.document.OTransactionOptimisticClient;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.index.ClassIndexManagerRemote;
import com.orientechnologies.orient.core.metadata.security.OImmutableUser;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import java.util.Collections;
import java.util.Map;

public class ODatabaseDocumentRemote
extends ODatabaseDocumentAbstract {
    protected OStorageRemoteSession sessionMetadata;
    private OrientDBConfig config;
    private OStorageRemote storage;

    public ODatabaseDocumentRemote(OStorageRemote storage) {
        this.activateOnCurrentThread();
        try {
            this.status = ODatabase.STATUS.CLOSED;
            this.url = storage.getURL();
            this.storage = storage;
            this.componentsFactory = storage.getComponentsFactory();
            this.unmodifiableHooks = Collections.unmodifiableMap(this.hooks);
            this.localCache = new OLocalRecordCache();
            this.init();
            this.databaseOwner = this;
        }
        catch (Exception t) {
            ODatabaseRecordThreadLocal.INSTANCE.remove();
            throw OException.wrapException((OException)new ODatabaseException("Error on opening database "), (Throwable)t);
        }
    }

    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Use OrientDB");
    }

    @Deprecated
    public <DB extends ODatabase> DB open(OToken iToken) {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    public <DB extends ODatabase> DB create() {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    public <DB extends ODatabase> DB create(String incrementalBackupPath) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public <DB extends ODatabase> DB create(Map<OGlobalConfiguration, Object> iInitialSettings) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public void drop() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public ODatabaseDocumentInternal copy() {
        ODatabaseDocumentRemote database = new ODatabaseDocumentRemote(this.storage);
        database.storage = this.storage.copy(this, database);
        database.storage.addUser();
        database.status = ODatabase.STATUS.OPEN;
        database.applyAttributes(this.config);
        database.initAtFirstOpen();
        database.user = this.user;
        this.activateOnCurrentThread();
        return database;
    }

    public boolean exists() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public void internalOpen(String user, String password, OrientDBConfig config) {
        this.config = config;
        boolean failure = true;
        this.applyAttributes(config);
        this.applyListeners(config);
        try {
            this.storage.open(user, password, config.getConfigurations());
            this.status = ODatabase.STATUS.OPEN;
            this.initAtFirstOpen();
            this.user = new OImmutableUser(-1L, new OUser(user, OUser.encryptPassword((String)password)).addRole((OSecurityRole)new ORole("passthrough", null, OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT)));
            this.callOnOpenListeners();
            failure = false;
        }
        catch (OException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw OException.wrapException((OException)new ODatabaseException("Cannot open database url=" + this.getURL()), (Throwable)e);
        }
    }

    private void applyAttributes(OrientDBConfig config) {
        for (Map.Entry attrs : config.getAttributes().entrySet()) {
            this.set((ODatabase.ATTRIBUTES)attrs.getKey(), attrs.getValue());
        }
    }

    private void initAtFirstOpen() {
        if (this.initialized) {
            return;
        }
        ORecordSerializerFactory serializerFactory = ORecordSerializerFactory.instance();
        this.serializer = serializerFactory.getFormat("onet_ser_v0");
        this.localCache.startup();
        this.componentsFactory = this.getStorage().getComponentsFactory();
        this.user = null;
        this.loadMetadata();
        this.installHooksRemote();
        this.initialized = true;
    }

    protected void installHooksRemote() {
        this.hooks.clear();
        this.registerHook((ORecordHook)new ClassIndexManagerRemote((ODatabaseDocument)this), ORecordHook.HOOK_POSITION.LAST);
    }

    private void applyListeners(OrientDBConfig config) {
        for (ODatabaseListener listener : config.getListeners()) {
            this.registerListener(listener);
        }
    }

    public ODatabaseDocumentAbstract begin(OTransaction.TXTYPE iType) {
        this.checkOpenness();
        this.checkIfActive();
        if (this.currentTx.isActive()) {
            if (iType == OTransaction.TXTYPE.OPTIMISTIC && this.currentTx instanceof OTransactionOptimistic) {
                this.currentTx.begin();
                return this;
            }
            this.currentTx.rollback(true, 0);
        }
        if (!this.inHook.isEmpty()) {
            throw new IllegalStateException("Cannot begin a transaction while a hook is executing");
        }
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxBegin((ODatabase)this);
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error before tx begin", t, new Object[0]);
            }
        }
        switch (iType) {
            case NOTX: {
                this.setDefaultTransactionMode();
                break;
            }
            case OPTIMISTIC: {
                this.currentTx = new OTransactionOptimisticClient((ODatabaseDocumentInternal)this);
                break;
            }
            case PESSIMISTIC: {
                throw new UnsupportedOperationException("Pessimistic transaction");
            }
        }
        this.currentTx.begin();
        return this;
    }

    public OStorageRemoteSession getSessionMetadata() {
        return this.sessionMetadata;
    }

    public void setSessionMetadata(OStorageRemoteSession sessionMetadata) {
        this.sessionMetadata = sessionMetadata;
    }

    public OStorage getStorage() {
        return this.storage;
    }

    public void replaceStorage(OStorage iNewStorage) {
        throw new UnsupportedOperationException("unsupported replace of storage for remote database");
    }

    private void checkAndSendTransaction() {
        if (this.currentTx.isActive() && ((OTransactionOptimistic)this.currentTx).isChanged()) {
            if (((OTransactionOptimistic)this.getTransaction()).isAlreadyCleared()) {
                this.storage.reBeginTransaction(this, (OTransactionOptimistic)this.currentTx);
            } else {
                this.storage.beginTransaction(this, (OTransactionOptimistic)this.currentTx);
            }
            ((OTransactionOptimistic)this.currentTx).resetChangesTracking();
        }
    }

    private void fetchTransacion() {
        this.storage.fetchTransaction(this);
    }

    public OResultSet query(String query, Object[] args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.query((ODatabase)this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        return result.getResult();
    }

    public OResultSet query(String query, Map args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.query((ODatabase)this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        return result.getResult();
    }

    public OResultSet command(String query, Object[] args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.command((ODatabase)this, "sql", query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        return result.getResult();
    }

    public OResultSet command(String query, Map args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.command((ODatabase)this, "sql", query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        return result.getResult();
    }

    public OResultSet execute(String language, String script, Object ... args) throws OCommandExecutionException, OCommandScriptException {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.command((ODatabase)this, language, script, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        return result.getResult();
    }

    public OResultSet execute(String language, String script, Map<String, ?> args) throws OCommandExecutionException, OCommandScriptException {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.command((ODatabase)this, language, script, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        return result.getResult();
    }

    public void closeQuery(String queryId) {
        this.storage.closeQuery(this, queryId);
    }

    public void fetchNextPage(ORemoteResultSet rs) {
        this.storage.fetchNextPage(this, rs);
    }
}

