/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.orient.client.remote.message.tx.IndexChange;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class OTransactionOptimisticClient
extends OTransactionOptimistic {
    public OTransactionOptimisticClient(ODatabaseDocumentInternal iDatabase) {
        super(iDatabase);
    }

    public void replaceContent(List<ORecordOperationRequest> operations, List<IndexChange> indexChanges) {
        this.allEntries.clear();
        for (ORecordOperationRequest operation : operations) {
            ORecordInternal.setIdentity((ORecord)operation.getRecord(), (ORecordId)((ORecordId)operation.getId()));
            ORecordInternal.setVersion((ORecord)operation.getRecord(), (int)operation.getVersion());
            this.addRecord(operation.getRecord(), operation.getType(), null);
        }
        for (IndexChange change : indexChanges) {
            TreeMap changesPerKey = new TreeMap(ODefaultComparator.INSTANCE);
            for (Map.Entry keyChange : change.getKeyChanges().changesPerKey.entrySet()) {
                Object key = keyChange.getKey();
                if (key instanceof OIdentifiable && ((OIdentifiable)key).getIdentity().isNew()) {
                    key = ((OIdentifiable)key).getRecord();
                }
                OTransactionIndexChangesPerKey singleChange = new OTransactionIndexChangesPerKey(key);
                singleChange.entries.addAll(((OTransactionIndexChangesPerKey)keyChange.getValue()).entries);
                changesPerKey.put(key, singleChange);
            }
            change.getKeyChanges().changesPerKey = changesPerKey;
            this.indexEntries.put(change.getName(), change.getKeyChanges());
        }
    }
}

