/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.Collection;

public class OOpenResponse
implements OBinaryResponse {
    private int sessionId;
    private byte[] sessionToken;
    private OCluster[] clusterIds;
    private byte[] distributedConfiguration;
    private String serverVersion;

    public OOpenResponse() {
    }

    public OOpenResponse(int sessionId, byte[] sessionToken, Collection<? extends OCluster> clusters, byte[] distriConf, String version) {
        this.sessionId = sessionId;
        this.sessionToken = sessionToken;
        this.clusterIds = clusters.toArray(new OCluster[clusters.size()]);
        this.distributedConfiguration = distriConf;
        this.serverVersion = version;
    }

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        channel.writeInt(this.sessionId);
        if (protocolVersion > 26) {
            channel.writeBytes(this.sessionToken);
        }
        OMessageHelper.writeClustersArray(channel, this.clusterIds, protocolVersion);
        channel.writeBytes(this.distributedConfiguration);
        channel.writeString(this.serverVersion);
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        this.sessionId = network.readInt();
        this.sessionToken = network.readBytes();
        this.clusterIds = OMessageHelper.readClustersArray(network);
        this.distributedConfiguration = network.readBytes();
        this.serverVersion = network.readString();
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public byte[] getSessionToken() {
        return this.sessionToken;
    }

    public OCluster[] getClusterIds() {
        return this.clusterIds;
    }

    public byte[] getDistributedConfiguration() {
        return this.distributedConfiguration;
    }
}

