/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.remote.ORemotePushHandler;
import com.orientechnologies.orient.client.remote.message.OBinaryPushRequest;
import com.orientechnologies.orient.client.remote.message.OBinaryPushResponse;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OPushDistributedConfigurationRequest
implements OBinaryPushRequest<OBinaryPushResponse> {
    public ODocument configuration;
    private List<String> hosts;

    public OPushDistributedConfigurationRequest(List<String> hosts) {
        this.hosts = hosts;
    }

    public OPushDistributedConfigurationRequest() {
    }

    @Override
    public byte getPushCommand() {
        return 80;
    }

    @Override
    public void write(OChannelDataOutput channel) throws IOException {
        channel.writeInt(this.hosts.size());
        for (String host : this.hosts) {
            channel.writeString(host);
        }
    }

    @Override
    public void read(OChannelDataInput network) throws IOException {
        int size = network.readInt();
        this.hosts = new ArrayList<String>(size);
        while (size-- > 0) {
            this.hosts.add(network.readString());
        }
    }

    @Override
    public OBinaryPushResponse execute(ORemotePushHandler remote) {
        return remote.executeUpdateDistributedConfig(this);
    }

    @Override
    public OBinaryPushResponse createResponse() {
        return null;
    }

    public List<String> getHosts() {
        return this.hosts;
    }
}

