/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.client.remote.OLiveQueryClientListener;
import com.orientechnologies.orient.client.remote.ORemoteQueryResult;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.ORemoteResultSet;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OHookReplacedRecordThreadLocal;
import com.orientechnologies.orient.core.db.OLiveQueryMonitor;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.db.document.OSharedContextRemote;
import com.orientechnologies.orient.core.db.document.OTransactionOptimisticClient;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBagDeleter;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerRemote;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaRemote;
import com.orientechnologies.orient.core.metadata.security.OImmutableUser;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODirtyManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OEdgeDelegate;
import com.orientechnologies.orient.core.record.impl.OVertexDelegate;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSaveThreadLocal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OMicroTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ODatabaseDocumentRemote
extends ODatabaseDocumentAbstract {
    protected OStorageRemoteSession sessionMetadata;
    private OrientDBConfig config;
    private OStorageRemote storage;

    public ODatabaseDocumentRemote(OStorageRemote storage) {
        this.activateOnCurrentThread();
        try {
            this.status = ODatabase.STATUS.CLOSED;
            this.url = storage.getURL();
            this.storage = storage;
            this.componentsFactory = storage.getComponentsFactory();
            this.unmodifiableHooks = Collections.unmodifiableMap(this.hooks);
            this.localCache = new OLocalRecordCache();
            this.init();
            this.databaseOwner = this;
        }
        catch (Exception t) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw OException.wrapException((OException)new ODatabaseException("Error on opening database "), (Throwable)t);
        }
    }

    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Use OrientDB");
    }

    @Deprecated
    public <DB extends ODatabase> DB open(OToken iToken) {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    public <DB extends ODatabase> DB create() {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    public <DB extends ODatabase> DB create(String incrementalBackupPath) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public <DB extends ODatabase> DB create(Map<OGlobalConfiguration, Object> iInitialSettings) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public void drop() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <DB extends ODatabase> DB set(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        if (iAttribute == ODatabase.ATTRIBUTES.CUSTOM) {
            int indx;
            String stringValue = iValue.toString();
            int n = indx = stringValue != null ? stringValue.indexOf(61) : -1;
            if (indx < 0) {
                if (!"clear".equalsIgnoreCase(stringValue)) throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                String query = "alter database CUSTOM 'clear'";
                ORemoteQueryResult result = this.getStorage().command(this, query, new Object[]{iValue});
                result.getResult().close();
                return (DB)((Object)this);
            } else {
                String customName = stringValue.substring(0, indx).trim();
                String customValue = stringValue.substring(indx + 1).trim();
                this.setCustom(customName, customValue);
            }
            return (DB)((Object)this);
        } else {
            String query = "alter database " + iAttribute.name() + " ? ";
            ORemoteQueryResult result = this.getStorage().command(this, query, new Object[]{iValue});
            result.getResult().close();
            this.getStorage().reload();
        }
        return (DB)((Object)this);
    }

    public <DB extends ODatabase> DB setCustom(String name, Object iValue) {
        if ("clear".equals(name) && iValue == null) {
            String query = "alter database CUSTOM 'clear'";
            ORemoteQueryResult result = this.getStorage().command(this, query, new Object[0]);
            result.getResult().close();
        } else {
            String query = "alter database CUSTOM  " + name + " = ?";
            ORemoteQueryResult result = this.getStorage().command(this, query, new Object[]{iValue});
            result.getResult().close();
            this.getStorage().reload();
        }
        return (DB)((Object)this);
    }

    public ODatabaseDocumentInternal copy() {
        ODatabaseDocumentRemote database = new ODatabaseDocumentRemote(this.storage);
        database.storage = this.storage.copy(this, database);
        database.storage.addUser();
        database.status = ODatabase.STATUS.OPEN;
        database.applyAttributes(this.config);
        database.initAtFirstOpen();
        database.user = this.user;
        this.activateOnCurrentThread();
        return database;
    }

    public boolean exists() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public void internalOpen(String user, String password, OrientDBConfig config) {
        this.config = config;
        this.applyAttributes(config);
        this.applyListeners(config);
        try {
            this.storage.open(user, password, config.getConfigurations());
            this.status = ODatabase.STATUS.OPEN;
            this.initAtFirstOpen();
            this.user = new OImmutableUser(-1L, new OUser(user, password).addRole((OSecurityRole)new ORole("passthrough", null, OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT)));
            this.callOnOpenListeners();
        }
        catch (OException e) {
            this.close();
            ODatabaseRecordThreadLocal.instance().remove();
            throw e;
        }
        catch (Exception e) {
            this.close();
            ODatabaseRecordThreadLocal.instance().remove();
            throw OException.wrapException((OException)new ODatabaseException("Cannot open database url=" + this.getURL()), (Throwable)e);
        }
    }

    private void applyAttributes(OrientDBConfig config) {
        for (Map.Entry attrs : config.getAttributes().entrySet()) {
            this.set((ODatabase.ATTRIBUTES)attrs.getKey(), attrs.getValue());
        }
    }

    private void initAtFirstOpen() {
        if (this.initialized) {
            return;
        }
        ORecordSerializerFactory serializerFactory = ORecordSerializerFactory.instance();
        this.serializer = serializerFactory.getFormat("onet_ser_v37");
        this.localCache.startup();
        this.componentsFactory = this.getStorage().getComponentsFactory();
        this.user = null;
        this.loadMetadata();
        this.initialized = true;
    }

    protected void loadMetadata() {
        this.metadata = new OMetadataDefault((ODatabaseDocumentInternal)this);
        this.sharedContext = (OSharedContext)this.getStorage().getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextRemote shared = new OSharedContextRemote((OStorage)ODatabaseDocumentRemote.this.getStorage());
                return shared;
            }
        });
        this.metadata.init(this.sharedContext);
        this.sharedContext.load((ODatabaseDocumentInternal)this);
    }

    private void applyListeners(OrientDBConfig config) {
        for (ODatabaseListener listener : config.getListeners()) {
            this.registerListener(listener);
        }
    }

    public ODatabaseDocumentAbstract begin(OTransaction.TXTYPE iType) {
        this.checkOpenness();
        this.checkIfActive();
        if (this.currentTx.isActive()) {
            if (iType == OTransaction.TXTYPE.OPTIMISTIC && this.currentTx instanceof OTransactionOptimistic) {
                this.currentTx.begin();
                return this;
            }
            this.currentTx.rollback(true, 0);
        }
        if (!this.inHook.isEmpty()) {
            throw new IllegalStateException("Cannot begin a transaction while a hook is executing");
        }
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxBegin((ODatabase)this);
            }
            catch (Exception t) {
                OLogManager.instance().error((Object)this, "Error before tx begin", (Throwable)t, new Object[0]);
            }
            catch (Error e) {
                OLogManager.instance().error((Object)this, "Error before tx begin", (Throwable)e, new Object[0]);
                throw e;
            }
        }
        switch (iType) {
            case NOTX: {
                this.setDefaultTransactionMode();
                break;
            }
            case OPTIMISTIC: {
                this.currentTx = new OTransactionOptimisticClient((ODatabaseDocumentInternal)this);
                break;
            }
            case PESSIMISTIC: {
                throw new UnsupportedOperationException("Pessimistic transaction");
            }
        }
        this.currentTx.begin();
        return this;
    }

    public OStorageRemoteSession getSessionMetadata() {
        return this.sessionMetadata;
    }

    public void setSessionMetadata(OStorageRemoteSession sessionMetadata) {
        this.sessionMetadata = sessionMetadata;
    }

    public OStorageRemote getStorage() {
        return this.storage;
    }

    public void replaceStorage(OStorage iNewStorage) {
        throw new UnsupportedOperationException("unsupported replace of storage for remote database");
    }

    private void checkAndSendTransaction() {
        if (this.currentTx.isActive() && ((OTransactionOptimistic)this.currentTx).isChanged()) {
            if (((OTransactionOptimistic)this.getTransaction()).isAlreadyCleared()) {
                this.storage.reBeginTransaction(this, (OTransactionOptimistic)this.currentTx);
            } else {
                this.storage.beginTransaction(this, (OTransactionOptimistic)this.currentTx);
            }
            ((OTransactionOptimistic)this.currentTx).resetChangesTracking();
            ((OTransactionOptimistic)this.currentTx).setSentToServer(true);
        }
    }

    private void fetchTransacion() {
        this.storage.fetchTransaction(this);
    }

    public OResultSet query(String query, Object[] args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.query(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public OResultSet query(String query, Map args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.query(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public OResultSet indexQuery(String indexName, String query, Object ... args) {
        ORemoteQueryResult result;
        this.checkOpenness();
        if (this.getTransaction().isActive()) {
            OTransactionIndexChanges changes = this.getTransaction().getIndexChanges(indexName);
            Set<String> changedIndexes = ((OTransactionOptimisticClient)this.getTransaction()).getIndexChanged();
            if (changedIndexes.contains(indexName) || changes != null) {
                this.checkAndSendTransaction();
            }
        }
        if ((result = this.storage.command(this, query, args)).isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public OResultSet command(String query, Object ... args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.command(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public OResultSet command(String query, Map args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.command(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public OResultSet execute(String language, String script, Object ... args) throws OCommandExecutionException, OCommandScriptException {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.execute(this, language, script, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public OResultSet execute(String language, String script, Map<String, ?> args) throws OCommandExecutionException, OCommandScriptException {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.execute(this, language, script, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public void closeQuery(String queryId) {
        this.storage.closeQuery(this, queryId);
        this.queryClosed(queryId);
    }

    public void fetchNextPage(ORemoteResultSet rs) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        this.storage.fetchNextPage(this, rs);
    }

    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Object ... args) {
        return this.storage.liveQuery(this, query, new OLiveQueryClientListener((ODatabaseDocument)this.copy(), listener), args);
    }

    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Map<String, ?> args) {
        return this.storage.liveQuery(this, query, new OLiveQueryClientListener((ODatabaseDocument)this.copy(), listener), args);
    }

    public void recycle(ORecord record) {
        throw new UnsupportedOperationException();
    }

    protected OMicroTransaction beginMicroTransaction() {
        return null;
    }

    public static void deInit(OStorageRemote storage) {
        OSharedContext sharedContext = (OSharedContext)storage.removeResource(OSharedContext.class.getName());
        if (sharedContext != null) {
            sharedContext.close();
        }
    }

    public static void updateSchema(final OStorageRemote storage, ODocument schema) {
        OSharedContext shared = (OSharedContext)storage.getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextRemote shared = new OSharedContextRemote((OStorage)storage);
                return shared;
            }
        });
        ((OSchemaRemote)shared.getSchema()).update(schema);
    }

    public static void updateIndexManager(final OStorageRemote storage, ODocument indexManager) {
        OSharedContext shared = (OSharedContext)storage.getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextRemote shared = new OSharedContextRemote((OStorage)storage);
                return shared;
            }
        });
        ((OIndexManagerRemote)shared.getIndexManager()).update(indexManager);
    }

    public static void updateFunction(final OStorageRemote storage) {
        OSharedContext shared = (OSharedContext)storage.getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextRemote shared = new OSharedContextRemote((OStorage)storage);
                return shared;
            }
        });
        shared.getFunctionLibrary().update();
    }

    public static void updateSequences(final OStorageRemote storage) {
        OSharedContext shared = (OSharedContext)storage.getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextRemote shared = new OSharedContextRemote((OStorage)storage);
                return shared;
            }
        });
        shared.getSequenceLibrary().update();
    }

    public int addBlobCluster(String iClusterName, Object ... iParameters) {
        try (OResultSet resultSet = this.command("create blob cluster :1", iClusterName);){
            int id;
            assert (resultSet.hasNext());
            OResult result = resultSet.next();
            assert (result.getProperty("value") != null);
            int n = id = ((Integer)result.getProperty("value")).intValue();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RET extends ORecord> RET executeSaveRecord(ORecord record, String clusterName, int ver, ODatabase.OPERATION_MODE mode, boolean forceCreate, ORecordCallback<? extends Number> recordCreatedCallback, ORecordCallback<Integer> recordUpdatedCallback) {
        this.checkOpenness();
        this.checkIfActive();
        if (!record.isDirty()) {
            return (RET)record;
        }
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot create record because it has no identity. Probably is not a regular record or contains projections of fields rather than a full record");
        }
        record.setInternalStatus(ORecordElement.STATUS.MARSHALLING);
        try {
            OStorageOperationResult operationResult;
            byte[] stream = null;
            this.getMetadata().makeThreadLocalSchemaSnapshot();
            if (record instanceof ODocument) {
                ODocumentInternal.checkClass((ODocument)((ODocument)record), (ODatabaseDocumentInternal)this);
            }
            ORecordSerializationContext.pushContext();
            boolean isNew = forceCreate || rid.isNew();
            try {
                ORecord overwritten;
                if (isNew) {
                    ORecordInternal.onBeforeIdentityChanged((ORecord)record);
                    int id = this.assignAndCheckCluster(record, clusterName);
                    clusterName = this.getClusterNameById(id);
                    overwritten = (ORecord)this.beforeCreateOperations((OIdentifiable)record, clusterName);
                } else {
                    overwritten = (ORecord)this.beforeUpdateOperations((OIdentifiable)record, clusterName);
                }
                if (overwritten != null) {
                    record = overwritten;
                }
                stream = this.getSerializer().toStream(record, false);
                ORecordSaveThreadLocal.setLast((ORecord)record);
                try {
                    boolean updateContent = ORecordInternal.isContentChanged((ORecord)record);
                    byte[] content = stream == null ? OCommonConst.EMPTY_BYTE_ARRAY : stream;
                    byte recordType = ORecordInternal.getRecordType((ORecord)record);
                    int modeIndex = mode.ordinal();
                    Orient.instance().getRecordFactoryManager().getRecordTypeClass(recordType);
                    if (forceCreate || ORecordId.isNew((long)rid.getClusterPosition())) {
                        OStorageOperationResult<OPhysicalPosition> ppos = this.getStorage().createRecord(rid, content, ver, recordType, modeIndex, recordCreatedCallback);
                        operationResult = new OStorageOperationResult((Object)((OPhysicalPosition)ppos.getResult()).recordVersion, ppos.isMoved());
                    } else {
                        operationResult = this.getStorage().updateRecord(rid, updateContent, content, ver, recordType, modeIndex, recordUpdatedCallback);
                    }
                    int version = (Integer)operationResult.getResult();
                    if (isNew) {
                        ((ORecordId)record.getIdentity()).copyFrom((ORID)rid);
                        ORecordInternal.onAfterIdentityChanged((ORecord)record);
                    }
                    if (operationResult.getModifiedRecordContent() != null) {
                        stream = operationResult.getModifiedRecordContent();
                    } else if (version > record.getVersion() + 1 && this.getStorage() instanceof OStorageProxy) {
                        record.unload();
                    }
                    ORecordInternal.fill((ORecord)record, (ORID)rid, (int)version, (byte[])stream, (boolean)false);
                    this.callbackHookSuccess(record, isNew, stream, operationResult);
                }
                catch (Exception t) {
                    this.callbackHookFailure(record, isNew, stream);
                    throw t;
                }
            }
            catch (Throwable throwable) {
                this.callbackHookFinalize(record, isNew, stream);
                ORecordSerializationContext.pullContext();
                this.getMetadata().clearThreadLocalSchemaSnapshot();
                ORecordSaveThreadLocal.removeLast();
                throw throwable;
            }
            this.callbackHookFinalize(record, isNew, stream);
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
            ORecordSaveThreadLocal.removeLast();
            if (stream != null && stream.length > 0 && !operationResult.isMoved()) {
                this.getLocalCache().updateRecord(record);
            }
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception t) {
            if (!ORecordId.isValid((long)record.getIdentity().getClusterPosition())) {
                throw OException.wrapException((OException)new ODatabaseException("Error on saving record in cluster #" + record.getIdentity().getClusterId()), (Throwable)t);
            }
            throw OException.wrapException((OException)new ODatabaseException("Error on saving record " + record.getIdentity()), (Throwable)t);
        }
        finally {
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return (RET)record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDeleteRecord(OIdentifiable record, int iVersion, boolean iRequired, ODatabase.OPERATION_MODE iMode, boolean prohibitTombstones) {
        this.checkOpenness();
        this.checkIfActive();
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot delete record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return;
        }
        if ((record = record.getRecord()) == null) {
            return;
        }
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_DELETE, this.getClusterNameById(rid.getClusterId()));
        ORecordSerializationContext.pushContext();
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        try {
            if (record instanceof ODocument) {
                ODocumentInternal.checkClass((ODocument)((ODocument)record), (ODatabaseDocumentInternal)this);
            }
            try {
                OStorageOperationResult operationResult;
                ORecord rec = record.getRecord();
                if (rec != null) {
                    this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, (OIdentifiable)rec);
                    if (rec instanceof ODocument) {
                        ORidBagDeleter.deleteAllRidBags((ODocument)((ODocument)rec));
                    }
                }
                try {
                    if (prohibitTombstones) {
                        boolean result = this.getStorage().cleanOutRecord(rid, iVersion, iMode.ordinal(), null);
                        if (!result && iRequired) {
                            throw new ORecordNotFoundException((ORID)rid);
                        }
                        operationResult = new OStorageOperationResult((Object)result);
                    } else {
                        OStorageOperationResult<Boolean> result = this.getStorage().deleteRecord(rid, iVersion, iMode.ordinal(), null);
                        if (!((Boolean)result.getResult()).booleanValue() && iRequired) {
                            throw new ORecordNotFoundException((ORID)rid);
                        }
                        operationResult = new OStorageOperationResult(result.getResult());
                    }
                    if (!operationResult.isMoved() && rec != null) {
                        this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, (OIdentifiable)rec);
                    } else if (rec != null) {
                        this.callbackHooks(ORecordHook.TYPE.DELETE_REPLICATED, (OIdentifiable)rec);
                    }
                }
                catch (Exception t) {
                    this.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, (OIdentifiable)rec);
                    throw t;
                }
                finally {
                    this.callbackHooks(ORecordHook.TYPE.FINALIZE_DELETION, (OIdentifiable)rec);
                }
                this.clearDocumentTracking(rec);
                if (!operationResult.isMoved()) {
                    this.getLocalCache().deleteRecord((ORID)rid);
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception t) {
                throw OException.wrapException((OException)new ODatabaseException("Error on deleting record in cluster #" + record.getIdentity().getClusterId()), (Throwable)t);
            }
        }
        finally {
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    protected byte[] updateStream(ORecord record) {
        ORecordSerializationContext.pullContext();
        ODirtyManager manager = ORecordInternal.getDirtyManager((ORecord)record);
        Set newRecords = manager.getNewRecords();
        Set updatedRecords = manager.getUpdateRecords();
        manager.clearForSave();
        if (newRecords != null) {
            for (ORecord newRecord : newRecords) {
                if (newRecord == record) continue;
                this.getTransaction().saveRecord(newRecord, null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
            }
        }
        if (updatedRecords != null) {
            for (ORecord updatedRecord : updatedRecords) {
                if (updatedRecord == record) continue;
                this.getTransaction().saveRecord(updatedRecord, null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
            }
        }
        ORecordSerializationContext.pushContext();
        ORecordInternal.unsetDirty((ORecord)record);
        record.setDirty();
        return this.serializer.toStream(record, false);
    }

    public OIdentifiable beforeCreateOperations(OIdentifiable id, String iClusterName) {
        this.checkClusterSecurity(ORole.PERMISSION_CREATE, id, iClusterName);
        ORecordHook.RESULT res = this.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, id);
        if (res == ORecordHook.RESULT.RECORD_CHANGED) {
            if (id instanceof ODocument) {
                ((ODocument)id).validate();
            }
            return id;
        }
        if (res == ORecordHook.RESULT.RECORD_REPLACED) {
            ORecord replaced = (ORecord)OHookReplacedRecordThreadLocal.INSTANCE.get();
            if (replaced instanceof ODocument) {
                ((ODocument)replaced).validate();
            }
            return replaced;
        }
        return null;
    }

    public OIdentifiable beforeUpdateOperations(OIdentifiable id, String iClusterName) {
        this.checkClusterSecurity(ORole.PERMISSION_UPDATE, id, iClusterName);
        ORecordHook.RESULT res = this.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, id);
        if (res == ORecordHook.RESULT.RECORD_CHANGED) {
            if (id instanceof ODocument) {
                ((ODocument)id).validate();
            }
            return id;
        }
        if (res == ORecordHook.RESULT.RECORD_REPLACED) {
            ORecord replaced = (ORecord)OHookReplacedRecordThreadLocal.INSTANCE.get();
            if (replaced instanceof ODocument) {
                ((ODocument)replaced).validate();
            }
            return replaced;
        }
        return null;
    }

    public void beforeDeleteOperations(OIdentifiable id, String iClusterName) {
        this.checkClusterSecurity(ORole.PERMISSION_DELETE, id, iClusterName);
        this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, id);
    }

    public void afterUpdateOperations(OIdentifiable id) {
        ODocument doc;
        OImmutableClass clazz;
        this.callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, id);
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass((ODatabaseDocumentInternal)this, (ODocument)(doc = (ODocument)id))) != null && this.getTransaction().isActive()) {
            ArrayList indexChanges = new ArrayList();
            OClassIndexManager.processIndexOnUpdate((ODatabaseDocumentInternal)this, (ODocument)doc, indexChanges);
            OTransactionOptimisticClient tx = (OTransactionOptimisticClient)this.getTransaction();
            for (OClassIndexManager.IndexChange indexChange : indexChanges) {
                tx.addIndexChanged(indexChange.index.getName());
            }
        }
    }

    public void afterCreateOperations(OIdentifiable id) {
        ODocument doc;
        OImmutableClass clazz;
        this.callbackHooks(ORecordHook.TYPE.AFTER_CREATE, id);
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass((ODatabaseDocumentInternal)this, (ODocument)(doc = (ODocument)id))) != null && this.getTransaction().isActive()) {
            ArrayList indexChanges = new ArrayList();
            OClassIndexManager.processIndexOnCreate((ODatabaseDocumentInternal)this, (ODocument)doc, indexChanges);
            OTransactionOptimisticClient tx = (OTransactionOptimisticClient)this.getTransaction();
            for (OClassIndexManager.IndexChange indexChange : indexChanges) {
                tx.addIndexChanged(indexChange.index.getName());
            }
        }
    }

    public void afterDeleteOperations(OIdentifiable id) {
        ODocument doc;
        OImmutableClass clazz;
        this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, id);
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass((ODatabaseDocumentInternal)this, (ODocument)(doc = (ODocument)id))) != null && this.getTransaction().isActive()) {
            ArrayList indexChanges = new ArrayList();
            OClassIndexManager.processIndexOnDelete((ODatabaseDocumentInternal)this, (ODocument)doc, indexChanges);
            OTransactionOptimisticClient tx = (OTransactionOptimisticClient)this.getTransaction();
            for (OClassIndexManager.IndexChange indexChange : indexChanges) {
                tx.addIndexChanged(indexChange.index.getName());
            }
        }
    }

    public boolean beforeReadOperations(OIdentifiable identifiable) {
        return this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, identifiable) == ORecordHook.RESULT.SKIP;
    }

    public void afterReadOperations(OIdentifiable identifiable) {
        this.callbackHooks(ORecordHook.TYPE.AFTER_READ, identifiable);
    }

    public ODatabaseDocumentAbstract delete(ORecord record) {
        this.checkOpenness();
        if (record == null) {
            throw new ODatabaseException("Cannot delete null document");
        }
        if (record instanceof OVertex) {
            this.reload(record, "in*:2 out*:2");
            OVertexDelegate.deleteLinks((OVertex)((OVertex)record));
        } else if (record instanceof OEdge) {
            this.reload(record.getRecord(), "in:1 out:1");
            OEdgeDelegate.deleteLinks((OEdge)((OEdge)record));
        } else if (record instanceof ODocument) {
            OElement elem = (OElement)record;
            if (elem.isVertex()) {
                OVertex delegate = (OVertex)elem.asVertex().get();
                this.reload(delegate.getRecord(), "in*:2 out*:2");
                OVertexDelegate.deleteLinks((OVertex)delegate);
            } else if (elem.isEdge()) {
                OEdge delegate = (OEdge)elem.asEdge().get();
                this.reload(delegate.getRecord(), "in:1 out:1");
                OEdgeDelegate.deleteLinks((OEdge)delegate);
            }
        }
        if (record instanceof ODocument && ((ODocument)record).getClassName() != null) {
            this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_DELETE, ((ODocument)record).getClassName());
        }
        try {
            this.currentTx.deleteRecord(record, ODatabase.OPERATION_MODE.SYNCHRONOUS);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            if (record instanceof ODocument) {
                throw OException.wrapException((OException)new ODatabaseException("Error on deleting record " + record.getIdentity() + " of class '" + ((ODocument)record).getClassName() + "'"), (Throwable)e);
            }
            throw OException.wrapException((OException)new ODatabaseException("Error on deleting record " + record.getIdentity()), (Throwable)e);
        }
        return this;
    }
}

