/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OReloadResponse
implements OBinaryResponse {
    private String[] clusterNames;
    private int[] clusterIds;

    public OReloadResponse() {
    }

    public OReloadResponse(String[] clusterNames, int[] clusterIds) {
        this.clusterNames = clusterNames;
        this.clusterIds = clusterIds;
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        ORawPair<String[], int[]> clusters = OMessageHelper.readClustersArray(network);
        this.clusterNames = (String[])clusters.getFirst();
        this.clusterIds = (int[])clusters.getSecond();
    }

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        OMessageHelper.writeClustersArray(channel, (ORawPair<String[], int[]>)new ORawPair((Object)this.clusterNames, (Object)this.clusterIds), protocolVersion);
    }

    public String[] getClusterNames() {
        return this.clusterNames;
    }

    public int[] getClusterIds() {
        return this.clusterIds;
    }
}

