/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.binary;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OSystemException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OStorageRemoteNodeSession;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OError37Response;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import com.orientechnologies.orient.enterprise.channel.OSocketFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.enterprise.channel.binary.OResponseProcessingException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;

public class OChannelBinaryAsynchClient
extends OChannelBinary {
    private int socketTimeout;
    protected final short srvProtocolVersion;
    private String serverURL;
    private byte currentStatus;
    private int currentSessionId;
    private byte currentMessage;
    private volatile long lastUse;
    private volatile boolean inUse;

    public OChannelBinaryAsynchClient(String remoteHost, int remotePort, String iDatabaseName, OContextConfiguration iConfig, int iProtocolVersion) throws IOException {
        super(OSocketFactory.instance((OContextConfiguration)iConfig).createSocket(), iConfig);
        try {
            this.serverURL = remoteHost + ":" + remotePort;
            if (iDatabaseName != null) {
                this.serverURL = this.serverURL + "/" + iDatabaseName;
            }
            this.socketTimeout = iConfig.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_TIMEOUT);
            try {
                this.socket.connect(new InetSocketAddress(remoteHost, remotePort), this.getSocketTimeout());
                this.setReadResponseTimeout();
                this.connected();
            }
            catch (SocketTimeoutException e) {
                throw new IOException("Cannot connect to host " + remoteHost + ":" + remotePort, e);
            }
            try {
                if (this.socketBufferSize > 0) {
                    this.inStream = new BufferedInputStream(this.socket.getInputStream(), this.socketBufferSize);
                    this.outStream = new BufferedOutputStream(this.socket.getOutputStream(), this.socketBufferSize);
                } else {
                    this.inStream = new BufferedInputStream(this.socket.getInputStream());
                    this.outStream = new BufferedOutputStream(this.socket.getOutputStream());
                }
                this.in = new DataInputStream(this.inStream);
                this.out = new DataOutputStream(this.outStream);
                this.srvProtocolVersion = this.readShort();
                this.writeByte((byte)20);
                this.writeShort((short)iProtocolVersion);
                this.writeString("Java Client");
                this.writeString(OConstants.getVersion());
                this.writeByte((byte)0);
                this.writeByte((byte)0);
                this.flush();
            }
            catch (IOException e) {
                throw new ONetworkProtocolException("Cannot read protocol version from remote server " + this.socket.getRemoteSocketAddress() + ": " + e);
            }
            if (this.srvProtocolVersion != iProtocolVersion) {
                OLogManager.instance().warn((Object)this, "The Client driver version is different than Server version: client=" + iProtocolVersion + ", server=" + this.srvProtocolVersion + ". You could not use the full features of the newer version. Assure to have the same versions on both", new Object[0]);
            }
        }
        catch (RuntimeException e) {
            if (this.socket.isConnected()) {
                this.socket.close();
            }
            throw e;
        }
    }

    private static RuntimeException createException(String iClassName, String iMessage, Exception iPrevious) {
        OException rootException = null;
        Constructor<?> c = null;
        try {
            Class<?> excClass = Class.forName(iClassName);
            if (iPrevious != null) {
                try {
                    c = excClass.getConstructor(String.class, Throwable.class);
                }
                catch (NoSuchMethodException e) {
                    c = excClass.getConstructor(String.class, Exception.class);
                }
            }
            if (c == null) {
                c = excClass.getConstructor(String.class);
            }
        }
        catch (Exception e) {
            rootException = OException.wrapException((OException)new OSystemException(iMessage), (Throwable)iPrevious);
        }
        if (c != null) {
            try {
                Exception cause = c.getParameterTypes().length > 1 ? (Exception)c.newInstance(iMessage, iPrevious) : (Exception)c.newInstance(iMessage);
                rootException = OException.wrapException((OException)new OSystemException("Data processing exception"), (Throwable)cause);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return rootException;
    }

    public byte[] beginResponse(int iRequesterId, boolean token) throws IOException {
        return this.beginResponse(iRequesterId, this.timeout, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] beginResponse(int iRequesterId, long iTimeout, boolean token) throws IOException {
        try {
            if (iTimeout <= 0L) {
                this.acquireReadLock();
            }
            if (!this.isConnected()) {
                this.releaseReadLock();
                throw new IOException("Channel is closed");
            }
            try {
                this.setWaitResponseTimeout();
                this.currentStatus = this.readByte();
                this.currentSessionId = this.readInt();
                if (this.debug) {
                    OLogManager.instance().debug((Object)this, "%s - Read response: %d-%d", new Object[]{this.socket.getLocalAddress(), (int)this.currentStatus, this.currentSessionId});
                }
            }
            finally {
                this.setReadResponseTimeout();
            }
            assert (this.currentSessionId == iRequesterId);
            if (this.debug) {
                OLogManager.instance().debug((Object)this, "%s - Session %d handle response", new Object[]{this.socket.getLocalAddress(), iRequesterId});
            }
            byte[] tokenBytes = token ? this.readBytes() : null;
            this.currentMessage = this.readByte();
            this.handleStatus(this.currentStatus, this.currentSessionId);
            return tokenBytes;
        }
        catch (OLockException e) {
            Thread.currentThread().interrupt();
            OLogManager.instance().error((Object)this, "Unexpected error on reading response from channel", (Throwable)e, new Object[0]);
            return null;
        }
    }

    public void endResponse() throws IOException {
        try {
            this.releaseReadLock();
        }
        catch (IllegalMonitorStateException e) {
            OLogManager.instance().debug((Object)this, "Error on unlocking network channel after reading response", new Object[0]);
        }
    }

    public void endRequest() throws IOException {
        this.flush();
        this.releaseWriteLock();
    }

    public void close() {
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearInput() throws IOException {
        this.acquireReadLock();
        try {
            super.clearInput();
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean isConnected() {
        Socket s = this.socket;
        return s != null && !s.isClosed() && s.isConnected() && !s.isInputShutdown() && !s.isOutputShutdown();
    }

    public short getSrvProtocolVersion() {
        return this.srvProtocolVersion;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public boolean tryLock() {
        return this.getLockWrite().tryAcquireLock();
    }

    public void unlock() {
        this.getLockWrite().unlock();
    }

    public int handleStatus(byte iResult, int iClientTxId, ExceptionHandler exceptionHandler) throws IOException {
        if (iResult == 0 || iResult == 3) {
            return iClientTxId;
        }
        if (iResult == 1) {
            OError37Response response = new OError37Response();
            response.read((OChannelDataInput)this, null);
            byte[] serializedException = response.getVerbose();
            RuntimeException previous = null;
            if (serializedException != null && serializedException.length > 0) {
                Throwable deserializeException = this.deserializeException(serializedException);
                exceptionHandler.onException(deserializeException);
            }
            for (Map.Entry<String, String> entry : response.getMessages().entrySet()) {
                previous = OChannelBinaryAsynchClient.createException(entry.getKey(), entry.getValue(), previous);
            }
            if (previous != null) {
                exceptionHandler.onException(new RuntimeException(previous));
            } else {
                exceptionHandler.onException((Throwable)new ONetworkProtocolException("Network response error"));
            }
        } else {
            exceptionHandler.onException((Throwable)new ONetworkProtocolException("Error on reading response from the server"));
        }
        return iClientTxId;
    }

    public int handleStatus(byte iResult, int iClientTxId) throws IOException {
        return this.handleStatus(iResult, iClientTxId, this::handleException);
    }

    private void setReadResponseTimeout() throws SocketException {
        Socket s = this.socket;
        if (s != null && s.isConnected() && !s.isClosed()) {
            s.setSoTimeout(this.getSocketTimeout());
        }
    }

    private Throwable deserializeException(byte[] serializedException) throws IOException {
        OMemoryInputStream inputStream = new OMemoryInputStream(serializedException);
        ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)inputStream);
        Object throwable = null;
        try {
            throwable = objectInputStream.readObject();
        }
        catch (ClassNotFoundException e) {
            OLogManager.instance().error((Object)this, "Error during exception deserialization", (Throwable)e, new Object[0]);
            throw new IOException("Error during exception deserialization: " + e.toString(), e);
        }
        objectInputStream.close();
        return (Throwable)throwable;
    }

    public void handleException(Throwable throwable) {
        if (throwable instanceof OException) {
            try {
                Class<?> cls = throwable.getClass();
                Constructor<?> constructor = cls.getConstructor(cls);
                OException proxyInstance = (OException)((Object)constructor.newInstance(throwable));
                proxyInstance.addSuppressed((Throwable)((Exception)throwable));
                throw proxyInstance;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                OLogManager.instance().error((Object)this, "Error during exception deserialization", (Throwable)e, new Object[0]);
            }
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Throwable) {
            throw new OResponseProcessingException("Exception during response processing", throwable);
        }
        OLogManager.instance().error((Object)this, "Error during exception serialization, serialized exception is not Throwable, exception type is " + (throwable != null ? throwable.getClass().getName() : "null"), null, new Object[0]);
    }

    public void beginRequest(byte iCommand, OStorageRemoteSession session) throws IOException {
        OStorageRemoteNodeSession nodeSession = session.getServerSession(this.getServerURL());
        this.beginRequest(iCommand, nodeSession);
    }

    public void beginRequest(byte iCommand, OStorageRemoteNodeSession nodeSession) throws IOException {
        if (nodeSession == null) {
            throw new OIOException("Invalid session for URL '" + this.getServerURL() + "'");
        }
        this.writeByte(iCommand);
        this.writeInt(nodeSession.getSessionId());
        this.writeBytes(nodeSession.getToken());
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    private void markLastUse() {
        this.lastUse = System.currentTimeMillis();
    }

    public long getLastUse() {
        return this.lastUse;
    }

    public void markReturned() {
        this.markLastUse();
        this.inUse = false;
    }

    public void markInUse() {
        this.markLastUse();
        this.inUse = false;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public static interface ExceptionHandler {
        public void onException(Throwable var1);
    }
}

