/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.message.OSBTFetchEntriesMajorRequest;
import com.orientechnologies.orient.client.remote.message.OSBTFetchEntriesMajorResponse;
import com.orientechnologies.orient.client.remote.message.OSBTFirstKeyRequest;
import com.orientechnologies.orient.client.remote.message.OSBTFirstKeyResponse;
import com.orientechnologies.orient.client.remote.message.OSBTGetRealBagSizeRequest;
import com.orientechnologies.orient.client.remote.message.OSBTGetRealBagSizeResponse;
import com.orientechnologies.orient.client.remote.message.OSBTGetRequest;
import com.orientechnologies.orient.client.remote.message.OSBTGetResponse;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OSBTreeBonsaiRemote<K, V>
implements OSBTreeBonsai<K, V> {
    private final OBonsaiCollectionPointer treePointer;
    private final OBinarySerializer<K> keySerializer;
    private final OBinarySerializer<V> valueSerializer;

    public OSBTreeBonsaiRemote(OBonsaiCollectionPointer treePointer, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        this.treePointer = treePointer;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public long getFileId() {
        return this.treePointer.getFileId();
    }

    public OBonsaiBucketPointer getRootBucketPointer() {
        return this.treePointer.getRootPointer();
    }

    public OBonsaiCollectionPointer getCollectionPointer() {
        return this.treePointer;
    }

    public V get(K key) {
        OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.instance().get().getStorage().getUnderlying();
        byte[] keyStream = new byte[this.keySerializer.getObjectSize(key, new Object[0])];
        this.keySerializer.serialize(key, keyStream, 0, new Object[0]);
        OBonsaiCollectionPointer collectionPointer = this.getCollectionPointer();
        OSBTGetRequest request = new OSBTGetRequest(collectionPointer, keyStream);
        OSBTGetResponse response = storage.networkOperation(request, "Cannot get by key from sb-tree bonsai");
        byte[] stream = response.getStream();
        byte serializerId = OByteSerializer.INSTANCE.deserializeLiteral(stream, 0);
        OBinarySerializer serializer = OBinarySerializerFactory.getInstance().getObjectSerializer(serializerId);
        return (V)serializer.deserialize(stream, 1);
    }

    public boolean put(OAtomicOperation atomicOperation, K key, V value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public V remove(OAtomicOperation atomicOperation, K key) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void clear(OAtomicOperation atomicOperation) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void delete(OAtomicOperation atomicOperation) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long size() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<V> getValuesMinor(K key, boolean inclusive, int maxValuesToFetch) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void loadEntriesMinor(K key, boolean inclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<V> getValuesMajor(K key, boolean inclusive, int maxValuesToFetch) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void loadEntriesMajor(K key, boolean inclusive, boolean ascSortOrder, OTreeInternal.RangeResultListener<K, V> listener) {
        if (!ascSortOrder) {
            throw new IllegalStateException("Descending sort order is not supported");
        }
        List<Map.Entry<K, V>> entries = this.fetchEntriesMajor(key, inclusive);
        while (this.pushEntriesToListener(listener, entries)) {
            K nextKey = entries.get(entries.size() - 1).getKey();
            entries = this.fetchEntriesMajor(nextKey, false);
        }
    }

    private boolean pushEntriesToListener(OTreeInternal.RangeResultListener<K, V> listener, List<Map.Entry<K, V>> entries) {
        boolean more = false;
        for (Map.Entry<K, V> entry : entries) {
            more = listener.addResult(entry);
            if (more) continue;
            return false;
        }
        return more;
    }

    private List<Map.Entry<K, V>> fetchEntriesMajor(K key, boolean inclusive) {
        byte[] keyStream = new byte[this.keySerializer.getObjectSize(key, new Object[0])];
        this.keySerializer.serialize(key, keyStream, 0, new Object[0]);
        OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.instance().get().getStorage().getUnderlying();
        OSBTFetchEntriesMajorRequest<K, V> request = new OSBTFetchEntriesMajorRequest<K, V>(inclusive, keyStream, this.getCollectionPointer(), this.keySerializer, this.valueSerializer);
        OSBTFetchEntriesMajorResponse response = (OSBTFetchEntriesMajorResponse)storage.networkOperation(request, "Cannot get first key from sb-tree bonsai");
        return response.getList();
    }

    public Collection<V> getValuesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, int maxValuesToFetch) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public K firstKey() {
        OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.instance().get().getStorage().getUnderlying();
        OBonsaiCollectionPointer collectionPointer = this.getCollectionPointer();
        OSBTFirstKeyRequest request = new OSBTFirstKeyRequest(collectionPointer);
        OSBTFirstKeyResponse response = storage.networkOperation(request, "Cannot get first key from sb-tree bonsai");
        byte[] stream = response.getStream();
        byte serializerId = OByteSerializer.INSTANCE.deserializeLiteral(stream, 0);
        OBinarySerializer serializer = OBinarySerializerFactory.getInstance().getObjectSerializer(serializerId);
        return (K)serializer.deserialize(stream, 1);
    }

    public K lastKey() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void loadEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int getRealBagSize(Map<K, Change> changes) {
        OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.instance().get().getStorage().getUnderlying();
        OBonsaiCollectionPointer collectionPointer = this.getCollectionPointer();
        OSBTGetRealBagSizeRequest request = new OSBTGetRealBagSizeRequest(this.keySerializer, collectionPointer, changes);
        OSBTGetRealBagSizeResponse response = storage.networkOperation(request, "Cannot get by real bag size sb-tree bonsai");
        return response.getRealSize();
    }

    public OBinarySerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public OBinarySerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public void markToDelete(OAtomicOperation atomicOperation) {
        throw new UnsupportedOperationException();
    }

    public static class TreeEntry<EK, EV>
    implements Map.Entry<EK, EV> {
        private final EK key;
        private final EV value;

        public TreeEntry(EK key, EV value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public EK getKey() {
            return this.key;
        }

        @Override
        public EV getValue() {
            return this.value;
        }

        @Override
        public EV setValue(EV value) {
            throw new UnsupportedOperationException();
        }
    }
}

