/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.thread.OScheduledThreadPoolExecutorWithLogging;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.client.ONotSendRequestException;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.client.remote.OBinaryAsyncRequest;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OClusterRemote;
import com.orientechnologies.orient.client.remote.OLiveQueryClientListener;
import com.orientechnologies.orient.client.remote.ORemoteConnectionManager;
import com.orientechnologies.orient.client.remote.ORemotePushHandler;
import com.orientechnologies.orient.client.remote.ORemoteQueryResult;
import com.orientechnologies.orient.client.remote.OSBTreeCollectionManagerRemote;
import com.orientechnologies.orient.client.remote.OStorageConfigurationRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteNodeSession;
import com.orientechnologies.orient.client.remote.OStorageRemoteOperation;
import com.orientechnologies.orient.client.remote.OStorageRemotePushThread;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OAddClusterRequest;
import com.orientechnologies.orient.client.remote.message.OAddClusterResponse;
import com.orientechnologies.orient.client.remote.message.OBeginTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OBeginTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OBinaryPushRequest;
import com.orientechnologies.orient.client.remote.message.OBinaryPushResponse;
import com.orientechnologies.orient.client.remote.message.OCeilingPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OCeilingPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OCleanOutRecordRequest;
import com.orientechnologies.orient.client.remote.message.OCleanOutRecordResponse;
import com.orientechnologies.orient.client.remote.message.OCloseQueryRequest;
import com.orientechnologies.orient.client.remote.message.OCloseRequest;
import com.orientechnologies.orient.client.remote.message.OCommandRequest;
import com.orientechnologies.orient.client.remote.message.OCommandResponse;
import com.orientechnologies.orient.client.remote.message.OCommit37Request;
import com.orientechnologies.orient.client.remote.message.OCommit37Response;
import com.orientechnologies.orient.client.remote.message.OCountRecordsRequest;
import com.orientechnologies.orient.client.remote.message.OCountRecordsResponse;
import com.orientechnologies.orient.client.remote.message.OCountRequest;
import com.orientechnologies.orient.client.remote.message.OCountResponse;
import com.orientechnologies.orient.client.remote.message.OCreateRecordRequest;
import com.orientechnologies.orient.client.remote.message.OCreateRecordResponse;
import com.orientechnologies.orient.client.remote.message.ODeleteRecordRequest;
import com.orientechnologies.orient.client.remote.message.ODeleteRecordResponse;
import com.orientechnologies.orient.client.remote.message.ODropClusterRequest;
import com.orientechnologies.orient.client.remote.message.ODropClusterResponse;
import com.orientechnologies.orient.client.remote.message.OFetchTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OFetchTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OFloorPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OFloorPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OGetClusterDataRangeRequest;
import com.orientechnologies.orient.client.remote.message.OGetClusterDataRangeResponse;
import com.orientechnologies.orient.client.remote.message.OGetRecordMetadataRequest;
import com.orientechnologies.orient.client.remote.message.OGetRecordMetadataResponse;
import com.orientechnologies.orient.client.remote.message.OGetSizeRequest;
import com.orientechnologies.orient.client.remote.message.OGetSizeResponse;
import com.orientechnologies.orient.client.remote.message.OHideRecordRequest;
import com.orientechnologies.orient.client.remote.message.OHideRecordResponse;
import com.orientechnologies.orient.client.remote.message.OHigherPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OHigherPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OImportRequest;
import com.orientechnologies.orient.client.remote.message.OImportResponse;
import com.orientechnologies.orient.client.remote.message.OIncrementalBackupRequest;
import com.orientechnologies.orient.client.remote.message.OIncrementalBackupResponse;
import com.orientechnologies.orient.client.remote.message.OLiveQueryPushRequest;
import com.orientechnologies.orient.client.remote.message.OLowerPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OLowerPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OOpen37Request;
import com.orientechnologies.orient.client.remote.message.OOpen37Response;
import com.orientechnologies.orient.client.remote.message.OPushDistributedConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OPushFunctionsRequest;
import com.orientechnologies.orient.client.remote.message.OPushIndexManagerRequest;
import com.orientechnologies.orient.client.remote.message.OPushSchemaRequest;
import com.orientechnologies.orient.client.remote.message.OPushSequencesRequest;
import com.orientechnologies.orient.client.remote.message.OPushStorageConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OQueryNextPageRequest;
import com.orientechnologies.orient.client.remote.message.OQueryRequest;
import com.orientechnologies.orient.client.remote.message.OQueryResponse;
import com.orientechnologies.orient.client.remote.message.OReadRecordIfVersionIsNotLatestRequest;
import com.orientechnologies.orient.client.remote.message.OReadRecordIfVersionIsNotLatestResponse;
import com.orientechnologies.orient.client.remote.message.OReadRecordRequest;
import com.orientechnologies.orient.client.remote.message.OReadRecordResponse;
import com.orientechnologies.orient.client.remote.message.ORebeginTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OReloadRequest37;
import com.orientechnologies.orient.client.remote.message.OReloadResponse37;
import com.orientechnologies.orient.client.remote.message.ORemoteResultSet;
import com.orientechnologies.orient.client.remote.message.OReopenRequest;
import com.orientechnologies.orient.client.remote.message.OReopenResponse;
import com.orientechnologies.orient.client.remote.message.ORollbackTransactionRequest;
import com.orientechnologies.orient.client.remote.message.ORollbackTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OSubscribeDistributedConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeFunctionsRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeIndexManagerRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeLiveQueryRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeLiveQueryResponse;
import com.orientechnologies.orient.client.remote.message.OSubscribeSchemaRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeSequencesRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeStorageConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OUnsubscribeLiveQueryRequest;
import com.orientechnologies.orient.client.remote.message.OUnsubscribeRequest;
import com.orientechnologies.orient.client.remote.message.OUpdateRecordRequest;
import com.orientechnologies.orient.client.remote.message.OUpdateRecordResponse;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequestAsynch;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OLiveQueryMonitor;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBRemote;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentRemote;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTxInternal;
import com.orientechnologies.orient.core.db.document.OLiveQueryMonitorRemote;
import com.orientechnologies.orient.core.db.document.OTransactionOptimisticClient;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.OTokenException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OCredentialInterceptor;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.query.OLiveQuery;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.cluster.OPaginatedCluster;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import com.orientechnologies.orient.enterprise.channel.binary.ODistributedRedirectException;
import com.orientechnologies.orient.enterprise.channel.binary.OTokenSecurityException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class OStorageRemote
extends OStorageAbstract
implements OStorageProxy,
ORemotePushHandler {
    @Deprecated
    public static final String PARAM_CONNECTION_STRATEGY = "connectionStrategy";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 2424;
    private static final int DEFAULT_SSL_PORT = 2434;
    public static final String ADDRESS_SEPARATOR = ";";
    public static final String DRIVER_NAME = "OrientDB Java";
    private static final String LOCAL_IP = "127.0.0.1";
    private static final String LOCALHOST = "localhost";
    private static AtomicInteger sessionSerialId = new AtomicInteger(-1);
    private CONNECTION_STRATEGY connectionStrategy = CONNECTION_STRATEGY.STICKY;
    private final OSBTreeCollectionManagerRemote sbTreeCollectionManager = new OSBTreeCollectionManagerRemote((OStorage)this);
    private final List<String> serverURLs = new ArrayList<String>();
    private final Map<String, OCluster> clusterMap = new ConcurrentHashMap<String, OCluster>();
    private final ExecutorService asynchExecutor;
    private final ODocument clusterConfiguration = new ODocument();
    private final AtomicInteger users = new AtomicInteger(0);
    private OContextConfiguration clientConfiguration;
    private int connectionRetry;
    private int connectionRetryDelay;
    private OCluster[] clusters = OCommonConst.EMPTY_CLUSTER_ARRAY;
    private int defaultClusterId;
    public ORemoteConnectionManager connectionManager;
    private final Set<OStorageRemoteSession> sessions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Integer, OLiveQueryClientListener> liveQueryListener = new ConcurrentHashMap<Integer, OLiveQueryClientListener>();
    private volatile OStorageRemotePushThread pushThread;
    private final OrientDBRemote context;
    private int nextServerToConnect = 0;

    public OStorageRemote(String iURL, OrientDBRemote context, String iMode, ORemoteConnectionManager connectionManager, OrientDBConfig config) throws IOException {
        this(iURL, context, iMode, connectionManager, null, config);
    }

    public OStorageRemote(String iURL, OrientDBRemote context, String iMode, ORemoteConnectionManager connectionManager, OStorage.STATUS status, OrientDBConfig config) throws IOException {
        super(iURL, iURL, iMode);
        if (status != null) {
            this.status = status;
        }
        this.configuration = null;
        this.clientConfiguration = config != null ? config.getConfigurations() : new OContextConfiguration();
        this.connectionRetry = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY);
        this.connectionRetryDelay = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY_DELAY);
        this.parseServerURLs();
        this.asynchExecutor = new OScheduledThreadPoolExecutorWithLogging(1);
        this.connectionManager = connectionManager;
        this.context = context;
    }

    public <T extends OBinaryResponse> T asyncNetworkOperationNoRetry(OBinaryAsyncRequest<T> request, int mode, ORecordId recordId, ORecordCallback<T> callback, String errorMessage) {
        return this.asyncNetworkOperationRetry(request, mode, recordId, callback, errorMessage, 0);
    }

    public <T extends OBinaryResponse> T asyncNetworkOperationRetry(OBinaryAsyncRequest<T> request, int mode, ORecordId recordId, ORecordCallback<T> callback, String errorMessage, int retry) {
        int pMode = mode == 1 && callback == null ? 2 : mode;
        request.setMode((byte)pMode);
        return (T)this.baseNetworkOperation((network, session) -> {
            try {
                try {
                    network.beginRequest(request.getCommand(), session);
                    request.write((OChannelDataOutput)network, session);
                }
                finally {
                    network.endRequest();
                }
            }
            catch (IOException e) {
                throw new ONotSendRequestException("Cannot send request on this channel");
            }
            Object response = request.createResponse();
            OBinaryResponse ret = null;
            if (pMode == 0) {
                try {
                    this.beginResponse(network, session);
                    response.read((OChannelDataInput)network, session);
                }
                finally {
                    this.endResponse(network);
                }
                ret = (OBinaryResponse)response;
                this.connectionManager.release(network);
            } else if (pMode == 1) {
                this.asynchExecutor.submit(() -> {
                    try {
                        try {
                            this.beginResponse(network, session);
                            response.read((OChannelDataInput)network, session);
                        }
                        finally {
                            this.endResponse(network);
                        }
                        callback.call(recordId, response);
                        this.connectionManager.release(network);
                    }
                    catch (Exception e) {
                        this.connectionManager.remove(network);
                        OLogManager.instance().error((Object)this, "Exception on async query", (Throwable)e, new Object[0]);
                    }
                    catch (Error e) {
                        this.connectionManager.remove(network);
                        OLogManager.instance().error((Object)this, "Exception on async query", (Throwable)e, new Object[0]);
                        throw e;
                    }
                });
            } else {
                this.connectionManager.release(network);
            }
            return ret;
        }, errorMessage, retry);
    }

    public <T extends OBinaryResponse> T networkOperationRetryTimeout(OBinaryRequest<T> request, String errorMessage, int retry, int timeout) {
        return (T)this.baseNetworkOperation((network, session) -> {
            try {
                try {
                    network.beginRequest(request.getCommand(), session);
                    request.write((OChannelDataOutput)network, session);
                }
                finally {
                    network.endRequest();
                }
            }
            catch (IOException e) {
                if (network.isConnected()) {
                    OLogManager.instance().warn((Object)this, "Error Writing request on the network", (Throwable)e, new Object[0]);
                }
                throw new ONotSendRequestException("Cannot send request on this channel");
            }
            int prev = network.getSocketTimeout();
            Object response = request.createResponse();
            try {
                if (timeout > 0) {
                    network.setSocketTimeout(timeout);
                }
                this.beginResponse(network, session);
                response.read((OChannelDataInput)network, session);
            }
            finally {
                this.endResponse(network);
                if (timeout > 0) {
                    network.setSocketTimeout(prev);
                }
            }
            this.connectionManager.release(network);
            return response;
        }, errorMessage, retry);
    }

    public <T extends OBinaryResponse> T networkOperationNoRetry(OBinaryRequest<T> request, String errorMessage) {
        return this.networkOperationRetryTimeout(request, errorMessage, 0, 0);
    }

    public <T extends OBinaryResponse> T networkOperation(OBinaryRequest<T> request, String errorMessage) {
        return this.networkOperationRetryTimeout(request, errorMessage, this.connectionRetry, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T baseNetworkOperation(OStorageRemoteOperation<T> operation, String errorMessage, int retry) {
        OStorageRemoteSession session = this.getCurrentSession();
        if (session.commandExecuting) {
            throw new ODatabaseException("Cannot execute the request because an asynchronous operation is in progress. Please use a different connection");
        }
        String serverUrl = null;
        while (true) {
            Object object;
            OChannelBinaryAsynchClient network = null;
            if (serverUrl == null) {
                serverUrl = this.getNextAvailableServerURL(false, session);
            }
            do {
                try {
                    network = this.getNetwork(serverUrl);
                }
                catch (OException e) {
                    if (session.isStickToSession()) {
                        throw e;
                    }
                    if ((serverUrl = this.useNewServerURL(serverUrl)) != null) continue;
                    throw e;
                }
            } while (network == null);
            try {
                session.commandExecuting = true;
                OStorageRemoteNodeSession nodeSession = session.getServerSession(network.getServerURL());
                if (nodeSession == null || !nodeSession.isValid()) {
                    this.openRemoteDatabase(network);
                    if (!network.tryLock()) continue;
                }
                object = operation.execute(network, session);
                return (T)object;
            }
            catch (ONotSendRequestException e) {
                this.connectionManager.remove(network);
                serverUrl = null;
                continue;
            }
            catch (ODistributedRedirectException e) {
                this.connectionManager.release(network);
                OLogManager.instance().debug((Object)this, "Redirecting the request from server '%s' to the server '%s' because %s", new Object[]{e.getFromServer(), e.toString(), e.getMessage()});
                serverUrl = e.getToServerAddress();
                continue;
            }
            catch (OModificationOperationProhibitedException mope) {
                this.connectionManager.release(network);
                this.handleDBFreeze();
                serverUrl = null;
                continue;
            }
            catch (OTokenException | OTokenSecurityException e) {
                this.connectionManager.release(network);
                if (session.isStickToSession()) {
                    session.removeServerSession(network.getServerURL());
                    throw OException.wrapException((OException)new OStorageException(errorMessage), (Throwable)e);
                }
                session.removeServerSession(network.getServerURL());
                serverUrl = null;
                continue;
            }
            catch (OOfflineNodeException e) {
                this.connectionManager.release(network);
                object = this.serverURLs;
                synchronized (object) {
                    this.serverURLs.remove(serverUrl);
                    this.nextServerToConnect = 0;
                }
                for (OStorageRemoteSession activeSession : this.sessions) {
                    activeSession.removeServerSession(serverUrl);
                }
                serverUrl = null;
                continue;
            }
            catch (OIOException | IOException e) {
                OLogManager.instance().info((Object)this, "Caught Network I/O errors on %s, trying an automatic reconnection... (error: %s)", new Object[]{network.getServerURL(), e.getMessage()});
                OLogManager.instance().debug((Object)this, "I/O error stack: ", e, new Object[0]);
                this.connectionManager.remove(network);
                if (--retry <= 0) {
                    throw OException.wrapException((OException)((Object)new OIOException(e.getMessage())), (Throwable)e);
                }
                try {
                    Thread.sleep(this.connectionRetryDelay);
                }
                catch (InterruptedException e1) {
                    OLogManager.instance().error((Object)this, "Exception was suppressed, original exception is ", e, new Object[0]);
                    throw OException.wrapException((OException)new OInterruptedException(e1.getMessage()), (Throwable)e1);
                }
                serverUrl = null;
                continue;
            }
            catch (OException e) {
                this.connectionManager.release(network);
                throw e;
            }
            catch (Exception e) {
                this.connectionManager.release(network);
                throw OException.wrapException((OException)new OStorageException(errorMessage), (Throwable)e);
            }
            finally {
                session.commandExecuting = false;
                continue;
            }
            break;
        }
    }

    public boolean isAssigningClusterIds() {
        return false;
    }

    public String getCreatedAtVersion() {
        throw new UnsupportedOperationException("Supported only in embedded storage. Use 'SELECT FROM metadata:storage' instead.");
    }

    public int getSessionId() {
        OStorageRemoteSession session = this.getCurrentSession();
        return session != null ? session.getSessionId() : -1;
    }

    public String getServerURL() {
        OStorageRemoteSession session = this.getCurrentSession();
        return session != null ? session.getServerUrl() : null;
    }

    public void open(String iUserName, String iUserPassword, OContextConfiguration conf) {
        this.stateLock.acquireWriteLock();
        this.addUser();
        try {
            OStorageRemoteSession session = this.getCurrentSession();
            if (this.status == OStorage.STATUS.CLOSED || !iUserName.equals(session.connectionUserName) || !iUserPassword.equals(session.connectionUserPassword) || session.sessions.isEmpty()) {
                OCredentialInterceptor ci = OSecurityManager.instance().newCredentialInterceptor();
                if (ci != null) {
                    ci.intercept(this.getURL(), iUserName, iUserPassword);
                    session.connectionUserName = ci.getUsername();
                    session.connectionUserPassword = ci.getPassword();
                } else {
                    session.connectionUserName = iUserName;
                    session.connectionUserPassword = iUserPassword;
                }
                String strategy = conf.getValueAsString(OGlobalConfiguration.CLIENT_CONNECTION_STRATEGY);
                if (strategy != null) {
                    this.connectionStrategy = CONNECTION_STRATEGY.valueOf(strategy.toUpperCase(Locale.ENGLISH));
                }
                this.openRemoteDatabase();
                this.reload();
                this.initPush(session);
                this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
            } else {
                this.reopenRemoteDatabase();
            }
        }
        catch (Exception e) {
            this.removeUser();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw OException.wrapException((OException)new OStorageException("Cannot open the remote storage: " + this.name), (Throwable)e);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    public OSBTreeCollectionManager getSBtreeCollectionManager() {
        return this.sbTreeCollectionManager;
    }

    public void reload() {
        OReloadResponse37 res = this.networkOperation(new OReloadRequest37(), "error loading storage configuration");
        OStorageConfigurationRemote storageConfiguration = new OStorageConfigurationRemote(ORecordSerializerFactory.instance().getDefaultRecordSerializer().toString(), res.getPayload(), this.clientConfiguration);
        this.updateStorageConfiguration(storageConfiguration);
    }

    public void create(OContextConfiguration contextConfiguration) {
        throw new UnsupportedOperationException("Cannot create a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    public boolean exists() {
        throw new UnsupportedOperationException("Cannot check the existence of a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    public void close(boolean iForce, boolean onDelete) {
        if (this.status == OStorage.STATUS.CLOSED) {
            return;
        }
        OStorageRemoteSession session = this.getCurrentSession();
        if (session != null) {
            Collection<OStorageRemoteNodeSession> nodes = session.getAllServerSessions();
            if (!nodes.isEmpty()) {
                for (OStorageRemoteNodeSession nodeSession : nodes) {
                    OChannelBinaryAsynchClient network = null;
                    try {
                        network = this.getNetwork(nodeSession.getServerURL());
                        OCloseRequest request = new OCloseRequest();
                        network.beginRequest(request.getCommand(), session);
                        request.write((OChannelDataOutput)network, session);
                        this.endRequest(network);
                        this.connectionManager.release(network);
                    }
                    catch (OIOException ex) {
                        OLogManager.instance().debug((Object)this, "Impossible to comunicate to the server for close: %s", (Throwable)ex, new Object[0]);
                        this.connectionManager.remove(network);
                    }
                    catch (IOException ex) {
                        OLogManager.instance().debug((Object)this, "Impossible to comunicate to the server for close: %s", (Throwable)ex, new Object[0]);
                        this.connectionManager.remove(network);
                    }
                }
                session.close();
                this.sessions.remove(session);
                if (!this.checkForClose(iForce)) {
                    return;
                }
            } else if (!iForce) {
                return;
            }
            if (!this.checkForClose(iForce)) {
                return;
            }
        }
        if (this.context != null && this.status != OStorage.STATUS.CLOSED && this.status != OStorage.STATUS.CLOSING) {
            this.context.closeStorage(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.status == OStorage.STATUS.CLOSED || this.status == OStorage.STATUS.CLOSING) {
            return;
        }
        for (Map.Entry<Integer, OLiveQueryClientListener> listener : this.liveQueryListener.entrySet()) {
            listener.getValue().onEnd();
        }
        this.liveQueryListener.clear();
        this.stateLock.acquireWriteLock();
        try {
            if (this.status == OStorage.STATUS.CLOSED) {
                return;
            }
            this.status = OStorage.STATUS.CLOSING;
            super.close(true, false);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
        if (this.pushThread != null) {
            this.pushThread.shutdown();
            try {
                this.pushThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.stateLock.acquireWriteLock();
        try {
            for (String url : this.serverURLs) {
                this.connectionManager.closePool(url);
            }
            this.sbTreeCollectionManager.close();
            this.status = OStorage.STATUS.CLOSED;
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    private boolean checkForClose(boolean force) {
        if (this.status == OStorage.STATUS.CLOSED) {
            return false;
        }
        if (this.status == OStorage.STATUS.CLOSED) {
            return false;
        }
        int remainingUsers = this.getUsers() > 0 ? this.removeUser() : 0;
        return force || remainingUsers == 0;
    }

    public int getUsers() {
        return this.users.get();
    }

    public int addUser() {
        return this.users.incrementAndGet();
    }

    public int removeUser() {
        if (this.users.get() < 1) {
            throw new IllegalStateException("Cannot remove user of the remote storage '" + this.toString() + "' because no user is using it");
        }
        return this.users.decrementAndGet();
    }

    public void delete() {
        throw new UnsupportedOperationException("Cannot delete a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    public Set<String> getClusterNames() {
        this.stateLock.acquireReadLock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.clusterMap.keySet());
            return hashSet;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public OStorageOperationResult<OPhysicalPosition> createRecord(ORecordId iRid, byte[] iContent, int iRecordVersion, byte iRecordType, int iMode, ORecordCallback<Long> iCallback) {
        OSBTreeCollectionManager collectionManager = ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager();
        ORecordCallback realCallback = null;
        if (iCallback != null) {
            realCallback = (iRID, response) -> {
                iCallback.call(response.getIdentity(), (Object)response.getIdentity().getClusterPosition());
                this.updateCollectionsFromChanges(collectionManager, response.getChangedIds());
            };
        }
        OPhysicalPosition ppos = new OPhysicalPosition(iRecordType);
        OCreateRecordRequest request = new OCreateRecordRequest(iContent, iRid, iRecordType);
        OCreateRecordResponse response2 = this.asyncNetworkOperationNoRetry(request, iMode, iRid, realCallback, "Error on create record in cluster " + iRid.getClusterId());
        if (response2 != null) {
            ppos.clusterPosition = response2.getIdentity().getClusterPosition();
            ppos.recordVersion = response2.getVersion();
            if (iMode == 0) {
                iRid.setClusterId(response2.getIdentity().getClusterId());
                iRid.setClusterPosition(response2.getIdentity().getClusterPosition());
            }
            this.updateCollectionsFromChanges(collectionManager, response2.getChangedIds());
        }
        return new OStorageOperationResult((Object)ppos);
    }

    private void updateCollectionsFromChanges(OSBTreeCollectionManager collectionManager, Map<UUID, OBonsaiCollectionPointer> changes) {
        if (collectionManager != null) {
            for (Map.Entry<UUID, OBonsaiCollectionPointer> coll : changes.entrySet()) {
                collectionManager.updateCollectionPointer(coll.getKey(), coll.getValue());
            }
            if (ORecordSerializationContext.getDepth() <= 1) {
                collectionManager.clearPendingCollections();
            }
        }
    }

    public ORecordMetadata getRecordMetadata(ORID rid) {
        OGetRecordMetadataRequest request = new OGetRecordMetadataRequest(rid);
        OGetRecordMetadataResponse response = this.networkOperation(request, "Error on record metadata read " + rid);
        return response.getMetadata();
    }

    public OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(ORecordId rid, String fetchPlan, boolean ignoreCache, int recordVersion) throws ORecordNotFoundException {
        if (this.getCurrentSession().commandExecuting) {
            return new OStorageOperationResult(null);
        }
        OReadRecordIfVersionIsNotLatestRequest request = new OReadRecordIfVersionIsNotLatestRequest(rid, recordVersion, fetchPlan, ignoreCache);
        OReadRecordIfVersionIsNotLatestResponse response = this.networkOperation(request, "Error on read record " + rid);
        return new OStorageOperationResult((Object)response.getResult());
    }

    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, boolean prefetchRecords, ORecordCallback<ORawBuffer> iCallback) {
        if (this.getCurrentSession().commandExecuting) {
            return new OStorageOperationResult(null);
        }
        OReadRecordRequest request = new OReadRecordRequest(iIgnoreCache, iRid, iFetchPlan, false);
        OReadRecordResponse response = this.networkOperation(request, "Error on read record " + iRid);
        return new OStorageOperationResult((Object)response.getResult());
    }

    public String incrementalBackup(String backupDirectory, OCallable<Void, Void> started) {
        OIncrementalBackupRequest request = new OIncrementalBackupRequest(backupDirectory);
        OIncrementalBackupResponse response = this.networkOperationNoRetry(request, "Error on incremental backup");
        return response.getFileName();
    }

    public boolean supportIncremental() {
        return false;
    }

    public void fullIncrementalBackup(OutputStream stream) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This operations is part of internal API and is not supported in remote storage");
    }

    public void restoreFromIncrementalBackup(String filePath) {
        throw new UnsupportedOperationException("This operations is part of internal API and is not supported in remote storage");
    }

    public void restoreFullIncrementalBackup(InputStream stream) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This operations is part of internal API and is not supported in remote storage");
    }

    public OStorageOperationResult<Integer> updateRecord(ORecordId iRid, boolean updateContent, byte[] iContent, int iVersion, byte iRecordType, int iMode, ORecordCallback<Integer> iCallback) {
        OSBTreeCollectionManager collectionManager = ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager();
        ORecordCallback realCallback = null;
        if (iCallback != null) {
            realCallback = (iRID, response) -> {
                iCallback.call(iRID, (Object)response.getVersion());
                this.updateCollectionsFromChanges(collectionManager, response.getChanges());
            };
        }
        OUpdateRecordRequest request = new OUpdateRecordRequest(iRid, iContent, iVersion, updateContent, iRecordType);
        OUpdateRecordResponse response2 = this.asyncNetworkOperationNoRetry(request, iMode, iRid, realCallback, "Error on update record " + iRid);
        Integer resVersion = null;
        if (response2 != null) {
            resVersion = response2.getVersion();
            this.updateCollectionsFromChanges(collectionManager, response2.getChanges());
        }
        return new OStorageOperationResult((Object)resVersion);
    }

    public OStorageOperationResult<Integer> recyclePosition(ORecordId iRecordId, byte[] iContent, int iVersion, byte recordType) {
        throw new UnsupportedOperationException("recyclePosition");
    }

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRid, int iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        ORecordCallback realCallback = null;
        if (iCallback != null) {
            realCallback = (iRID, response) -> iCallback.call(iRID, (Object)response.getResult());
        }
        ODeleteRecordRequest request = new ODeleteRecordRequest(iRid, iVersion);
        ODeleteRecordResponse response2 = this.asyncNetworkOperationNoRetry(request, iMode, iRid, realCallback, "Error on delete record " + iRid);
        Boolean resDelete = null;
        if (response2 != null) {
            resDelete = response2.getResult();
        }
        return new OStorageOperationResult((Object)resDelete);
    }

    public OStorageOperationResult<Boolean> hideRecord(ORecordId recordId, int mode, ORecordCallback<Boolean> callback) {
        ORecordCallback realCallback = null;
        if (callback != null) {
            realCallback = (iRID, response) -> callback.call(iRID, (Object)response.getResult());
        }
        OHideRecordRequest request = new OHideRecordRequest(recordId);
        OHideRecordResponse response2 = this.asyncNetworkOperationNoRetry(request, mode, recordId, realCallback, "Error on hide record " + recordId);
        Boolean resHide = null;
        if (response2 != null) {
            resHide = response2.getResult();
        }
        return new OStorageOperationResult((Object)resHide);
    }

    public boolean cleanOutRecord(ORecordId recordId, int recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        ORecordCallback realCallback = null;
        if (callback != null) {
            realCallback = (iRID, response) -> callback.call(iRID, (Object)response.getResult());
        }
        OCleanOutRecordRequest request = new OCleanOutRecordRequest(recordVersion, recordId);
        OCleanOutRecordResponse response2 = this.asyncNetworkOperationNoRetry(request, iMode, recordId, realCallback, "Error on delete record " + recordId);
        Boolean result = null;
        if (response2 != null) {
            result = response2.getResult();
        }
        return result != null ? result : false;
    }

    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        throw new UnsupportedOperationException("backup is not supported against remote storage. Open the database with plocal or use the incremental backup in the Enterprise Edition");
    }

    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        throw new UnsupportedOperationException("restore is not supported against remote storage. Open the database with plocal or use Enterprise Edition");
    }

    public OContextConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public long count(int iClusterId) {
        return this.count(new int[]{iClusterId});
    }

    public long count(int iClusterId, boolean countTombstones) {
        return this.count(new int[]{iClusterId}, countTombstones);
    }

    public long[] getClusterDataRange(int iClusterId) {
        OGetClusterDataRangeRequest request = new OGetClusterDataRangeRequest(iClusterId);
        OGetClusterDataRangeResponse response = this.networkOperation(request, "Error on getting last entry position count in cluster: " + iClusterId);
        return response.getPos();
    }

    public OPhysicalPosition[] higherPhysicalPositions(int iClusterId, OPhysicalPosition iClusterPosition) {
        OHigherPhysicalPositionsRequest request = new OHigherPhysicalPositionsRequest(iClusterId, iClusterPosition);
        OHigherPhysicalPositionsResponse response = this.networkOperation(request, "Error on retrieving higher positions after " + iClusterPosition.clusterPosition);
        return response.getNextPositions();
    }

    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        OCeilingPhysicalPositionsRequest request = new OCeilingPhysicalPositionsRequest(clusterId, physicalPosition);
        OCeilingPhysicalPositionsResponse response = this.networkOperation(request, "Error on retrieving ceiling positions after " + physicalPosition.clusterPosition);
        return response.getPositions();
    }

    public OPhysicalPosition[] lowerPhysicalPositions(int iClusterId, OPhysicalPosition physicalPosition) {
        OLowerPhysicalPositionsRequest request = new OLowerPhysicalPositionsRequest(physicalPosition, iClusterId);
        OLowerPhysicalPositionsResponse response = this.networkOperation(request, "Error on retrieving lower positions after " + physicalPosition.clusterPosition);
        return response.getPreviousPositions();
    }

    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        OFloorPhysicalPositionsRequest request = new OFloorPhysicalPositionsRequest(physicalPosition, clusterId);
        OFloorPhysicalPositionsResponse response = this.networkOperation(request, "Error on retrieving floor positions after " + physicalPosition.clusterPosition);
        return response.getPositions();
    }

    public long getSize() {
        OGetSizeRequest request = new OGetSizeRequest();
        OGetSizeResponse response = this.networkOperation(request, "Error on read database size");
        return response.getSize();
    }

    public long countRecords() {
        OCountRecordsRequest request = new OCountRecordsRequest();
        OCountRecordsResponse response = this.networkOperation(request, "Error on read database record count");
        return response.getCountRecords();
    }

    public long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    public long count(int[] iClusterIds, boolean countTombstones) {
        OCountRequest request = new OCountRequest(iClusterIds, countTombstones);
        OCountResponse response = this.networkOperation(request, "Error on read record count in clusters: " + Arrays.toString(iClusterIds));
        return response.getCount();
    }

    public Object command(OCommandRequestText iCommand) {
        boolean live = iCommand instanceof OLiveQuery;
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().get();
        boolean asynch = iCommand instanceof OCommandRequestAsynch && ((OCommandRequestAsynch)iCommand).isAsynchronous();
        OCommandRequest request = new OCommandRequest(database, asynch, iCommand, live);
        OCommandResponse response = this.networkOperation(request, "Error on executing command: " + iCommand);
        return response.getResult();
    }

    public void stickToSession() {
        OStorageRemoteSession session = this.getCurrentSession();
        session.stickToSession();
    }

    public void unstickToSession() {
        OStorageRemoteSession session = this.getCurrentSession();
        session.unStickToSession();
    }

    public ORemoteQueryResult query(ODatabaseDocumentRemote db, String query, Object[] args) {
        int recordsPerPage = OGlobalConfiguration.QUERY_REMOTE_RESULTSET_PAGE_SIZE.getValueAsInteger();
        if (recordsPerPage <= 0) {
            recordsPerPage = 100;
        }
        OQueryRequest request = new OQueryRequest("sql", query, args, OQueryRequest.QUERY, db.getSerializer(), recordsPerPage);
        OQueryResponse response = this.networkOperation(request, "Error on executing command: " + query);
        ORemoteResultSet rs = new ORemoteResultSet(db, response.getQueryId(), response.getResult(), response.getExecutionPlan(), response.getQueryStats(), response.isHasNextPage());
        if (response.isHasNextPage()) {
            this.stickToSession();
        } else {
            db.queryClosed(response.getQueryId());
        }
        return new ORemoteQueryResult(rs, response.isTxChanges(), response.isReloadMetadata());
    }

    public ORemoteQueryResult query(ODatabaseDocumentRemote db, String query, Map args) {
        int recordsPerPage = OGlobalConfiguration.QUERY_REMOTE_RESULTSET_PAGE_SIZE.getValueAsInteger();
        if (recordsPerPage <= 0) {
            recordsPerPage = 100;
        }
        OQueryRequest request = new OQueryRequest("sql", query, args, OQueryRequest.QUERY, db.getSerializer(), recordsPerPage);
        OQueryResponse response = this.networkOperation(request, "Error on executing command: " + query);
        ORemoteResultSet rs = new ORemoteResultSet(db, response.getQueryId(), response.getResult(), response.getExecutionPlan(), response.getQueryStats(), response.isHasNextPage());
        if (response.isHasNextPage()) {
            this.stickToSession();
        } else {
            db.queryClosed(response.getQueryId());
        }
        return new ORemoteQueryResult(rs, response.isTxChanges(), response.isReloadMetadata());
    }

    public ORemoteQueryResult command(ODatabaseDocumentRemote db, String query, Object[] args) {
        int recordsPerPage = OGlobalConfiguration.QUERY_REMOTE_RESULTSET_PAGE_SIZE.getValueAsInteger();
        if (recordsPerPage <= 0) {
            recordsPerPage = 100;
        }
        OQueryRequest request = new OQueryRequest("sql", query, args, OQueryRequest.COMMAND, db.getSerializer(), recordsPerPage);
        OQueryResponse response = this.networkOperationNoRetry(request, "Error on executing command: " + query);
        ORemoteResultSet rs = new ORemoteResultSet(db, response.getQueryId(), response.getResult(), response.getExecutionPlan(), response.getQueryStats(), response.isHasNextPage());
        if (response.isHasNextPage()) {
            this.stickToSession();
        } else {
            db.queryClosed(response.getQueryId());
        }
        return new ORemoteQueryResult(rs, response.isTxChanges(), response.isReloadMetadata());
    }

    public ORemoteQueryResult command(ODatabaseDocumentRemote db, String query, Map args) {
        int recordsPerPage = OGlobalConfiguration.QUERY_REMOTE_RESULTSET_PAGE_SIZE.getValueAsInteger();
        if (recordsPerPage <= 0) {
            recordsPerPage = 100;
        }
        OQueryRequest request = new OQueryRequest("sql", query, args, OQueryRequest.COMMAND, db.getSerializer(), recordsPerPage);
        OQueryResponse response = this.networkOperationNoRetry(request, "Error on executing command: " + query);
        ORemoteResultSet rs = new ORemoteResultSet(db, response.getQueryId(), response.getResult(), response.getExecutionPlan(), response.getQueryStats(), response.isHasNextPage());
        if (response.isHasNextPage()) {
            this.stickToSession();
        } else {
            db.queryClosed(response.getQueryId());
        }
        return new ORemoteQueryResult(rs, response.isTxChanges(), response.isReloadMetadata());
    }

    public ORemoteQueryResult execute(ODatabaseDocumentRemote db, String language, String query, Object[] args) {
        int recordsPerPage = OGlobalConfiguration.QUERY_REMOTE_RESULTSET_PAGE_SIZE.getValueAsInteger();
        if (recordsPerPage <= 0) {
            recordsPerPage = 100;
        }
        OQueryRequest request = new OQueryRequest(language, query, args, OQueryRequest.EXECUTE, db.getSerializer(), recordsPerPage);
        OQueryResponse response = this.networkOperationNoRetry(request, "Error on executing command: " + query);
        ORemoteResultSet rs = new ORemoteResultSet(db, response.getQueryId(), response.getResult(), response.getExecutionPlan(), response.getQueryStats(), response.isHasNextPage());
        if (response.isHasNextPage()) {
            this.stickToSession();
        } else {
            db.queryClosed(response.getQueryId());
        }
        return new ORemoteQueryResult(rs, response.isTxChanges(), response.isReloadMetadata());
    }

    public ORemoteQueryResult execute(ODatabaseDocumentRemote db, String language, String query, Map args) {
        int recordsPerPage = OGlobalConfiguration.QUERY_REMOTE_RESULTSET_PAGE_SIZE.getValueAsInteger();
        if (recordsPerPage <= 0) {
            recordsPerPage = 100;
        }
        OQueryRequest request = new OQueryRequest(language, query, args, OQueryRequest.EXECUTE, db.getSerializer(), recordsPerPage);
        OQueryResponse response = this.networkOperationNoRetry(request, "Error on executing command: " + query);
        ORemoteResultSet rs = new ORemoteResultSet(db, response.getQueryId(), response.getResult(), response.getExecutionPlan(), response.getQueryStats(), response.isHasNextPage());
        if (response.isHasNextPage()) {
            this.stickToSession();
        } else {
            db.queryClosed(response.getQueryId());
        }
        return new ORemoteQueryResult(rs, response.isTxChanges(), response.isReloadMetadata());
    }

    public void closeQuery(ODatabaseDocumentRemote database, String queryId) {
        this.unstickToSession();
        OCloseQueryRequest request = new OCloseQueryRequest(queryId);
        this.networkOperation(request, "Error closing query: " + queryId);
    }

    public void fetchNextPage(ODatabaseDocumentRemote database, ORemoteResultSet rs) {
        int recordsPerPage = OGlobalConfiguration.QUERY_REMOTE_RESULTSET_PAGE_SIZE.getValueAsInteger();
        if (recordsPerPage <= 0) {
            recordsPerPage = 100;
        }
        OQueryNextPageRequest request = new OQueryNextPageRequest(rs.getQueryId(), recordsPerPage);
        OQueryResponse response = this.networkOperation(request, "Error on fetching next page for statment: " + rs.getQueryId());
        rs.fetched(response.getResult(), response.isHasNextPage(), response.getExecutionPlan(), response.getQueryStats());
        if (!response.isHasNextPage()) {
            this.unstickToSession();
            database.queryClosed(response.getQueryId());
        }
    }

    public List<ORecordOperation> commit(OTransactionInternal iTx) {
        ORecordOperation rop;
        this.unstickToSession();
        OCommit37Request request = new OCommit37Request(iTx.getId(), true, iTx.isUsingLog(), iTx.getRecordOperations(), iTx.getIndexOperations());
        OCommit37Response response = this.networkOperationNoRetry(request, "Error on commit");
        for (OCommit37Response.OCreatedRecordResponse created : response.getCreated()) {
            iTx.updateIdentityAfterCommit((ORID)created.getCurrentRid(), (ORID)created.getCreatedRid());
            rop = iTx.getRecordEntry((ORID)created.getCurrentRid());
            if (rop == null) continue;
            if (created.getVersion() > rop.getRecord().getVersion() + 1) {
                rop.getRecord().unload();
            }
            ORecordInternal.setVersion((ORecord)rop.getRecord(), (int)created.getVersion());
        }
        for (OCommit37Response.OUpdatedRecordResponse updated : response.getUpdated()) {
            rop = iTx.getRecordEntry((ORID)updated.getRid());
            if (rop == null) continue;
            if (updated.getVersion() > rop.getRecord().getVersion() + 1) {
                rop.getRecord().unload();
            }
            ORecordInternal.setVersion((ORecord)rop.getRecord(), (int)updated.getVersion());
        }
        this.updateCollectionsFromChanges(((OTransactionOptimistic)iTx).getDatabase().getSbTreeCollectionManager(), response.getCollectionChanges());
        for (ORecordOperation txEntry : iTx.getRecordOperations()) {
            ORecordInternal.unsetDirty((ORecord)txEntry.getRecord());
        }
        OTransactionAbstract.updateCacheFromEntries((ODatabaseDocumentInternal)iTx.getDatabase(), (Iterable)iTx.getRecordOperations(), (boolean)true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(OTransactionInternal iTx) {
        try {
            if (((OTransactionOptimistic)iTx).isAlreadyCleared() && this.getCurrentSession().getAllServerSessions().size() > 0) {
                ORollbackTransactionRequest request = new ORollbackTransactionRequest(iTx.getId());
                ORollbackTransactionResponse oRollbackTransactionResponse = this.networkOperation(request, "Error on fetching next page for statment: " + request);
            }
        }
        finally {
            this.unstickToSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClusterIdByName(String iClusterName) {
        this.stateLock.acquireReadLock();
        try {
            if (iClusterName == null) {
                int n = -1;
                return n;
            }
            if (Character.isDigit(iClusterName.charAt(0))) {
                int n = Integer.parseInt(iClusterName);
                return n;
            }
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase(Locale.ENGLISH));
            if (cluster == null) {
                int n = -1;
                return n;
            }
            int n = cluster.getId();
            return n;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    public int addCluster(String iClusterName, Object ... iArguments) {
        return this.addCluster(iClusterName, -1, iArguments);
    }

    public int addCluster(String iClusterName, int iRequestedId, Object ... iParameters) {
        OAddClusterRequest request = new OAddClusterRequest(iRequestedId, iClusterName);
        OAddClusterResponse response = this.networkOperationNoRetry(request, "Error on add new cluster");
        this.addNewClusterToConfiguration(response.getClusterId(), iClusterName);
        return response.getClusterId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClusterNameById(int clusterId) {
        this.stateLock.acquireReadLock();
        try {
            if (clusterId < 0 || clusterId >= this.clusters.length) {
                throw new OStorageException("Cluster with id " + clusterId + " does not exist");
            }
            OCluster cluster = this.clusters[clusterId];
            String string = cluster.getName();
            return string;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public long getClusterRecordsSizeById(int clusterId) {
        throw new UnsupportedOperationException();
    }

    public long getClusterRecordsSizeByName(String clusterName) {
        throw new UnsupportedOperationException();
    }

    public void truncateCluster(String clusterName) {
        throw new UnsupportedOperationException();
    }

    public void setClusterAttribute(int clusterId, OCluster.ATTRIBUTES attribute, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object setClusterAttribute(String clusterName, OCluster.ATTRIBUTES attribute, Object value) {
        throw new UnsupportedOperationException();
    }

    public String getClusterRecordConflictStrategy(int clusterId) {
        throw new UnsupportedOperationException();
    }

    public String getClusterEncryption(int clusterId) {
        throw new UnsupportedOperationException();
    }

    public boolean isSystemCluster(int clusterId) {
        throw new UnsupportedOperationException();
    }

    public long getLastClusterPosition(int clusterId) {
        throw new UnsupportedOperationException();
    }

    public long getClusterNextPosition(int clusterId) {
        throw new UnsupportedOperationException();
    }

    public OPaginatedCluster.RECORD_STATUS getRecordStatus(ORID rid) {
        throw new UnsupportedOperationException();
    }

    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        ODropClusterRequest request = new ODropClusterRequest(iClusterId);
        ODropClusterResponse response = this.networkOperationNoRetry(request, "Error on removing of cluster");
        if (response.getResult()) {
            this.removeClusterFromConfiguration(iClusterId);
        }
        return response.getResult();
    }

    public void removeClusterFromConfiguration(int iClusterId) {
        this.stateLock.acquireWriteLock();
        try {
            if (this.clusters.length > iClusterId && this.clusters[iClusterId] != null) {
                OCluster cluster = this.clusters[iClusterId];
                this.clusters[iClusterId] = null;
                this.clusterMap.remove(cluster.getName());
                ((OStorageConfigurationRemote)this.configuration).dropCluster(iClusterId);
            }
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    public void synch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPhysicalClusterNameById(int iClusterId) {
        this.stateLock.acquireReadLock();
        try {
            if (iClusterId >= this.clusters.length) {
                String string = null;
                return string;
            }
            OCluster cluster = this.clusters[iClusterId];
            String string = cluster != null ? cluster.getName() : null;
            return string;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public int getClusterMap() {
        this.stateLock.acquireReadLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public long getVersion() {
        throw new UnsupportedOperationException("getVersion");
    }

    public ODocument getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    public void endRequest(OChannelBinaryAsynchClient iNetwork) throws IOException {
        if (iNetwork == null) {
            return;
        }
        iNetwork.flush();
        iNetwork.releaseWriteLock();
    }

    public void endResponse(OChannelBinaryAsynchClient iNetwork) throws IOException {
        iNetwork.endResponse();
    }

    public boolean isRemote() {
        return true;
    }

    public boolean isPermanentRequester() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDistributedNodes(List<String> hosts) {
        OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.setValue((Object)Integer.MAX_VALUE);
        if (!this.clientConfiguration.getValueAsBoolean(OGlobalConfiguration.CLIENT_CONNECTION_FETCH_HOST_LIST)) {
            List<String> definedHosts = this.parseAddressesFromUrl(this.url);
            List<String> list = this.serverURLs;
            synchronized (list) {
                for (String host : definedHosts) {
                    this.addHost(host);
                }
            }
            return;
        }
        List<String> list = this.serverURLs;
        synchronized (list) {
            for (String host : hosts) {
                this.addHost(host);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessions(String url) {
        List<String> list = this.serverURLs;
        synchronized (list) {
            this.serverURLs.remove(url);
            this.nextServerToConnect = 0;
        }
    }

    public ORecordConflictStrategy getClusterRecordConflictStrategy() {
        throw new UnsupportedOperationException("getConflictStrategy");
    }

    public void setConflictStrategy(ORecordConflictStrategy iResolver) {
        throw new UnsupportedOperationException("setConflictStrategy");
    }

    public String getURL() {
        return "remote:" + this.url;
    }

    public int getClusters() {
        this.stateLock.acquireReadLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public String getType() {
        return "remote";
    }

    public String getUserName() {
        OStorageRemoteSession session = this.getCurrentSession();
        if (session == null) {
            return null;
        }
        return session.connectionUserName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String reopenRemoteDatabase() throws IOException {
        String currentURL = this.getCurrentServerURL();
        do {
            String string;
            OChannelBinaryAsynchClient network = this.getNetwork(currentURL);
            OStorageRemoteSession session = this.getCurrentSession();
            OStorageRemoteNodeSession nodeSession = session.getOrCreateServerSession(network.getServerURL());
            if (nodeSession == null || !nodeSession.isValid()) {
                this.openRemoteDatabase(network);
                return network.getServerURL();
            }
            OReopenRequest request = new OReopenRequest();
            try {
                network.writeByte(request.getCommand());
                network.writeInt(nodeSession.getSessionId());
                network.writeBytes(nodeSession.getToken());
                request.write((OChannelDataOutput)network, session);
            }
            finally {
                this.endRequest(network);
            }
            OReopenResponse response = request.createResponse();
            try {
                byte[] newToken = network.beginResponse(nodeSession.getSessionId(), true);
                response.read((OChannelDataInput)network, session);
                if (newToken != null && newToken.length > 0) {
                    nodeSession.setSession(response.getSessionId(), newToken);
                } else {
                    nodeSession.setSession(response.getSessionId(), nodeSession.getToken());
                }
                OLogManager.instance().debug((Object)this, "Client connected to %s with session id=%d", new Object[]{network.getServerURL(), response.getSessionId()});
                string = currentURL;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    this.connectionManager.release(network);
                    throw throwable;
                }
                catch (OIOException e) {
                    if (network != null) {
                        this.connectionManager.remove(network);
                    }
                    OLogManager.instance().error((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
                    continue;
                }
                catch (OOfflineNodeException e) {
                    if (network != null) {
                        this.connectionManager.remove(network);
                    }
                    OLogManager.instance().debug((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
                    continue;
                }
                catch (OSecurityException ex) {
                    OLogManager.instance().debug((Object)this, "Invalidate token for url=%s", (Throwable)ex, new Object[]{currentURL});
                    OStorageRemoteSession session2 = this.getCurrentSession();
                    session2.removeServerSession(currentURL);
                    if (network == null) continue;
                    try {
                        this.connectionManager.remove(network);
                    }
                    catch (Exception e) {
                        OLogManager.instance().debug((Object)this, "Cannot remove connection or database url=" + currentURL, (Throwable)e, new Object[0]);
                    }
                    continue;
                }
                catch (OException e) {
                    this.connectionManager.release(network);
                    throw e;
                }
                catch (Exception e) {
                    OLogManager.instance().debug((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
                    if (network == null) continue;
                    try {
                        this.connectionManager.remove(network);
                        continue;
                    }
                    catch (Exception ex) {
                        OLogManager.instance().debug((Object)this, "Cannot remove connection or database url=" + currentURL, (Throwable)e, new Object[0]);
                    }
                }
            }
            this.endResponse(network);
            this.connectionManager.release(network);
            return string;
        } while (this.connectionManager.getAvailableConnections(currentURL) > 0 || (currentURL = this.useNewServerURL(currentURL)) != null);
        this.parseServerURLs();
        List<String> list = this.serverURLs;
        synchronized (list) {
            throw new OStorageException("Cannot create a connection to remote server address(es): " + this.serverURLs);
        }
    }

    protected void openRemoteDatabase() throws IOException {
        String currentURL = this.getNextAvailableServerURL(true, this.getCurrentSession());
        this.openRemoteDatabase(currentURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openRemoteDatabase(OChannelBinaryAsynchClient network) throws IOException {
        OStorageRemoteSession session = this.getCurrentSession();
        OStorageRemoteNodeSession nodeSession = session.getOrCreateServerSession(network.getServerURL());
        OOpen37Request request = new OOpen37Request(this.name, session.connectionUserName, session.connectionUserPassword);
        try {
            network.writeByte(request.getCommand());
            network.writeInt(nodeSession.getSessionId());
            network.writeBytes(null);
            request.write((OChannelDataOutput)network, session);
        }
        finally {
            this.endRequest(network);
        }
        OOpen37Response response = request.createResponse();
        try {
            network.beginResponse(nodeSession.getSessionId(), true);
            response.read((OChannelDataInput)network, session);
        }
        finally {
            this.endResponse(network);
            this.connectionManager.release(network);
        }
        int sessionId = response.getSessionId();
        byte[] token = response.getSessionToken();
        if (token.length == 0) {
            token = null;
        }
        nodeSession.setSession(sessionId, token);
        OLogManager.instance().debug((Object)this, "Client connected to %s with session id=%d", new Object[]{network.getServerURL(), sessionId});
        this.stateLock.acquireWriteLock();
        try {
            this.status = OStorage.STATUS.OPEN;
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    private void initPush(OStorageRemoteSession session) {
        if (this.pushThread == null) {
            this.stateLock.acquireWriteLock();
            try {
                if (this.pushThread == null) {
                    this.pushThread = new OStorageRemotePushThread(this, this.getCurrentServerURL(), this.connectionRetryDelay, this.configuration.getContextConfiguration().getValueAsLong(OGlobalConfiguration.NETWORK_REQUEST_TIMEOUT));
                    this.pushThread.start();
                    this.subscribeStorageConfiguration(session);
                    this.subscribeDistributedConfiguration(session);
                    this.subscribeSchema(session);
                    this.subscribeIndexManager(session);
                    this.subscribeFunctions(session);
                    this.subscribeSequences(session);
                }
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
    }

    private void subscribeDistributedConfiguration(OStorageRemoteSession nodeSession) {
        this.pushThread.subscribe(new OSubscribeDistributedConfigurationRequest(), nodeSession);
    }

    private void subscribeStorageConfiguration(OStorageRemoteSession nodeSession) {
        this.pushThread.subscribe(new OSubscribeStorageConfigurationRequest(), nodeSession);
    }

    private void subscribeSchema(OStorageRemoteSession nodeSession) {
        this.pushThread.subscribe(new OSubscribeSchemaRequest(), nodeSession);
    }

    private void subscribeFunctions(OStorageRemoteSession nodeSession) {
        this.pushThread.subscribe(new OSubscribeFunctionsRequest(), nodeSession);
    }

    private void subscribeSequences(OStorageRemoteSession nodeSession) {
        this.pushThread.subscribe(new OSubscribeSequencesRequest(), nodeSession);
    }

    private void subscribeIndexManager(OStorageRemoteSession nodeSession) {
        this.pushThread.subscribe(new OSubscribeIndexManagerRequest(), nodeSession);
    }

    protected void openRemoteDatabase(String currentURL) {
        do {
            OChannelBinaryAsynchClient network = null;
            try {
                network = this.getNetwork(currentURL);
                this.openRemoteDatabase(network);
                return;
            }
            catch (ODistributedRedirectException e) {
                this.connectionManager.release(network);
                currentURL = e.getToServerAddress();
            }
            catch (OModificationOperationProhibitedException mope) {
                this.connectionManager.release(network);
                this.handleDBFreeze();
                currentURL = this.useNewServerURL(currentURL);
            }
            catch (OOfflineNodeException e) {
                this.connectionManager.release(network);
                currentURL = this.useNewServerURL(currentURL);
            }
            catch (OIOException e) {
                if (network != null) {
                    this.connectionManager.remove(network);
                }
                OLogManager.instance().debug((Object)this, "Cannot open database with url " + currentURL, (Throwable)e, new Object[0]);
            }
            catch (OException e) {
                this.connectionManager.release(network);
                throw e;
            }
            catch (IOException e) {
                if (network == null) continue;
                this.connectionManager.remove(network);
            }
            catch (Exception e) {
                if (network != null) {
                    this.connectionManager.remove(network);
                }
                throw OException.wrapException((OException)new OStorageException(e.getMessage()), (Throwable)e);
            }
        } while (this.connectionManager.getReusableConnections(currentURL) > 0 || (currentURL = this.useNewServerURL(currentURL)) != null);
        this.parseServerURLs();
        List<String> list = this.serverURLs;
        synchronized (list) {
            throw new OStorageException("Cannot create a connection to remote server address(es): " + this.serverURLs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String useNewServerURL(String iUrl) {
        int pos = iUrl.indexOf(47);
        if (pos >= iUrl.length() - 1) {
            pos = -1;
        }
        String postFix = pos > -1 ? iUrl.substring(pos) : "";
        String url = pos > -1 ? iUrl.substring(0, pos) : iUrl;
        List<String> list = this.serverURLs;
        synchronized (list) {
            this.serverURLs.remove(url);
            this.nextServerToConnect = 0;
            OLogManager.instance().debug((Object)this, "Updated server list: %s...", new Object[]{this.serverURLs});
            if (!this.serverURLs.isEmpty()) {
                return this.serverURLs.get(0) + postFix;
            }
        }
        return null;
    }

    public List<String> parseAddressesFromUrl(String url) {
        ArrayList<String> addresses = new ArrayList<String>();
        int dbPos = url.indexOf(47);
        if (dbPos == -1) {
            addresses.add(url);
        } else {
            for (String host : url.substring(0, dbPos).split(ADDRESS_SEPARATOR)) {
                addresses.add(host);
            }
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseServerURLs() {
        int dbPos = this.url.indexOf(47);
        this.name = dbPos == -1 ? this.url : this.url.substring(this.url.lastIndexOf("/") + 1);
        String lastHost = null;
        List<String> hosts = this.parseAddressesFromUrl(this.url);
        Object object = hosts.iterator();
        while (object.hasNext()) {
            String host;
            lastHost = host = object.next();
            this.addHost(host);
        }
        object = this.serverURLs;
        synchronized (object) {
            List<String> toAdd;
            if (this.serverURLs.size() == 1 && this.getClientConfiguration().getValueAsBoolean(OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_ENABLED) && (toAdd = this.fetchHostsFromDns(lastHost)).size() > 0) {
                this.serverURLs.clear();
                this.nextServerToConnect = 0;
                for (String host : toAdd) {
                    this.addHost(host);
                }
            }
        }
    }

    private List<String> fetchHostsFromDns(String primaryServer) {
        OLogManager.instance().debug((Object)this, "Retrieving URLs from DNS '%s' (timeout=%d)...", new Object[]{primaryServer, this.getClientConfiguration().getValueAsInteger(OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT)});
        ArrayList<String> toAdd = new ArrayList<String>();
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("com.sun.jndi.ldap.connect.timeout", this.getClientConfiguration().getValueAsString(OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT));
            InitialDirContext ictx = new InitialDirContext(env);
            String hostName = !primaryServer.contains(":") ? primaryServer : primaryServer.substring(0, primaryServer.indexOf(":"));
            Attributes attrs = ictx.getAttributes(hostName, new String[]{"TXT"});
            Attribute attr = attrs.get("TXT");
            if (attr != null) {
                for (int i = 0; i < attr.size(); ++i) {
                    String[] parts;
                    String configuration = (String)attr.get(i);
                    if (configuration.startsWith("\"")) {
                        configuration = configuration.substring(1, configuration.length() - 1);
                    }
                    if (configuration == null) continue;
                    for (String part : parts = configuration.split(" ")) {
                        if (!part.startsWith("s=")) continue;
                        toAdd.add(part.substring("s=".length()));
                    }
                }
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return toAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addHost(String host) {
        if (host.startsWith("localhost")) {
            host = LOCAL_IP + host.substring("localhost".length());
        }
        if (host.contains("/")) {
            host = host.substring(0, host.indexOf("/"));
        }
        if (!host.contains(":")) {
            host = host + ":" + (this.clientConfiguration.getValueAsBoolean(OGlobalConfiguration.CLIENT_USE_SSL) ? this.getDefaultSSLPort() : this.getDefaultPort());
        } else if (host.split(":").length < 2 || host.split(":")[1].trim().length() == 0) {
            host = host + (this.clientConfiguration.getValueAsBoolean(OGlobalConfiguration.CLIENT_USE_SSL) ? this.getDefaultSSLPort() : this.getDefaultPort());
        }
        List<String> list = this.serverURLs;
        synchronized (list) {
            if (!this.serverURLs.contains(host)) {
                this.serverURLs.add(host);
                OLogManager.instance().debug((Object)this, "Registered the new available server '%s'", new Object[]{host});
            }
        }
        return host;
    }

    protected int getDefaultPort() {
        return 2424;
    }

    protected int getDefaultSSLPort() {
        return 2434;
    }

    public OChannelBinaryAsynchClient beginRequest(OChannelBinaryAsynchClient network, byte iCommand, OStorageRemoteSession session) throws IOException {
        network.beginRequest(iCommand, session);
        return network;
    }

    protected String getNextAvailableServerURL(boolean iIsConnectOperation, OStorageRemoteSession session) {
        String url = null;
        CONNECTION_STRATEGY strategy = this.connectionStrategy;
        if (session.isStickToSession()) {
            strategy = CONNECTION_STRATEGY.STICKY;
        }
        switch (strategy) {
            case STICKY: {
                url = session.getServerUrl();
                if (url != null) break;
                url = this.getServerURFromList(false, session);
                break;
            }
            case ROUND_ROBIN_CONNECT: {
                url = iIsConnectOperation || session.getServerUrl() == null ? this.getNextConnectUrl(session) : session.getServerUrl();
                OLogManager.instance().debug((Object)this, "ROUND_ROBIN_CONNECT: Next remote operation will be executed on server: %s (isConnectOperation=%s)", new Object[]{url, iIsConnectOperation});
                break;
            }
            case ROUND_ROBIN_REQUEST: {
                url = this.getServerURFromList(true, session);
                OLogManager.instance().debug((Object)this, "ROUND_ROBIN_REQUEST: Next remote operation will be executed on server: %s (isConnectOperation=%s)", new Object[]{url, iIsConnectOperation});
                break;
            }
            default: {
                throw new OConfigurationException("Connection mode " + (Object)((Object)this.connectionStrategy) + " is not supported");
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextConnectUrl(OStorageRemoteSession session) {
        List<String> list = this.serverURLs;
        synchronized (list) {
            if (this.serverURLs.isEmpty()) {
                this.parseServerURLs();
                if (this.serverURLs.isEmpty()) {
                    throw new OStorageException("Cannot create a connection to remote server because url list is empty");
                }
            }
            if (this.serverURLs.size() <= this.nextServerToConnect) {
                this.nextServerToConnect = 0;
            }
            String serverURL = this.serverURLs.get(this.nextServerToConnect) + "/" + this.getName();
            if (session != null) {
                session.serverURLIndex = this.nextServerToConnect;
            }
            ++this.nextServerToConnect;
            if (this.nextServerToConnect >= this.serverURLs.size()) {
                this.nextServerToConnect = 0;
            }
            return serverURL;
        }
    }

    protected String getCurrentServerURL() {
        return this.getServerURFromList(false, this.getCurrentSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServerURFromList(boolean iNextAvailable, OStorageRemoteSession session) {
        List<String> list = this.serverURLs;
        synchronized (list) {
            if (this.serverURLs.isEmpty()) {
                this.parseServerURLs();
                if (this.serverURLs.isEmpty()) {
                    throw new OStorageException("Cannot create a connection to remote server because url list is empty");
                }
            }
            int serverURLIndex = session != null ? session.serverURLIndex : 0;
            if (iNextAvailable) {
                ++serverURLIndex;
            }
            if (serverURLIndex < 0 || serverURLIndex >= this.serverURLs.size()) {
                serverURLIndex = 0;
            }
            String serverURL = this.serverURLs.get(serverURLIndex) + "/" + this.getName();
            if (session != null) {
                session.serverURLIndex = serverURLIndex;
            }
            return serverURL;
        }
    }

    @Override
    public OChannelBinaryAsynchClient getNetwork(String iCurrentURL) {
        OChannelBinaryAsynchClient network;
        do {
            try {
                network = this.connectionManager.acquire(iCurrentURL, this.clientConfiguration);
            }
            catch (OIOException cause) {
                throw cause;
            }
            catch (Exception cause) {
                throw OException.wrapException((OException)new OStorageException("Cannot open a connection to remote server: " + iCurrentURL), (Throwable)cause);
            }
            if (network.tryLock()) continue;
            OLogManager.instance().error((Object)this, "Removing locked network channel '%s' (connected=%s)...", null, new Object[]{iCurrentURL, network.isConnected()});
            this.connectionManager.remove(network);
            network = null;
        } while (network == null);
        return network;
    }

    public void beginResponse(OChannelBinaryAsynchClient iNetwork, OStorageRemoteSession session) throws IOException {
        OStorageRemoteNodeSession nodeSession = session.getServerSession(iNetwork.getServerURL());
        byte[] newToken = iNetwork.beginResponse(nodeSession.getSessionId(), true);
        if (newToken != null && newToken.length > 0) {
            nodeSession.setSession(nodeSession.getSessionId(), newToken);
        }
    }

    private boolean handleDBFreeze() {
        OLogManager.instance().warn((Object)this, "DB is frozen will wait for " + this.getClientConfiguration().getValue(OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT) + " ms. and then retry.", new Object[0]);
        boolean retry = true;
        try {
            Thread.sleep(this.getClientConfiguration().getValueAsInteger(OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT));
        }
        catch (InterruptedException ie) {
            retry = false;
            Thread.currentThread().interrupt();
        }
        return retry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStorageConfiguration(OStorageConfiguration storageConfiguration) {
        if (this.status != OStorage.STATUS.OPEN) {
            return;
        }
        this.stateLock.acquireWriteLock();
        try {
            if (this.status != OStorage.STATUS.OPEN) {
                return;
            }
            this.configuration = storageConfiguration;
            List configClusters = storageConfiguration.getClusters();
            OCluster[] clusters = new OCluster[configClusters.size()];
            for (OStorageClusterConfiguration clusterConfig : configClusters) {
                if (clusterConfig == null) continue;
                OClusterRemote cluster = new OClusterRemote();
                String clusterName = clusterConfig.getName();
                int clusterId = clusterConfig.getId();
                if (clusterName == null) continue;
                clusterName = clusterName.toLowerCase(Locale.ENGLISH);
                cluster.configure(null, clusterId, clusterName, new Object[0]);
                if (clusterId >= clusters.length) {
                    clusters = Arrays.copyOf(clusters, clusterId + 1);
                }
                clusters[clusterId] = cluster;
            }
            this.clusters = clusters;
            this.clusterMap.clear();
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null) continue;
                this.clusterMap.put(clusters[i].getName(), clusters[i]);
            }
            OCluster defaultCluster = this.clusterMap.get("default");
            if (defaultCluster != null) {
                this.defaultClusterId = this.clusterMap.get("default").getId();
            }
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    protected OStorageRemoteSession getCurrentSession() {
        ODatabaseDocumentRemote remote;
        ODatabaseDocumentInternal db = null;
        if (ODatabaseRecordThreadLocal.instance() != null) {
            db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        }
        if ((remote = (ODatabaseDocumentRemote)ODatabaseDocumentTxInternal.getInternal(db)) == null) {
            return null;
        }
        OStorageRemoteSession session = remote.getSessionMetadata();
        if (session == null) {
            session = new OStorageRemoteSession(sessionSerialId.decrementAndGet());
            this.sessions.add(session);
            remote.setSessionMetadata(session);
        }
        return session;
    }

    public boolean isClosed() {
        if (super.isClosed()) {
            return true;
        }
        OStorageRemoteSession session = this.getCurrentSession();
        if (session == null) {
            return false;
        }
        return session.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorageRemote copy(ODatabaseDocumentRemote source, ODatabaseDocumentRemote dest) {
        ODatabaseDocumentInternal origin = null;
        if (ODatabaseRecordThreadLocal.instance() != null) {
            origin = ODatabaseRecordThreadLocal.instance().getIfDefined();
        }
        origin = ODatabaseDocumentTxInternal.getInternal(origin);
        OStorageRemoteSession session = source.getSessionMetadata();
        if (session != null) {
            OStorageRemoteSession newSession = new OStorageRemoteSession(sessionSerialId.decrementAndGet());
            newSession.connectionUserName = session.connectionUserName;
            newSession.connectionUserPassword = session.connectionUserPassword;
            dest.setSessionMetadata(newSession);
        }
        try {
            dest.activateOnCurrentThread();
            this.openRemoteDatabase();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error during database open", (Throwable)e, new Object[0]);
        }
        finally {
            ODatabaseRecordThreadLocal.instance().set(origin);
        }
        return this;
    }

    public void importDatabase(String options, InputStream inputStream, String name, OCommandOutputListener listener) {
        OImportRequest request = new OImportRequest(inputStream, options, name);
        OImportResponse response = this.networkOperationRetryTimeout(request, "Error sending import request", 0, this.getClientConfiguration().getValueAsInteger(OGlobalConfiguration.NETWORK_REQUEST_TIMEOUT));
        for (String message : response.getMessages()) {
            listener.onMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewClusterToConfiguration(int clusterId, String iClusterName) {
        this.stateLock.acquireWriteLock();
        try {
            if (this.clusters.length <= clusterId || this.clusters[clusterId] == null) {
                OClusterRemote cluster = new OClusterRemote();
                cluster.configure((OStorage)this, clusterId, iClusterName.toLowerCase(Locale.ENGLISH), new Object[0]);
                if (this.clusters.length <= clusterId) {
                    this.clusters = Arrays.copyOf(this.clusters, clusterId + 1);
                }
                this.clusters[cluster.getId()] = cluster;
                this.clusterMap.put(cluster.getName().toLowerCase(Locale.ENGLISH), cluster);
            }
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    public void beginTransaction(ODatabaseDocumentRemote database, OTransactionOptimistic transaction) {
        OBeginTransactionRequest request = new OBeginTransactionRequest(transaction.getId(), true, transaction.isUsingLog(), transaction.getRecordOperations(), transaction.getIndexOperations());
        OBeginTransactionResponse response = this.networkOperationNoRetry(request, "Error on remote transaction begin");
        for (Map.Entry<ORID, ORID> entry : response.getUpdatedIds().entrySet()) {
            transaction.updateIdentityAfterCommit(entry.getKey(), entry.getValue());
        }
        this.stickToSession();
    }

    public void reBeginTransaction(ODatabaseDocumentRemote database, OTransactionOptimistic transaction) {
        ORebeginTransactionRequest request = new ORebeginTransactionRequest(transaction.getId(), transaction.isUsingLog(), transaction.getRecordOperations(), transaction.getIndexOperations());
        OBeginTransactionResponse response = this.networkOperationNoRetry(request, "Error on remote transaction begin");
        for (Map.Entry<ORID, ORID> entry : response.getUpdatedIds().entrySet()) {
            transaction.updateIdentityAfterCommit(entry.getKey(), entry.getValue());
        }
    }

    public void fetchTransaction(ODatabaseDocumentRemote remote) {
        OTransactionOptimisticClient transaction = (OTransactionOptimisticClient)remote.getTransaction();
        OFetchTransactionRequest request = new OFetchTransactionRequest(transaction.getId());
        OFetchTransactionResponse respose = this.networkOperation(request, "Error fetching transaction from server side");
        transaction.replaceContent(respose.getOperations(), respose.getIndexChanges());
    }

    @Override
    public OBinaryPushRequest createPush(byte type) {
        switch (type) {
            case 80: {
                return new OPushDistributedConfigurationRequest();
            }
            case 81: {
                return new OLiveQueryPushRequest();
            }
            case 82: {
                return new OPushStorageConfigurationRequest();
            }
            case 83: {
                return new OPushSchemaRequest();
            }
            case 84: {
                return new OPushIndexManagerRequest();
            }
            case 85: {
                return new OPushFunctionsRequest();
            }
            case 86: {
                return new OPushSequencesRequest();
            }
        }
        return null;
    }

    @Override
    public OBinaryPushResponse executeUpdateDistributedConfig(OPushDistributedConfigurationRequest request) {
        this.updateDistributedNodes(request.getHosts());
        return null;
    }

    @Override
    public OBinaryPushResponse executeUpdateFunction(OPushFunctionsRequest request) {
        ODatabaseDocumentRemote.updateFunction(this);
        return null;
    }

    @Override
    public OBinaryPushResponse executeUpdateSequences(OPushSequencesRequest request) {
        ODatabaseDocumentRemote.updateSequences(this);
        return null;
    }

    @Override
    public OBinaryPushResponse executeUpdateStorageConfig(OPushStorageConfigurationRequest payload) {
        OStorageConfigurationRemote storageConfiguration = new OStorageConfigurationRemote(ORecordSerializerFactory.instance().getDefaultRecordSerializer().toString(), payload.getPayload(), this.clientConfiguration);
        this.updateStorageConfiguration(storageConfiguration);
        return null;
    }

    @Override
    public OBinaryPushResponse executeUpdateSchema(OPushSchemaRequest request) {
        ODocument schema = request.getSchema();
        ORecordInternal.setIdentity((ORecord)schema, (ORecordId)new ORecordId(this.getConfiguration().getSchemaRecordId()));
        ODatabaseDocumentRemote.updateSchema(this, schema);
        return null;
    }

    @Override
    public OBinaryPushResponse executeUpdateIndexManager(OPushIndexManagerRequest request) {
        ODocument indexManager = request.getIndexManager();
        ORecordInternal.setIdentity((ORecord)indexManager, (ORecordId)new ORecordId(this.getConfiguration().getIndexMgrRecordId()));
        ODatabaseDocumentRemote.updateIndexManager(this, indexManager);
        return null;
    }

    public OLiveQueryMonitor liveQuery(ODatabaseDocumentRemote database, String query, OLiveQueryClientListener listener, Object[] params) {
        OSubscribeLiveQueryRequest request = new OSubscribeLiveQueryRequest(query, params);
        OSubscribeLiveQueryResponse response = this.pushThread.subscribe(request, this.getCurrentSession());
        if (response == null) {
            throw new ODatabaseException("Impossible to start the live query, check server log for additional information");
        }
        this.registerLiveListener(response.getMonitorId(), listener);
        return new OLiveQueryMonitorRemote(database, response.getMonitorId());
    }

    public OLiveQueryMonitor liveQuery(ODatabaseDocumentRemote database, String query, OLiveQueryClientListener listener, Map<String, ?> params) {
        OSubscribeLiveQueryRequest request = new OSubscribeLiveQueryRequest(query, params);
        OSubscribeLiveQueryResponse response = this.pushThread.subscribe(request, this.getCurrentSession());
        if (response == null) {
            throw new ODatabaseException("Impossible to start the live query, check server log for additional information");
        }
        this.registerLiveListener(response.getMonitorId(), listener);
        return new OLiveQueryMonitorRemote(database, response.getMonitorId());
    }

    public void unsubscribeLive(ODatabaseDocumentRemote database, int monitorId) {
        OUnsubscribeRequest request = new OUnsubscribeRequest(new OUnsubscribeLiveQueryRequest(monitorId));
        this.networkOperation(request, "Error on unsubscribe of live query");
    }

    public void registerLiveListener(int monitorId, OLiveQueryClientListener listener) {
        this.liveQueryListener.put(monitorId, listener);
    }

    public static HashMap<String, Object> paramsArrayToParamsMap(Object[] positionalParams) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (positionalParams != null) {
            for (int i = 0; i < positionalParams.length; ++i) {
                params.put(Integer.toString(i), positionalParams[i]);
            }
        }
        return params;
    }

    @Override
    public void executeLiveQueryPush(OLiveQueryPushRequest pushRequest) {
        OLiveQueryClientListener listener = this.liveQueryListener.get(pushRequest.getMonitorId());
        if (listener.onEvent(pushRequest)) {
            this.liveQueryListener.remove(pushRequest.getMonitorId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPushReconnect(String host) {
        if (this.status != OStorage.STATUS.OPEN) {
            return;
        }
        OStorageRemoteSession aValidSession = null;
        for (OStorageRemoteSession session : this.sessions) {
            if (session.getServerSession(host) == null) continue;
            aValidSession = session;
            break;
        }
        if (aValidSession != null) {
            this.subscribeDistributedConfiguration(aValidSession);
            this.subscribeStorageConfiguration(aValidSession);
        } else {
            OStorageRemotePushThread old;
            OLogManager.instance().warn((Object)this, "Cannot find a valid session for subscribe for event to host '%s' forward the subscribe for the next session open ", new Object[]{host});
            this.stateLock.acquireWriteLock();
            try {
                old = this.pushThread;
                this.pushThread = null;
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
            old.shutdown();
        }
    }

    @Override
    public void onPushDisconnect(OChannelBinary network, Exception e) {
        this.connectionManager.remove((OChannelBinaryAsynchClient)network);
        if (e instanceof InterruptedException) {
            for (OLiveQueryClientListener liveListener : this.liveQueryListener.values()) {
                liveListener.onEnd();
            }
        } else {
            for (OLiveQueryClientListener liveListener : this.liveQueryListener.values()) {
                if (e instanceof OException) {
                    liveListener.onError((OException)((Object)e));
                    continue;
                }
                liveListener.onError(OException.wrapException((OException)new ODatabaseException("Live query disconnection "), (Throwable)e));
            }
        }
    }

    @Override
    public void returnSocket(OChannelBinary network) {
        this.connectionManager.remove((OChannelBinaryAsynchClient)network);
    }

    public void setSchemaRecordId(String schemaRecordId) {
        throw new UnsupportedOperationException();
    }

    public void setDateFormat(String dateFormat) {
        throw new UnsupportedOperationException();
    }

    public void setTimeZone(TimeZone timeZoneValue) {
        throw new UnsupportedOperationException();
    }

    public void setLocaleLanguage(String locale) {
        throw new UnsupportedOperationException();
    }

    public void setCharset(String charset) {
        throw new UnsupportedOperationException();
    }

    public void setIndexMgrRecordId(String indexMgrRecordId) {
        throw new UnsupportedOperationException();
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        throw new UnsupportedOperationException();
    }

    public void setLocaleCountry(String localeCountry) {
        throw new UnsupportedOperationException();
    }

    public void setClusterSelection(String clusterSelection) {
        throw new UnsupportedOperationException();
    }

    public void setMinimumClusters(int minimumClusters) {
        throw new UnsupportedOperationException();
    }

    public void setValidation(boolean validation) {
        throw new UnsupportedOperationException();
    }

    public void removeProperty(String property) {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String property, String value) {
        throw new UnsupportedOperationException();
    }

    public void setRecordSerializer(String recordSerializer, int version) {
        throw new UnsupportedOperationException();
    }

    public void clearProperties() {
        throw new UnsupportedOperationException();
    }

    public List<String> getServerURLs() {
        return this.serverURLs;
    }

    public static enum CONNECTION_STRATEGY {
        STICKY,
        ROUND_ROBIN_CONNECT,
        ROUND_ROBIN_REQUEST;

    }
}

