/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OLiveQueryClientListener;
import com.orientechnologies.orient.client.remote.ORemoteQueryResult;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OLockRecordResponse;
import com.orientechnologies.orient.client.remote.message.ORemoteResultSet;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OHookReplacedRecordThreadLocal;
import com.orientechnologies.orient.core.db.OLiveQueryMonitor;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.db.document.OTransactionOptimisticClient;
import com.orientechnologies.orient.core.db.document.RecordReader;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerRemote;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaRemote;
import com.orientechnologies.orient.core.metadata.security.OImmutableUser;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OMicroTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineClusterException;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ODatabaseDocumentRemote
extends ODatabaseDocumentAbstract {
    protected OStorageRemoteSession sessionMetadata;
    private OrientDBConfig config;
    private OStorageRemote storage;

    public ODatabaseDocumentRemote(OStorageRemote storage) {
        this.activateOnCurrentThread();
        try {
            this.status = ODatabase.STATUS.CLOSED;
            this.url = storage.getURL();
            this.storage = storage;
            this.componentsFactory = storage.getComponentsFactory();
            this.unmodifiableHooks = Collections.unmodifiableMap(this.hooks);
            this.localCache = new OLocalRecordCache();
            this.init();
            this.databaseOwner = this;
        }
        catch (Exception t) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw OException.wrapException((OException)new ODatabaseException("Error on opening database "), (Throwable)t);
        }
    }

    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Use OrientDB");
    }

    @Deprecated
    public <DB extends ODatabase> DB open(OToken iToken) {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    public <DB extends ODatabase> DB create() {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    public <DB extends ODatabase> DB create(String incrementalBackupPath) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public <DB extends ODatabase> DB create(Map<OGlobalConfiguration, Object> iInitialSettings) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public void drop() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <DB extends ODatabase> DB set(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        if (iAttribute == ODatabase.ATTRIBUTES.CUSTOM) {
            int indx;
            String stringValue = iValue.toString();
            int n = indx = stringValue != null ? stringValue.indexOf(61) : -1;
            if (indx < 0) {
                if (!"clear".equalsIgnoreCase(stringValue)) throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                String query = "alter database CUSTOM 'clear'";
                ORemoteQueryResult result = this.getStorage().command(this, query, new Object[]{iValue});
                result.getResult().close();
                return (DB)((Object)this);
            } else {
                String customName = stringValue.substring(0, indx).trim();
                String customValue = stringValue.substring(indx + 1).trim();
                this.setCustom(customName, customValue);
            }
            return (DB)((Object)this);
        } else {
            String query = "alter database " + iAttribute.name() + " ? ";
            ORemoteQueryResult result = this.getStorage().command(this, query, new Object[]{iValue});
            result.getResult().close();
            this.getStorage().reload();
        }
        return (DB)((Object)this);
    }

    public <DB extends ODatabase> DB setCustom(String name, Object iValue) {
        if ("clear".equals(name) && iValue == null) {
            String query = "alter database CUSTOM 'clear'";
            ORemoteQueryResult result = this.getStorage().command(this, query, new Object[0]);
            result.getResult().close();
        } else {
            String query = "alter database CUSTOM  " + name + " = ?";
            ORemoteQueryResult result = this.getStorage().command(this, query, new Object[]{iValue});
            result.getResult().close();
            this.getStorage().reload();
        }
        return (DB)((Object)this);
    }

    public ODatabaseDocumentInternal copy() {
        ODatabaseDocumentRemote database = new ODatabaseDocumentRemote(this.storage);
        database.storage = this.storage.copy(this, database);
        database.storage.addUser();
        database.status = ODatabase.STATUS.OPEN;
        database.applyAttributes(this.config);
        database.initAtFirstOpen(this.getSharedContext());
        database.user = this.user;
        this.activateOnCurrentThread();
        return database;
    }

    public boolean exists() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public void internalOpen(String user, String password, OrientDBConfig config, OSharedContext ctx) {
        this.config = config;
        this.applyAttributes(config);
        this.applyListeners(config);
        try {
            this.storage.open(user, password, config.getConfigurations());
            this.status = ODatabase.STATUS.OPEN;
            this.initAtFirstOpen(ctx);
            this.user = new OImmutableUser(-1L, new OUser(user, password).addRole((OSecurityRole)new ORole("passthrough", null, OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT)));
            this.callOnOpenListeners();
        }
        catch (OException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw OException.wrapException((OException)new ODatabaseException("Cannot open database url=" + this.getURL()), (Throwable)e);
        }
    }

    private void applyAttributes(OrientDBConfig config) {
        for (Map.Entry attrs : config.getAttributes().entrySet()) {
            this.set((ODatabase.ATTRIBUTES)attrs.getKey(), attrs.getValue());
        }
    }

    private void initAtFirstOpen(OSharedContext ctx) {
        if (this.initialized) {
            return;
        }
        ORecordSerializerFactory serializerFactory = ORecordSerializerFactory.instance();
        this.serializer = serializerFactory.getFormat("onet_ser_v37");
        this.localCache.startup();
        this.componentsFactory = this.getStorage().getComponentsFactory();
        this.user = null;
        this.loadMetadata(ctx);
        this.initialized = true;
    }

    protected void loadMetadata() {
        this.loadMetadata(this.getSharedContext());
    }

    protected void loadMetadata(OSharedContext ctx) {
        this.metadata = new OMetadataDefault((ODatabaseDocumentInternal)this);
        this.sharedContext = ctx;
        this.metadata.init(this.sharedContext);
        this.sharedContext.load((ODatabaseDocumentInternal)this);
    }

    private void applyListeners(OrientDBConfig config) {
        for (ODatabaseListener listener : config.getListeners()) {
            this.registerListener(listener);
        }
    }

    public ODatabaseDocumentAbstract begin(OTransaction.TXTYPE iType) {
        this.checkOpenness();
        this.checkIfActive();
        if (this.currentTx.isActive()) {
            if (iType == OTransaction.TXTYPE.OPTIMISTIC && this.currentTx instanceof OTransactionOptimistic) {
                this.currentTx.begin();
                return this;
            }
            this.currentTx.rollback(true, 0);
        }
        if (!this.inHook.isEmpty()) {
            throw new IllegalStateException("Cannot begin a transaction while a hook is executing");
        }
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxBegin((ODatabase)this);
            }
            catch (Exception t) {
                OLogManager.instance().error((Object)this, "Error before tx begin", (Throwable)t, new Object[0]);
            }
            catch (Error e) {
                OLogManager.instance().error((Object)this, "Error before tx begin", (Throwable)e, new Object[0]);
                throw e;
            }
        }
        switch (iType) {
            case NOTX: {
                this.setDefaultTransactionMode(null);
                break;
            }
            case OPTIMISTIC: {
                this.currentTx = new OTransactionOptimisticClient((ODatabaseDocumentInternal)this);
                break;
            }
            case PESSIMISTIC: {
                throw new UnsupportedOperationException("Pessimistic transaction");
            }
        }
        this.currentTx.begin();
        return this;
    }

    public OStorageRemoteSession getSessionMetadata() {
        return this.sessionMetadata;
    }

    public void setSessionMetadata(OStorageRemoteSession sessionMetadata) {
        this.sessionMetadata = sessionMetadata;
    }

    public OStorageRemote getStorage() {
        return this.storage;
    }

    public void replaceStorage(OStorage iNewStorage) {
        throw new UnsupportedOperationException("unsupported replace of storage for remote database");
    }

    private void checkAndSendTransaction() {
        if (this.currentTx.isActive() && ((OTransactionOptimistic)this.currentTx).isChanged()) {
            if (((OTransactionOptimistic)this.getTransaction()).isAlreadyCleared()) {
                this.storage.reBeginTransaction(this, (OTransactionOptimistic)this.currentTx);
            } else {
                this.storage.beginTransaction(this, (OTransactionOptimistic)this.currentTx);
            }
            ((OTransactionOptimistic)this.currentTx).resetChangesTracking();
        }
    }

    private void fetchTransacion() {
        this.storage.fetchTransaction(this);
    }

    public OResultSet query(String query, Object[] args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.query(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public OResultSet query(String query, Map args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.query(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public OResultSet indexQuery(String indexName, String query, Object ... args) {
        ORemoteQueryResult result;
        this.checkOpenness();
        if (this.getTransaction().isActive()) {
            OTransactionIndexChanges changes = this.getTransaction().getIndexChanges(indexName);
            Set<String> changedIndexes = ((OTransactionOptimisticClient)this.getTransaction()).getIndexChanged();
            if (changedIndexes.contains(indexName) || changes != null) {
                this.checkAndSendTransaction();
            }
        }
        if ((result = this.storage.command(this, query, args)).isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public OResultSet command(String query, Object ... args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.command(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public OResultSet command(String query, Map args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.command(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public OResultSet execute(String language, String script, Object ... args) throws OCommandExecutionException, OCommandScriptException {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.execute(this, language, script, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public OResultSet execute(String language, String script, Map<String, ?> args) throws OCommandExecutionException, OCommandScriptException {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.execute(this, language, script, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public void closeQuery(String queryId) {
        this.storage.closeQuery(this, queryId);
        this.queryClosed(queryId);
    }

    public void fetchNextPage(ORemoteResultSet rs) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        this.storage.fetchNextPage(this, rs);
    }

    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Object ... args) {
        return this.storage.liveQuery(this, query, new OLiveQueryClientListener((ODatabaseDocument)this.copy(), listener), args);
    }

    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Map<String, ?> args) {
        return this.storage.liveQuery(this, query, new OLiveQueryClientListener((ODatabaseDocument)this.copy(), listener), args);
    }

    public void recycle(ORecord record) {
        throw new UnsupportedOperationException();
    }

    protected OMicroTransaction beginMicroTransaction() {
        return null;
    }

    public static void deInit(OStorageRemote storage) {
        OSharedContext sharedContext = (OSharedContext)storage.removeResource(OSharedContext.class.getName());
        if (sharedContext != null) {
            sharedContext.close();
        }
    }

    public static void updateSchema(OStorageRemote storage, ODocument schema) {
        OSharedContext shared = (OSharedContext)storage.getResource(OSharedContext.class.getName(), () -> null);
        if (shared != null) {
            ((OSchemaRemote)shared.getSchema()).update(schema);
        }
    }

    public static void updateIndexManager(OStorageRemote storage, ODocument indexManager) {
        OSharedContext shared = (OSharedContext)storage.getResource(OSharedContext.class.getName(), () -> null);
        if (shared != null) {
            ((OIndexManagerRemote)shared.getIndexManager()).update(indexManager);
        }
    }

    public static void updateFunction(OStorageRemote storage) {
        OSharedContext shared = (OSharedContext)storage.getResource(OSharedContext.class.getName(), () -> null);
        if (shared != null) {
            shared.getFunctionLibrary().update();
        }
    }

    public static void updateSequences(OStorageRemote storage) {
        OSharedContext shared = (OSharedContext)storage.getResource(OSharedContext.class.getName(), () -> null);
        if (shared != null) {
            shared.getSequenceLibrary().update();
        }
    }

    public int addBlobCluster(String iClusterName, Object ... iParameters) {
        try (OResultSet resultSet = this.command("create blob cluster :1", iClusterName);){
            int id;
            assert (resultSet.hasNext());
            OResult result = resultSet.next();
            assert (result.getProperty("value") != null);
            int n = id = ((Integer)result.getProperty("value")).intValue();
            return n;
        }
    }

    public void executeDeleteRecord(OIdentifiable record, int iVersion, boolean iRequired, ODatabase.OPERATION_MODE iMode, boolean prohibitTombstones) {
        OTransactionOptimisticClient tx = new OTransactionOptimisticClient((ODatabaseDocumentInternal)this){

            protected void checkTransaction() {
            }
        };
        tx.begin();
        tx.deleteRecord((ORecord)record, iMode);
        tx.commit();
    }

    public OIdentifiable beforeCreateOperations(OIdentifiable id, String iClusterName) {
        this.checkClusterSecurity(ORole.PERMISSION_CREATE, id, iClusterName);
        ORecordHook.RESULT res = this.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, id);
        if (res == ORecordHook.RESULT.RECORD_CHANGED) {
            if (id instanceof ODocument) {
                ((ODocument)id).validate();
            }
            return id;
        }
        if (res == ORecordHook.RESULT.RECORD_REPLACED) {
            ORecord replaced = (ORecord)OHookReplacedRecordThreadLocal.INSTANCE.get();
            if (replaced instanceof ODocument) {
                ((ODocument)replaced).validate();
            }
            return replaced;
        }
        return null;
    }

    public OIdentifiable beforeUpdateOperations(OIdentifiable id, String iClusterName) {
        this.checkClusterSecurity(ORole.PERMISSION_UPDATE, id, iClusterName);
        ORecordHook.RESULT res = this.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, id);
        if (res == ORecordHook.RESULT.RECORD_CHANGED) {
            if (id instanceof ODocument) {
                ((ODocument)id).validate();
            }
            return id;
        }
        if (res == ORecordHook.RESULT.RECORD_REPLACED) {
            ORecord replaced = (ORecord)OHookReplacedRecordThreadLocal.INSTANCE.get();
            if (replaced instanceof ODocument) {
                ((ODocument)replaced).validate();
            }
            return replaced;
        }
        return null;
    }

    public void beforeDeleteOperations(OIdentifiable id, String iClusterName) {
        this.checkClusterSecurity(ORole.PERMISSION_DELETE, id, iClusterName);
        this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, id);
    }

    public void afterUpdateOperations(OIdentifiable id) {
        ODocument doc;
        OImmutableClass clazz;
        this.callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, id);
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass((ODatabaseDocumentInternal)this, (ODocument)(doc = (ODocument)id))) != null && this.getTransaction().isActive()) {
            ArrayList indexChanges = new ArrayList();
            OClassIndexManager.processIndexOnDelete((ODatabaseDocumentInternal)this, (ODocument)doc, indexChanges);
            OTransactionOptimisticClient tx = (OTransactionOptimisticClient)this.getTransaction();
            for (OClassIndexManager.IndexChange indexChange : indexChanges) {
                tx.addIndexChanged(indexChange.index.getName());
            }
        }
    }

    public void afterCreateOperations(OIdentifiable id) {
        ODocument doc;
        OImmutableClass clazz;
        this.callbackHooks(ORecordHook.TYPE.AFTER_CREATE, id);
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass((ODatabaseDocumentInternal)this, (ODocument)(doc = (ODocument)id))) != null && this.getTransaction().isActive()) {
            ArrayList indexChanges = new ArrayList();
            OClassIndexManager.processIndexOnCreate((ODatabaseDocumentInternal)this, (ODocument)doc, indexChanges);
            OTransactionOptimisticClient tx = (OTransactionOptimisticClient)this.getTransaction();
            for (OClassIndexManager.IndexChange indexChange : indexChanges) {
                tx.addIndexChanged(indexChange.index.getName());
            }
        }
    }

    public void afterDeleteOperations(OIdentifiable id) {
        ODocument doc;
        OImmutableClass clazz;
        this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, id);
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass((ODatabaseDocumentInternal)this, (ODocument)(doc = (ODocument)id))) != null && this.getTransaction().isActive()) {
            ArrayList indexChanges = new ArrayList();
            OClassIndexManager.processIndexOnDelete((ODatabaseDocumentInternal)this, (ODocument)doc, indexChanges);
            OTransactionOptimisticClient tx = (OTransactionOptimisticClient)this.getTransaction();
            for (OClassIndexManager.IndexChange indexChange : indexChanges) {
                tx.addIndexChanged(indexChange.index.getName());
            }
        }
    }

    public boolean beforeReadOperations(OIdentifiable identifiable) {
        return this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, identifiable) == ORecordHook.RESULT.SKIP;
    }

    public void afterReadOperations(OIdentifiable identifiable) {
        this.callbackHooks(ORecordHook.TYPE.AFTER_READ, identifiable);
    }

    public ORecord saveAll(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        OTransactionOptimisticClient tx = new OTransactionOptimisticClient((ODatabaseDocumentInternal)this){

            protected void checkTransaction() {
            }
        };
        tx.begin();
        tx.saveRecord(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        tx.commit();
        return iRecord;
    }

    public <RET extends ORecord> RET executeReadRecord(ORecordId rid, ORecord iRecord, int recordVersion, String fetchPlan, boolean ignoreCache, boolean iUpdateCache, boolean loadTombstones, OStorage.LOCKING_STRATEGY lockingStrategy, RecordReader recordReader) {
        this.checkOpenness();
        this.checkIfActive();
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        try {
            ORawBuffer recordBuffer;
            this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, this.getClusterNameById(rid.getClusterId()));
            ORecord record = this.getTransaction().getRecord((ORID)rid);
            if (record == OBasicTransaction.DELETED_RECORD) {
                RET RET = null;
                return RET;
            }
            if (record == null && !ignoreCache) {
                record = this.getLocalCache().findRecord((ORID)rid);
            }
            if (record != null) {
                if (iRecord != null) {
                    iRecord.fromStream(record.toStream());
                    ORecordInternal.setVersion((ORecord)iRecord, (int)record.getVersion());
                    record = iRecord;
                }
                OFetchHelper.checkFetchPlanValid((String)fetchPlan);
                if (this.beforeReadOperations((OIdentifiable)record)) {
                    RET RET = null;
                    return RET;
                }
                if (record.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    record.reload();
                }
                if (lockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_SHARED_LOCK) {
                    OLogManager.instance().warn((Object)this, "You use deprecated record locking strategy: %s it may lead to deadlocks " + lockingStrategy, new Object[0]);
                    record.lock(false);
                } else if (lockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK) {
                    OLogManager.instance().warn((Object)this, "You use deprecated record locking strategy: %s it may lead to deadlocks " + lockingStrategy, new Object[0]);
                    record.lock(true);
                }
                this.afterReadOperations((OIdentifiable)record);
                if (record instanceof ODocument) {
                    ODocumentInternal.checkClass((ODocument)((ODocument)record), (ODatabaseDocumentInternal)this);
                }
                ORecord oRecord = record;
                return (RET)oRecord;
            }
            if (!rid.isValid()) {
                recordBuffer = null;
            } else {
                OFetchHelper.checkFetchPlanValid((String)fetchPlan);
                int version = iRecord != null ? iRecord.getVersion() : recordVersion;
                recordBuffer = recordReader.readRecord((OStorage)this.getStorage(), rid, fetchPlan, ignoreCache, version);
            }
            if (recordBuffer == null) {
                RET RET = null;
                return RET;
            }
            if (iRecord == null || ORecordInternal.getRecordType((ORecord)iRecord) != recordBuffer.recordType) {
                iRecord = Orient.instance().getRecordFactoryManager().newInstance(recordBuffer.recordType, rid.getClusterId(), (ODatabaseDocumentInternal)this);
            }
            ORecordInternal.setRecordSerializer((ORecord)iRecord, (ORecordSerializer)this.getSerializer());
            ORecordInternal.fill((ORecord)iRecord, (ORID)rid, (int)recordBuffer.version, (byte[])recordBuffer.buffer, (boolean)false, (ODatabaseDocumentInternal)this);
            if (iRecord instanceof ODocument) {
                ODocumentInternal.checkClass((ODocument)((ODocument)iRecord), (ODatabaseDocumentInternal)this);
            }
            if (ORecordVersionHelper.isTombstone((int)iRecord.getVersion())) {
                ORecord oRecord = iRecord;
                return (RET)oRecord;
            }
            if (this.beforeReadOperations((OIdentifiable)iRecord)) {
                RET RET = null;
                return RET;
            }
            iRecord.fromStream(recordBuffer.buffer);
            this.afterReadOperations((OIdentifiable)iRecord);
            if (iUpdateCache) {
                this.getLocalCache().updateRecord(iRecord);
            }
            ORecord oRecord = iRecord;
            return (RET)oRecord;
        }
        catch (OOfflineClusterException t) {
            throw t;
        }
        catch (ORecordNotFoundException t) {
            throw t;
        }
        catch (Exception t) {
            if (rid.isTemporary()) {
                throw OException.wrapException((OException)new ODatabaseException("Error on retrieving record using temporary RID: " + rid), (Throwable)t);
            }
            throw OException.wrapException((OException)new ODatabaseException("Error on retrieving record " + rid + " (cluster: " + this.getStorage().getPhysicalClusterNameById(rid.getClusterId()) + ")"), (Throwable)t);
        }
        finally {
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    public String getClusterName(ORecord record) {
        return null;
    }

    public void internalLockRecord(OIdentifiable iRecord, OStorage.LOCKING_STRATEGY lockingStrategy) {
        this.checkAndSendTransaction();
        OStorageRemote remote = this.getStorage();
        remote.lockRecord(iRecord, lockingStrategy, -1L);
    }

    public void internalUnlockRecord(OIdentifiable iRecord) {
        OStorageRemote remote = this.getStorage();
        remote.unlockRecord((OIdentifiable)iRecord.getIdentity());
    }

    public <RET extends ORecord> RET lock(ORID recordId) throws OLockException {
        this.checkOpenness();
        this.checkIfActive();
        this.pessimisticLockChecks(recordId);
        this.checkAndSendTransaction();
        OStorageRemote remote = this.getStorage();
        OLockRecordResponse response = remote.lockRecord((OIdentifiable)recordId, OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK, -1L);
        ORecord record = this.fillRecordFromNetwork(recordId, response.getRecordType(), response.getVersion(), response.getRecord());
        return (RET)record;
    }

    public <RET extends ORecord> RET lock(ORID recordId, long timeout, TimeUnit timeoutUnit) throws OLockException {
        this.checkOpenness();
        this.checkIfActive();
        this.pessimisticLockChecks(recordId);
        this.checkAndSendTransaction();
        OStorageRemote remote = this.getStorage();
        OLockRecordResponse response = remote.lockRecord((OIdentifiable)recordId, OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK, timeoutUnit.toMillis(timeout));
        ORecord record = this.fillRecordFromNetwork(recordId, response.getRecordType(), response.getVersion(), response.getRecord());
        return (RET)record;
    }

    private ORecord fillRecordFromNetwork(ORID recordId, byte recordType, int version, byte[] buffer) {
        this.beforeReadOperations((OIdentifiable)recordId);
        ORecord toFillRecord = this.getLocalCache().findRecord(recordId);
        if (toFillRecord == null) {
            toFillRecord = Orient.instance().getRecordFactoryManager().newInstance(recordType, recordId.getClusterId(), (ODatabaseDocumentInternal)this);
        }
        ORecordInternal.fill((ORecord)toFillRecord, (ORID)recordId, (int)version, (byte[])buffer, (boolean)false);
        this.getLocalCache().updateRecord(toFillRecord);
        this.afterReadOperations((OIdentifiable)recordId);
        return toFillRecord;
    }

    public void unlock(ORID recordId) throws OLockException {
        this.checkOpenness();
        this.checkIfActive();
        this.internalUnlockRecord((OIdentifiable)recordId);
    }
}

